# coding=utf8

# Any copyright is dedicated to the Public Domain.
# http://creativecommons.org/publicdomain/zero/1.0/

from __future__ import absolute_import
import fluent.syntax.ast as FTL
from fluent.migrate.helpers import MESSAGE_REFERENCE
from fluent.migrate.transforms import REPLACE
from fluent.migrate import COPY


def migrate(ctx):
    """Bug 1446180 - Migrate Preferences::Privacy to Fluent, part {index}."""

    ctx.add_transforms(
        'browser/branding/official/brand.ftl',
        'browser/branding/official/brand.ftl',
        [
            FTL.Term(
                id=FTL.Identifier('-vendor-short-name'),
                value=COPY(
                    'browser/branding/official/brand.dtd',
                    'vendorShortName'
                )
            ),
        ]
    )

    ctx.add_transforms(
        'browser/browser/preferences/preferences.ftl',
        'browser/browser/preferences/preferences.ftl',
        [
            FTL.Message(
                id=FTL.Identifier('privacy-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/preferences.dtd',
                    'browserPrivacy.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('forms-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/security.dtd',
                    'formsAndPasswords.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('forms-exceptions'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'passwordExceptions.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'passwordExceptions.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('forms-saved-logins'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'savedLogins.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'savedLogins.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('forms-master-pw-use'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'useMasterPassword.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'useMasterPassword.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('forms-master-pw-change'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'changeMasterPassword.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'changeMasterPassword.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('history-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'history.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('history-remember-description'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'rememberDescription1.label',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('history-dontremember-description'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'dontrememberDescription.label',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('history-private-browsing-permanent'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'privateBrowsingPermanent2.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'privateBrowsingPermanent2.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('history-remember-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'rememberHistory2.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'rememberHistory2.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('history-remember-search-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'rememberSearchForm.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'rememberSearchForm.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('history-clear-on-close-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        REPLACE(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'clearOnClose.label',
                            {
                                '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                            },
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'clearOnClose.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('history-clear-on-close-settings'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'clearOnCloseSettings.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'clearOnCloseSettings.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('history-clear-button'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'clearHistoryButton.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'clearHistoryButton.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'siteData1.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-learn-more'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'siteDataLearnMoreLink.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-accept-cookies-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'acceptCookies4.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'acceptCookies4.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-block-cookies-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'blockCookies.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'blockCookies.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-keep-until'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'keepUntil2.label',
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'keepUntil2.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-accept-third-party-desc'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'acceptThirdParty3.pre.label',
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'acceptThirdParty3.pre.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-accept-third-party-always-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'acceptThirdParty.always.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-accept-third-party-visited-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'acceptThirdParty.visited.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-accept-third-party-never-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'acceptThirdParty.never.label',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-clear'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'clearSiteData1.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'clearSiteData1.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-settings'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'siteDataSettings1.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'siteDataSettings1.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('sitedata-cookies-exceptions'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'cookieExceptions.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'cookieExceptions.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('addressbar-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'addressBar.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('addressbar-suggest'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'addressBar.suggest.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('addressbar-locbar-history-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'locbar.history2.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'locbar.history2.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('addressbar-locbar-bookmarks-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'locbar.bookmarks.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'locbar.bookmarks.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('addressbar-locbar-openpage-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'locbar.openpage.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'locbar.openpage.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('addressbar-suggestions-settings'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'suggestionSettings2.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('tracking-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'trackingProtectionHeader2.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('tracking-mode-label'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'trackingProtection3.radioGroupLabel',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('tracking-mode-always'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'trackingProtectionAlways.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'trackingProtectionAlways.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('tracking-mode-private'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'trackingProtectionPrivate.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'trackingProtectionPrivate.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('tracking-mode-never'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'trackingProtectionNever.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'trackingProtectionNever.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('tracking-pbm-label'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'trackingProtectionPBM6.label',
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'trackingProtectionPBM6.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('tracking-exceptions'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'trackingProtectionExceptions.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'trackingProtectionExceptions.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('tracking-change-block-list'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'changeBlockList2.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'changeBlockList2.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'permissions.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-location'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'locationPermissions.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-location-settings'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'locationSettingsButton.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'locationSettingsButton.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-camera'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'cameraPermissions.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-camera-settings'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'cameraSettingsButton.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'cameraSettingsButton.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-microphone'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'microphonePermissions.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-microphone-settings'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'microphoneSettingsButton.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'microphoneSettingsButton.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-notification'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'notificationPermissions.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-notification-settings'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'notificationSettingsButton.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'notificationSettingsButton.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-notification-link'),
                value=COPY(
                    'browser/chrome/browser/preferences/content.dtd',
                    'notificationPermissionsLearnMore.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-notification-pause'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        REPLACE(
                            'browser/chrome/browser/preferences/preferences.properties',
                            'pauseNotifications.label',
                            {
                                '%S': MESSAGE_REFERENCE('-brand-short-name')
                            },
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/preferences.properties',
                            'pauseNotifications.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-block-popups'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'blockPopups.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'blockPopups.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-block-popups-exceptions'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'popupExceptions.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/content.dtd',
                            'popupExceptions.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-addon-install-warning'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'warnOnAddonInstall2.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'warnOnAddonInstall2.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-addon-exceptions'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'addonExceptions.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'addonExceptions.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-a11y-privacy-checkbox'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'a11yPrivacy.checkbox.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/privacy.dtd',
                            'a11yPrivacy.checkbox.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('permissions-a11y-privacy-link'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'a11yPrivacy.learnmore.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('collection-header'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'dataCollection.label',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('collection-description'),
                value=REPLACE(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'dataCollectionDesc.label',
                    {
                        '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                    },
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('collection-privacy-notice'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'dataCollectionPrivacyNotice.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('collection-health-report'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        REPLACE(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'enableHealthReport2.label',
                            {
                                '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name'),
                                'Mozilla': MESSAGE_REFERENCE('-vendor-short-name'),
                            },
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'enableHealthReport2.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('collection-health-report-link'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'healthReportLearnMore.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('collection-health-report-disabled'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'healthReportingDisabled.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('collection-browser-errors'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        REPLACE(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'collectBrowserErrors.label',
                            {
                                '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name'),
                                'Mozilla': MESSAGE_REFERENCE('-vendor-short-name'),
                            },
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'collectBrowserErrors.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('collection-browser-errors-link'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'collectBrowserErrorsLearnMore.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('collection-backlogged-crash-reports'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        REPLACE(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'sendBackloggedCrashReports.label',
                            {
                                '&brandShortName;': MESSAGE_REFERENCE('-brand-short-name')
                            },
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'sendBackloggedCrashReports.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('collection-backlogged-crash-reports-link'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'crashReporterLearnMore.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('security-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/security.dtd',
                    'security.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('security-browsing-protection'),
                value=COPY(
                    'browser/chrome/browser/preferences/security.dtd',
                    'browsingProtection.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('security-enable-safe-browsing'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'enableSafeBrowsing.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'enableSafeBrowsing.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('security-enable-safe-browsing-link'),
                value=COPY(
                    'browser/chrome/browser/preferences/privacy.dtd',
                    'enableSafeBrowsingLearnMore.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('security-block-downloads'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'blockDownloads.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'blockDownloads.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('security-block-uncommon-software'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'blockUncommonAndUnwanted.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/security.dtd',
                            'blockUncommonAndUnwanted.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('certs-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'certificateTab.label',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('certs-personal-label'),
                value=COPY(
                    'browser/chrome/browser/preferences/advanced.dtd',
                    'certPersonal2.description',
                ),
            ),
            FTL.Message(
                id=FTL.Identifier('certs-select-auto-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'selectCerts.auto',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'selectCerts.auto.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('certs-select-ask-option'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'selectCerts.ask',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'selectCerts.ask.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('certs-enable-ocsp'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'enableOCSP.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'enableOCSP.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('certs-view'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'viewCerts2.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'viewCerts2.accesskey',
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('certs-devices'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'viewSecurityDevices2.label',
                        ),
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/advanced.dtd',
                            'viewSecurityDevices2.accesskey',
                        ),
                    ),
                ],
            ),
        ]
    )
