# coding=utf8

# Any copyright is dedicated to the Public Domain.
# http://creativecommons.org/publicdomain/zero/1.0/

from __future__ import absolute_import
import fluent.syntax.ast as FTL
from fluent.migrate import COPY, CONCAT

def migrate(ctx):
    """Bug 1451992 - Migrate Preferences::Subdialogs::Colors to Fluent, part {index}."""

    ctx.add_transforms(
        'browser/browser/preferences/colors.ftl',
        'browser/browser/preferences/colors.ftl',
        [
            FTL.Message(
                id=FTL.Identifier('colors-window'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('title'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'colorsDialog.title'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('style'),
                        FTL.Pattern(
                            elements=[
                                FTL.Placeable(
                                    expression=FTL.SelectExpression(
                                        expression=FTL.CallExpression(
                                            callee=FTL.Function('PLATFORM')
                                        ),
                                        variants=[
                                            FTL.Variant(
                                                key=FTL.VariantName('macos'),
                                                default=False,
                                                value=CONCAT(
                                                    FTL.TextElement('width: '),
                                                    COPY(
                                                        'browser/chrome/browser/preferences/colors.dtd',
                                                        'window.macWidth'
                                                    )
                                                )
                                            ),
                                            FTL.Variant(
                                                key=FTL.VariantName('other'),
                                                default=True,
                                                value=CONCAT(
                                                    FTL.TextElement('width: '),
                                                    COPY(
                                                        'browser/chrome/browser/preferences/colors.dtd',
                                                        'window.width'
                                                    )
                                                )
                                            )
                                        ]
                                    )
                                )
                            ]
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('colors-close-key'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('key'),
                        COPY(
                            'toolkit/chrome/global/preferences.dtd',
                            'windowClose.key'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('colors-page-override'),
                value=COPY(
                    'browser/chrome/browser/preferences/colors.dtd',
                    'overrideDefaultPageColors2.label'
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'overrideDefaultPageColors2.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('colors-page-override-option-always'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'overrideDefaultPageColors.always.label'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('colors-page-override-option-auto'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'overrideDefaultPageColors.auto.label'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('colors-page-override-option-never'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'overrideDefaultPageColors.never.label'
                        ),
                    ),
                ],
            ),
            FTL.Message(
                id=FTL.Identifier('colors-text-and-background'),
                value=COPY(
                    'browser/chrome/browser/preferences/colors.dtd',
                    'color'
                )
            ),
            FTL.Message(
                id=FTL.Identifier('colors-text-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/colors.dtd',
                    'textColor2.label'
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'textColor2.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('colors-background'),
                value=COPY(
                    'browser/chrome/browser/preferences/colors.dtd',
                    'backgroundColor2.label'
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'backgroundColor2.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('colors-use-system'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'useSystemColors.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'useSystemColors.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('colors-underline-links'),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('label'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'underlineLinks.label'
                        )
                    ),
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'underlineLinks.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('colors-links-header'),
                value=COPY(
                    'browser/chrome/browser/preferences/colors.dtd',
                    'links'
                )
            ),
            FTL.Message(
                id=FTL.Identifier('colors-unvisited-links'),
                value=COPY(
                    'browser/chrome/browser/preferences/colors.dtd',
                    'linkColor2.label'
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'linkColor2.accesskey'
                        )
                    )
                ]
            ),
            FTL.Message(
                id=FTL.Identifier('colors-visited-links'),
                value=COPY(
                    'browser/chrome/browser/preferences/colors.dtd',
                    'visitedLinkColor2.label'
                ),
                attributes=[
                    FTL.Attribute(
                        FTL.Identifier('accesskey'),
                        COPY(
                            'browser/chrome/browser/preferences/colors.dtd',
                            'visitedLinkColor2.accesskey'
                        )
                    )
                ]
            )
        ]
    )
