tiki.stylesheet("core_test:en/7a2aea76f269c0cc7f8d3ce26c88cdae21c54665/stylesheet.css");/* >>>>>>>>>> BEGIN package_info.js */
;tiki.register('core_test', {"packages":{"tiki/system":{"scripts":[{"url":"/static/tiki/system/en/58f2d5c8bfde7ac3c30a019dee28e46835844718/javascript.js","id":"tiki/system:en/58f2d5c8bfde7ac3c30a019dee28e46835844718/javascript.js"}]},"tiki":{"scripts":[{"url":"/static/tiki/en/e7a9cb4289d80edc4c34b0987472876b9a547e7e/javascript.js","id":"tiki:en/e7a9cb4289d80edc4c34b0987472876b9a547e7e/javascript.js"}]}},"stylesheets":[{"url":"/static/core_test/en/7a2aea76f269c0cc7f8d3ce26c88cdae21c54665/stylesheet.css","id":"core_test:en/7a2aea76f269c0cc7f8d3ce26c88cdae21c54665/stylesheet.css"}],"depends":["tiki","tiki/system"],"scripts":[{"url":"/static/core_test/en/7a2aea76f269c0cc7f8d3ce26c88cdae21c54665/javascript.js","id":"core_test:en/7a2aea76f269c0cc7f8d3ce26c88cdae21c54665/javascript.js"}]});

/* >>>>>>>>>> BEGIN source/core.js */
tiki.module('core_test:core',"var $m__ = require('core_test:utils'), K=$m__.K,beget=$m__.beget,mixin=$m__.mixin,fmt=$m__.fmt;var CoreTest;// ==========================================================================\n// Project:   SproutCore Unit Testing Library\n// Copyright: \u00a92006-2009 Sprout Systems, Inc. and contributors.\n//            Portions \u00a92008-2009 Apple Inc. All rights reserved.\n// License:   Licened under MIT license (see license.js)\n// ==========================================================================\n/*globals CoreTest */\n\n\"import utils\";\n\"export package CoreTest\";\n\n/** @namespace\n\n  CoreTest is the unit testing library for SproutCore.  It includes a test \n  runner based on QUnit with some useful extensions for testing SproutCore-\n  based applications.\n  \n  You can use CoreTest just like you would use QUnit in your tests directory.\n*/\nCoreTest = {\n  \n  /**\n    If set to false, then built-in assertions will simply record errors to the\n    current logger instead of throwing an error, stopping the unit test.\n    \n    @property {Boolean}\n  */\n  throwsOnFailure: true,\n  \n  /**\n    Set to a logger object during a test run.\n    \n    @property {Logger}\n  */\n  logger: null,\n  \n  // ..........................................................\n  // SUPPORT METHODS\n  // \n  \n  /**\n    Returns a stub function that records any passed arguments and a call\n    count.  You can pass no parameters, a single function or a hash.  \n    \n    If you pass no parameters, then this simply returns a function that does \n    nothing but record being called.  \n    \n    If you pass a function, then the function will execute when the method is\n    called, allowing you to stub in some fake behavior.\n    \n    If you pass a hash, you can supply any properties you want attached to the\n    stub function.  The two most useful are \"action\", which is the function \n    that will execute when the stub runs (as if you just passed a function), \n    and \"expect\" which should evaluate the stub results.\n    \n    In your unit test you can verify the stub by calling stub.expect(X), \n    where X is the number of times you expect the function to be called.  If\n    you implement your own test function, you can actually pass whatever you\n    want.\n    \n    Calling stub.reset() will reset the record on the stub for further \n    testing.\n\n    @param {String} name the name of the stub to use for logging\n    @param {Function|Hash} func the function or hash\n    @returns {Function} stub function\n  */\n  stub: function(name, func) {  \n\n    // normalize param\n    var attrs = {};\n    if (typeof func === \"function\") {\n      attrs.action = func;\n    } else if (typeof func === \"object\") {\n      attrs = func ;\n    }\n\n    // create basic stub\n    var ret = function() {\n      ret.callCount++;\n      \n      // get arguments into independent array and save in history\n      var args = [], loc = arguments.length;\n      while(--loc >= 0) args[loc] = arguments[loc];\n      args.unshift(this); // save context\n      ret.history.push(args);\n      \n      return ret.action.apply(this, arguments);\n    };\n    ret.callCount = 0 ;\n    ret.history = [];\n    ret.stubName = name ;\n\n    // copy attrs\n    var key;\n    for(key in attrs) {\n      if (!attrs.hasOwnProperty(key)) continue ;\n      ret[key] = attrs[key];\n    }\n\n    // add on defaults\n    if (!ret.reset) {\n      ret.reset = function() {\n        this.callCount = 0;\n        this.history = [];\n      };\n    }\n    \n    if (!ret.action) {\n      ret.action = function() { return this; };\n    }\n    \n    if (!ret.expect) {\n      ret.expect = function(callCount) {\n        if (callCount === YES) {\n          ok(this.callCount > 0, CoreTest.fmt(\"%@ should be called at least once\", this.stubName));\n        } else {\n          if (callCount === NO) callCount = 0;\n          equals(this.callCount, callCount, CoreTest.fmt(\"%@ should be called X times\", this.stubName));\n        }\n      };\n    }\n    \n    return ret ;\n  },\n  \n\n  /** Test is OK */\n  OK: 'passed',\n  \n  /** Test failed */\n  FAIL: 'failed',\n  \n  /** Test raised exception */\n  ERROR: 'errors',\n  \n  /** Test raised warning */\n  WARN: 'warnings',\n  \n  showUI : false\n  \n};\n;exports.CoreTest = CoreTest;\n");
/* >>>>>>>>>> BEGIN source/utils.js */
tiki.module('core_test:utils',"var K,beget,mixin,fmt;// ==========================================================================\n// Project:   SproutCore Unit Testing Library\n// Copyright: \u00a92006-2009 Sprout Systems, Inc. and contributors.\n//            Portions \u00a92008-2009 Apple Inc. All rights reserved.\n// License:   Licened under MIT license (see license.js)\n// ==========================================================================\n/*globals fmt beget mixin */\n\n\"export K beget mixin fmt\";\n\n/**\n  Generic helper utility methods used internally by the framework code.  \n  These utilities are not exposed automatically outside of the package.\n*/\n\n/** \n  Empty function.  Useful for some operations. \n*/\nK = function K() { return this; },\n\n/**\n  Copied from SproutCore Runtime Core.  Included here to avoid dependencies.\n\n  @param obj {Object} the object to beget\n  @returns {Object} the new object.\n*/\nbeget = function beget(obj) {\n  if (!obj) return null ;\n  K.prototype = obj ;\n  \n  var ret = new K();\n  K.prototype = null ; // avoid leaks\n\n  return ret ;\n};\n\n/**\n  Copied from SproutCore Runtime Core.  Included here to avoid dependencies.\n\n  @param target {Object} the target object to extend\n  @param properties {Object} one or more objects with properties to copy.\n  @returns {Object} the target object.\n  @static\n*/\nmixin = function mixin() {\n  // copy reference to target object\n  var target = arguments[0] || {};\n  var idx = 1;\n  var length = arguments.length ;\n  var options ;\n\n  // Handle case where we have only one item...extend CoreTest\n  if (length === 1) {\n    target = this || {};\n    idx=0;\n  }\n\n  for ( ; idx < length; idx++ ) {\n    if (!(options = arguments[idx])) continue ;\n    for(var key in options) {\n      if (!options.hasOwnProperty(key)) continue ;\n      var src = target[key];\n      var copy = options[key] ;\n      if (target===copy) continue ; // prevent never-ending loop\n      if (copy !== undefined) target[key] = copy ;\n    }\n  }\n\n  return target;\n};\n\n\n/** Borrowed from SproutCore Runtime Core */\nfmt = function fmt(str) {\n  // first, replace any ORDERED replacements.\n  var args = arguments;\n  var idx  = 1; // the current index for non-numerical replacements\n  return str.replace(/%@([0-9]+)?/g, function(s, argIndex) {\n    argIndex = (argIndex) ? parseInt(argIndex,0) : idx++ ;\n    s =args[argIndex];\n    return ((s===null) ? '(null)' : (s===undefined) ? '' : s).toString(); \n  }) ;\n};;exports.K = K;\nexports.beget = beget;\nexports.mixin = mixin;\nexports.fmt = fmt;\n");
/* >>>>>>>>>> BEGIN source/browser/jquery.js */
tiki.module('core_test:browser/jquery',"var jQuery,$;// NOTE: This version of jQuery has a line added at the end that remaps it to\n// Q$, for private use by Qunit only.  This way the jQuery library used by \n// Qunit will not interfere with any other jQuery libs you might load.\n// You should be able to merge this file with new versions of jQuery with \n// minor effort.\n/*globals exports */\n\n\"export jQuery $\";\n\n/*!\n *\n * jQuery 1.2.6 - New Wave Javascript\n *\n * Copyright (c) 2008 John Resig (jquery.com)\n * Dual licensed under the MIT (MIT-LICENSE.txt)\n * and GPL (GPL-LICENSE.txt) licenses.\n *\n * $Date: 2008-05-24 14:22:17 -0400 (Sat, 24 May 2008) $\n * $Rev: 5685 $\n */\n\n// Map over jQuery in case of overwrite\nvar _jQuery = exports.jQuery,\n// Map over the $ in case of overwrite\n\t_$ = exports.$;\n\n$ = jQuery = exports.jQuery = exports.$ = function( selector, context ) {\n\t// The jQuery object is actually just the init constructor 'enhanced'\n\treturn new jQuery.fn.init( selector, context );\n};\n\n// A simple way to check for HTML strings or ID strings\n// (both of which we optimize for)\nvar quickExpr = /^[^<]*(<(.|\\s)+>)[^>]*$|^#(\\w+)$/,\n\n// Is it a simple selector\n\tisSimple = /^.[^:#\\[\\.]*$/,\n\n// Will speed up references to undefined, and allows munging its name.\n\tundefined;\n\njQuery.fn = jQuery.prototype = {\n\tinit: function( selector, context ) {\n\t\t// Make sure that a selection was provided\n\t\tselector = selector || document;\n\n\t\t// Handle $(DOMElement)\n\t\tif ( selector.nodeType ) {\n\t\t\tthis[0] = selector;\n\t\t\tthis.length = 1;\n\t\t\treturn this;\n\t\t}\n\t\t// Handle HTML strings\n\t\tif ( typeof selector == \"string\" ) {\n\t\t\t// Are we dealing with HTML string or an ID?\n\t\t\tvar match = quickExpr.exec( selector );\n\n\t\t\t// Verify a match, and that no context was specified for #id\n\t\t\tif ( match && (match[1] || !context) ) {\n\n\t\t\t\t// HANDLE: $(html) -> $(array)\n\t\t\t\tif ( match[1] )\n\t\t\t\t\tselector = jQuery.clean( [ match[1] ], context );\n\n\t\t\t\t// HANDLE: $(\"#id\")\n\t\t\t\telse {\n\t\t\t\t\tvar elem = document.getElementById( match[3] );\n\n\t\t\t\t\t// Make sure an element was located\n\t\t\t\t\tif ( elem ){\n\t\t\t\t\t\t// Handle the case where IE and Opera return items\n\t\t\t\t\t\t// by name instead of ID\n\t\t\t\t\t\tif ( elem.id != match[3] )\n\t\t\t\t\t\t\treturn jQuery().find( selector );\n\n\t\t\t\t\t\t// Otherwise, we inject the element directly into the jQuery object\n\t\t\t\t\t\treturn jQuery( elem );\n\t\t\t\t\t}\n\t\t\t\t\tselector = [];\n\t\t\t\t}\n\n\t\t\t// HANDLE: $(expr, [context])\n\t\t\t// (which is just equivalent to: $(content).find(expr)\n\t\t\t} else\n\t\t\t\treturn jQuery( context ).find( selector );\n\n\t\t// HANDLE: $(function)\n\t\t// Shortcut for document ready\n\t\t} else if ( jQuery.isFunction( selector ) )\n\t\t\treturn jQuery( document )[ jQuery.fn.ready ? \"ready\" : \"load\" ]( selector );\n\n\t\treturn this.setArray(jQuery.makeArray(selector));\n\t},\n\n\t// The current version of jQuery being used\n\tjquery: \"1.2.6\",\n\n\t// The number of elements contained in the matched element set\n\tsize: function() {\n\t\treturn this.length;\n\t},\n\n\t// The number of elements contained in the matched element set\n\tlength: 0,\n\n\t// Get the Nth element in the matched element set OR\n\t// Get the whole matched element set as a clean array\n\tget: function( num ) {\n\t\treturn num == undefined ?\n\n\t\t\t// Return a 'clean' array\n\t\t\tjQuery.makeArray( this ) :\n\n\t\t\t// Return just the object\n\t\t\tthis[ num ];\n\t},\n\n\t// Take an array of elements and push it onto the stack\n\t// (returning the new matched element set)\n\tpushStack: function( elems ) {\n\t\t// Build a new jQuery matched element set\n\t\tvar ret = jQuery( elems );\n\n\t\t// Add the old object onto the stack (as a reference)\n\t\tret.prevObject = this;\n\n\t\t// Return the newly-formed element set\n\t\treturn ret;\n\t},\n\n\t// Force the current matched set of elements to become\n\t// the specified array of elements (destroying the stack in the process)\n\t// You should use pushStack() in order to do this, but maintain the stack\n\tsetArray: function( elems ) {\n\t\t// Resetting the length to 0, then using the native Array push\n\t\t// is a super-fast way to populate an object with array-like properties\n\t\tthis.length = 0;\n\t\tArray.prototype.push.apply( this, elems );\n\n\t\treturn this;\n\t},\n\n\t// Execute a callback for every element in the matched set.\n\t// (You can seed the arguments with an array of args, but this is\n\t// only used internally.)\n\teach: function( callback, args ) {\n\t\treturn jQuery.each( this, callback, args );\n\t},\n\n\t// Determine the position of an element within\n\t// the matched set of elements\n\tindex: function( elem ) {\n\t\tvar ret = -1;\n\n\t\t// Locate the position of the desired element\n\t\treturn jQuery.inArray(\n\t\t\t// If it receives a jQuery object, the first element is used\n\t\t\telem && elem.jquery ? elem[0] : elem\n\t\t, this );\n\t},\n\n\tattr: function( name, value, type ) {\n\t\tvar options = name;\n\n\t\t// Look for the case where we're accessing a style value\n\t\tif ( name.constructor == String )\n\t\t\tif ( value === undefined )\n\t\t\t\treturn this[0] && jQuery[ type || \"attr\" ]( this[0], name );\n\n\t\t\telse {\n\t\t\t\toptions = {};\n\t\t\t\toptions[ name ] = value;\n\t\t\t}\n\n\t\t// Check to see if we're setting style values\n\t\treturn this.each(function(i){\n\t\t\t// Set all the styles\n\t\t\tfor ( name in options )\n\t\t\t\tjQuery.attr(\n\t\t\t\t\ttype ?\n\t\t\t\t\t\tthis.style :\n\t\t\t\t\t\tthis,\n\t\t\t\t\tname, jQuery.prop( this, options[ name ], type, i, name )\n\t\t\t\t);\n\t\t});\n\t},\n\n\tcss: function( key, value ) {\n\t\t// ignore negative width and height values\n\t\tif ( (key == 'width' || key == 'height') && parseFloat(value) < 0 )\n\t\t\tvalue = undefined;\n\t\treturn this.attr( key, value, \"curCSS\" );\n\t},\n\n\ttext: function( text ) {\n\t\tif ( typeof text != \"object\" && text != null )\n\t\t\treturn this.empty().append( (this[0] && this[0].ownerDocument || document).createTextNode( text ) );\n\n\t\tvar ret = \"\";\n\n\t\tjQuery.each( text || this, function(){\n\t\t\tjQuery.each( this.childNodes, function(){\n\t\t\t\tif ( this.nodeType != 8 )\n\t\t\t\t\tret += this.nodeType != 1 ?\n\t\t\t\t\t\tthis.nodeValue :\n\t\t\t\t\t\tjQuery.fn.text( [ this ] );\n\t\t\t});\n\t\t});\n\n\t\treturn ret;\n\t},\n\n\twrapAll: function( html ) {\n\t\tif ( this[0] )\n\t\t\t// The elements to wrap the target around\n\t\t\tjQuery( html, this[0].ownerDocument )\n\t\t\t\t.clone()\n\t\t\t\t.insertBefore( this[0] )\n\t\t\t\t.map(function(){\n\t\t\t\t\tvar elem = this;\n\n\t\t\t\t\twhile ( elem.firstChild )\n\t\t\t\t\t\telem = elem.firstChild;\n\n\t\t\t\t\treturn elem;\n\t\t\t\t})\n\t\t\t\t.append(this);\n\n\t\treturn this;\n\t},\n\n\twrapInner: function( html ) {\n\t\treturn this.each(function(){\n\t\t\tjQuery( this ).contents().wrapAll( html );\n\t\t});\n\t},\n\n\twrap: function( html ) {\n\t\treturn this.each(function(){\n\t\t\tjQuery( this ).wrapAll( html );\n\t\t});\n\t},\n\n\tappend: function() {\n\t\treturn this.domManip(arguments, true, false, function(elem){\n\t\t\tif (this.nodeType == 1)\n\t\t\t\tthis.appendChild( elem );\n\t\t});\n\t},\n\n\tprepend: function() {\n\t\treturn this.domManip(arguments, true, true, function(elem){\n\t\t\tif (this.nodeType == 1)\n\t\t\t\tthis.insertBefore( elem, this.firstChild );\n\t\t});\n\t},\n\n\tbefore: function() {\n\t\treturn this.domManip(arguments, false, false, function(elem){\n\t\t\tthis.parentNode.insertBefore( elem, this );\n\t\t});\n\t},\n\n\tafter: function() {\n\t\treturn this.domManip(arguments, false, true, function(elem){\n\t\t\tthis.parentNode.insertBefore( elem, this.nextSibling );\n\t\t});\n\t},\n\n\tend: function() {\n\t\treturn this.prevObject || jQuery( [] );\n\t},\n\n\tfind: function( selector ) {\n\t\tvar elems = jQuery.map(this, function(elem){\n\t\t\treturn jQuery.find( selector, elem );\n\t\t});\n\n\t\treturn this.pushStack( /[^+>] [^+>]/.test( selector ) || selector.indexOf(\"..\") > -1 ?\n\t\t\tjQuery.unique( elems ) :\n\t\t\telems );\n\t},\n\n\tclone: function( events ) {\n\t\t// Do the clone\n\t\tvar ret = this.map(function(){\n\t\t\tif ( jQuery.browser.msie && !jQuery.isXMLDoc(this) ) {\n\t\t\t\t// IE copies events bound via attachEvent when\n\t\t\t\t// using cloneNode. Calling detachEvent on the\n\t\t\t\t// clone will also remove the events from the orignal\n\t\t\t\t// In order to get around this, we use innerHTML.\n\t\t\t\t// Unfortunately, this means some modifications to\n\t\t\t\t// attributes in IE that are actually only stored\n\t\t\t\t// as properties will not be copied (such as the\n\t\t\t\t// the name attribute on an input).\n\t\t\t\tvar clone = this.cloneNode(true),\n\t\t\t\t\tcontainer = document.createElement(\"div\");\n\t\t\t\tcontainer.appendChild(clone);\n\t\t\t\treturn jQuery.clean([container.innerHTML])[0];\n\t\t\t} else\n\t\t\t\treturn this.cloneNode(true);\n\t\t});\n\n\t\t// Need to set the expando to null on the cloned set if it exists\n\t\t// removeData doesn't work here, IE removes it from the original as well\n\t\t// this is primarily for IE but the data expando shouldn't be copied over in any browser\n\t\tvar clone = ret.find(\"*\").andSelf().each(function(){\n\t\t\tif ( this[ expando ] != undefined )\n\t\t\t\tthis[ expando ] = null;\n\t\t});\n\n\t\t// Copy the events from the original to the clone\n\t\tif ( events === true )\n\t\t\tthis.find(\"*\").andSelf().each(function(i){\n\t\t\t\tif (this.nodeType == 3)\n\t\t\t\t\treturn;\n\t\t\t\tvar events = jQuery.data( this, \"events\" );\n\n\t\t\t\tfor ( var type in events )\n\t\t\t\t\tfor ( var handler in events[ type ] )\n\t\t\t\t\t\tjQuery.event.add( clone[ i ], type, events[ type ][ handler ], events[ type ][ handler ].data );\n\t\t\t});\n\n\t\t// Return the cloned set\n\t\treturn ret;\n\t},\n\n\tfilter: function( selector ) {\n\t\treturn this.pushStack(\n\t\t\tjQuery.isFunction( selector ) &&\n\t\t\tjQuery.grep(this, function(elem, i){\n\t\t\t\treturn selector.call( elem, i );\n\t\t\t}) ||\n\n\t\t\tjQuery.multiFilter( selector, this ) );\n\t},\n\n\tnot: function( selector ) {\n\t\tif ( selector.constructor == String )\n\t\t\t// test special case where just one selector is passed in\n\t\t\tif ( isSimple.test( selector ) )\n\t\t\t\treturn this.pushStack( jQuery.multiFilter( selector, this, true ) );\n\t\t\telse\n\t\t\t\tselector = jQuery.multiFilter( selector, this );\n\n\t\tvar isArrayLike = selector.length && selector[selector.length - 1] !== undefined && !selector.nodeType;\n\t\treturn this.filter(function() {\n\t\t\treturn isArrayLike ? jQuery.inArray( this, selector ) < 0 : this != selector;\n\t\t});\n\t},\n\n\tadd: function( selector ) {\n\t\treturn this.pushStack( jQuery.unique( jQuery.merge(\n\t\t\tthis.get(),\n\t\t\ttypeof selector == 'string' ?\n\t\t\t\tjQuery( selector ) :\n\t\t\t\tjQuery.makeArray( selector )\n\t\t)));\n\t},\n\n\tis: function( selector ) {\n\t\treturn !!selector && jQuery.multiFilter( selector, this ).length > 0;\n\t},\n\n\thasClass: function( selector ) {\n\t\treturn this.is( \".\" + selector );\n\t},\n\n\tval: function( value ) {\n\t\tif ( value == undefined ) {\n\n\t\t\tif ( this.length ) {\n\t\t\t\tvar elem = this[0];\n\n\t\t\t\t// We need to handle select boxes special\n\t\t\t\tif ( jQuery.nodeName( elem, \"select\" ) ) {\n\t\t\t\t\tvar index = elem.selectedIndex,\n\t\t\t\t\t\tvalues = [],\n\t\t\t\t\t\toptions = elem.options,\n\t\t\t\t\t\tone = elem.type == \"select-one\";\n\n\t\t\t\t\t// Nothing was selected\n\t\t\t\t\tif ( index < 0 )\n\t\t\t\t\t\treturn null;\n\n\t\t\t\t\t// Loop through all the selected options\n\t\t\t\t\tfor ( var i = one ? index : 0, max = one ? index + 1 : options.length; i < max; i++ ) {\n\t\t\t\t\t\tvar option = options[ i ];\n\n\t\t\t\t\t\tif ( option.selected ) {\n\t\t\t\t\t\t\t// Get the specifc value for the option\n\t\t\t\t\t\t\tvalue = jQuery.browser.msie && !option.attributes.value.specified ? option.text : option.value;\n\n\t\t\t\t\t\t\t// We don't need an array for one selects\n\t\t\t\t\t\t\tif ( one )\n\t\t\t\t\t\t\t\treturn value;\n\n\t\t\t\t\t\t\t// Multi-Selects return an array\n\t\t\t\t\t\t\tvalues.push( value );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\treturn values;\n\n\t\t\t\t// Everything else, we just grab the value\n\t\t\t\t} else\n\t\t\t\t\treturn (this[0].value || \"\").replace(/\\r/g, \"\");\n\n\t\t\t}\n\n\t\t\treturn undefined;\n\t\t}\n\n\t\tif( value.constructor == Number )\n\t\t\tvalue += '';\n\n\t\treturn this.each(function(){\n\t\t\tif ( this.nodeType != 1 )\n\t\t\t\treturn;\n\n\t\t\tif ( value.constructor == Array && /radio|checkbox/.test( this.type ) )\n\t\t\t\tthis.checked = (jQuery.inArray(this.value, value) >= 0 ||\n\t\t\t\t\tjQuery.inArray(this.name, value) >= 0);\n\n\t\t\telse if ( jQuery.nodeName( this, \"select\" ) ) {\n\t\t\t\tvar values = jQuery.makeArray(value);\n\n\t\t\t\tjQuery( \"option\", this ).each(function(){\n\t\t\t\t\tthis.selected = (jQuery.inArray( this.value, values ) >= 0 ||\n\t\t\t\t\t\tjQuery.inArray( this.text, values ) >= 0);\n\t\t\t\t});\n\n\t\t\t\tif ( !values.length )\n\t\t\t\t\tthis.selectedIndex = -1;\n\n\t\t\t} else\n\t\t\t\tthis.value = value;\n\t\t});\n\t},\n\n\thtml: function( value ) {\n\t\treturn value == undefined ?\n\t\t\t(this[0] ?\n\t\t\t\tthis[0].innerHTML :\n\t\t\t\tnull) :\n\t\t\tthis.empty().append( value );\n\t},\n\n\treplaceWith: function( value ) {\n\t\treturn this.after( value ).remove();\n\t},\n\n\teq: function( i ) {\n\t\treturn this.slice( i, i + 1 );\n\t},\n\n\tslice: function() {\n\t\treturn this.pushStack( Array.prototype.slice.apply( this, arguments ) );\n\t},\n\n\tmap: function( callback ) {\n\t\treturn this.pushStack( jQuery.map(this, function(elem, i){\n\t\t\treturn callback.call( elem, i, elem );\n\t\t}));\n\t},\n\n\tandSelf: function() {\n\t\treturn this.add( this.prevObject );\n\t},\n\n\tdata: function( key, value ){\n\t\tvar parts = key.split(\".\");\n\t\tparts[1] = parts[1] ? \".\" + parts[1] : \"\";\n\n\t\tif ( value === undefined ) {\n\t\t\tvar data = this.triggerHandler(\"getData\" + parts[1] + \"!\", [parts[0]]);\n\n\t\t\tif ( data === undefined && this.length )\n\t\t\t\tdata = jQuery.data( this[0], key );\n\n\t\t\treturn data === undefined && parts[1] ?\n\t\t\t\tthis.data( parts[0] ) :\n\t\t\t\tdata;\n\t\t} else\n\t\t\treturn this.trigger(\"setData\" + parts[1] + \"!\", [parts[0], value]).each(function(){\n\t\t\t\tjQuery.data( this, key, value );\n\t\t\t});\n\t},\n\n\tremoveData: function( key ){\n\t\treturn this.each(function(){\n\t\t\tjQuery.removeData( this, key );\n\t\t});\n\t},\n\n\tdomManip: function( args, table, reverse, callback ) {\n\t\tvar clone = this.length > 1, elems;\n\n\t\treturn this.each(function(){\n\t\t\tif ( !elems ) {\n\t\t\t\telems = jQuery.clean( args, this.ownerDocument );\n\n\t\t\t\tif ( reverse )\n\t\t\t\t\telems.reverse();\n\t\t\t}\n\n\t\t\tvar obj = this;\n\n\t\t\tif ( table && jQuery.nodeName( this, \"table\" ) && jQuery.nodeName( elems[0], \"tr\" ) )\n\t\t\t\tobj = this.getElementsByTagName(\"tbody\")[0] || this.appendChild( this.ownerDocument.createElement(\"tbody\") );\n\n\t\t\tvar scripts = jQuery( [] );\n\n\t\t\tjQuery.each(elems, function(){\n\t\t\t\tvar elem = clone ?\n\t\t\t\t\tjQuery( this ).clone( true )[0] :\n\t\t\t\t\tthis;\n\n\t\t\t\t// execute all scripts after the elements have been injected\n\t\t\t\tif ( jQuery.nodeName( elem, \"script\" ) )\n\t\t\t\t\tscripts = scripts.add( elem );\n\t\t\t\telse {\n\t\t\t\t\t// Remove any inner scripts for later evaluation\n\t\t\t\t\tif ( elem.nodeType == 1 )\n\t\t\t\t\t\tscripts = scripts.add( jQuery( \"script\", elem ).remove() );\n\n\t\t\t\t\t// Inject the elements into the document\n\t\t\t\t\tcallback.call( obj, elem );\n\t\t\t\t}\n\t\t\t});\n\n\t\t\tscripts.each( evalScript );\n\t\t});\n\t}\n};\n\n// Give the init function the jQuery prototype for later instantiation\njQuery.fn.init.prototype = jQuery.fn;\n\nfunction evalScript( i, elem ) {\n\tif ( elem.src )\n\t\tjQuery.ajax({\n\t\t\turl: elem.src,\n\t\t\tasync: false,\n\t\t\tdataType: \"script\"\n\t\t});\n\n\telse\n\t\tjQuery.globalEval( elem.text || elem.textContent || elem.innerHTML || \"\" );\n\n\tif ( elem.parentNode )\n\t\telem.parentNode.removeChild( elem );\n}\n\nfunction now(){\n\treturn +new Date;\n}\n\njQuery.extend = jQuery.fn.extend = function() {\n\t// copy reference to target object\n\tvar target = arguments[0] || {}, i = 1, length = arguments.length, deep = false, options;\n\n\t// Handle a deep copy situation\n\tif ( target.constructor == Boolean ) {\n\t\tdeep = target;\n\t\ttarget = arguments[1] || {};\n\t\t// skip the boolean and the target\n\t\ti = 2;\n\t}\n\n\t// Handle case when target is a string or something (possible in deep copy)\n\tif ( typeof target != \"object\" && typeof target != \"function\" )\n\t\ttarget = {};\n\n\t// extend jQuery itself if only one argument is passed\n\tif ( length == i ) {\n\t\ttarget = this;\n\t\t--i;\n\t}\n\n\tfor ( ; i < length; i++ )\n\t\t// Only deal with non-null/undefined values\n\t\tif ( (options = arguments[ i ]) != null )\n\t\t\t// Extend the base object\n\t\t\tfor ( var name in options ) {\n\t\t\t\tvar src = target[ name ], copy = options[ name ];\n\n\t\t\t\t// Prevent never-ending loop\n\t\t\t\tif ( target === copy )\n\t\t\t\t\tcontinue;\n\n\t\t\t\t// Recurse if we're merging object values\n\t\t\t\tif ( deep && copy && typeof copy == \"object\" && !copy.nodeType )\n\t\t\t\t\ttarget[ name ] = jQuery.extend( deep, \n\t\t\t\t\t\t// Never move original objects, clone them\n\t\t\t\t\t\tsrc || ( copy.length != null ? [ ] : { } )\n\t\t\t\t\t, copy );\n\n\t\t\t\t// Don't bring in undefined values\n\t\t\t\telse if ( copy !== undefined )\n\t\t\t\t\ttarget[ name ] = copy;\n\n\t\t\t}\n\n\t// Return the modified object\n\treturn target;\n};\n\nvar expando = \"jQuery\" + now(), uuid = 0, windowData = {},\n\t// exclude the following css properties to add px\n\texclude = /z-?index|font-?weight|opacity|zoom|line-?height/i,\n\t// cache defaultView\n\tdefaultView = document.defaultView || {};\n\njQuery.extend({\n\tnoConflict: function( deep ) {\n\t\texports.$ = _$;\n\n\t\tif ( deep )\n\t\t\texports.jQuery = _jQuery;\n\n\t\treturn jQuery;\n\t},\n\n\t// See test/unit/core.js for details concerning this function.\n\tisFunction: function( fn ) {\n\t\treturn !!fn && typeof fn != \"string\" && !fn.nodeName &&\n\t\t\tfn.constructor != Array && /^[\\s[]?function/.test( fn + \"\" );\n\t},\n\n\t// check if an element is in a (or is an) XML document\n\tisXMLDoc: function( elem ) {\n\t\treturn elem.documentElement && !elem.body ||\n\t\t\telem.tagName && elem.ownerDocument && !elem.ownerDocument.body;\n\t},\n\n\t// Evalulates a script in a global context\n\tglobalEval: function( data ) {\n\t\tdata = jQuery.trim( data );\n\n\t\tif ( data ) {\n\t\t\t// Inspired by code by Andrea Giammarchi\n\t\t\t// http://webreflection.blogspot.com/2007/08/global-scope-evaluation-and-dom.html\n\t\t\tvar head = document.getElementsByTagName(\"head\")[0] || document.documentElement,\n\t\t\t\tscript = document.createElement(\"script\");\n\n\t\t\tscript.type = \"text/javascript\";\n\t\t\tif ( jQuery.browser.msie )\n\t\t\t\tscript.text = data;\n\t\t\telse\n\t\t\t\tscript.appendChild( document.createTextNode( data ) );\n\n\t\t\t// Use insertBefore instead of appendChild  to circumvent an IE6 bug.\n\t\t\t// This arises when a base node is used (#2709).\n\t\t\thead.insertBefore( script, head.firstChild );\n\t\t\thead.removeChild( script );\n\t\t}\n\t},\n\n\tnodeName: function( elem, name ) {\n\t\treturn elem.nodeName && elem.nodeName.toUpperCase() == name.toUpperCase();\n\t},\n\n\tcache: {},\n\n\tdata: function( elem, name, data ) {\n\t\telem = elem == window ?\n\t\t\twindowData :\n\t\t\telem;\n\n\t\tvar id = elem[ expando ];\n\n\t\t// Compute a unique ID for the element\n\t\tif ( !id )\n\t\t\tid = elem[ expando ] = ++uuid;\n\n\t\t// Only generate the data cache if we're\n\t\t// trying to access or manipulate it\n\t\tif ( name && !jQuery.cache[ id ] )\n\t\t\tjQuery.cache[ id ] = {};\n\n\t\t// Prevent overriding the named cache with undefined values\n\t\tif ( data !== undefined )\n\t\t\tjQuery.cache[ id ][ name ] = data;\n\n\t\t// Return the named cache data, or the ID for the element\n\t\treturn name ?\n\t\t\tjQuery.cache[ id ][ name ] :\n\t\t\tid;\n\t},\n\n\tremoveData: function( elem, name ) {\n\t\telem = elem == window ?\n\t\t\twindowData :\n\t\t\telem;\n\n\t\tvar id = elem[ expando ];\n\n\t\t// If we want to remove a specific section of the element's data\n\t\tif ( name ) {\n\t\t\tif ( jQuery.cache[ id ] ) {\n\t\t\t\t// Remove the section of cache data\n\t\t\t\tdelete jQuery.cache[ id ][ name ];\n\n\t\t\t\t// If we've removed all the data, remove the element's cache\n\t\t\t\tname = \"\";\n\n\t\t\t\tfor ( name in jQuery.cache[ id ] )\n\t\t\t\t\tbreak;\n\n\t\t\t\tif ( !name )\n\t\t\t\t\tjQuery.removeData( elem );\n\t\t\t}\n\n\t\t// Otherwise, we want to remove all of the element's data\n\t\t} else {\n\t\t\t// Clean up the element expando\n\t\t\ttry {\n\t\t\t\tdelete elem[ expando ];\n\t\t\t} catch(e){\n\t\t\t\t// IE has trouble directly removing the expando\n\t\t\t\t// but it's ok with using removeAttribute\n\t\t\t\tif ( elem.removeAttribute )\n\t\t\t\t\telem.removeAttribute( expando );\n\t\t\t}\n\n\t\t\t// Completely remove the data cache\n\t\t\tdelete jQuery.cache[ id ];\n\t\t}\n\t},\n\n\t// args is for internal usage only\n\teach: function( object, callback, args ) {\n\t\tvar name, i = 0, length = object.length;\n\n\t\tif ( args ) {\n\t\t\tif ( length == undefined ) {\n\t\t\t\tfor ( name in object )\n\t\t\t\t\tif ( callback.apply( object[ name ], args ) === false )\n\t\t\t\t\t\tbreak;\n\t\t\t} else\n\t\t\t\tfor ( ; i < length; )\n\t\t\t\t\tif ( callback.apply( object[ i++ ], args ) === false )\n\t\t\t\t\t\tbreak;\n\n\t\t// A special, fast, case for the most common use of each\n\t\t} else {\n\t\t\tif ( length == undefined ) {\n\t\t\t\tfor ( name in object )\n\t\t\t\t\tif ( callback.call( object[ name ], name, object[ name ] ) === false )\n\t\t\t\t\t\tbreak;\n\t\t\t} else\n\t\t\t\tfor ( var value = object[0];\n\t\t\t\t\ti < length && callback.call( value, i, value ) !== false; value = object[++i] ){}\n\t\t}\n\n\t\treturn object;\n\t},\n\n\tprop: function( elem, value, type, i, name ) {\n\t\t// Handle executable functions\n\t\tif ( jQuery.isFunction( value ) )\n\t\t\tvalue = value.call( elem, i );\n\n\t\t// Handle passing in a number to a CSS property\n\t\treturn value && value.constructor == Number && type == \"curCSS\" && !exclude.test( name ) ?\n\t\t\tvalue + \"px\" :\n\t\t\tvalue;\n\t},\n\n\tclassName: {\n\t\t// internal only, use addClass(\"class\")\n\t\tadd: function( elem, classNames ) {\n\t\t\tjQuery.each((classNames || \"\").split(/\\s+/), function(i, className){\n\t\t\t\tif ( elem.nodeType == 1 && !jQuery.className.has( elem.className, className ) )\n\t\t\t\t\telem.className += (elem.className ? \" \" : \"\") + className;\n\t\t\t});\n\t\t},\n\n\t\t// internal only, use removeClass(\"class\")\n\t\tremove: function( elem, classNames ) {\n\t\t\tif (elem.nodeType == 1)\n\t\t\t\telem.className = classNames != undefined ?\n\t\t\t\t\tjQuery.grep(elem.className.split(/\\s+/), function(className){\n\t\t\t\t\t\treturn !jQuery.className.has( classNames, className );\n\t\t\t\t\t}).join(\" \") :\n\t\t\t\t\t\"\";\n\t\t},\n\n\t\t// internal only, use hasClass(\"class\")\n\t\thas: function( elem, className ) {\n\t\t\treturn jQuery.inArray( className, (elem.className || elem).toString().split(/\\s+/) ) > -1;\n\t\t}\n\t},\n\n\t// A method for quickly swapping in/out CSS properties to get correct calculations\n\tswap: function( elem, options, callback ) {\n\t\tvar old = {};\n\t\t// Remember the old values, and insert the new ones\n\t\tfor ( var name in options ) {\n\t\t\told[ name ] = elem.style[ name ];\n\t\t\telem.style[ name ] = options[ name ];\n\t\t}\n\n\t\tcallback.call( elem );\n\n\t\t// Revert the old values\n\t\tfor ( var name in options )\n\t\t\telem.style[ name ] = old[ name ];\n\t},\n\n\tcss: function( elem, name, force ) {\n\t\tif ( name == \"width\" || name == \"height\" ) {\n\t\t\tvar val, props = { position: \"absolute\", visibility: \"hidden\", display:\"block\" }, which = name == \"width\" ? [ \"Left\", \"Right\" ] : [ \"Top\", \"Bottom\" ];\n\n\t\t\tfunction getWH() {\n\t\t\t\tval = name == \"width\" ? elem.offsetWidth : elem.offsetHeight;\n\t\t\t\tvar padding = 0, border = 0;\n\t\t\t\tjQuery.each( which, function() {\n\t\t\t\t\tpadding += parseFloat(jQuery.curCSS( elem, \"padding\" + this, true)) || 0;\n\t\t\t\t\tborder += parseFloat(jQuery.curCSS( elem, \"border\" + this + \"Width\", true)) || 0;\n\t\t\t\t});\n\t\t\t\tval -= Math.round(padding + border);\n\t\t\t}\n\n\t\t\tif ( jQuery(elem).is(\":visible\") )\n\t\t\t\tgetWH();\n\t\t\telse\n\t\t\t\tjQuery.swap( elem, props, getWH );\n\n\t\t\treturn Math.max(0, val);\n\t\t}\n\n\t\treturn jQuery.curCSS( elem, name, force );\n\t},\n\n\tcurCSS: function( elem, name, force ) {\n\t\tvar ret, style = elem.style;\n\n\t\t// A helper method for determining if an element's values are broken\n\t\tfunction color( elem ) {\n\t\t\tif ( !jQuery.browser.safari )\n\t\t\t\treturn false;\n\n\t\t\t// defaultView is cached\n\t\t\tvar ret = defaultView.getComputedStyle( elem, null );\n\t\t\treturn !ret || ret.getPropertyValue(\"color\") == \"\";\n\t\t}\n\n\t\t// We need to handle opacity special in IE\n\t\tif ( name == \"opacity\" && jQuery.browser.msie ) {\n\t\t\tret = jQuery.attr( style, \"opacity\" );\n\n\t\t\treturn ret == \"\" ?\n\t\t\t\t\"1\" :\n\t\t\t\tret;\n\t\t}\n\t\t// Opera sometimes will give the wrong display answer, this fixes it, see #2037\n\t\tif ( jQuery.browser.opera && name == \"display\" ) {\n\t\t\tvar save = style.outline;\n\t\t\tstyle.outline = \"0 solid black\";\n\t\t\tstyle.outline = save;\n\t\t}\n\n\t\t// Make sure we're using the right name for getting the float value\n\t\tif ( name.match( /float/i ) )\n\t\t\tname = styleFloat;\n\n\t\tif ( !force && style && style[ name ] )\n\t\t\tret = style[ name ];\n\n\t\telse if ( defaultView.getComputedStyle ) {\n\n\t\t\t// Only \"float\" is needed here\n\t\t\tif ( name.match( /float/i ) )\n\t\t\t\tname = \"float\";\n\n\t\t\tname = name.replace( /([A-Z])/g, \"-$1\" ).toLowerCase();\n\n\t\t\tvar computedStyle = defaultView.getComputedStyle( elem, null );\n\n\t\t\tif ( computedStyle && !color( elem ) )\n\t\t\t\tret = computedStyle.getPropertyValue( name );\n\n\t\t\t// If the element isn't reporting its values properly in Safari\n\t\t\t// then some display: none elements are involved\n\t\t\telse {\n\t\t\t\tvar swap = [], stack = [], a = elem, i = 0;\n\n\t\t\t\t// Locate all of the parent display: none elements\n\t\t\t\tfor ( ; a && color(a); a = a.parentNode )\n\t\t\t\t\tstack.unshift(a);\n\n\t\t\t\t// Go through and make them visible, but in reverse\n\t\t\t\t// (It would be better if we knew the exact display type that they had)\n\t\t\t\tfor ( ; i < stack.length; i++ )\n\t\t\t\t\tif ( color( stack[ i ] ) ) {\n\t\t\t\t\t\tswap[ i ] = stack[ i ].style.display;\n\t\t\t\t\t\tstack[ i ].style.display = \"block\";\n\t\t\t\t\t}\n\n\t\t\t\t// Since we flip the display style, we have to handle that\n\t\t\t\t// one special, otherwise get the value\n\t\t\t\tret = name == \"display\" && swap[ stack.length - 1 ] != null ?\n\t\t\t\t\t\"none\" :\n\t\t\t\t\t( computedStyle && computedStyle.getPropertyValue( name ) ) || \"\";\n\n\t\t\t\t// Finally, revert the display styles back\n\t\t\t\tfor ( i = 0; i < swap.length; i++ )\n\t\t\t\t\tif ( swap[ i ] != null )\n\t\t\t\t\t\tstack[ i ].style.display = swap[ i ];\n\t\t\t}\n\n\t\t\t// We should always get a number back from opacity\n\t\t\tif ( name == \"opacity\" && ret == \"\" )\n\t\t\t\tret = \"1\";\n\n\t\t} else if ( elem.currentStyle ) {\n\t\t\tvar camelCase = name.replace(/\\-(\\w)/g, function(all, letter){\n\t\t\t\treturn letter.toUpperCase();\n\t\t\t});\n\n\t\t\tret = elem.currentStyle[ name ] || elem.currentStyle[ camelCase ];\n\n\t\t\t// From the awesome hack by Dean Edwards\n\t\t\t// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291\n\n\t\t\t// If we're not dealing with a regular pixel number\n\t\t\t// but a number that has a weird ending, we need to convert it to pixels\n\t\t\tif ( !/^\\d+(px)?$/i.test( ret ) && /^\\d/.test( ret ) ) {\n\t\t\t\t// Remember the original values\n\t\t\t\tvar left = style.left, rsLeft = elem.runtimeStyle.left;\n\n\t\t\t\t// Put in the new values to get a computed value out\n\t\t\t\telem.runtimeStyle.left = elem.currentStyle.left;\n\t\t\t\tstyle.left = ret || 0;\n\t\t\t\tret = style.pixelLeft + \"px\";\n\n\t\t\t\t// Revert the changed values\n\t\t\t\tstyle.left = left;\n\t\t\t\telem.runtimeStyle.left = rsLeft;\n\t\t\t}\n\t\t}\n\n\t\treturn ret;\n\t},\n\n\tclean: function( elems, context ) {\n\t\tvar ret = [];\n\t\tcontext = context || document;\n\t\t// !context.createElement fails in IE with an error but returns typeof 'object'\n\t\tif (typeof context.createElement == 'undefined')\n\t\t\tcontext = context.ownerDocument || context[0] && context[0].ownerDocument || document;\n\n\t\tjQuery.each(elems, function(i, elem){\n\t\t\tif ( !elem )\n\t\t\t\treturn;\n\n\t\t\tif ( elem.constructor == Number )\n\t\t\t\telem += '';\n\n\t\t\t// Convert html string into DOM nodes\n\t\t\tif ( typeof elem == \"string\" ) {\n\t\t\t\t// Fix \"XHTML\"-style tags in all browsers\n\t\t\t\telem = elem.replace(/(<(\\w+)[^>]*?)\\/>/g, function(all, front, tag){\n\t\t\t\t\treturn tag.match(/^(abbr|br|col|img|input|link|meta|param|hr|area|embed)$/i) ?\n\t\t\t\t\t\tall :\n\t\t\t\t\t\tfront + \"></\" + tag + \">\";\n\t\t\t\t});\n\n\t\t\t\t// Trim whitespace, otherwise indexOf won't work as expected\n\t\t\t\tvar tags = jQuery.trim( elem ).toLowerCase(), div = context.createElement(\"div\");\n\n\t\t\t\tvar wrap =\n\t\t\t\t\t// option or optgroup\n\t\t\t\t\t!tags.indexOf(\"<opt\") &&\n\t\t\t\t\t[ 1, \"<select multiple='multiple'>\", \"</select>\" ] ||\n\n\t\t\t\t\t!tags.indexOf(\"<leg\") &&\n\t\t\t\t\t[ 1, \"<fieldset>\", \"</fieldset>\" ] ||\n\n\t\t\t\t\ttags.match(/^<(thead|tbody|tfoot|colg|cap)/) &&\n\t\t\t\t\t[ 1, \"<table>\", \"</table>\" ] ||\n\n\t\t\t\t\t!tags.indexOf(\"<tr\") &&\n\t\t\t\t\t[ 2, \"<table><tbody>\", \"</tbody></table>\" ] ||\n\n\t\t\t\t \t// <thead> matched above\n\t\t\t\t\t(!tags.indexOf(\"<td\") || !tags.indexOf(\"<th\")) &&\n\t\t\t\t\t[ 3, \"<table><tbody><tr>\", \"</tr></tbody></table>\" ] ||\n\n\t\t\t\t\t!tags.indexOf(\"<col\") &&\n\t\t\t\t\t[ 2, \"<table><tbody></tbody><colgroup>\", \"</colgroup></table>\" ] ||\n\n\t\t\t\t\t// IE can't serialize <link> and <script> tags normally\n\t\t\t\t\tjQuery.browser.msie &&\n\t\t\t\t\t[ 1, \"div<div>\", \"</div>\" ] ||\n\n\t\t\t\t\t[ 0, \"\", \"\" ];\n\n\t\t\t\t// Go to html and back, then peel off extra wrappers\n\t\t\t\tdiv.innerHTML = wrap[1] + elem + wrap[2];\n\n\t\t\t\t// Move to the right depth\n\t\t\t\twhile ( wrap[0]-- )\n\t\t\t\t\tdiv = div.lastChild;\n\n\t\t\t\t// Remove IE's autoinserted <tbody> from table fragments\n\t\t\t\tif ( jQuery.browser.msie ) {\n\n\t\t\t\t\t// String was a <table>, *may* have spurious <tbody>\n\t\t\t\t\tvar tbody = !tags.indexOf(\"<table\") && tags.indexOf(\"<tbody\") < 0 ?\n\t\t\t\t\t\tdiv.firstChild && div.firstChild.childNodes :\n\n\t\t\t\t\t\t// String was a bare <thead> or <tfoot>\n\t\t\t\t\t\twrap[1] == \"<table>\" && tags.indexOf(\"<tbody\") < 0 ?\n\t\t\t\t\t\t\tdiv.childNodes :\n\t\t\t\t\t\t\t[];\n\n\t\t\t\t\tfor ( var j = tbody.length - 1; j >= 0 ; --j )\n\t\t\t\t\t\tif ( jQuery.nodeName( tbody[ j ], \"tbody\" ) && !tbody[ j ].childNodes.length )\n\t\t\t\t\t\t\ttbody[ j ].parentNode.removeChild( tbody[ j ] );\n\n\t\t\t\t\t// IE completely kills leading whitespace when innerHTML is used\n\t\t\t\t\tif ( /^\\s/.test( elem ) )\n\t\t\t\t\t\tdiv.insertBefore( context.createTextNode( elem.match(/^\\s*/)[0] ), div.firstChild );\n\n\t\t\t\t}\n\n\t\t\t\telem = jQuery.makeArray( div.childNodes );\n\t\t\t}\n\n\t\t\tif ( elem.length === 0 && (!jQuery.nodeName( elem, \"form\" ) && !jQuery.nodeName( elem, \"select\" )) )\n\t\t\t\treturn;\n\n\t\t\tif ( elem[0] == undefined || jQuery.nodeName( elem, \"form\" ) || elem.options )\n\t\t\t\tret.push( elem );\n\n\t\t\telse\n\t\t\t\tret = jQuery.merge( ret, elem );\n\n\t\t});\n\n\t\treturn ret;\n\t},\n\n\tattr: function( elem, name, value ) {\n\t\t// don't set attributes on text and comment nodes\n\t\tif (!elem || elem.nodeType == 3 || elem.nodeType == 8)\n\t\t\treturn undefined;\n\n\t\tvar notxml = !jQuery.isXMLDoc( elem ),\n\t\t\t// Whether we are setting (or getting)\n\t\t\tset = value !== undefined,\n\t\t\tmsie = jQuery.browser.msie;\n\n\t\t// Try to normalize/fix the name\n\t\tname = notxml && jQuery.props[ name ] || name;\n\n\t\t// Only do all the following if this is a node (faster for style)\n\t\t// IE elem.getAttribute passes even for style\n\t\tif ( elem.tagName ) {\n\n\t\t\t// These attributes require special treatment\n\t\t\tvar special = /href|src|style/.test( name );\n\n\t\t\t// Safari mis-reports the default selected property of a hidden option\n\t\t\t// Accessing the parent's selectedIndex property fixes it\n\t\t\tif ( name == \"selected\" && jQuery.browser.safari )\n\t\t\t\telem.parentNode.selectedIndex;\n\n\t\t\t// If applicable, access the attribute via the DOM 0 way\n\t\t\tif ( name in elem && notxml && !special ) {\n\t\t\t\tif ( set ){\n\t\t\t\t\t// We can't allow the type property to be changed (since it causes problems in IE)\n\t\t\t\t\tif ( name == \"type\" && jQuery.nodeName( elem, \"input\" ) && elem.parentNode )\n\t\t\t\t\t\tthrow \"type property can't be changed\";\n\n\t\t\t\t\telem[ name ] = value;\n\t\t\t\t}\n\n\t\t\t\t// browsers index elements by id/name on forms, give priority to attributes.\n\t\t\t\tif( jQuery.nodeName( elem, \"form\" ) && elem.getAttributeNode(name) )\n\t\t\t\t\treturn elem.getAttributeNode( name ).nodeValue;\n\n\t\t\t\treturn elem[ name ];\n\t\t\t}\n\n\t\t\tif ( msie && notxml &&  name == \"style\" )\n\t\t\t\treturn jQuery.attr( elem.style, \"cssText\", value );\n\n\t\t\tif ( set )\n\t\t\t\t// convert the value to a string (all browsers do this but IE) see #1070\n\t\t\t\telem.setAttribute( name, \"\" + value );\n\n\t\t\tvar attr = msie && notxml && special\n\t\t\t\t\t// Some attributes require a special call on IE\n\t\t\t\t\t? elem.getAttribute( name, 2 )\n\t\t\t\t\t: elem.getAttribute( name );\n\n\t\t\t// Non-existent attributes return null, we normalize to undefined\n\t\t\treturn attr === null ? undefined : attr;\n\t\t}\n\n\t\t// elem is actually elem.style ... set the style\n\n\t\t// IE uses filters for opacity\n\t\tif ( msie && name == \"opacity\" ) {\n\t\t\tif ( set ) {\n\t\t\t\t// IE has trouble with opacity if it does not have layout\n\t\t\t\t// Force it by setting the zoom level\n\t\t\t\telem.zoom = 1;\n\n\t\t\t\t// Set the alpha filter to set the opacity\n\t\t\t\telem.filter = (elem.filter || \"\").replace( /alpha\\([^)]*\\)/, \"\" ) +\n\t\t\t\t\t(parseInt( value ) + '' == \"NaN\" ? \"\" : \"alpha(opacity=\" + value * 100 + \")\");\n\t\t\t}\n\n\t\t\treturn elem.filter && elem.filter.indexOf(\"opacity=\") >= 0 ?\n\t\t\t\t(parseFloat( elem.filter.match(/opacity=([^)]*)/)[1] ) / 100) + '':\n\t\t\t\t\"\";\n\t\t}\n\n\t\tname = name.replace(/-([a-z])/ig, function(all, letter){\n\t\t\treturn letter.toUpperCase();\n\t\t});\n\n\t\tif ( set )\n\t\t\telem[ name ] = value;\n\n\t\treturn elem[ name ];\n\t},\n\n\ttrim: function( text ) {\n\t\treturn (text || \"\").replace( /^\\s+|\\s+$/g, \"\" );\n\t},\n\n\tmakeArray: function( array ) {\n\t\tvar ret = [];\n\n\t\tif( array != null ){\n\t\t\tvar i = array.length;\n\t\t\t//the window, strings and functions also have 'length'\n\t\t\tif( i == null || array.split || array.setInterval || array.call )\n\t\t\t\tret[0] = array;\n\t\t\telse\n\t\t\t\twhile( i )\n\t\t\t\t\tret[--i] = array[i];\n\t\t}\n\n\t\treturn ret;\n\t},\n\n\tinArray: function( elem, array ) {\n\t\tfor ( var i = 0, length = array.length; i < length; i++ )\n\t\t// Use === because on IE, window == document\n\t\t\tif ( array[ i ] === elem )\n\t\t\t\treturn i;\n\n\t\treturn -1;\n\t},\n\n\tmerge: function( first, second ) {\n\t\t// We have to loop this way because IE & Opera overwrite the length\n\t\t// expando of getElementsByTagName\n\t\tvar i = 0, elem, pos = first.length;\n\t\t// Also, we need to make sure that the correct elements are being returned\n\t\t// (IE returns comment nodes in a '*' query)\n\t\tif ( jQuery.browser.msie ) {\n\t\t\twhile ( elem = second[ i++ ] )\n\t\t\t\tif ( elem.nodeType != 8 )\n\t\t\t\t\tfirst[ pos++ ] = elem;\n\n\t\t} else\n\t\t\twhile ( elem = second[ i++ ] )\n\t\t\t\tfirst[ pos++ ] = elem;\n\n\t\treturn first;\n\t},\n\n\tunique: function( array ) {\n\t\tvar ret = [], done = {};\n\n\t\ttry {\n\n\t\t\tfor ( var i = 0, length = array.length; i < length; i++ ) {\n\t\t\t\tvar id = jQuery.data( array[ i ] );\n\n\t\t\t\tif ( !done[ id ] ) {\n\t\t\t\t\tdone[ id ] = true;\n\t\t\t\t\tret.push( array[ i ] );\n\t\t\t\t}\n\t\t\t}\n\n\t\t} catch( e ) {\n\t\t\tret = array;\n\t\t}\n\n\t\treturn ret;\n\t},\n\n\tgrep: function( elems, callback, inv ) {\n\t\tvar ret = [];\n\n\t\t// Go through the array, only saving the items\n\t\t// that pass the validator function\n\t\tfor ( var i = 0, length = elems.length; i < length; i++ )\n\t\t\tif ( !inv != !callback( elems[ i ], i ) )\n\t\t\t\tret.push( elems[ i ] );\n\n\t\treturn ret;\n\t},\n\n\tmap: function( elems, callback ) {\n\t\tvar ret = [];\n\n\t\t// Go through the array, translating each of the items to their\n\t\t// new value (or values).\n\t\tfor ( var i = 0, length = elems.length; i < length; i++ ) {\n\t\t\tvar value = callback( elems[ i ], i );\n\n\t\t\tif ( value != null )\n\t\t\t\tret[ ret.length ] = value;\n\t\t}\n\n\t\treturn ret.concat.apply( [], ret );\n\t}\n});\n\nvar userAgent = navigator.userAgent.toLowerCase();\n\n// Figure out what browser is being used\njQuery.browser = {\n\tversion: (userAgent.match( /.+(?:rv|it|ra|ie)[\\/: ]([\\d.]+)/ ) || [])[1],\n\tsafari: /webkit/.test( userAgent ),\n\topera: /opera/.test( userAgent ),\n\tmsie: /msie/.test( userAgent ) && !/opera/.test( userAgent ),\n\tmozilla: /mozilla/.test( userAgent ) && !/(compatible|webkit)/.test( userAgent )\n};\n\nvar styleFloat = jQuery.browser.msie ?\n\t\"styleFloat\" :\n\t\"cssFloat\";\n\njQuery.extend({\n\t// Check to see if the W3C box model is being used\n\tboxModel: !jQuery.browser.msie || document.compatMode == \"CSS1Compat\",\n\n\tprops: {\n\t\t\"for\": \"htmlFor\",\n\t\t\"class\": \"className\",\n\t\t\"float\": styleFloat,\n\t\tcssFloat: styleFloat,\n\t\tstyleFloat: styleFloat,\n\t\treadonly: \"readOnly\",\n\t\tmaxlength: \"maxLength\",\n\t\tcellspacing: \"cellSpacing\"\n\t}\n});\n\njQuery.each({\n\tparent: function(elem){return elem.parentNode;},\n\tparents: function(elem){return jQuery.dir(elem,\"parentNode\");},\n\tnext: function(elem){return jQuery.nth(elem,2,\"nextSibling\");},\n\tprev: function(elem){return jQuery.nth(elem,2,\"previousSibling\");},\n\tnextAll: function(elem){return jQuery.dir(elem,\"nextSibling\");},\n\tprevAll: function(elem){return jQuery.dir(elem,\"previousSibling\");},\n\tsiblings: function(elem){return jQuery.sibling(elem.parentNode.firstChild,elem);},\n\tchildren: function(elem){return jQuery.sibling(elem.firstChild);},\n\tcontents: function(elem){return jQuery.nodeName(elem,\"iframe\")?elem.contentDocument||elem.contentWindow.document:jQuery.makeArray(elem.childNodes);}\n}, function(name, fn){\n\tjQuery.fn[ name ] = function( selector ) {\n\t\tvar ret = jQuery.map( this, fn );\n\n\t\tif ( selector && typeof selector == \"string\" )\n\t\t\tret = jQuery.multiFilter( selector, ret );\n\n\t\treturn this.pushStack( jQuery.unique( ret ) );\n\t};\n});\n\njQuery.each({\n\tappendTo: \"append\",\n\tprependTo: \"prepend\",\n\tinsertBefore: \"before\",\n\tinsertAfter: \"after\",\n\treplaceAll: \"replaceWith\"\n}, function(name, original){\n\tjQuery.fn[ name ] = function() {\n\t\tvar args = arguments;\n\n\t\treturn this.each(function(){\n\t\t\tfor ( var i = 0, length = args.length; i < length; i++ )\n\t\t\t\tjQuery( args[ i ] )[ original ]( this );\n\t\t});\n\t};\n});\n\njQuery.each({\n\tremoveAttr: function( name ) {\n\t\tjQuery.attr( this, name, \"\" );\n\t\tif (this.nodeType == 1)\n\t\t\tthis.removeAttribute( name );\n\t},\n\n\taddClass: function( classNames ) {\n\t\tjQuery.className.add( this, classNames );\n\t},\n\n\tremoveClass: function( classNames ) {\n\t\tjQuery.className.remove( this, classNames );\n\t},\n\n\ttoggleClass: function( classNames ) {\n\t\tjQuery.className[ jQuery.className.has( this, classNames ) ? \"remove\" : \"add\" ]( this, classNames );\n\t},\n\n\tremove: function( selector ) {\n\t\tif ( !selector || jQuery.filter( selector, [ this ] ).r.length ) {\n\t\t\t// Prevent memory leaks\n\t\t\tjQuery( \"*\", this ).add(this).each(function(){\n\t\t\t\tjQuery.event.remove(this);\n\t\t\t\tjQuery.removeData(this);\n\t\t\t});\n\t\t\tif (this.parentNode)\n\t\t\t\tthis.parentNode.removeChild( this );\n\t\t}\n\t},\n\n\tempty: function() {\n\t\t// Remove element nodes and prevent memory leaks\n\t\tjQuery( \">*\", this ).remove();\n\n\t\t// Remove any remaining nodes\n\t\twhile ( this.firstChild )\n\t\t\tthis.removeChild( this.firstChild );\n\t}\n}, function(name, fn){\n\tjQuery.fn[ name ] = function(){\n\t\treturn this.each( fn, arguments );\n\t};\n});\n\njQuery.each([ \"Height\", \"Width\" ], function(i, name){\n\tvar type = name.toLowerCase();\n\n\tjQuery.fn[ type ] = function( size ) {\n\t\t// Get window width or height\n\t\treturn this[0] == window ?\n\t\t\t// Opera reports document.body.client[Width/Height] properly in both quirks and standards\n\t\t\tjQuery.browser.opera && document.body[ \"client\" + name ] ||\n\n\t\t\t// Safari reports inner[Width/Height] just fine (Mozilla and Opera include scroll bar widths)\n\t\t\tjQuery.browser.safari && window[ \"inner\" + name ] ||\n\n\t\t\t// Everyone else use document.documentElement or document.body depending on Quirks vs Standards mode\n\t\t\tdocument.compatMode == \"CSS1Compat\" && document.documentElement[ \"client\" + name ] || document.body[ \"client\" + name ] :\n\n\t\t\t// Get document width or height\n\t\t\tthis[0] == document ?\n\t\t\t\t// Either scroll[Width/Height] or offset[Width/Height], whichever is greater\n\t\t\t\tMath.max(\n\t\t\t\t\tMath.max(document.body[\"scroll\" + name], document.documentElement[\"scroll\" + name]),\n\t\t\t\t\tMath.max(document.body[\"offset\" + name], document.documentElement[\"offset\" + name])\n\t\t\t\t) :\n\n\t\t\t\t// Get or set width or height on the element\n\t\t\t\tsize == undefined ?\n\t\t\t\t\t// Get width or height on the element\n\t\t\t\t\t(this.length ? jQuery.css( this[0], type ) : null) :\n\n\t\t\t\t\t// Set the width or height on the element (default to pixels if value is unitless)\n\t\t\t\t\tthis.css( type, size.constructor == String ? size : size + \"px\" );\n\t};\n});\n\n// Helper function used by the dimensions and offset modules\nfunction num(elem, prop) {\n\treturn elem[0] && parseInt( jQuery.curCSS(elem[0], prop, true), 10 ) || 0;\n}var chars = jQuery.browser.safari && parseInt(jQuery.browser.version) < 417 ?\n\t\t\"(?:[\\\\w*_-]|\\\\\\\\.)\" :\n\t\t\"(?:[\\\\w\\u0128-\\uFFFF*_-]|\\\\\\\\.)\",\n\tquickChild = new RegExp(\"^>\\\\s*(\" + chars + \"+)\"),\n\tquickID = new RegExp(\"^(\" + chars + \"+)(#)(\" + chars + \"+)\"),\n\tquickClass = new RegExp(\"^([#.]?)(\" + chars + \"*)\");\n\njQuery.extend({\n\texpr: {\n\t\t\"\": function(a,i,m){return m[2]==\"*\"||jQuery.nodeName(a,m[2]);},\n\t\t\"#\": function(a,i,m){return a.getAttribute(\"id\")==m[2];},\n\t\t\":\": {\n\t\t\t// Position Checks\n\t\t\tlt: function(a,i,m){return i<m[3]-0;},\n\t\t\tgt: function(a,i,m){return i>m[3]-0;},\n\t\t\tnth: function(a,i,m){return m[3]-0==i;},\n\t\t\teq: function(a,i,m){return m[3]-0==i;},\n\t\t\tfirst: function(a,i){return i==0;},\n\t\t\tlast: function(a,i,m,r){return i==r.length-1;},\n\t\t\teven: function(a,i){return i%2==0;},\n\t\t\todd: function(a,i){return i%2;},\n\n\t\t\t// Child Checks\n\t\t\t\"first-child\": function(a){return a.parentNode.getElementsByTagName(\"*\")[0]==a;},\n\t\t\t\"last-child\": function(a){return jQuery.nth(a.parentNode.lastChild,1,\"previousSibling\")==a;},\n\t\t\t\"only-child\": function(a){return !jQuery.nth(a.parentNode.lastChild,2,\"previousSibling\");},\n\n\t\t\t// Parent Checks\n\t\t\tparent: function(a){return a.firstChild;},\n\t\t\tempty: function(a){return !a.firstChild;},\n\n\t\t\t// Text Check\n\t\t\tcontains: function(a,i,m){return (a.textContent||a.innerText||jQuery(a).text()||\"\").indexOf(m[3])>=0;},\n\n\t\t\t// Visibility\n\t\t\tvisible: function(a){return \"hidden\"!=a.type&&jQuery.css(a,\"display\")!=\"none\"&&jQuery.css(a,\"visibility\")!=\"hidden\";},\n\t\t\thidden: function(a){return \"hidden\"==a.type||jQuery.css(a,\"display\")==\"none\"||jQuery.css(a,\"visibility\")==\"hidden\";},\n\n\t\t\t// Form attributes\n\t\t\tenabled: function(a){return !a.disabled;},\n\t\t\tdisabled: function(a){return a.disabled;},\n\t\t\tchecked: function(a){return a.checked;},\n\t\t\tselected: function(a){return a.selected||jQuery.attr(a,\"selected\");},\n\n\t\t\t// Form elements\n\t\t\ttext: function(a){return \"text\"==a.type;},\n\t\t\tradio: function(a){return \"radio\"==a.type;},\n\t\t\tcheckbox: function(a){return \"checkbox\"==a.type;},\n\t\t\tfile: function(a){return \"file\"==a.type;},\n\t\t\tpassword: function(a){return \"password\"==a.type;},\n\t\t\tsubmit: function(a){return \"submit\"==a.type;},\n\t\t\timage: function(a){return \"image\"==a.type;},\n\t\t\treset: function(a){return \"reset\"==a.type;},\n\t\t\tbutton: function(a){return \"button\"==a.type||jQuery.nodeName(a,\"button\");},\n\t\t\tinput: function(a){return /input|select|textarea|button/i.test(a.nodeName);},\n\n\t\t\t// :has()\n\t\t\thas: function(a,i,m){return jQuery.find(m[3],a).length;},\n\n\t\t\t// :header\n\t\t\theader: function(a){return /h\\d/i.test(a.nodeName);},\n\n\t\t\t// :animated\n\t\t\tanimated: function(a){return jQuery.grep(jQuery.timers,function(fn){return a==fn.elem;}).length;}\n\t\t}\n\t},\n\n\t// The regular expressions that power the parsing engine\n\tparse: [\n\t\t// Match: [@value='test'], [@foo]\n\t\t/^(\\[) *@?([\\w-]+) *([!*$^~=]*) *('?\"?)(.*?)\\4 *\\]/,\n\n\t\t// Match: :contains('foo')\n\t\t/^(:)([\\w-]+)\\(\"?'?(.*?(\\(.*?\\))?[^(]*?)\"?'?\\)/,\n\n\t\t// Match: :even, :last-child, #id, .class\n\t\tnew RegExp(\"^([:.#]*)(\" + chars + \"+)\")\n\t],\n\n\tmultiFilter: function( expr, elems, not ) {\n\t\tvar old, cur = [];\n\n\t\twhile ( expr && expr != old ) {\n\t\t\told = expr;\n\t\t\tvar f = jQuery.filter( expr, elems, not );\n\t\t\texpr = f.t.replace(/^\\s*,\\s*/, \"\" );\n\t\t\tcur = not ? elems = f.r : jQuery.merge( cur, f.r );\n\t\t}\n\n\t\treturn cur;\n\t},\n\n\tfind: function( t, context ) {\n\t\t// Quickly handle non-string expressions\n\t\tif ( typeof t != \"string\" )\n\t\t\treturn [ t ];\n\n\t\t// check to make sure context is a DOM element or a document\n\t\tif ( context && context.nodeType != 1 && context.nodeType != 9)\n\t\t\treturn [ ];\n\n\t\t// Set the correct context (if none is provided)\n\t\tcontext = context || document;\n\n\t\t// Initialize the search\n\t\tvar ret = [context], done = [], last, nodeName;\n\n\t\t// Continue while a selector expression exists, and while\n\t\t// we're no longer looping upon ourselves\n\t\twhile ( t && last != t ) {\n\t\t\tvar r = [];\n\t\t\tlast = t;\n\n\t\t\tt = jQuery.trim(t);\n\n\t\t\tvar foundToken = false,\n\n\t\t\t// An attempt at speeding up child selectors that\n\t\t\t// point to a specific element tag\n\t\t\t\tre = quickChild,\n\n\t\t\t\tm = re.exec(t);\n\n\t\t\tif ( m ) {\n\t\t\t\tnodeName = m[1].toUpperCase();\n\n\t\t\t\t// Perform our own iteration and filter\n\t\t\t\tfor ( var i = 0; ret[i]; i++ )\n\t\t\t\t\tfor ( var c = ret[i].firstChild; c; c = c.nextSibling )\n\t\t\t\t\t\tif ( c.nodeType == 1 && (nodeName == \"*\" || c.nodeName.toUpperCase() == nodeName) )\n\t\t\t\t\t\t\tr.push( c );\n\n\t\t\t\tret = r;\n\t\t\t\tt = t.replace( re, \"\" );\n\t\t\t\tif ( t.indexOf(\" \") == 0 ) continue;\n\t\t\t\tfoundToken = true;\n\t\t\t} else {\n\t\t\t\tre = /^([>+~])\\s*(\\w*)/i;\n\n\t\t\t\tif ( (m = re.exec(t)) != null ) {\n\t\t\t\t\tr = [];\n\n\t\t\t\t\tvar merge = {};\n\t\t\t\t\tnodeName = m[2].toUpperCase();\n\t\t\t\t\tm = m[1];\n\n\t\t\t\t\tfor ( var j = 0, rl = ret.length; j < rl; j++ ) {\n\t\t\t\t\t\tvar n = m == \"~\" || m == \"+\" ? ret[j].nextSibling : ret[j].firstChild;\n\t\t\t\t\t\tfor ( ; n; n = n.nextSibling )\n\t\t\t\t\t\t\tif ( n.nodeType == 1 ) {\n\t\t\t\t\t\t\t\tvar id = jQuery.data(n);\n\n\t\t\t\t\t\t\t\tif ( m == \"~\" && merge[id] ) break;\n\n\t\t\t\t\t\t\t\tif (!nodeName || n.nodeName.toUpperCase() == nodeName ) {\n\t\t\t\t\t\t\t\t\tif ( m == \"~\" ) merge[id] = true;\n\t\t\t\t\t\t\t\t\tr.push( n );\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\t\tif ( m == \"+\" ) break;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tret = r;\n\n\t\t\t\t\t// And remove the token\n\t\t\t\t\tt = jQuery.trim( t.replace( re, \"\" ) );\n\t\t\t\t\tfoundToken = true;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// See if there's still an expression, and that we haven't already\n\t\t\t// matched a token\n\t\t\tif ( t && !foundToken ) {\n\t\t\t\t// Handle multiple expressions\n\t\t\t\tif ( !t.indexOf(\",\") ) {\n\t\t\t\t\t// Clean the result set\n\t\t\t\t\tif ( context == ret[0] ) ret.shift();\n\n\t\t\t\t\t// Merge the result sets\n\t\t\t\t\tdone = jQuery.merge( done, ret );\n\n\t\t\t\t\t// Reset the context\n\t\t\t\t\tr = ret = [context];\n\n\t\t\t\t\t// Touch up the selector string\n\t\t\t\t\tt = \" \" + t.substr(1,t.length);\n\n\t\t\t\t} else {\n\t\t\t\t\t// Optimize for the case nodeName#idName\n\t\t\t\t\tvar re2 = quickID;\n\t\t\t\t\tvar m = re2.exec(t);\n\n\t\t\t\t\t// Re-organize the results, so that they're consistent\n\t\t\t\t\tif ( m ) {\n\t\t\t\t\t\tm = [ 0, m[2], m[3], m[1] ];\n\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// Otherwise, do a traditional filter check for\n\t\t\t\t\t\t// ID, class, and element selectors\n\t\t\t\t\t\tre2 = quickClass;\n\t\t\t\t\t\tm = re2.exec(t);\n\t\t\t\t\t}\n\n\t\t\t\t\tm[2] = m[2].replace(/\\\\/g, \"\");\n\n\t\t\t\t\tvar elem = ret[ret.length-1];\n\n\t\t\t\t\t// Try to do a global search by ID, where we can\n\t\t\t\t\tif ( m[1] == \"#\" && elem && elem.getElementById && !jQuery.isXMLDoc(elem) ) {\n\t\t\t\t\t\t// Optimization for HTML document case\n\t\t\t\t\t\tvar oid = elem.getElementById(m[2]);\n\n\t\t\t\t\t\t// Do a quick check for the existence of the actual ID attribute\n\t\t\t\t\t\t// to avoid selecting by the name attribute in IE\n\t\t\t\t\t\t// also check to insure id is a string to avoid selecting an element with the name of 'id' inside a form\n\t\t\t\t\t\tif ( (jQuery.browser.msie||jQuery.browser.opera) && oid && typeof oid.id == \"string\" && oid.id != m[2] )\n\t\t\t\t\t\t\toid = jQuery('[@id=\"'+m[2]+'\"]', elem)[0];\n\n\t\t\t\t\t\t// Do a quick check for node name (where applicable) so\n\t\t\t\t\t\t// that div#foo searches will be really fast\n\t\t\t\t\t\tret = r = oid && (!m[3] || jQuery.nodeName(oid, m[3])) ? [oid] : [];\n\t\t\t\t\t} else {\n\t\t\t\t\t\t// We need to find all descendant elements\n\t\t\t\t\t\tfor ( var i = 0; ret[i]; i++ ) {\n\t\t\t\t\t\t\t// Grab the tag name being searched for\n\t\t\t\t\t\t\tvar tag = m[1] == \"#\" && m[3] ? m[3] : m[1] != \"\" || m[0] == \"\" ? \"*\" : m[2];\n\n\t\t\t\t\t\t\t// Handle IE7 being really dumb about <object>s\n\t\t\t\t\t\t\tif ( tag == \"*\" && ret[i].nodeName.toLowerCase() == \"object\" )\n\t\t\t\t\t\t\t\ttag = \"param\";\n\n\t\t\t\t\t\t\tr = jQuery.merge( r, ret[i].getElementsByTagName( tag ));\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// It's faster to filter by class and be done with it\n\t\t\t\t\t\tif ( m[1] == \".\" )\n\t\t\t\t\t\t\tr = jQuery.classFilter( r, m[2] );\n\n\t\t\t\t\t\t// Same with ID filtering\n\t\t\t\t\t\tif ( m[1] == \"#\" ) {\n\t\t\t\t\t\t\tvar tmp = [];\n\n\t\t\t\t\t\t\t// Try to find the element with the ID\n\t\t\t\t\t\t\tfor ( var i = 0; r[i]; i++ )\n\t\t\t\t\t\t\t\tif ( r[i].getAttribute(\"id\") == m[2] ) {\n\t\t\t\t\t\t\t\t\ttmp = [ r[i] ];\n\t\t\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t\t\t}\n\n\t\t\t\t\t\t\tr = tmp;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tret = r;\n\t\t\t\t\t}\n\n\t\t\t\t\tt = t.replace( re2, \"\" );\n\t\t\t\t}\n\n\t\t\t}\n\n\t\t\t// If a selector string still exists\n\t\t\tif ( t ) {\n\t\t\t\t// Attempt to filter it\n\t\t\t\tvar val = jQuery.filter(t,r);\n\t\t\t\tret = r = val.r;\n\t\t\t\tt = jQuery.trim(val.t);\n\t\t\t}\n\t\t}\n\n\t\t// An error occurred with the selector;\n\t\t// just return an empty set instead\n\t\tif ( t )\n\t\t\tret = [];\n\n\t\t// Remove the root context\n\t\tif ( ret && context == ret[0] )\n\t\t\tret.shift();\n\n\t\t// And combine the results\n\t\tdone = jQuery.merge( done, ret );\n\n\t\treturn done;\n\t},\n\n\tclassFilter: function(r,m,not){\n\t\tm = \" \" + m + \" \";\n\t\tvar tmp = [];\n\t\tfor ( var i = 0; r[i]; i++ ) {\n\t\t\tvar pass = (\" \" + r[i].className + \" \").indexOf( m ) >= 0;\n\t\t\tif ( !not && pass || not && !pass )\n\t\t\t\ttmp.push( r[i] );\n\t\t}\n\t\treturn tmp;\n\t},\n\n\tfilter: function(t,r,not) {\n\t\tvar last;\n\n\t\t// Look for common filter expressions\n\t\twhile ( t && t != last ) {\n\t\t\tlast = t;\n\n\t\t\tvar p = jQuery.parse, m;\n\n\t\t\tfor ( var i = 0; p[i]; i++ ) {\n\t\t\t\tm = p[i].exec( t );\n\n\t\t\t\tif ( m ) {\n\t\t\t\t\t// Remove what we just matched\n\t\t\t\t\tt = t.substring( m[0].length );\n\n\t\t\t\t\tm[2] = m[2].replace(/\\\\/g, \"\");\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( !m )\n\t\t\t\tbreak;\n\n\t\t\t// :not() is a special case that can be optimized by\n\t\t\t// keeping it out of the expression list\n\t\t\tif ( m[1] == \":\" && m[2] == \"not\" )\n\t\t\t\t// optimize if only one selector found (most common case)\n\t\t\t\tr = isSimple.test( m[3] ) ?\n\t\t\t\t\tjQuery.filter(m[3], r, true).r :\n\t\t\t\t\tjQuery( r ).not( m[3] );\n\n\t\t\t// We can get a big speed boost by filtering by class here\n\t\t\telse if ( m[1] == \".\" )\n\t\t\t\tr = jQuery.classFilter(r, m[2], not);\n\n\t\t\telse if ( m[1] == \"[\" ) {\n\t\t\t\tvar tmp = [], type = m[3];\n\n\t\t\t\tfor ( var i = 0, rl = r.length; i < rl; i++ ) {\n\t\t\t\t\tvar a = r[i], z = a[ jQuery.props[m[2]] || m[2] ];\n\n\t\t\t\t\tif ( z == null || /href|src|selected/.test(m[2]) )\n\t\t\t\t\t\tz = jQuery.attr(a,m[2]) || '';\n\n\t\t\t\t\tif ( (type == \"\" && !!z ||\n\t\t\t\t\t\t type == \"=\" && z == m[5] ||\n\t\t\t\t\t\t type == \"!=\" && z != m[5] ||\n\t\t\t\t\t\t type == \"^=\" && z && !z.indexOf(m[5]) ||\n\t\t\t\t\t\t type == \"$=\" && z.substr(z.length - m[5].length) == m[5] ||\n\t\t\t\t\t\t (type == \"*=\" || type == \"~=\") && z.indexOf(m[5]) >= 0) ^ not )\n\t\t\t\t\t\t\ttmp.push( a );\n\t\t\t\t}\n\n\t\t\t\tr = tmp;\n\n\t\t\t// We can get a speed boost by handling nth-child here\n\t\t\t} else if ( m[1] == \":\" && m[2] == \"nth-child\" ) {\n\t\t\t\tvar merge = {}, tmp = [],\n\t\t\t\t\t// parse equations like 'even', 'odd', '5', '2n', '3n+2', '4n-1', '-n+6'\n\t\t\t\t\ttest = /(-?)(\\d*)n((?:\\+|-)?\\d*)/.exec(\n\t\t\t\t\t\tm[3] == \"even\" && \"2n\" || m[3] == \"odd\" && \"2n+1\" ||\n\t\t\t\t\t\t!/\\D/.test(m[3]) && \"0n+\" + m[3] || m[3]),\n\t\t\t\t\t// calculate the numbers (first)n+(last) including if they are negative\n\t\t\t\t\tfirst = (test[1] + (test[2] || 1)) - 0, last = test[3] - 0;\n\n\t\t\t\t// loop through all the elements left in the jQuery object\n\t\t\t\tfor ( var i = 0, rl = r.length; i < rl; i++ ) {\n\t\t\t\t\tvar node = r[i], parentNode = node.parentNode, id = jQuery.data(parentNode);\n\n\t\t\t\t\tif ( !merge[id] ) {\n\t\t\t\t\t\tvar c = 1;\n\n\t\t\t\t\t\tfor ( var n = parentNode.firstChild; n; n = n.nextSibling )\n\t\t\t\t\t\t\tif ( n.nodeType == 1 )\n\t\t\t\t\t\t\t\tn.nodeIndex = c++;\n\n\t\t\t\t\t\tmerge[id] = true;\n\t\t\t\t\t}\n\n\t\t\t\t\tvar add = false;\n\n\t\t\t\t\tif ( first == 0 ) {\n\t\t\t\t\t\tif ( node.nodeIndex == last )\n\t\t\t\t\t\t\tadd = true;\n\t\t\t\t\t} else if ( (node.nodeIndex - last) % first == 0 && (node.nodeIndex - last) / first >= 0 )\n\t\t\t\t\t\tadd = true;\n\n\t\t\t\t\tif ( add ^ not )\n\t\t\t\t\t\ttmp.push( node );\n\t\t\t\t}\n\n\t\t\t\tr = tmp;\n\n\t\t\t// Otherwise, find the expression to execute\n\t\t\t} else {\n\t\t\t\tvar fn = jQuery.expr[ m[1] ];\n\t\t\t\tif ( typeof fn == \"object\" )\n\t\t\t\t\tfn = fn[ m[2] ];\n\n\t\t\t\tif ( typeof fn == \"string\" )\n\t\t\t\t\tfn = eval(\"false||function(a,i){return \" + fn + \";}\");\n\n\t\t\t\t// Execute it against the current filter\n\t\t\t\tr = jQuery.grep( r, function(elem, i){\n\t\t\t\t\treturn fn(elem, i, m, r);\n\t\t\t\t}, not );\n\t\t\t}\n\t\t}\n\n\t\t// Return an array of filtered elements (r)\n\t\t// and the modified expression string (t)\n\t\treturn { r: r, t: t };\n\t},\n\n\tdir: function( elem, dir ){\n\t\tvar matched = [],\n\t\t\tcur = elem[dir];\n\t\twhile ( cur && cur != document ) {\n\t\t\tif ( cur.nodeType == 1 )\n\t\t\t\tmatched.push( cur );\n\t\t\tcur = cur[dir];\n\t\t}\n\t\treturn matched;\n\t},\n\n\tnth: function(cur,result,dir,elem){\n\t\tresult = result || 1;\n\t\tvar num = 0;\n\n\t\tfor ( ; cur; cur = cur[dir] )\n\t\t\tif ( cur.nodeType == 1 && ++num == result )\n\t\t\t\tbreak;\n\n\t\treturn cur;\n\t},\n\n\tsibling: function( n, elem ) {\n\t\tvar r = [];\n\n\t\tfor ( ; n; n = n.nextSibling ) {\n\t\t\tif ( n.nodeType == 1 && n != elem )\n\t\t\t\tr.push( n );\n\t\t}\n\n\t\treturn r;\n\t}\n});\n/*\n * A number of helper functions used for managing events.\n * Many of the ideas behind this code orignated from\n * Dean Edwards' addEvent library.\n */\njQuery.event = {\n\n\t// Bind an event to an element\n\t// Original by Dean Edwards\n\tadd: function(elem, types, handler, data) {\n\t\tif ( elem.nodeType == 3 || elem.nodeType == 8 )\n\t\t\treturn;\n\n\t\t// For whatever reason, IE has trouble passing the window object\n\t\t// around, causing it to be cloned in the process\n\t\tif ( jQuery.browser.msie && elem.setInterval )\n\t\t\telem = window;\n\n\t\t// Make sure that the function being executed has a unique ID\n\t\tif ( !handler.guid )\n\t\t\thandler.guid = this.guid++;\n\n\t\t// if data is passed, bind to handler\n\t\tif( data != undefined ) {\n\t\t\t// Create temporary function pointer to original handler\n\t\t\tvar fn = handler;\n\n\t\t\t// Create unique handler function, wrapped around original handler\n\t\t\thandler = this.proxy( fn, function() {\n\t\t\t\t// Pass arguments and context to original handler\n\t\t\t\treturn fn.apply(this, arguments);\n\t\t\t});\n\n\t\t\t// Store data in unique handler\n\t\t\thandler.data = data;\n\t\t}\n\n\t\t// Init the element's event structure\n\t\tvar events = jQuery.data(elem, \"events\") || jQuery.data(elem, \"events\", {}),\n\t\t\thandle = jQuery.data(elem, \"handle\") || jQuery.data(elem, \"handle\", function(){\n\t\t\t\t// Handle the second event of a trigger and when\n\t\t\t\t// an event is called after a page has unloaded\n\t\t\t\tif ( typeof jQuery != \"undefined\" && !jQuery.event.triggered )\n\t\t\t\t\treturn jQuery.event.handle.apply(arguments.callee.elem, arguments);\n\t\t\t});\n\t\t// Add elem as a property of the handle function\n\t\t// This is to prevent a memory leak with non-native\n\t\t// event in IE.\n\t\thandle.elem = elem;\n\n\t\t// Handle multiple events separated by a space\n\t\t// jQuery(...).bind(\"mouseover mouseout\", fn);\n\t\tjQuery.each(types.split(/\\s+/), function(index, type) {\n\t\t\t// Namespaced event handlers\n\t\t\tvar parts = type.split(\".\");\n\t\t\ttype = parts[0];\n\t\t\thandler.type = parts[1];\n\n\t\t\t// Get the current list of functions bound to this event\n\t\t\tvar handlers = events[type];\n\n\t\t\t// Init the event handler queue\n\t\t\tif (!handlers) {\n\t\t\t\thandlers = events[type] = {};\n\n\t\t\t\t// Check for a special event handler\n\t\t\t\t// Only use addEventListener/attachEvent if the special\n\t\t\t\t// events handler returns false\n\t\t\t\tif ( !jQuery.event.special[type] || jQuery.event.special[type].setup.call(elem) === false ) {\n\t\t\t\t\t// Bind the global event handler to the element\n\t\t\t\t\tif (elem.addEventListener)\n\t\t\t\t\t\telem.addEventListener(type, handle, false);\n\t\t\t\t\telse if (elem.attachEvent)\n\t\t\t\t\t\telem.attachEvent(\"on\" + type, handle);\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Add the function to the element's handler list\n\t\t\thandlers[handler.guid] = handler;\n\n\t\t\t// Keep track of which events have been used, for global triggering\n\t\t\tjQuery.event.global[type] = true;\n\t\t});\n\n\t\t// Nullify elem to prevent memory leaks in IE\n\t\telem = null;\n\t},\n\n\tguid: 1,\n\tglobal: {},\n\n\t// Detach an event or set of events from an element\n\tremove: function(elem, types, handler) {\n\t\t// don't do events on text and comment nodes\n\t\tif ( elem.nodeType == 3 || elem.nodeType == 8 )\n\t\t\treturn;\n\n\t\tvar events = jQuery.data(elem, \"events\"), ret, index;\n\n\t\tif ( events ) {\n\t\t\t// Unbind all events for the element\n\t\t\tif ( types == undefined || (typeof types == \"string\" && types.charAt(0) == \".\") )\n\t\t\t\tfor ( var type in events )\n\t\t\t\t\tthis.remove( elem, type + (types || \"\") );\n\t\t\telse {\n\t\t\t\t// types is actually an event object here\n\t\t\t\tif ( types.type ) {\n\t\t\t\t\thandler = types.handler;\n\t\t\t\t\ttypes = types.type;\n\t\t\t\t}\n\n\t\t\t\t// Handle multiple events seperated by a space\n\t\t\t\t// jQuery(...).unbind(\"mouseover mouseout\", fn);\n\t\t\t\tjQuery.each(types.split(/\\s+/), function(index, type){\n\t\t\t\t\t// Namespaced event handlers\n\t\t\t\t\tvar parts = type.split(\".\");\n\t\t\t\t\ttype = parts[0];\n\n\t\t\t\t\tif ( events[type] ) {\n\t\t\t\t\t\t// remove the given handler for the given type\n\t\t\t\t\t\tif ( handler )\n\t\t\t\t\t\t\tdelete events[type][handler.guid];\n\n\t\t\t\t\t\t// remove all handlers for the given type\n\t\t\t\t\t\telse\n\t\t\t\t\t\t\tfor ( handler in events[type] )\n\t\t\t\t\t\t\t\t// Handle the removal of namespaced events\n\t\t\t\t\t\t\t\tif ( !parts[1] || events[type][handler].type == parts[1] )\n\t\t\t\t\t\t\t\t\tdelete events[type][handler];\n\n\t\t\t\t\t\t// remove generic event handler if no more handlers exist\n\t\t\t\t\t\tfor ( ret in events[type] ) break;\n\t\t\t\t\t\tif ( !ret ) {\n\t\t\t\t\t\t\tif ( !jQuery.event.special[type] || jQuery.event.special[type].teardown.call(elem) === false ) {\n\t\t\t\t\t\t\t\tif (elem.removeEventListener)\n\t\t\t\t\t\t\t\t\telem.removeEventListener(type, jQuery.data(elem, \"handle\"), false);\n\t\t\t\t\t\t\t\telse if (elem.detachEvent)\n\t\t\t\t\t\t\t\t\telem.detachEvent(\"on\" + type, jQuery.data(elem, \"handle\"));\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tret = null;\n\t\t\t\t\t\t\tdelete events[type];\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\n\t\t\t// Remove the expando if it's no longer used\n\t\t\tfor ( ret in events ) break;\n\t\t\tif ( !ret ) {\n\t\t\t\tvar handle = jQuery.data( elem, \"handle\" );\n\t\t\t\tif ( handle ) handle.elem = null;\n\t\t\t\tjQuery.removeData( elem, \"events\" );\n\t\t\t\tjQuery.removeData( elem, \"handle\" );\n\t\t\t}\n\t\t}\n\t},\n\n\ttrigger: function(type, data, elem, donative, extra) {\n\t\t// Clone the incoming data, if any\n\t\tdata = jQuery.makeArray(data);\n\n\t\tif ( type.indexOf(\"!\") >= 0 ) {\n\t\t\ttype = type.slice(0, -1);\n\t\t\tvar exclusive = true;\n\t\t}\n\n\t\t// Handle a global trigger\n\t\tif ( !elem ) {\n\t\t\t// Only trigger if we've ever bound an event for it\n\t\t\tif ( this.global[type] )\n\t\t\t\tjQuery(\"*\").add([window, document]).trigger(type, data);\n\n\t\t// Handle triggering a single element\n\t\t} else {\n\t\t\t// don't do events on text and comment nodes\n\t\t\tif ( elem.nodeType == 3 || elem.nodeType == 8 )\n\t\t\t\treturn undefined;\n\n\t\t\tvar val, ret, fn = jQuery.isFunction( elem[ type ] || null ),\n\t\t\t\t// Check to see if we need to provide a fake event, or not\n\t\t\t\tevent = !data[0] || !data[0].preventDefault;\n\n\t\t\t// Pass along a fake event\n\t\t\tif ( event ) {\n\t\t\t\tdata.unshift({\n\t\t\t\t\ttype: type,\n\t\t\t\t\ttarget: elem,\n\t\t\t\t\tpreventDefault: function(){},\n\t\t\t\t\tstopPropagation: function(){},\n\t\t\t\t\ttimeStamp: now()\n\t\t\t\t});\n\t\t\t\tdata[0][expando] = true; // no need to fix fake event\n\t\t\t}\n\n\t\t\t// Enforce the right trigger type\n\t\t\tdata[0].type = type;\n\t\t\tif ( exclusive )\n\t\t\t\tdata[0].exclusive = true;\n\n\t\t\t// Trigger the event, it is assumed that \"handle\" is a function\n\t\t\tvar handle = jQuery.data(elem, \"handle\");\n\t\t\tif ( handle )\n\t\t\t\tval = handle.apply( elem, data );\n\n\t\t\t// Handle triggering native .onfoo handlers (and on links since we don't call .click() for links)\n\t\t\tif ( (!fn || (jQuery.nodeName(elem, 'a') && type == \"click\")) && elem[\"on\"+type] && elem[\"on\"+type].apply( elem, data ) === false )\n\t\t\t\tval = false;\n\n\t\t\t// Extra functions don't get the custom event object\n\t\t\tif ( event )\n\t\t\t\tdata.shift();\n\n\t\t\t// Handle triggering of extra function\n\t\t\tif ( extra && jQuery.isFunction( extra ) ) {\n\t\t\t\t// call the extra function and tack the current return value on the end for possible inspection\n\t\t\t\tret = extra.apply( elem, val == null ? data : data.concat( val ) );\n\t\t\t\t// if anything is returned, give it precedence and have it overwrite the previous value\n\t\t\t\tif (ret !== undefined)\n\t\t\t\t\tval = ret;\n\t\t\t}\n\n\t\t\t// Trigger the native events (except for clicks on links)\n\t\t\tif ( fn && donative !== false && val !== false && !(jQuery.nodeName(elem, 'a') && type == \"click\") ) {\n\t\t\t\tthis.triggered = true;\n\t\t\t\ttry {\n\t\t\t\t\telem[ type ]();\n\t\t\t\t// prevent IE from throwing an error for some hidden elements\n\t\t\t\t} catch (e) {}\n\t\t\t}\n\n\t\t\tthis.triggered = false;\n\t\t}\n\n\t\treturn val;\n\t},\n\n\thandle: function(event) {\n\t\t// returned undefined or false\n\t\tvar val, ret, namespace, all, handlers;\n\n\t\tevent = arguments[0] = jQuery.event.fix( event || window.event );\n\n\t\t// Namespaced event handlers\n\t\tnamespace = event.type.split(\".\");\n\t\tevent.type = namespace[0];\n\t\tnamespace = namespace[1];\n\t\t// Cache this now, all = true means, any handler\n\t\tall = !namespace && !event.exclusive;\n\n\t\thandlers = ( jQuery.data(this, \"events\") || {} )[event.type];\n\n\t\tfor ( var j in handlers ) {\n\t\t\tvar handler = handlers[j];\n\n\t\t\t// Filter the functions by class\n\t\t\tif ( all || handler.type == namespace ) {\n\t\t\t\t// Pass in a reference to the handler function itself\n\t\t\t\t// So that we can later remove it\n\t\t\t\tevent.handler = handler;\n\t\t\t\tevent.data = handler.data;\n\n\t\t\t\tret = handler.apply( this, arguments );\n\n\t\t\t\tif ( val !== false )\n\t\t\t\t\tval = ret;\n\n\t\t\t\tif ( ret === false ) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tevent.stopPropagation();\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\treturn val;\n\t},\n\n\tfix: function(event) {\n\t\tif ( event[expando] == true )\n\t\t\treturn event;\n\n\t\t// store a copy of the original event object\n\t\t// and \"clone\" to set read-only properties\n\t\tvar originalEvent = event;\n\t\tevent = { originalEvent: originalEvent };\n\t\tvar props = \"altKey attrChange attrName bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase fromElement handler keyCode metaKey newValue originalTarget pageX pageY prevValue relatedNode relatedTarget screenX screenY shiftKey srcElement target timeStamp toElement type view wheelDelta which\".split(\" \");\n\t\tfor ( var i=props.length; i; i-- )\n\t\t\tevent[ props[i] ] = originalEvent[ props[i] ];\n\n\t\t// Mark it as fixed\n\t\tevent[expando] = true;\n\n\t\t// add preventDefault and stopPropagation since\n\t\t// they will not work on the clone\n\t\tevent.preventDefault = function() {\n\t\t\t// if preventDefault exists run it on the original event\n\t\t\tif (originalEvent.preventDefault)\n\t\t\t\toriginalEvent.preventDefault();\n\t\t\t// otherwise set the returnValue property of the original event to false (IE)\n\t\t\toriginalEvent.returnValue = false;\n\t\t};\n\t\tevent.stopPropagation = function() {\n\t\t\t// if stopPropagation exists run it on the original event\n\t\t\tif (originalEvent.stopPropagation)\n\t\t\t\toriginalEvent.stopPropagation();\n\t\t\t// otherwise set the cancelBubble property of the original event to true (IE)\n\t\t\toriginalEvent.cancelBubble = true;\n\t\t};\n\n\t\t// Fix timeStamp\n\t\tevent.timeStamp = event.timeStamp || now();\n\n\t\t// Fix target property, if necessary\n\t\tif ( !event.target )\n\t\t\tevent.target = event.srcElement || document; // Fixes #1925 where srcElement might not be defined either\n\n\t\t// check if target is a textnode (safari)\n\t\tif ( event.target.nodeType == 3 )\n\t\t\tevent.target = event.target.parentNode;\n\n\t\t// Add relatedTarget, if necessary\n\t\tif ( !event.relatedTarget && event.fromElement )\n\t\t\tevent.relatedTarget = event.fromElement == event.target ? event.toElement : event.fromElement;\n\n\t\t// Calculate pageX/Y if missing and clientX/Y available\n\t\tif ( event.pageX == null && event.clientX != null ) {\n\t\t\tvar doc = document.documentElement, body = document.body;\n\t\t\tevent.pageX = event.clientX + (doc && doc.scrollLeft || body && body.scrollLeft || 0) - (doc.clientLeft || 0);\n\t\t\tevent.pageY = event.clientY + (doc && doc.scrollTop || body && body.scrollTop || 0) - (doc.clientTop || 0);\n\t\t}\n\n\t\t// Add which for key events\n\t\tif ( !event.which && ((event.charCode || event.charCode === 0) ? event.charCode : event.keyCode) )\n\t\t\tevent.which = event.charCode || event.keyCode;\n\n\t\t// Add metaKey to non-Mac browsers (use ctrl for PC's and Meta for Macs)\n\t\tif ( !event.metaKey && event.ctrlKey )\n\t\t\tevent.metaKey = event.ctrlKey;\n\n\t\t// Add which for click: 1 == left; 2 == middle; 3 == right\n\t\t// Note: button is not normalized, so don't use it\n\t\tif ( !event.which && event.button )\n\t\t\tevent.which = (event.button & 1 ? 1 : ( event.button & 2 ? 3 : ( event.button & 4 ? 2 : 0 ) ));\n\n\t\treturn event;\n\t},\n\n\tproxy: function( fn, proxy ){\n\t\t// Set the guid of unique handler to the same of original handler, so it can be removed\n\t\tproxy.guid = fn.guid = fn.guid || proxy.guid || this.guid++;\n\t\t// So proxy can be declared as an argument\n\t\treturn proxy;\n\t},\n\n\tspecial: {\n\t\tready: {\n\t\t\tsetup: function() {\n\t\t\t\t// Make sure the ready event is setup\n\t\t\t\tbindReady();\n\t\t\t\treturn;\n\t\t\t},\n\n\t\t\tteardown: function() { return; }\n\t\t},\n\n\t\tmouseenter: {\n\t\t\tsetup: function() {\n\t\t\t\tif ( jQuery.browser.msie ) return false;\n\t\t\t\tjQuery(this).bind(\"mouseover\", jQuery.event.special.mouseenter.handler);\n\t\t\t\treturn true;\n\t\t\t},\n\n\t\t\tteardown: function() {\n\t\t\t\tif ( jQuery.browser.msie ) return false;\n\t\t\t\tjQuery(this).unbind(\"mouseover\", jQuery.event.special.mouseenter.handler);\n\t\t\t\treturn true;\n\t\t\t},\n\n\t\t\thandler: function(event) {\n\t\t\t\t// If we actually just moused on to a sub-element, ignore it\n\t\t\t\tif ( withinElement(event, this) ) return true;\n\t\t\t\t// Execute the right handlers by setting the event type to mouseenter\n\t\t\t\tevent.type = \"mouseenter\";\n\t\t\t\treturn jQuery.event.handle.apply(this, arguments);\n\t\t\t}\n\t\t},\n\n\t\tmouseleave: {\n\t\t\tsetup: function() {\n\t\t\t\tif ( jQuery.browser.msie ) return false;\n\t\t\t\tjQuery(this).bind(\"mouseout\", jQuery.event.special.mouseleave.handler);\n\t\t\t\treturn true;\n\t\t\t},\n\n\t\t\tteardown: function() {\n\t\t\t\tif ( jQuery.browser.msie ) return false;\n\t\t\t\tjQuery(this).unbind(\"mouseout\", jQuery.event.special.mouseleave.handler);\n\t\t\t\treturn true;\n\t\t\t},\n\n\t\t\thandler: function(event) {\n\t\t\t\t// If we actually just moused on to a sub-element, ignore it\n\t\t\t\tif ( withinElement(event, this) ) return true;\n\t\t\t\t// Execute the right handlers by setting the event type to mouseleave\n\t\t\t\tevent.type = \"mouseleave\";\n\t\t\t\treturn jQuery.event.handle.apply(this, arguments);\n\t\t\t}\n\t\t}\n\t}\n};\n\njQuery.fn.extend({\n\tbind: function( type, data, fn ) {\n\t\treturn type == \"unload\" ? this.one(type, data, fn) : this.each(function(){\n\t\t\tjQuery.event.add( this, type, fn || data, fn && data );\n\t\t});\n\t},\n\n\tone: function( type, data, fn ) {\n\t\tvar one = jQuery.event.proxy( fn || data, function(event) {\n\t\t\tjQuery(this).unbind(event, one);\n\t\t\treturn (fn || data).apply( this, arguments );\n\t\t});\n\t\treturn this.each(function(){\n\t\t\tjQuery.event.add( this, type, one, fn && data);\n\t\t});\n\t},\n\n\tunbind: function( type, fn ) {\n\t\treturn this.each(function(){\n\t\t\tjQuery.event.remove( this, type, fn );\n\t\t});\n\t},\n\n\ttrigger: function( type, data, fn ) {\n\t\treturn this.each(function(){\n\t\t\tjQuery.event.trigger( type, data, this, true, fn );\n\t\t});\n\t},\n\n\ttriggerHandler: function( type, data, fn ) {\n\t\treturn this[0] && jQuery.event.trigger( type, data, this[0], false, fn );\n\t},\n\n\ttoggle: function( fn ) {\n\t\t// Save reference to arguments for access in closure\n\t\tvar args = arguments, i = 1;\n\n\t\t// link all the functions, so any of them can unbind this click handler\n\t\twhile( i < args.length )\n\t\t\tjQuery.event.proxy( fn, args[i++] );\n\n\t\treturn this.click( jQuery.event.proxy( fn, function(event) {\n\t\t\t// Figure out which function to execute\n\t\t\tthis.lastToggle = ( this.lastToggle || 0 ) % i;\n\n\t\t\t// Make sure that clicks stop\n\t\t\tevent.preventDefault();\n\n\t\t\t// and execute the function\n\t\t\treturn args[ this.lastToggle++ ].apply( this, arguments ) || false;\n\t\t}));\n\t},\n\n\thover: function(fnOver, fnOut) {\n\t\treturn this.bind('mouseenter', fnOver).bind('mouseleave', fnOut);\n\t},\n\n\tready: function(fn) {\n\t\t// Attach the listeners\n\t\tbindReady();\n\n\t\t// If the DOM is already ready\n\t\tif ( jQuery.isReady )\n\t\t\t// Execute the function immediately\n\t\t\tfn.call( document, jQuery );\n\n\t\t// Otherwise, remember the function for later\n\t\telse\n\t\t\t// Add the function to the wait list\n\t\t\tjQuery.readyList.push( function() { return fn.call(this, jQuery); } );\n\n\t\treturn this;\n\t}\n});\n\njQuery.extend({\n\tisReady: false,\n\treadyList: [],\n\t// Handle when the DOM is ready\n\tready: function() {\n\t\t// Make sure that the DOM is not already loaded\n\t\tif ( !jQuery.isReady ) {\n\t\t\t// Remember that the DOM is ready\n\t\t\tjQuery.isReady = true;\n\n\t\t\t// If there are functions bound, to execute\n\t\t\tif ( jQuery.readyList ) {\n\t\t\t\t// Execute all of them\n\t\t\t\tjQuery.each( jQuery.readyList, function(){\n\t\t\t\t\tthis.call( document );\n\t\t\t\t});\n\n\t\t\t\t// Reset the list of functions\n\t\t\t\tjQuery.readyList = null;\n\t\t\t}\n\n\t\t\t// Trigger any bound ready events\n\t\t\tjQuery(document).triggerHandler(\"ready\");\n\t\t}\n\t}\n});\n\nvar readyBound = false;\n\nfunction bindReady(){\n\tif ( readyBound ) return;\n\treadyBound = true;\n\n\t// Mozilla, Opera (see further below for it) and webkit nightlies currently support this event\n\tif ( document.addEventListener && !jQuery.browser.opera)\n\t\t// Use the handy event callback\n\t\tdocument.addEventListener( \"DOMContentLoaded\", jQuery.ready, false );\n\n\t// If IE is used and is not in a frame\n\t// Continually check to see if the document is ready\n\tif ( jQuery.browser.msie && window == top ) (function(){\n\t\tif (jQuery.isReady) return;\n\t\ttry {\n\t\t\t// If IE is used, use the trick by Diego Perini\n\t\t\t// http://javascript.nwbox.com/IEContentLoaded/\n\t\t\tdocument.documentElement.doScroll(\"left\");\n\t\t} catch( error ) {\n\t\t\tsetTimeout( arguments.callee, 0 );\n\t\t\treturn;\n\t\t}\n\t\t// and execute any waiting functions\n\t\tjQuery.ready();\n\t})();\n\n\tif ( jQuery.browser.opera )\n\t\tdocument.addEventListener( \"DOMContentLoaded\", function () {\n\t\t\tif (jQuery.isReady) return;\n\t\t\tfor (var i = 0; i < document.styleSheets.length; i++)\n\t\t\t\tif (document.styleSheets[i].disabled) {\n\t\t\t\t\tsetTimeout( arguments.callee, 0 );\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t// and execute any waiting functions\n\t\t\tjQuery.ready();\n\t\t}, false);\n\n\tif ( jQuery.browser.safari ) {\n\t\tvar numStyles;\n\t\t(function(){\n\t\t\tif (jQuery.isReady) return;\n\t\t\tif ( document.readyState != \"loaded\" && document.readyState != \"complete\" ) {\n\t\t\t\tsetTimeout( arguments.callee, 0 );\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tif ( numStyles === undefined )\n\t\t\t\tnumStyles = jQuery(\"style, link[rel=stylesheet]\").length;\n\t\t\tif ( document.styleSheets.length != numStyles ) {\n\t\t\t\tsetTimeout( arguments.callee, 0 );\n\t\t\t\treturn;\n\t\t\t}\n\t\t\t// and execute any waiting functions\n\t\t\tjQuery.ready();\n\t\t})();\n\t}\n\n\t// A fallback to window.onload, that will always work\n\tjQuery.event.add( window, \"load\", jQuery.ready );\n}\n\njQuery.each( (\"blur,focus,load,resize,scroll,unload,click,dblclick,\" +\n\t\"mousedown,mouseup,mousemove,mouseover,mouseout,change,select,\" +\n\t\"submit,keydown,keypress,keyup,error\").split(\",\"), function(i, name){\n\n\t// Handle event binding\n\tjQuery.fn[name] = function(fn){\n\t\treturn fn ? this.bind(name, fn) : this.trigger(name);\n\t};\n});\n\n// Checks if an event happened on an element within another element\n// Used in jQuery.event.special.mouseenter and mouseleave handlers\nvar withinElement = function(event, elem) {\n\t// Check if mouse(over|out) are still within the same parent element\n\tvar parent = event.relatedTarget;\n\t// Traverse up the tree\n\twhile ( parent && parent != elem ) try { parent = parent.parentNode; } catch(error) { parent = elem; }\n\t// Return true if we actually just moused on to a sub-element\n\treturn parent == elem;\n};\n\n// Prevent memory leaks in IE\n// And prevent errors on refresh with events like mouseover in other browsers\n// Window isn't included so as not to unbind existing unload events\njQuery(window).bind(\"unload\", function() {\n\tjQuery(\"*\").add(document).unbind();\n});\njQuery.fn.extend({\n\t// Keep a copy of the old load\n\t_load: jQuery.fn.load,\n\n\tload: function( url, params, callback ) {\n\t\tif ( typeof url != 'string' )\n\t\t\treturn this._load( url );\n\n\t\tvar off = url.indexOf(\" \");\n\t\tif ( off >= 0 ) {\n\t\t\tvar selector = url.slice(off, url.length);\n\t\t\turl = url.slice(0, off);\n\t\t}\n\n\t\tcallback = callback || function(){};\n\n\t\t// Default to a GET request\n\t\tvar type = \"GET\";\n\n\t\t// If the second parameter was provided\n\t\tif ( params )\n\t\t\t// If it's a function\n\t\t\tif ( jQuery.isFunction( params ) ) {\n\t\t\t\t// We assume that it's the callback\n\t\t\t\tcallback = params;\n\t\t\t\tparams = null;\n\n\t\t\t// Otherwise, build a param string\n\t\t\t} else {\n\t\t\t\tparams = jQuery.param( params );\n\t\t\t\ttype = \"POST\";\n\t\t\t}\n\n\t\tvar self = this;\n\n\t\t// Request the remote document\n\t\tjQuery.ajax({\n\t\t\turl: url,\n\t\t\ttype: type,\n\t\t\tdataType: \"html\",\n\t\t\tdata: params,\n\t\t\tcomplete: function(res, status){\n\t\t\t\t// If successful, inject the HTML into all the matched elements\n\t\t\t\tif ( status == \"success\" || status == \"notmodified\" )\n\t\t\t\t\t// See if a selector was specified\n\t\t\t\t\tself.html( selector ?\n\t\t\t\t\t\t// Create a dummy div to hold the results\n\t\t\t\t\t\tjQuery(\"<div/>\")\n\t\t\t\t\t\t\t// inject the contents of the document in, removing the scripts\n\t\t\t\t\t\t\t// to avoid any 'Permission Denied' errors in IE\n\t\t\t\t\t\t\t.append(res.responseText.replace(/<script(.|\\s)*?\\/script>/g, \"\"))\n\n\t\t\t\t\t\t\t// Locate the specified elements\n\t\t\t\t\t\t\t.find(selector) :\n\n\t\t\t\t\t\t// If not, just inject the full result\n\t\t\t\t\t\tres.responseText );\n\n\t\t\t\tself.each( callback, [res.responseText, status, res] );\n\t\t\t}\n\t\t});\n\t\treturn this;\n\t},\n\n\tserialize: function() {\n\t\treturn jQuery.param(this.serializeArray());\n\t},\n\tserializeArray: function() {\n\t\treturn this.map(function(){\n\t\t\treturn jQuery.nodeName(this, \"form\") ?\n\t\t\t\tjQuery.makeArray(this.elements) : this;\n\t\t})\n\t\t.filter(function(){\n\t\t\treturn this.name && !this.disabled &&\n\t\t\t\t(this.checked || /select|textarea/i.test(this.nodeName) ||\n\t\t\t\t\t/text|hidden|password/i.test(this.type));\n\t\t})\n\t\t.map(function(i, elem){\n\t\t\tvar val = jQuery(this).val();\n\t\t\treturn val == null ? null :\n\t\t\t\tval.constructor == Array ?\n\t\t\t\t\tjQuery.map( val, function(val, i){\n\t\t\t\t\t\treturn {name: elem.name, value: val};\n\t\t\t\t\t}) :\n\t\t\t\t\t{name: elem.name, value: val};\n\t\t}).get();\n\t}\n});\n\n// Attach a bunch of functions for handling common AJAX events\njQuery.each( \"ajaxStart,ajaxStop,ajaxComplete,ajaxError,ajaxSuccess,ajaxSend\".split(\",\"), function(i,o){\n\tjQuery.fn[o] = function(f){\n\t\treturn this.bind(o, f);\n\t};\n});\n\nvar jsc = now();\n\njQuery.extend({\n\tget: function( url, data, callback, type ) {\n\t\t// shift arguments if data argument was ommited\n\t\tif ( jQuery.isFunction( data ) ) {\n\t\t\tcallback = data;\n\t\t\tdata = null;\n\t\t}\n\n\t\treturn jQuery.ajax({\n\t\t\ttype: \"GET\",\n\t\t\turl: url,\n\t\t\tdata: data,\n\t\t\tsuccess: callback,\n\t\t\tdataType: type\n\t\t});\n\t},\n\n\tgetScript: function( url, callback ) {\n\t\treturn jQuery.get(url, null, callback, \"script\");\n\t},\n\n\tgetJSON: function( url, data, callback ) {\n\t\treturn jQuery.get(url, data, callback, \"json\");\n\t},\n\n\tpost: function( url, data, callback, type ) {\n\t\tif ( jQuery.isFunction( data ) ) {\n\t\t\tcallback = data;\n\t\t\tdata = {};\n\t\t}\n\n\t\treturn jQuery.ajax({\n\t\t\ttype: \"POST\",\n\t\t\turl: url,\n\t\t\tdata: data,\n\t\t\tsuccess: callback,\n\t\t\tdataType: type\n\t\t});\n\t},\n\n\tajaxSetup: function( settings ) {\n\t\tjQuery.extend( jQuery.ajaxSettings, settings );\n\t},\n\n\tajaxSettings: {\n\t\turl: location.href,\n\t\tglobal: true,\n\t\ttype: \"GET\",\n\t\ttimeout: 0,\n\t\tcontentType: \"application/x-www-form-urlencoded\",\n\t\tprocessData: true,\n\t\tasync: true,\n\t\tdata: null,\n\t\tusername: null,\n\t\tpassword: null,\n\t\taccepts: {\n\t\t\txml: \"application/xml, text/xml\",\n\t\t\thtml: \"text/html\",\n\t\t\tscript: \"text/javascript, application/javascript\",\n\t\t\tjson: \"application/json, text/javascript\",\n\t\t\ttext: \"text/plain\",\n\t\t\t_default: \"*/*\"\n\t\t}\n\t},\n\n\t// Last-Modified header cache for next request\n\tlastModified: {},\n\n\tajax: function( s ) {\n\t\t// Extend the settings, but re-extend 's' so that it can be\n\t\t// checked again later (in the test suite, specifically)\n\t\ts = jQuery.extend(true, s, jQuery.extend(true, {}, jQuery.ajaxSettings, s));\n\n\t\tvar jsonp, jsre = /=\\?(&|$)/g, status, data,\n\t\t\ttype = s.type.toUpperCase();\n\n\t\t// convert data if not already a string\n\t\tif ( s.data && s.processData && typeof s.data != \"string\" )\n\t\t\ts.data = jQuery.param(s.data);\n\n\t\t// Handle JSONP Parameter Callbacks\n\t\tif ( s.dataType == \"jsonp\" ) {\n\t\t\tif ( type == \"GET\" ) {\n\t\t\t\tif ( !s.url.match(jsre) )\n\t\t\t\t\ts.url += (s.url.match(/\\?/) ? \"&\" : \"?\") + (s.jsonp || \"callback\") + \"=?\";\n\t\t\t} else if ( !s.data || !s.data.match(jsre) )\n\t\t\t\ts.data = (s.data ? s.data + \"&\" : \"\") + (s.jsonp || \"callback\") + \"=?\";\n\t\t\ts.dataType = \"json\";\n\t\t}\n\n\t\t// Build temporary JSONP function\n\t\tif ( s.dataType == \"json\" && (s.data && s.data.match(jsre) || s.url.match(jsre)) ) {\n\t\t\tjsonp = \"jsonp\" + jsc++;\n\n\t\t\t// Replace the =? sequence both in the query string and the data\n\t\t\tif ( s.data )\n\t\t\t\ts.data = (s.data + \"\").replace(jsre, \"=\" + jsonp + \"$1\");\n\t\t\ts.url = s.url.replace(jsre, \"=\" + jsonp + \"$1\");\n\n\t\t\t// We need to make sure\n\t\t\t// that a JSONP style response is executed properly\n\t\t\ts.dataType = \"script\";\n\n\t\t\t// Handle JSONP-style loading\n\t\t\twindow[ jsonp ] = function(tmp){\n\t\t\t\tdata = tmp;\n\t\t\t\tsuccess();\n\t\t\t\tcomplete();\n\t\t\t\t// Garbage collect\n\t\t\t\twindow[ jsonp ] = undefined;\n\t\t\t\ttry{ delete window[ jsonp ]; } catch(e){}\n\t\t\t\tif ( head )\n\t\t\t\t\thead.removeChild( script );\n\t\t\t};\n\t\t}\n\n\t\tif ( s.dataType == \"script\" && s.cache == null )\n\t\t\ts.cache = false;\n\n\t\tif ( s.cache === false && type == \"GET\" ) {\n\t\t\tvar ts = now();\n\t\t\t// try replacing _= if it is there\n\t\t\tvar ret = s.url.replace(/(\\?|&)_=.*?(&|$)/, \"$1_=\" + ts + \"$2\");\n\t\t\t// if nothing was replaced, add timestamp to the end\n\t\t\ts.url = ret + ((ret == s.url) ? (s.url.match(/\\?/) ? \"&\" : \"?\") + \"_=\" + ts : \"\");\n\t\t}\n\n\t\t// If data is available, append data to url for get requests\n\t\tif ( s.data && type == \"GET\" ) {\n\t\t\ts.url += (s.url.match(/\\?/) ? \"&\" : \"?\") + s.data;\n\n\t\t\t// IE likes to send both get and post data, prevent this\n\t\t\ts.data = null;\n\t\t}\n\n\t\t// Watch for a new set of requests\n\t\tif ( s.global && ! jQuery.active++ )\n\t\t\tjQuery.event.trigger( \"ajaxStart\" );\n\n\t\t// Matches an absolute URL, and saves the domain\n\t\tvar remote = /^(?:\\w+:)?\\/\\/([^\\/?#]+)/;\n\n\t\t// If we're requesting a remote document\n\t\t// and trying to load JSON or Script with a GET\n\t\tif ( s.dataType == \"script\" && type == \"GET\"\n\t\t\t\t&& remote.test(s.url) && remote.exec(s.url)[1] != location.host ){\n\t\t\tvar head = document.getElementsByTagName(\"head\")[0];\n\t\t\tvar script = document.createElement(\"script\");\n\t\t\tscript.src = s.url;\n\t\t\tif (s.scriptCharset)\n\t\t\t\tscript.charset = s.scriptCharset;\n\n\t\t\t// Handle Script loading\n\t\t\tif ( !jsonp ) {\n\t\t\t\tvar done = false;\n\n\t\t\t\t// Attach handlers for all browsers\n\t\t\t\tscript.onload = script.onreadystatechange = function(){\n\t\t\t\t\tif ( !done && (!this.readyState ||\n\t\t\t\t\t\t\tthis.readyState == \"loaded\" || this.readyState == \"complete\") ) {\n\t\t\t\t\t\tdone = true;\n\t\t\t\t\t\tsuccess();\n\t\t\t\t\t\tcomplete();\n\t\t\t\t\t\thead.removeChild( script );\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t}\n\n\t\t\thead.appendChild(script);\n\n\t\t\t// We handle everything using the script element injection\n\t\t\treturn undefined;\n\t\t}\n\n\t\tvar requestDone = false;\n\n\t\t// Create the request object; Microsoft failed to properly\n\t\t// implement the XMLHttpRequest in IE7, so we use the ActiveXObject when it is available\n\t\tvar xhr = window.ActiveXObject ? new ActiveXObject(\"Microsoft.XMLHTTP\") : new XMLHttpRequest();\n\n\t\t// Open the socket\n\t\t// Passing null username, generates a login popup on Opera (#2865)\n\t\tif( s.username )\n\t\t\txhr.open(type, s.url, s.async, s.username, s.password);\n\t\telse\n\t\t\txhr.open(type, s.url, s.async);\n\n\t\t// Need an extra try/catch for cross domain requests in Firefox 3\n\t\ttry {\n\t\t\t// Set the correct header, if data is being sent\n\t\t\tif ( s.data )\n\t\t\t\txhr.setRequestHeader(\"Content-Type\", s.contentType);\n\n\t\t\t// Set the If-Modified-Since header, if ifModified mode.\n\t\t\tif ( s.ifModified )\n\t\t\t\txhr.setRequestHeader(\"If-Modified-Since\",\n\t\t\t\t\tjQuery.lastModified[s.url] || \"Thu, 01 Jan 1970 00:00:00 GMT\" );\n\n\t\t\t// Set header so the called script knows that it's an XMLHttpRequest\n\t\t\txhr.setRequestHeader(\"X-Requested-With\", \"XMLHttpRequest\");\n\n\t\t\t// Set the Accepts header for the server, depending on the dataType\n\t\t\txhr.setRequestHeader(\"Accept\", s.dataType && s.accepts[ s.dataType ] ?\n\t\t\t\ts.accepts[ s.dataType ] + \", */*\" :\n\t\t\t\ts.accepts._default );\n\t\t} catch(e){}\n\n\t\t// Allow custom headers/mimetypes\n\t\tif ( s.beforeSend && s.beforeSend(xhr, s) === false ) {\n\t\t\t// cleanup active request counter\n\t\t\ts.global && jQuery.active--;\n\t\t\t// close opended socket\n\t\t\txhr.abort();\n\t\t\treturn false;\n\t\t}\n\n\t\tif ( s.global )\n\t\t\tjQuery.event.trigger(\"ajaxSend\", [xhr, s]);\n\n\t\t// Wait for a response to come back\n\t\tvar onreadystatechange = function(isTimeout){\n\t\t\t// The transfer is complete and the data is available, or the request timed out\n\t\t\tif ( !requestDone && xhr && (xhr.readyState == 4 || isTimeout == \"timeout\") ) {\n\t\t\t\trequestDone = true;\n\n\t\t\t\t// clear poll interval\n\t\t\t\tif (ival) {\n\t\t\t\t\tclearInterval(ival);\n\t\t\t\t\tival = null;\n\t\t\t\t}\n\n\t\t\t\tstatus = isTimeout == \"timeout\" && \"timeout\" ||\n\t\t\t\t\t!jQuery.httpSuccess( xhr ) && \"error\" ||\n\t\t\t\t\ts.ifModified && jQuery.httpNotModified( xhr, s.url ) && \"notmodified\" ||\n\t\t\t\t\t\"success\";\n\n\t\t\t\tif ( status == \"success\" ) {\n\t\t\t\t\t// Watch for, and catch, XML document parse errors\n\t\t\t\t\ttry {\n\t\t\t\t\t\t// process the data (runs the xml through httpData regardless of callback)\n\t\t\t\t\t\tdata = jQuery.httpData( xhr, s.dataType, s.dataFilter );\n\t\t\t\t\t} catch(e) {\n\t\t\t\t\t\tstatus = \"parsererror\";\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Make sure that the request was successful or notmodified\n\t\t\t\tif ( status == \"success\" ) {\n\t\t\t\t\t// Cache Last-Modified header, if ifModified mode.\n\t\t\t\t\tvar modRes;\n\t\t\t\t\ttry {\n\t\t\t\t\t\tmodRes = xhr.getResponseHeader(\"Last-Modified\");\n\t\t\t\t\t} catch(e) {} // swallow exception thrown by FF if header is not available\n\n\t\t\t\t\tif ( s.ifModified && modRes )\n\t\t\t\t\t\tjQuery.lastModified[s.url] = modRes;\n\n\t\t\t\t\t// JSONP handles its own success callback\n\t\t\t\t\tif ( !jsonp )\n\t\t\t\t\t\tsuccess();\n\t\t\t\t} else\n\t\t\t\t\tjQuery.handleError(s, xhr, status);\n\n\t\t\t\t// Fire the complete handlers\n\t\t\t\tcomplete();\n\n\t\t\t\t// Stop memory leaks\n\t\t\t\tif ( s.async )\n\t\t\t\t\txhr = null;\n\t\t\t}\n\t\t};\n\n\t\tif ( s.async ) {\n\t\t\t// don't attach the handler to the request, just poll it instead\n\t\t\tvar ival = setInterval(onreadystatechange, 13);\n\n\t\t\t// Timeout checker\n\t\t\tif ( s.timeout > 0 )\n\t\t\t\tsetTimeout(function(){\n\t\t\t\t\t// Check to see if the request is still happening\n\t\t\t\t\tif ( xhr ) {\n\t\t\t\t\t\t// Cancel the request\n\t\t\t\t\t\txhr.abort();\n\n\t\t\t\t\t\tif( !requestDone )\n\t\t\t\t\t\t\tonreadystatechange( \"timeout\" );\n\t\t\t\t\t}\n\t\t\t\t}, s.timeout);\n\t\t}\n\n\t\t// Send the data\n\t\ttry {\n\t\t\txhr.send(s.data);\n\t\t} catch(e) {\n\t\t\tjQuery.handleError(s, xhr, null, e);\n\t\t}\n\n\t\t// firefox 1.5 doesn't fire statechange for sync requests\n\t\tif ( !s.async )\n\t\t\tonreadystatechange();\n\n\t\tfunction success(){\n\t\t\t// If a local callback was specified, fire it and pass it the data\n\t\t\tif ( s.success )\n\t\t\t\ts.success( data, status );\n\n\t\t\t// Fire the global callback\n\t\t\tif ( s.global )\n\t\t\t\tjQuery.event.trigger( \"ajaxSuccess\", [xhr, s] );\n\t\t}\n\n\t\tfunction complete(){\n\t\t\t// Process result\n\t\t\tif ( s.complete )\n\t\t\t\ts.complete(xhr, status);\n\n\t\t\t// The request was completed\n\t\t\tif ( s.global )\n\t\t\t\tjQuery.event.trigger( \"ajaxComplete\", [xhr, s] );\n\n\t\t\t// Handle the global AJAX counter\n\t\t\tif ( s.global && ! --jQuery.active )\n\t\t\t\tjQuery.event.trigger( \"ajaxStop\" );\n\t\t}\n\n\t\t// return XMLHttpRequest to allow aborting the request etc.\n\t\treturn xhr;\n\t},\n\n\thandleError: function( s, xhr, status, e ) {\n\t\t// If a local callback was specified, fire it\n\t\tif ( s.error ) s.error( xhr, status, e );\n\n\t\t// Fire the global callback\n\t\tif ( s.global )\n\t\t\tjQuery.event.trigger( \"ajaxError\", [xhr, s, e] );\n\t},\n\n\t// Counter for holding the number of active queries\n\tactive: 0,\n\n\t// Determines if an XMLHttpRequest was successful or not\n\thttpSuccess: function( xhr ) {\n\t\ttry {\n\t\t\t// IE error sometimes returns 1223 when it should be 204 so treat it as success, see #1450\n\t\t\treturn !xhr.status && location.protocol == \"file:\" ||\n\t\t\t\t( xhr.status >= 200 && xhr.status < 300 ) || xhr.status == 304 || xhr.status == 1223 ||\n\t\t\t\tjQuery.browser.safari && xhr.status == undefined;\n\t\t} catch(e){}\n\t\treturn false;\n\t},\n\n\t// Determines if an XMLHttpRequest returns NotModified\n\thttpNotModified: function( xhr, url ) {\n\t\ttry {\n\t\t\tvar xhrRes = xhr.getResponseHeader(\"Last-Modified\");\n\n\t\t\t// Firefox always returns 200. check Last-Modified date\n\t\t\treturn xhr.status == 304 || xhrRes == jQuery.lastModified[url] ||\n\t\t\t\tjQuery.browser.safari && xhr.status == undefined;\n\t\t} catch(e){}\n\t\treturn false;\n\t},\n\n\thttpData: function( xhr, type, filter ) {\n\t\tvar ct = xhr.getResponseHeader(\"content-type\"),\n\t\t\txml = type == \"xml\" || !type && ct && ct.indexOf(\"xml\") >= 0,\n\t\t\tdata = xml ? xhr.responseXML : xhr.responseText;\n\n\t\tif ( xml && data.documentElement.tagName == \"parsererror\" )\n\t\t\tthrow \"parsererror\";\n\t\t\t\n\t\t// Allow a pre-filtering function to sanitize the response\n\t\tif( filter )\n\t\t\tdata = filter( data, type );\n\n\t\t// If the type is \"script\", eval it in global context\n\t\tif ( type == \"script\" )\n\t\t\tjQuery.globalEval( data );\n\n\t\t// Get the JavaScript object, if JSON is used.\n\t\tif ( type == \"json\" )\n\t\t\tdata = eval(\"(\" + data + \")\");\n\n\t\treturn data;\n\t},\n\n\t// Serialize an array of form elements or a set of\n\t// key/values into a query string\n\tparam: function( a ) {\n\t\tvar s = [];\n\n\t\t// If an array was passed in, assume that it is an array\n\t\t// of form elements\n\t\tif ( a.constructor == Array || a.jquery )\n\t\t\t// Serialize the form elements\n\t\t\tjQuery.each( a, function(){\n\t\t\t\ts.push( encodeURIComponent(this.name) + \"=\" + encodeURIComponent( this.value ) );\n\t\t\t});\n\n\t\t// Otherwise, assume that it's an object of key/value pairs\n\t\telse\n\t\t\t// Serialize the key/values\n\t\t\tfor ( var j in a )\n\t\t\t\t// If the value is an array then the key names need to be repeated\n\t\t\t\tif ( a[j] && a[j].constructor == Array )\n\t\t\t\t\tjQuery.each( a[j], function(){\n\t\t\t\t\t\ts.push( encodeURIComponent(j) + \"=\" + encodeURIComponent( this ) );\n\t\t\t\t\t});\n\t\t\t\telse\n\t\t\t\t\ts.push( encodeURIComponent(j) + \"=\" + encodeURIComponent( jQuery.isFunction(a[j]) ? a[j]() : a[j] ) );\n\n\t\t// Return the resulting serialization\n\t\treturn s.join(\"&\").replace(/%20/g, \"+\");\n\t}\n\n});\njQuery.fn.extend({\n\tshow: function(speed,callback){\n\t\treturn speed ?\n\t\t\tthis.animate({\n\t\t\t\theight: \"show\", width: \"show\", opacity: \"show\"\n\t\t\t}, speed, callback) :\n\n\t\t\tthis.filter(\":hidden\").each(function(){\n\t\t\t\tthis.style.display = this.oldblock || \"\";\n\t\t\t\tif ( jQuery.css(this,\"display\") == \"none\" ) {\n\t\t\t\t\tvar elem = jQuery(\"<\" + this.tagName + \" />\").appendTo(\"body\");\n\t\t\t\t\tthis.style.display = elem.css(\"display\");\n\t\t\t\t\t// handle an edge condition where css is - div { display:none; } or similar\n\t\t\t\t\tif (this.style.display == \"none\")\n\t\t\t\t\t\tthis.style.display = \"block\";\n\t\t\t\t\telem.remove();\n\t\t\t\t}\n\t\t\t}).end();\n\t},\n\n\thide: function(speed,callback){\n\t\treturn speed ?\n\t\t\tthis.animate({\n\t\t\t\theight: \"hide\", width: \"hide\", opacity: \"hide\"\n\t\t\t}, speed, callback) :\n\n\t\t\tthis.filter(\":visible\").each(function(){\n\t\t\t\tthis.oldblock = this.oldblock || jQuery.css(this,\"display\");\n\t\t\t\tthis.style.display = \"none\";\n\t\t\t}).end();\n\t},\n\n\t// Save the old toggle function\n\t_toggle: jQuery.fn.toggle,\n\n\ttoggle: function( fn, fn2 ){\n\t\treturn jQuery.isFunction(fn) && jQuery.isFunction(fn2) ?\n\t\t\tthis._toggle.apply( this, arguments ) :\n\t\t\tfn ?\n\t\t\t\tthis.animate({\n\t\t\t\t\theight: \"toggle\", width: \"toggle\", opacity: \"toggle\"\n\t\t\t\t}, fn, fn2) :\n\t\t\t\tthis.each(function(){\n\t\t\t\t\tjQuery(this)[ jQuery(this).is(\":hidden\") ? \"show\" : \"hide\" ]();\n\t\t\t\t});\n\t},\n\n\tslideDown: function(speed,callback){\n\t\treturn this.animate({height: \"show\"}, speed, callback);\n\t},\n\n\tslideUp: function(speed,callback){\n\t\treturn this.animate({height: \"hide\"}, speed, callback);\n\t},\n\n\tslideToggle: function(speed, callback){\n\t\treturn this.animate({height: \"toggle\"}, speed, callback);\n\t},\n\n\tfadeIn: function(speed, callback){\n\t\treturn this.animate({opacity: \"show\"}, speed, callback);\n\t},\n\n\tfadeOut: function(speed, callback){\n\t\treturn this.animate({opacity: \"hide\"}, speed, callback);\n\t},\n\n\tfadeTo: function(speed,to,callback){\n\t\treturn this.animate({opacity: to}, speed, callback);\n\t},\n\n\tanimate: function( prop, speed, easing, callback ) {\n\t\tvar optall = jQuery.speed(speed, easing, callback);\n\n\t\treturn this[ optall.queue === false ? \"each\" : \"queue\" ](function(){\n\t\t\tif ( this.nodeType != 1)\n\t\t\t\treturn false;\n\n\t\t\tvar opt = jQuery.extend({}, optall), p,\n\t\t\t\thidden = jQuery(this).is(\":hidden\"), self = this;\n\n\t\t\tfor ( p in prop ) {\n\t\t\t\tif ( prop[p] == \"hide\" && hidden || prop[p] == \"show\" && !hidden )\n\t\t\t\t\treturn opt.complete.call(this);\n\n\t\t\t\tif ( p == \"height\" || p == \"width\" ) {\n\t\t\t\t\t// Store display property\n\t\t\t\t\topt.display = jQuery.css(this, \"display\");\n\n\t\t\t\t\t// Make sure that nothing sneaks out\n\t\t\t\t\topt.overflow = this.style.overflow;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif ( opt.overflow != null )\n\t\t\t\tthis.style.overflow = \"hidden\";\n\n\t\t\topt.curAnim = jQuery.extend({}, prop);\n\n\t\t\tjQuery.each( prop, function(name, val){\n\t\t\t\tvar e = new jQuery.fx( self, opt, name );\n\n\t\t\t\tif ( /toggle|show|hide/.test(val) )\n\t\t\t\t\te[ val == \"toggle\" ? hidden ? \"show\" : \"hide\" : val ]( prop );\n\t\t\t\telse {\n\t\t\t\t\tvar parts = val.toString().match(/^([+-]=)?([\\d+-.]+)(.*)$/),\n\t\t\t\t\t\tstart = e.cur(true) || 0;\n\n\t\t\t\t\tif ( parts ) {\n\t\t\t\t\t\tvar end = parseFloat(parts[2]),\n\t\t\t\t\t\t\tunit = parts[3] || \"px\";\n\n\t\t\t\t\t\t// We need to compute starting value\n\t\t\t\t\t\tif ( unit != \"px\" ) {\n\t\t\t\t\t\t\tself.style[ name ] = (end || 1) + unit;\n\t\t\t\t\t\t\tstart = ((end || 1) / e.cur(true)) * start;\n\t\t\t\t\t\t\tself.style[ name ] = start + unit;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// If a +=/-= token was provided, we're doing a relative animation\n\t\t\t\t\t\tif ( parts[1] )\n\t\t\t\t\t\t\tend = ((parts[1] == \"-=\" ? -1 : 1) * end) + start;\n\n\t\t\t\t\t\te.custom( start, end, unit );\n\t\t\t\t\t} else\n\t\t\t\t\t\te.custom( start, val, \"\" );\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// For JS strict compliance\n\t\t\treturn true;\n\t\t});\n\t},\n\n\tqueue: function(type, fn){\n\t\tif ( jQuery.isFunction(type) || ( type && type.constructor == Array )) {\n\t\t\tfn = type;\n\t\t\ttype = \"fx\";\n\t\t}\n\n\t\tif ( !type || (typeof type == \"string\" && !fn) )\n\t\t\treturn queue( this[0], type );\n\n\t\treturn this.each(function(){\n\t\t\tif ( fn.constructor == Array )\n\t\t\t\tqueue(this, type, fn);\n\t\t\telse {\n\t\t\t\tqueue(this, type).push( fn );\n\n\t\t\t\tif ( queue(this, type).length == 1 )\n\t\t\t\t\tfn.call(this);\n\t\t\t}\n\t\t});\n\t},\n\n\tstop: function(clearQueue, gotoEnd){\n\t\tvar timers = jQuery.timers;\n\n\t\tif (clearQueue)\n\t\t\tthis.queue([]);\n\n\t\tthis.each(function(){\n\t\t\t// go in reverse order so anything added to the queue during the loop is ignored\n\t\t\tfor ( var i = timers.length - 1; i >= 0; i-- )\n\t\t\t\tif ( timers[i].elem == this ) {\n\t\t\t\t\tif (gotoEnd)\n\t\t\t\t\t\t// force the next step to be the last\n\t\t\t\t\t\ttimers[i](true);\n\t\t\t\t\ttimers.splice(i, 1);\n\t\t\t\t}\n\t\t});\n\n\t\t// start the next in the queue if the last step wasn't forced\n\t\tif (!gotoEnd)\n\t\t\tthis.dequeue();\n\n\t\treturn this;\n\t}\n\n});\n\nvar queue = function( elem, type, array ) {\n\tif ( elem ){\n\n\t\ttype = type || \"fx\";\n\n\t\tvar q = jQuery.data( elem, type + \"queue\" );\n\n\t\tif ( !q || array )\n\t\t\tq = jQuery.data( elem, type + \"queue\", jQuery.makeArray(array) );\n\n\t}\n\treturn q;\n};\n\njQuery.fn.dequeue = function(type){\n\ttype = type || \"fx\";\n\n\treturn this.each(function(){\n\t\tvar q = queue(this, type);\n\n\t\tq.shift();\n\n\t\tif ( q.length )\n\t\t\tq[0].call( this );\n\t});\n};\n\njQuery.extend({\n\n\tspeed: function(speed, easing, fn) {\n\t\tvar opt = speed && speed.constructor == Object ? speed : {\n\t\t\tcomplete: fn || !fn && easing ||\n\t\t\t\tjQuery.isFunction( speed ) && speed,\n\t\t\tduration: speed,\n\t\t\teasing: fn && easing || easing && easing.constructor != Function && easing\n\t\t};\n\n\t\topt.duration = (opt.duration && opt.duration.constructor == Number ?\n\t\t\topt.duration :\n\t\t\tjQuery.fx.speeds[opt.duration]) || jQuery.fx.speeds.def;\n\n\t\t// Queueing\n\t\topt.old = opt.complete;\n\t\topt.complete = function(){\n\t\t\tif ( opt.queue !== false )\n\t\t\t\tjQuery(this).dequeue();\n\t\t\tif ( jQuery.isFunction( opt.old ) )\n\t\t\t\topt.old.call( this );\n\t\t};\n\n\t\treturn opt;\n\t},\n\n\teasing: {\n\t\tlinear: function( p, n, firstNum, diff ) {\n\t\t\treturn firstNum + diff * p;\n\t\t},\n\t\tswing: function( p, n, firstNum, diff ) {\n\t\t\treturn ((-Math.cos(p*Math.PI)/2) + 0.5) * diff + firstNum;\n\t\t}\n\t},\n\n\ttimers: [],\n\ttimerId: null,\n\n\tfx: function( elem, options, prop ){\n\t\tthis.options = options;\n\t\tthis.elem = elem;\n\t\tthis.prop = prop;\n\n\t\tif ( !options.orig )\n\t\t\toptions.orig = {};\n\t}\n\n});\n\njQuery.fx.prototype = {\n\n\t// Simple function for setting a style value\n\tupdate: function(){\n\t\tif ( this.options.step )\n\t\t\tthis.options.step.call( this.elem, this.now, this );\n\n\t\t(jQuery.fx.step[this.prop] || jQuery.fx.step._default)( this );\n\n\t\t// Set display property to block for height/width animations\n\t\tif ( this.prop == \"height\" || this.prop == \"width\" )\n\t\t\tthis.elem.style.display = \"block\";\n\t},\n\n\t// Get the current size\n\tcur: function(force){\n\t\tif ( this.elem[this.prop] != null && this.elem.style[this.prop] == null )\n\t\t\treturn this.elem[ this.prop ];\n\n\t\tvar r = parseFloat(jQuery.css(this.elem, this.prop, force));\n\t\treturn r && r > -10000 ? r : parseFloat(jQuery.curCSS(this.elem, this.prop)) || 0;\n\t},\n\n\t// Start an animation from one number to another\n\tcustom: function(from, to, unit){\n\t\tthis.startTime = now();\n\t\tthis.start = from;\n\t\tthis.end = to;\n\t\tthis.unit = unit || this.unit || \"px\";\n\t\tthis.now = this.start;\n\t\tthis.pos = this.state = 0;\n\t\tthis.update();\n\n\t\tvar self = this;\n\t\tfunction t(gotoEnd){\n\t\t\treturn self.step(gotoEnd);\n\t\t}\n\n\t\tt.elem = this.elem;\n\n\t\tjQuery.timers.push(t);\n\n\t\tif ( jQuery.timerId == null ) {\n\t\t\tjQuery.timerId = setInterval(function(){\n\t\t\t\tvar timers = jQuery.timers;\n\n\t\t\t\tfor ( var i = 0; i < timers.length; i++ )\n\t\t\t\t\tif ( !timers[i]() )\n\t\t\t\t\t\ttimers.splice(i--, 1);\n\n\t\t\t\tif ( !timers.length ) {\n\t\t\t\t\tclearInterval( jQuery.timerId );\n\t\t\t\t\tjQuery.timerId = null;\n\t\t\t\t}\n\t\t\t}, 13);\n\t\t}\n\t},\n\n\t// Simple 'show' function\n\tshow: function(){\n\t\t// Remember where we started, so that we can go back to it later\n\t\tthis.options.orig[this.prop] = jQuery.attr( this.elem.style, this.prop );\n\t\tthis.options.show = true;\n\n\t\t// Begin the animation\n\t\tthis.custom(0, this.cur());\n\n\t\t// Make sure that we start at a small width/height to avoid any\n\t\t// flash of content\n\t\tif ( this.prop == \"width\" || this.prop == \"height\" )\n\t\t\tthis.elem.style[this.prop] = \"1px\";\n\n\t\t// Start by showing the element\n\t\tjQuery(this.elem).show();\n\t},\n\n\t// Simple 'hide' function\n\thide: function(){\n\t\t// Remember where we started, so that we can go back to it later\n\t\tthis.options.orig[this.prop] = jQuery.attr( this.elem.style, this.prop );\n\t\tthis.options.hide = true;\n\n\t\t// Begin the animation\n\t\tthis.custom(this.cur(), 0);\n\t},\n\n\t// Each step of an animation\n\tstep: function(gotoEnd){\n\t\tvar t = now();\n\n\t\tif ( gotoEnd || t > this.options.duration + this.startTime ) {\n\t\t\tthis.now = this.end;\n\t\t\tthis.pos = this.state = 1;\n\t\t\tthis.update();\n\n\t\t\tthis.options.curAnim[ this.prop ] = true;\n\n\t\t\tvar done = true;\n\t\t\tfor ( var i in this.options.curAnim )\n\t\t\t\tif ( this.options.curAnim[i] !== true )\n\t\t\t\t\tdone = false;\n\n\t\t\tif ( done ) {\n\t\t\t\tif ( this.options.display != null ) {\n\t\t\t\t\t// Reset the overflow\n\t\t\t\t\tthis.elem.style.overflow = this.options.overflow;\n\n\t\t\t\t\t// Reset the display\n\t\t\t\t\tthis.elem.style.display = this.options.display;\n\t\t\t\t\tif ( jQuery.css(this.elem, \"display\") == \"none\" )\n\t\t\t\t\t\tthis.elem.style.display = \"block\";\n\t\t\t\t}\n\n\t\t\t\t// Hide the element if the \"hide\" operation was done\n\t\t\t\tif ( this.options.hide )\n\t\t\t\t\tthis.elem.style.display = \"none\";\n\n\t\t\t\t// Reset the properties, if the item has been hidden or shown\n\t\t\t\tif ( this.options.hide || this.options.show )\n\t\t\t\t\tfor ( var p in this.options.curAnim )\n\t\t\t\t\t\tjQuery.attr(this.elem.style, p, this.options.orig[p]);\n\t\t\t}\n\n\t\t\tif ( done )\n\t\t\t\t// Execute the complete function\n\t\t\t\tthis.options.complete.call( this.elem );\n\n\t\t\treturn false;\n\t\t} else {\n\t\t\tvar n = t - this.startTime;\n\t\t\tthis.state = n / this.options.duration;\n\n\t\t\t// Perform the easing function, defaults to swing\n\t\t\tthis.pos = jQuery.easing[this.options.easing || (jQuery.easing.swing ? \"swing\" : \"linear\")](this.state, n, 0, 1, this.options.duration);\n\t\t\tthis.now = this.start + ((this.end - this.start) * this.pos);\n\n\t\t\t// Perform the next step of the animation\n\t\t\tthis.update();\n\t\t}\n\n\t\treturn true;\n\t}\n\n};\n\njQuery.extend( jQuery.fx, {\n\tspeeds:{\n\t\tslow: 600,\n \t\tfast: 200,\n \t\t// Default speed\n \t\tdef: 400\n\t},\n\tstep: {\n\t\tscrollLeft: function(fx){\n\t\t\tfx.elem.scrollLeft = fx.now;\n\t\t},\n\n\t\tscrollTop: function(fx){\n\t\t\tfx.elem.scrollTop = fx.now;\n\t\t},\n\n\t\topacity: function(fx){\n\t\t\tjQuery.attr(fx.elem.style, \"opacity\", fx.now);\n\t\t},\n\n\t\t_default: function(fx){\n\t\t\tfx.elem.style[ fx.prop ] = fx.now + fx.unit;\n\t\t}\n\t}\n});\n// The Offset Method\n// Originally By Brandon Aaron, part of the Dimension Plugin\n// http://jquery.com/plugins/project/dimensions\njQuery.fn.offset = function() {\n\tvar left = 0, top = 0, elem = this[0], results;\n\n\tif ( elem ) with ( jQuery.browser ) {\n\t\tvar parent       = elem.parentNode,\n\t\t    offsetChild  = elem,\n\t\t    offsetParent = elem.offsetParent,\n\t\t    doc          = elem.ownerDocument,\n\t\t    safari2      = safari && parseInt(version) < 522 && !/adobeair/i.test(userAgent),\n\t\t    css          = jQuery.curCSS,\n\t\t    fixed        = css(elem, \"position\") == \"fixed\";\n\n\t\t// Use getBoundingClientRect if available\n\t\tif ( elem.getBoundingClientRect ) {\n\t\t\tvar box = elem.getBoundingClientRect();\n\n\t\t\t// Add the document scroll offsets\n\t\t\tadd(box.left + Math.max(doc.documentElement.scrollLeft, doc.body.scrollLeft),\n\t\t\t\tbox.top  + Math.max(doc.documentElement.scrollTop,  doc.body.scrollTop));\n\n\t\t\t// IE adds the HTML element's border, by default it is medium which is 2px\n\t\t\t// IE 6 and 7 quirks mode the border width is overwritable by the following css html { border: 0; }\n\t\t\t// IE 7 standards mode, the border is always 2px\n\t\t\t// This border/offset is typically represented by the clientLeft and clientTop properties\n\t\t\t// However, in IE6 and 7 quirks mode the clientLeft and clientTop properties are not updated when overwriting it via CSS\n\t\t\t// Therefore this method will be off by 2px in IE while in quirksmode\n\t\t\tadd( -doc.documentElement.clientLeft, -doc.documentElement.clientTop );\n\n\t\t// Otherwise loop through the offsetParents and parentNodes\n\t\t} else {\n\n\t\t\t// Initial element offsets\n\t\t\tadd( elem.offsetLeft, elem.offsetTop );\n\n\t\t\t// Get parent offsets\n\t\t\twhile ( offsetParent ) {\n\t\t\t\t// Add offsetParent offsets\n\t\t\t\tadd( offsetParent.offsetLeft, offsetParent.offsetTop );\n\n\t\t\t\t// Mozilla and Safari > 2 does not include the border on offset parents\n\t\t\t\t// However Mozilla adds the border for table or table cells\n\t\t\t\tif ( mozilla && !/^t(able|d|h)$/i.test(offsetParent.tagName) || safari && !safari2 )\n\t\t\t\t\tborder( offsetParent );\n\n\t\t\t\t// Add the document scroll offsets if position is fixed on any offsetParent\n\t\t\t\tif ( !fixed && css(offsetParent, \"position\") == \"fixed\" )\n\t\t\t\t\tfixed = true;\n\n\t\t\t\t// Set offsetChild to previous offsetParent unless it is the body element\n\t\t\t\toffsetChild  = /^body$/i.test(offsetParent.tagName) ? offsetChild : offsetParent;\n\t\t\t\t// Get next offsetParent\n\t\t\t\toffsetParent = offsetParent.offsetParent;\n\t\t\t}\n\n\t\t\t// Get parent scroll offsets\n\t\t\twhile ( parent && parent.tagName && !/^body|html$/i.test(parent.tagName) ) {\n\t\t\t\t// Remove parent scroll UNLESS that parent is inline or a table to work around Opera inline/table scrollLeft/Top bug\n\t\t\t\tif ( !/^inline|table.*$/i.test(css(parent, \"display\")) )\n\t\t\t\t\t// Subtract parent scroll offsets\n\t\t\t\t\tadd( -parent.scrollLeft, -parent.scrollTop );\n\n\t\t\t\t// Mozilla does not add the border for a parent that has overflow != visible\n\t\t\t\tif ( mozilla && css(parent, \"overflow\") != \"visible\" )\n\t\t\t\t\tborder( parent );\n\n\t\t\t\t// Get next parent\n\t\t\t\tparent = parent.parentNode;\n\t\t\t}\n\n\t\t\t// Safari <= 2 doubles body offsets with a fixed position element/offsetParent or absolutely positioned offsetChild\n\t\t\t// Mozilla doubles body offsets with a non-absolutely positioned offsetChild\n\t\t\tif ( (safari2 && (fixed || css(offsetChild, \"position\") == \"absolute\")) ||\n\t\t\t\t(mozilla && css(offsetChild, \"position\") != \"absolute\") )\n\t\t\t\t\tadd( -doc.body.offsetLeft, -doc.body.offsetTop );\n\n\t\t\t// Add the document scroll offsets if position is fixed\n\t\t\tif ( fixed )\n\t\t\t\tadd(Math.max(doc.documentElement.scrollLeft, doc.body.scrollLeft),\n\t\t\t\t\tMath.max(doc.documentElement.scrollTop,  doc.body.scrollTop));\n\t\t}\n\n\t\t// Return an object with top and left properties\n\t\tresults = { top: top, left: left };\n\t}\n\n\tfunction border(elem) {\n\t\tadd( jQuery.curCSS(elem, \"borderLeftWidth\", true), jQuery.curCSS(elem, \"borderTopWidth\", true) );\n\t}\n\n\tfunction add(l, t) {\n\t\tleft += parseInt(l, 10) || 0;\n\t\ttop += parseInt(t, 10) || 0;\n\t}\n\n\treturn results;\n};\n\n\njQuery.fn.extend({\n\tposition: function() {\n\t\tvar left = 0, top = 0, results;\n\n\t\tif ( this[0] ) {\n\t\t\t// Get *real* offsetParent\n\t\t\tvar offsetParent = this.offsetParent(),\n\n\t\t\t// Get correct offsets\n\t\t\toffset       = this.offset(),\n\t\t\tparentOffset = /^body|html$/i.test(offsetParent[0].tagName) ? { top: 0, left: 0 } : offsetParent.offset();\n\n\t\t\t// Subtract element margins\n\t\t\t// note: when an element has margin: auto the offsetLeft and marginLeft \n\t\t\t// are the same in Safari causing offset.left to incorrectly be 0\n\t\t\toffset.top  -= num( this, 'marginTop' );\n\t\t\toffset.left -= num( this, 'marginLeft' );\n\n\t\t\t// Add offsetParent borders\n\t\t\tparentOffset.top  += num( offsetParent, 'borderTopWidth' );\n\t\t\tparentOffset.left += num( offsetParent, 'borderLeftWidth' );\n\n\t\t\t// Subtract the two offsets\n\t\t\tresults = {\n\t\t\t\ttop:  offset.top  - parentOffset.top,\n\t\t\t\tleft: offset.left - parentOffset.left\n\t\t\t};\n\t\t}\n\n\t\treturn results;\n\t},\n\n\toffsetParent: function() {\n\t\tvar offsetParent = this[0].offsetParent;\n\t\twhile ( offsetParent && (!/^body|html$/i.test(offsetParent.tagName) && jQuery.css(offsetParent, 'position') == 'static') )\n\t\t\toffsetParent = offsetParent.offsetParent;\n\t\treturn jQuery(offsetParent);\n\t}\n});\n\n\n// Create scrollLeft and scrollTop methods\njQuery.each( ['Left', 'Top'], function(i, name) {\n\tvar method = 'scroll' + name;\n\t\n\tjQuery.fn[ method ] = function(val) {\n\t\tif (!this[0]) return;\n\n\t\treturn val != undefined ?\n\n\t\t\t// Set the scroll offset\n\t\t\tthis.each(function() {\n\t\t\t\tthis == window || this == document ?\n\t\t\t\t\twindow.scrollTo(\n\t\t\t\t\t\t!i ? val : jQuery(window).scrollLeft(),\n\t\t\t\t\t\t i ? val : jQuery(window).scrollTop()\n\t\t\t\t\t) :\n\t\t\t\t\tthis[ method ] = val;\n\t\t\t}) :\n\n\t\t\t// Return the scroll offset\n\t\t\tthis[0] == window || this[0] == document ?\n\t\t\t\tself[ i ? 'pageYOffset' : 'pageXOffset' ] ||\n\t\t\t\t\tjQuery.boxModel && document.documentElement[ method ] ||\n\t\t\t\t\tdocument.body[ method ] :\n\t\t\t\tthis[0][ method ];\n\t};\n});\n\n// Create innerHeight, innerWidth, outerHeight and outerWidth methods\njQuery.each([ \"Height\", \"Width\" ], function(i, name){\n\n\tvar tl = i ? \"Left\"  : \"Top\",  // top or left\n\t\tbr = i ? \"Right\" : \"Bottom\"; // bottom or right\n\n\t// innerHeight and innerWidth\n\tjQuery.fn[\"inner\" + name] = function(){\n\t\treturn this[ name.toLowerCase() ]() +\n\t\t\tnum(this, \"padding\" + tl) +\n\t\t\tnum(this, \"padding\" + br);\n\t};\n\n\t// outerHeight and outerWidth\n\tjQuery.fn[\"outer\" + name] = function(margin) {\n\t\treturn this[\"inner\" + name]() +\n\t\t\tnum(this, \"border\" + tl + \"Width\") +\n\t\t\tnum(this, \"border\" + br + \"Width\") +\n\t\t\t(margin ?\n\t\t\t\tnum(this, \"margin\" + tl) + num(this, \"margin\" + br) : 0);\n\t};\n\n});\n\n;exports.jQuery = jQuery;\nexports.$ = $;\n");
/* >>>>>>>>>> BEGIN source/browser/logger.js */
tiki.module('core_test:browser/logger',"var $m__ = require('core_test:core'), CoreTest=$m__.CoreTest;var $m__ = require('core_test:utils'), K=$m__.K,beget=$m__.beget,mixin=$m__.mixin,fmt=$m__.fmt;var $m__ = require('core_test:browser/jquery'), jQuery=$m__.jQuery,$=$m__.$;var BrowserLogger,logger;// ==========================================================================\n// Project:   SproutCore Unit Testing Library\n// Copyright: \u00a92006-2009 Sprout Systems, Inc. and contributors.\n//            Portions \u00a92008-2009 Apple Inc. All rights reserved.\n// License:   Licened under MIT license (see license.js)\n// ==========================================================================\n/*globals CoreTest BrowserLogger logger fmt */\n\n\"import core utils browser/jquery\";\n\"export package BrowserLogger\";\n\"export logger\";\n\n/**\n  The BrowserLogger can be used to log test output to the main web page.  \n*/\nBrowserLogger = function BrowserLogger() {\n  this.stats = {\n    tests: 0, passed: 0, failed: 0, total: 0, errors: 0, warnings: 0\n  };\n  return this ;\n};\n\nBrowserLogger.prototype = {\n  constructor: BrowserLogger,\n  \n  testCount: 0,\n  \n  planDidBegin: function(plan) {\n    if (!this.report) {\n      // setup the report DOM element.\n      this.report = $(['<div class=\"core-test\">',\n        '<div class=\"useragent\">UserAgent</div>',\n        '<div class=\"testresult\">',\n          '<label class=\"hide-passed\">',\n            '<input type=\"checkbox\" checked=\"checked\" /> Hide passed tests',\n          '</label>',\n          '<span class=\"status\">Running...</span>',\n        '</div>',\n        '<div class=\"detail\">',\n          '<table>',\n            '<thead><tr>',\n              '<th class=\"desc\">Test</th><th>Result</th>',\n            '</tr></thead>',\n            '<tbody><tr></tr></tbody>',\n          '</table>',\n        '</div>',\n      '</div>'].join(''));\n\n\n      this.report.find('.useragent').html(navigator.userAgent);\n      this.logq = this.report.find('tbody');\n      this.testCount = 0 ;\n\n      // listen to change event\n      var runner = this;\n      this.checkbox = this.report.find('.hide-passed input'); \n      this.checkbox.change(function() {\n        runner.hidePassedTestsDidChange();\n      });\n\n      $('body').append(this.report);\n      \n      this._startTime = new Date().getTime();\n    }\n    \n    this._plan = plan ;\n    return this ;\n  },\n  \n  planDidEnd: function(plan) {\n\n    this.scheduleFlushResult();\n    this.scheduleFlush();\n    //this.flush();\n    \n    var r = this.stats;\n    if (this._startTime) {\n      r.runtime = new Date().getTime() - this._startTime;\n    } else r.runtime = 0;\n    \n    var result = this.report.find('.testresult .status');\n    \n    var str = fmt('<span>Completed %@ tests in %@ msec. </span>'\n              +'<span class=\"total\">%@</span> total assertions: ', r.tests, \n              r.runtime, r.total);\n    \n    if (r.passed > 0) {\n      str += fmt('&nbsp;<span class=\"passed\">%@ passed</span>', r.passed);\n    }\n    \n    if (r.failed > 0) {\n      str += fmt('&nbsp;<span class=\"failed\">%@ failed</span>', r.failed);\n    }\n\n    if (r.errors > 0) {\n      str += fmt('&nbsp;<span class=\"errors\">%@ error%@</span>', \n            r.errors, (r.errors !== 1 ? 's' : ''));\n    }\n\n    if (r.warnings > 0) {\n      str += fmt('&nbsp;<span class=\"warnings\">%@ warnings%@</span>',\n            r.warnings, (r.warnings !== 1 ? 's' : ''));\n    }\n\n    // if all tests passed, disable hiding them.  if some tests failed, hide\n    // them by default.\n    if (this.errors) this.errors.push('</tr></tbody></table>');\n    if ((r.failed + r.errors + r.warnings) > 0) {\n      this.hidePassedTestsDidChange(); // should be checked by default\n    } else {\n      this.report.find('.hide-passed').addClass('disabled')\n        .find('input').attr('disabled', true);\n      if (this.errors) this.errors.length = 0;\n    }     \n    if(CoreTest.showUI) $('.core-test').css(\"right\", \"360px\");\n    this.resultStr = str;\n    \n    if (this.errors) CoreTest.errors=this.errors.join('');\n    this._plan = null;\n    return this ;\n  },\n  \n  moduleDidBegin: function(moduleName) {\n    if (!this._modules) this._modules = [];\n    this._modules.push(moduleName);\n    return this ;\n  },\n  \n  moduleDidEnd: function(moduleName) {\n    if (this._modules) this._modules.pop();\n    return this ;\n  },\n  \n  testDidBegin: function(testName) {\n    if (!this._tests) this._tests = [];\n    this._tests.push(testName);\n    \n    if (!this._assertions) this._assertions = [];\n    this._assertions.push([]);\n    this._timings = { total_begin: new Date().getTime(), total_end: 0 };\n    this.stats.tests++;\n    return this ;\n  },\n  \n  testDidEnd: function(testName) {\n    var p = this._plan,  \n        m = this._modules, \n        t = this._tests,\n        a = this._assertions;\n        \n    m = m ? m[m.length-1] : '' ;\n    t = t ? t[t.length-1] : '';\n    a = a ? a[a.length-1] : {};\n     \n    this._timings.total_end = new Date().getTime();\n    this.planDidRecord(p, m, t, a);\n    if (this._assertions) this._assertions.pop();\n    if (this._tests) this._tests.pop();\n    return this ;\n  },\n  \n  planDidRecord: function(plan, module, test, assertions) {\n    var name = test, \n        s    = { passed: 0, failed: 0, errors: 0, warnings: 0 }, \n        len  = assertions.length, \n        clean = '', \n        idx, cur, q;\n    \n    var timings = this._timings ;\n    if (!timings) timings = this._timings = {};\n    \n    for(idx=0;idx<len;idx++) s[assertions[idx].result]++;\n    if ((s.failed + s.errors + s.warnings) === 0) clean = \"clean\" ;\n    \n    if (module) name = module.replace(/\\n/g, '<br />') + \" module: \" + test ;\n    name = fmt('%@ - %@msec', name, timings.total_end - timings.total_begin);\n    \n    // place results into a single string to append all at once.\n    var logstr = this.logstr ;\n    var errors =this.errors;\n    if (!logstr) logstr = this.logstr = [];\n    if (!this.errors) {\n      this.errors = ['<style type=\"text/css\">* {font: 12px arial;}'+\n                    '.passed { background-color: #80D175; color: white;}'+\n                    '.failed { background-color: #ea4d4; color: black; }'+\n                    '.errors { background-color: red; color: black; }'+\n                    '.warnings { background-color: #E49723; color: black;}'+\n                    '.desc { text-align: left;}'+\n                    '</style><table style=\"border:1px solid\"><thead>'+\n                    '<tr><th class=\"desc\">'+navigator.userAgent+\n                    '</th><th>Result</th></tr>'+\n                    '</thead><tbody><tr>'];\n    }\n    logstr.push(fmt('<tr class=\"test %@\"><th class=\"desc\" colspan=\"2\">'+\n          '%@ (<span class=\"passed\">%@</span>, <span class=\"failed\">%@</span>,'+\n          ' <span class=\"errors\">%@</span>, <span class=\"warnings\">%@</span>)'+\n          '</th></tr>', clean, name, s.passed, s.failed, s.errors, s.warnings));\n    if(s.failed>0 || s.errors>0){\n      this.errors.push(fmt('<tr class=\"test %@\">'+\n          '<th style=\"background:grey; color:white\" class=\"desc\" colspan=\"2\">'+\n          '%@ (<span class=\"passed\">%@</span>, <span class=\"failed\">%@</span>'+\n          ', <span class=\"errors\">%@</span>, <span class=\"warnings\">%@</span>'+\n          ')</th></tr>', clean, name, s.passed, s.failed, s.errors, s.warnings));  \n    }\n    \n    len = assertions.length;\n    for(idx=0;idx<len;idx++) {\n      cur = assertions[idx];\n      clean = cur.result === 'passed' ? 'clean' : 'dirty';\n      logstr.push(fmt('<tr class=\"%@\"><td class=\"desc\">%@<pre>%@</pre></td>'\n          +'<td class=\"action %@\">%@</td></tr>', clean, cur.message,\n            cur.stack || \"\",cur.result, (cur.result || '').toUpperCase()));\n      if(clean=='dirty'){\n        this.errors.push(fmt('<tr class=\"%@\"><td class=\"desc\">%@</td>'\n        +'<td class=\"action %@\">%@</td></tr>', clean, cur.message, cur.result,\n        (cur.result || '').toUpperCase()));\n      }\n    }\n    \n    this.testCount++;\n    //this.resultStr = fmt(\"Running \u2013 Completed %@ tests so far.\", this.testCount);\n  },\n  \n  assertion: function(newAssertion) {\n    var a = this._assertions ;\n    if (a) a = a[a.length-1]; \n    if (a) a.push(newAssertion);\n    this.stats.total++;\n    return this ;\n  },\n  \n  info: function(msg) {\n    this.assertion({ message: msg, result: 'passed' });\n    this.stats.passed++;\n    return this;\n  },\n  \n  error: function(exception) {\n    this.assertion({\n        message: exception,\n        stack: exception.stack,\n        result: 'errors'\n    });\n    this.stats.errors++;\n    return this;\n  },\n  \n  warn: function(msg) {\n    this.assertion({ message: msg, result: 'warnings' });\n    this.stats.warnings++;\n    return this;\n  },\n  \n  debug: function(msg) {\n    //this.assertions().push({ message: msg, result: 'failed' });\n  },\n  \n  // ..........................................................\n  // SUPPORT METHODS\n  // \n  \n  hidePassedTestsDidChange: function() {\n    var checked = !!this.checkbox.val();\n        \n    if (checked) {\n      this.logq.addClass('hide-clean');\n    } else {\n      this.logq.removeClass('hide-clean');\n    }\n  },\n  \n  // flush result once every 100 msec\n  scheduleFlushResult: function() {\n    if (this._flushResultTimer) return this;\n\n    var f = this._scheduleFlushResult;\n    if (!f) {\n      var logger = this ;\n      f = this._scheduleFlushResult = function() {\n        logger._flushResultTimer = null;\n        logger.flush(true);\n      };\n    }\n    \n    this._flushResultTimer = setTimeout(f, 250);\n  },\n  \n  \n  // schedules a complete flush to happen 250msec.  Reset after each call\n  scheduleFlush: function() {  \n\n    var f = this._scheduleFlush;\n    if (!f) {\n      var logger = this ;\n      f = this._scheduleFlush = function() {\n        logger._flushTimer = null;\n        logger.flush();\n      };\n    }\n\n    if (this._flushTimer) clearTimeout(this._flushTimer);\n    this._flushTimer = setTimeout(f, 100);\n  },\n  \n  // flush any pending HTML changes...\n  flush: function(resultOnly) {\n    var logstr = this.logstr,\n        resultStr = this.resultStr,\n        result = this.report.find('.testresult .status');\n\n    if (!resultOnly && logstr) {\n      this.logq.append(this.logstr.join('')) ;\n      this.logstr = null;\n    }\n    \n    if (resultStr) result.html(resultStr);\n    this.resultStr = null ;\n  }\n  \n};\n\nlogger = new BrowserLogger();\n;exports.BrowserLogger = BrowserLogger;\nexports.logger = logger;\n");
/* >>>>>>>>>> BEGIN source/system/assert.js */
tiki.module('core_test:system/assert',"var $m__ = require('core_test:core'), CoreTest=$m__.CoreTest;var $m__ = require('core_test:utils'), K=$m__.K,beget=$m__.beget,mixin=$m__.mixin,fmt=$m__.fmt;require('core_test:system/dump');var AssertionError,ok,equal,equals,notEqual,deepEqual,same,deepNotEqual,shouldThrow;// ==========================================================================\n// Project:   SproutCore Costello - Property Observing Library\n// Copyright: \u00a92006-2009 Sprout Systems, Inc. and contributors.\n//            Portions \u00a92008-2009 Apple Inc. All rights reserved.\n// License:   Licened under MIT license (see license.js)\n// ==========================================================================\n/*globals ok AssertionError fmt beget equal notEqual deepEqual deepNotEqual */\n\n\"import core utils system/dump\";\n\"export package AssertionError\";\n\"export package ok equal equals notEqual deepEqual same deepNotEqual shouldThrow\";\n\n/**\n  @class\n  \n  Error thrown by assertions that have failed.  For these assertions you may\n  also set the CoreTest.throwsOnFailure property to false.\n  \n  When throwing an error, pass any properties you want copied onto the error.\n  The message, actual, and expected are required to properly log the output.\n  \n  h2. Examples\n  \n  Throwing an error:\n  \n  {{{\n    new AssertionError({ message: \"foo\", expected: \"bar\", actual: \"baz\" });\n  }}}\n  \n  Optional (non-standard) method using parameters:\n  \n  {{{\n    new AssertionError('actual', 'expected', 'message');\n  }}}\n  \n  @since SproutCore 1.1\n*/\nAssertionError = function AssertionError(actual, expected, message) {\n  if (arguments.length === 1) mixin(this, actual);\n  else {\n    this.actual   = actual;\n    this.expected = expected;\n    this.message  = message;\n  }\n\n  this.desc = this.message;\n\n  var ret = ['AssertionError:'];\n  if (this.message) ret.push(this.message);\n  if ((this.actual!==undefined) || (this.expected!==undefined)) {\n    var actual = CoreTest.dump(this.actual),\n        exp    = CoreTest.dump(this.expected);\n    ret.push(fmt('(actual = \"%@\" - expected = \"%@\")', actual, exp));\n  }\n  this.message = ret.join(' ');\n\n  return this ;\n};\n\nAssertionError.prototype = beget(Error.prototype);\nAssertionError.toString = function() {\n  return this.message;\n};\n\n// ..........................................................\n// PRIMITIVE ASSERTION API - Provides CommonJS Parity\n// \n  \n/**\n  Asserts that the first passed value is true.\n  \n  @param {Boolean} pass true if assertion passed\n  @param {String} message optional message\n  @param {Object} actual optional actual value to display\n  @param {Object} expected optional expected value to display\n  @returns {void}\n*/\nok = CoreTest.ok = function ok(pass, message, actual, expected) {\n  var logger       = CoreTest.logger,\n      shouldThrow  = CoreTest.throwsOnFailure,\n      showVars     = arguments.length > 2,\n      str;\n\n  if (!logger) return this; // nothing to do\n\n  if (showVars) {\n    actual = CoreTest.dump(actual);\n    expected = CoreTest.dump(expected);\n  }\n  \n  if (pass) {\n    str = showVars ? '%@ (actual = %@, expected = %@)' : '%@';\n    logger.info(fmt(str, message, actual, expected));\n    \n  } else if (shouldThrow) {\n    throw new AssertionError(actual, expected, message);\n    \n  } else {\n    str = showVars ? '%@ (actual = %@, expected = %@)' : '%@';\n    logger.error(fmt(str, message, actual, expected));\n  }\n  \n  return pass;\n};\n\n/**\n  Asserts that the actual value (first value) is identical to the expected \n  value using ===.\n  \n  @param {Object} actual actual value of test\n  @param {Object} expected expected value of test\n  @param {String} message optional message\n  @returns {Boolean} YES if passed\n*/\nequal = CoreTest.equal = function equal(actual, expect, message) {\n  message = fmt('%@ should be equal', message);\n  return CoreTest.ok(actual === expect, message, actual, expect);\n};\nequals = equal ; // QUnit compatibility\n\n/**\n  Asserts that the actual value is NOT identical to the expected value using \n  ===.\n  \n  @param {Object} actual actual value of test\n  @param {Object} expect expected value of test\n  @param {String} message optional message\n  @returns {Boolean} YES if passed\n*/\nnotEqual = CoreTest.notEqual = function notEqual(actual, expect, message) {\n  message = fmt('%@ should not be equal', message);\n  return CoreTest.ok(actual !== expect, message, actual, expect);\n};\n\n/**\n  Asserts the the actual value is the same as the expected value using a \n  deep comparison (CoreTest.equiv() if you must know).\n  \n  @param {Object} actual actual value of test\n  @param {Object} expect expected value of test\n  @param {String} msg optional message\n  @returns {Boolean} YES if passed\n*/\ndeepEqual = CoreTest.deepEqual = function deepEqual(actual, expect, msg) {\n  msg = fmt('%@ should be deepEqual', msg);\n  return CoreTest.ok(CoreTest.equiv(actual, expect), msg, actual, expect);\n} ;\nsame = deepEqual; // QUnit compatibility \n\n/**\n  Asserts the the actual value is NOT the same as the expected value using a \n  deep comparison (CoreTest.equiv() if you must know).\n  \n  @param {Object} actual actual value of test\n  @param {Object} expect expected value of test\n  @param {String} msg optional message\n  @returns {Boolean} YES if passed\n*/\ndeepNotEqual = function deepNotEqual(actual, expect, msg) {\n  message = fmt('%@ should not be deepEqual', message);\n  return CoreTest.ok(!CoreTest.equiv(actual,expect), msg, actual, expect);\n} ;\nCoreTest.deepNotEqual = deepNotEqual;\n\n/**\n  Asserts that the passed callback will throw the an error with the expected\n  message.\n  \n  @param {Function} callback callback to execute\n  @param {String} expected string of message or false if no exception expected\n  @param {String} msg optional additonal message\n  @returns {Boolean} YES if passed\n*/\nshouldThrow = function shouldThrow(callback, expected, msg) {\n  var actual = false ;\n  \n  try {\n    callback();\n  } catch(e) {\n    actual = (typeof expected === \"string\") ? e.message : e;        \n  }\n  \n  if (expected===false) {\n    CoreTest.ok(actual===false, fmt(\"%@ expected no exception, actual %@\", msg, actual));\n  } else if (expected===Error || expected===null || expected===true) {\n    CoreTest.ok(!!actual, fmt(\"%@ expected exception, actual %@\", msg, actual));\n  } else {\n    equals(actual, expected, msg);\n  }\n};\nCoreTest.shouldThrow = shouldThrow;\n\n\n;exports.AssertionError = AssertionError;\nexports.ok = ok;\nexports.equal = equal;\nexports.equals = equals;\nexports.notEqual = notEqual;\nexports.deepEqual = deepEqual;\nexports.same = same;\nexports.deepNotEqual = deepNotEqual;\nexports.shouldThrow = shouldThrow;\n");
/* >>>>>>>>>> BEGIN source/system/dump.js */
tiki.module('core_test:system/dump',"var $m__ = require('core_test:core'), CoreTest=$m__.CoreTest;// ==========================================================================\n// Project:   SproutCore Costello - Property Observing Library\n// Copyright: \u00a92006-2009 Sprout Systems, Inc. and contributors.\n//            Portions \u00a92008-2009 Apple Inc. All rights reserved.\n// License:   Licened under MIT license (see license.js)\n// ==========================================================================\n\n/*globals CoreTest */\n\n\"import core\";\n\"export package\";\n\n/**\n * jsDump\n * Copyright (c) 2008 Ariel Flesler - aflesler(at)gmail(dot)com | http://flesler.blogspot.com\n * Licensed under BSD (http://www.opensource.org/licenses/bsd-license.php)\n * Date: 5/15/2008\n * @projectDescription Advanced and extensible data dumping for Javascript.\n * @version 1.0.0\n * @author Ariel Flesler\n * @link {http://flesler.blogspot.com/2008/05/jsdump-pretty-dump-of-any-javascript.html}\n */\nvar reName, jsDump;\n\nfunction quote( str ){\n  return '\"' + str.toString().replace(/\"/g, '\\\\\"') + '\"';\n}\n\nfunction literal( o ){\n  return o + '';  \n}\n\nfunction join( pre, arr, post ){\n  var s     = jsDump.separator(),\n      base  = jsDump.indent(),\n      inner = jsDump.indent(1);\n      \n  if( arr.join )  arr = arr.join( ',' + s + inner );\n  if( !arr ) return pre + post;\n  \n  return [ pre, inner + arr, base + post ].join(s);\n}\n\nfunction array( arr ){\n  var i = arr.length, ret = new Array(i);         \n  this.up();\n  while( i-- ) ret[i] = this._parse( arr[i] );        \n  this.down();\n  return join( '[', ret, ']' );\n}\n\nreName = /^function (\\w+)/;\n\njsDump = CoreTest.jsDump = {\n\n  parse: function(obj, type) {\n    if (obj && obj.toString) {\n      var toString = obj.toString;\n      if ((toString !== Object.prototype.toString) && (toString !== Array.toString)) return obj.toString();\n    }\n    if (obj && obj.inspect) return obj.inspect();\n    \n    this.seen = [];\n    var ret = this._parse(obj, type);\n    this.seen = null;\n    return ret ;\n  },\n  \n  //type is used mostly internally, you can fix a (custom)type in advance\n  _parse: function( obj, type ) {\n    \n    \n    var parser = this.parsers[ type || this.typeOf(obj) ];\n    type = typeof parser;     \n\n    // avoid recursive loops\n    if ((parser === this.parsers.object) && (this.seen.indexOf(obj)>=0)) {\n      return '(recursive)';\n    }\n    this.seen.push(obj);\n    \n    return type == 'function' ? parser.call( this, obj ) :\n         type == 'string' ? parser :\n         this.parsers.error;\n  },\n  typeOf:function( obj ){\n    var type = typeof obj,\n      f = 'function';//we'll use it 3 times, save it\n      \n    if (obj && (obj.isObject || obj.isClass)) return 'scobj';\n    return type != 'object' && type != f ? type :\n      !obj ? 'null' :\n      obj.exec ? 'regexp' :// some browsers (FF) consider regexps functions\n      obj.getHours ? 'date' :\n      obj.scrollBy ?  'window' :\n      obj.nodeName == '#document' ? 'document' :\n      obj.nodeName ? 'node' :\n      obj.item ? 'nodelist' : // Safari reports nodelists as functions\n      obj.callee ? 'arguments' :\n      obj.call || obj.constructor != Array && //an array would also fall on this hack\n        (obj+'').indexOf(f) != -1 ? f : //IE reports functions like alert, as objects\n      'length' in obj ? 'array' :\n      type;\n  },\n  separator:function(){\n    return this.multiline ? this.HTML ? '<br />' : '\\n' : this.HTML ? '&nbsp;' : ' ';\n  },\n  indent:function( extra ){// extra can be a number, shortcut for increasing-calling-decreasing\n    if( !this.multiline ) return '';\n    \n    var chr = this.indentChar;\n    if( this.HTML ) chr = chr.replace(/\\t/g,'   ').replace(/ /g,'&nbsp;');\n    return (new Array( this._depth_ + (extra||0) )).join(chr);\n  },\n  up:function( a ){\n    this._depth_ += a || 1;\n  },\n  down:function( a ){\n    this._depth_ -= a || 1;\n  },\n  setParser:function( name, parser ){\n    this.parsers[name] = parser;\n  },\n  // The next 3 are exposed so you can use them\n  quote:quote, \n  literal:literal,\n  join:join,\n  //\n  _depth_: 1,\n  // This is the list of parsers, to modify them, use jsDump.setParser\n  parsers:{\n    window: '[Window]',\n    document: '[Document]',\n    error:'[ERROR]', //when no parser is found, shouldn't happen\n    unknown: '[Unknown]',\n    'null':'null',\n    'undefined':'undefined',\n    'function':function( fn ){\n      var ret = 'function',\n        name = 'name' in fn ? fn.name : (reName.exec(fn)||[])[1];//functions never have name in IE\n      if( name ) ret += ' ' + name;\n      ret += '(';\n      \n      ret = [ ret, this._parse( fn, 'functionArgs' ), '){'].join('');\n      return join( ret, this._parse(fn,'functionCode'), '}' );\n    },\n    array: array,\n    nodelist: array,\n    'arguments': array,\n    scobj: function(obj) { return obj.toString(); },\n    object:function( map ){\n      \n      var ret = [ ];\n      this.up();\n      for( var key in map ) {\n        ret.push( this._parse(key,'key') + ': ' + this._parse(map[key]) );\n      }\n      this.down();\n      return join( '{', ret, '}' );\n    },\n    node:function( node ){\n      var open = this.HTML ? '&lt;' : '<',\n        close = this.HTML ? '&gt;' : '>';\n        \n      var tag = node.nodeName.toLowerCase(),\n        ret = open + tag;\n        \n      for( var a in this.DOMAttrs ){\n        var val = node[this.DOMAttrs[a]];\n        if( val ) {\n          ret += ' ' + a + '=' + this._parse( val, 'attribute' );\n        }\n      }\n      return ret + close + open + '/' + tag + close;\n    },\n    functionArgs:function( fn ){//function calls it internally, it's the arguments part of the function\n      var l = fn.length;\n      if( !l ) return '';       \n      \n      var args = new Array(l);\n      while( l-- ) args[l] = String.fromCharCode(97+l);//97 is 'a'\n      return ' ' + args.join(', ') + ' ';\n    },\n    key:quote, //object calls it internally, the key part of an item in a map\n    functionCode:'[code]', //function calls it internally, it's the content of the function\n    attribute:quote, //node calls it internally, it's an html attribute value\n    string:quote,\n    date:quote,\n    regexp:literal, //regex\n    number:literal,\n    'boolean':literal\n  },\n  DOMAttrs:{//attributes to dump from nodes, name=>realName\n    id:'id',\n    name:'name',\n    'class':'className'\n  },\n  HTML:true,//if true, entities are escaped ( <, >, \\t, space and \\n )\n  indentChar:'   ',//indentation unit\n  multiline:true //if true, items in a collection, are separated by a \\n, else just a space.\n};\n\nCoreTest.dump = function dump(obj,type) {\n  return CoreTest.jsDump.parse(obj, type);\n};\n;");
/* >>>>>>>>>> BEGIN source/system/equiv.js */
tiki.module('core_test:system/equiv',"var $m__ = require('core_test:core'), CoreTest=$m__.CoreTest;// ==========================================================================\n// Project:   SproutCore Costello - Property Observing Library\n// Copyright: \u00a92006-2009 Sprout Systems, Inc. and contributors.\n//            Portions \u00a92008-2009 Apple Inc. All rights reserved.\n// License:   Licened under MIT license (see license.js)\n// ==========================================================================\n\n/*globals CoreTest */\n\n\"import core\";\n\"export package\";\n\n/**\n  Tests for equality any JavaScript type and structure without unexpected \n  results.\n\n  Discussions and reference: http://philrathe.com/articles/equiv\n  Test suites: http://philrathe.com/tests/equiv\n  Author: Philippe Rath\u00e9 <prathe@gmail.com>\n*/\nCoreTest.equiv = function () {\n\n    var innerEquiv; // the real equiv function\n    var callers = []; // stack to decide between skip/abort functions\n\n    // Determine what is o.\n    function hoozit(o) {\n        if (typeof o === \"string\") {\n            return \"string\";\n\n        } else if (typeof o === \"boolean\") {\n            return \"boolean\";\n\n        } else if (typeof o === \"number\") {\n\n            if (isNaN(o)) {\n                return \"nan\";\n            } else {\n                return \"number\";\n            }\n\n        } else if (typeof o === \"undefined\") {\n            return \"undefined\";\n\n        // consider: typeof null === object\n        } else if (o === null) {\n            return \"null\";\n\n        // consider: typeof [] === object\n        } else if (o instanceof Array) {\n            return \"array\";\n        \n        // consider: typeof new Date() === object\n        } else if (o instanceof Date) {\n            return \"date\";\n\n        // consider: /./ instanceof Object;\n        //           /./ instanceof RegExp;\n        //          typeof /./ === \"function\"; // => false in IE and Opera,\n        //                                          true in FF and Safari\n        } else if (o instanceof RegExp) {\n            return \"regexp\";\n\n        } else if (typeof o === \"object\") {\n            return \"object\";\n\n        } else if (o instanceof Function) {\n            return \"function\";\n        }\n    }\n\n    // Call the o related callback with the given arguments.\n    function bindCallbacks(o, callbacks, args) {\n        var prop = hoozit(o);\n        if (prop) {\n            if (hoozit(callbacks[prop]) === \"function\") {\n                return callbacks[prop].apply(callbacks, args);\n            } else {\n                return callbacks[prop]; // or undefined\n            }\n        }\n    }\n\n    var callbacks = function () {\n\n        // for string, boolean, number and null\n        function useStrictEquality(b, a) {\n            return a === b;\n        }\n\n        return {\n            \"string\": useStrictEquality,\n            \"boolean\": useStrictEquality,\n            \"number\": useStrictEquality,\n            \"null\": useStrictEquality,\n            \"undefined\": useStrictEquality,\n\n            \"nan\": function (b) {\n                return isNaN(b);\n            },\n\n            \"date\": function (b, a) {\n                return hoozit(b) === \"date\" && a.valueOf() === b.valueOf();\n            },\n\n            \"regexp\": function (b, a) {\n                return hoozit(b) === \"regexp\" &&\n                    a.source === b.source && // the regex itself\n                    a.global === b.global && // and its modifers (gmi) ...\n                    a.ignoreCase === b.ignoreCase &&\n                    a.multiline === b.multiline;\n            },\n\n            // - skip when the property is a method of an instance (OOP)\n            // - abort otherwise,\n            //   initial === would have catch identical references anyway\n            \"function\": function () {\n                var caller = callers[callers.length - 1];\n                return caller !== Object &&\n                        typeof caller !== \"undefined\";\n            },\n\n            \"array\": function (b, a) {\n                var i;\n                var len;\n\n                // b could be an object literal here\n                if ( ! (hoozit(b) === \"array\")) {\n                    return false;\n                }\n\n                len = a.length;\n                if (len !== b.length) { // safe and faster\n                    return false;\n                }\n                for (i = 0; i < len; i++) {\n                    if( ! innerEquiv(a[i], b[i])) {\n                        return false;\n                    }\n                }\n                return true;\n            },\n\n            \"object\": function (b, a) {\n                var i;\n                var eq = true; // unless we can proove it\n                var aProperties = [], bProperties = []; // collection of strings\n                if (b===a) return true;\n                \n                // comparing constructors is more strict than using instanceof\n                if ( a.constructor !== b.constructor) {\n                    return false;\n                }\n\n                // stack constructor before traversing properties\n                callers.push(a.constructor);\n\n                for (i in a) { // be strict: don't ensures hasOwnProperty and go deep\n\n                    aProperties.push(i); // collect a's properties\n\n                    if ( ! innerEquiv(a[i], b[i])) {\n                        eq = false;\n                    }\n                }\n\n                callers.pop(); // unstack, we are done\n\n                for (i in b) {\n                    bProperties.push(i); // collect b's properties\n                }\n\n                // Ensures identical properties name\n                return eq && innerEquiv(aProperties.sort(), bProperties.sort());\n            }\n        };\n    }();\n\n    innerEquiv = function () { // can take multiple arguments\n        var args = Array.prototype.slice.apply(arguments);\n        if (args.length < 2) {\n            return true; // end transition\n        }\n\n        return (function (a, b) {\n            if (a === b) {\n                return true; // catch the most you can\n\n            } else if (typeof a !== typeof b || a === null || b === null || typeof a === \"undefined\" || typeof b === \"undefined\") {\n                return false; // don't lose time with error prone cases\n\n            } else if (b && b.isEqual && b.isEqual instanceof Function) {\n              return b.isEqual(a);\n              \n            } else {\n                return bindCallbacks(a, callbacks, [b, a]);\n            }\n\n        // apply transition with (1..n) arguments\n        })(args[0], args[1]) && arguments.callee.apply(this, args.splice(1, args.length -1));\n    };\n\n    return innerEquiv;\n}(); // equiv\n;");
/* >>>>>>>>>> BEGIN source/system/ext.js */
tiki.module('core_test:system/ext',"// ==========================================================================\n// Project:   SproutCore Unit Testing Library\n// Copyright: \u00a92006-2009 Sprout Systems, Inc. and contributors.\n//            Portions \u00a92008-2009 Apple Inc. All rights reserved.\n// License:   Licened under MIT license (see license.js)\n// ==========================================================================\n\n\"export package\";\n\n// These utility methods are included from the SproutCore's foundation to \n// make it easier write unit tests.  They only install themselves if a method\n// has not already been defined.\n\nif (!String.prototype.camelize) {\n  String.prototype.camelize = function camelize() {\n    var ret = this.replace(SC.STRING_TITLEIZE_REGEXP, \n      function(str,separater,character) { \n        return (character) ? character.toUpperCase() : '' ;\n      }) ;\n    var first = ret.charAt(0), lower = first.toLowerCase() ;\n    return (first !== lower) ? (lower + ret.slice(1)) : ret ;\n  };\n}\n\nif (!String.prototype.trim) {\n  String.prototype.trim = function trim() {\n    return this.replace(/^\\s+|\\s+$/g,\"\");\n  } ;\n}\n\nif (!String.prototype.fmt) {\n  String.prototype.fmt = function fmt() {\n    // first, replace any ORDERED replacements.\n    var args = arguments;\n    var idx  = 0; // the current index for non-numerical replacements\n    return this.replace(/%@([0-9]+)?/g, function(s, argIndex) {\n      argIndex = (argIndex) ? parseInt(argIndex,0)-1 : idx++ ;\n      s =args[argIndex];\n      return ((s===null) ? '(null)' : (s===undefined) ? '' : s).toString(); \n    }) ;\n  } ;\n}\n\nif (!Array.prototype.uniq) {\n  Array.prototype.uniq = function uniq() {\n    var ret = [], len = this.length, item, idx ;\n    for(idx=0;idx<len;idx++) {\n      item = this[idx];\n      if (ret.indexOf(item) < 0) ret.push(item);\n    }\n    return ret ;\n  };\n}\n\nif (!String.prototype.w) {\n  String.prototype.w = function w() { \n    var ary = [], ary2 = this.split(' '), len = ary2.length ;\n    for (var idx=0; idx<len; ++idx) {\n      var str = ary2[idx] ;\n      if (str.length !== 0) ary.push(str) ; // skip empty strings\n    }\n    return ary ;\n  };\n};");
/* >>>>>>>>>> BEGIN source/system/plan.js */
tiki.module('core_test:system/plan',"var $m__ = require('core_test:core'), CoreTest=$m__.CoreTest;var $m__ = require('core_test:utils'), K=$m__.K,beget=$m__.beget,mixin=$m__.mixin,fmt=$m__.fmt;var Plan,test,module,plan,setup,teardown;// ==========================================================================\n// Project:   SproutCore Unit Testing Library\n// Copyright: \u00a92006-2009 Sprout Systems, Inc. and contributors.\n//            Portions \u00a92008-2009 Apple Inc. All rights reserved.\n// License:   Licened under MIT license (see license.js)\n// ==========================================================================\n/*globals CoreTest Plan plan module setup teardown test */\n\n\"import core utils\";\n\"export package Plan test module plan setup teardown\";\n\n/**\n  This module defines some helper methods for describing a test plan.  To \n  start building a test module, just call module() to start a test plan.  Then\n  call test() for each  test you want to perform.  This will generate test \n  functions as needed.\n  \n  The plan you are building will be found at CoreTest.plan.  When you are \n  ready, just call plan.run() to actually run the test.  To start a new test\n  plan, call plan('test name').  When you are done, just call plan.run();\n*/\n\nPlan = function(id) {\n  this.id = id;\n  return this;\n};\n\nPlan.prototype = {\n  \n  isFocused: false,\n  \n  logger: null,\n  \n  /**\n    Makes the receiver the current plan.\n    \n    @returns {Plan} receiver\n  */\n  begin: function() {    \n    if (this.isFocused) return this ;\n    this._lastPlan = CoreTest.plan;\n    CoreTest.plan = this ;\n    this.isFocused = true;\n    return this ;\n  },\n  \n  /**\n    Restores the previous focused plan.\n    \n    @returns {Plan} receiver\n  */\n  end: function() {\n    if (!this.isFocused) return this; \n    CoreTest.plan = this._lastPlan;\n    this._lastPlan = null;\n    this.isFocused = false;\n    return this ;\n  },\n  \n  /**\n    Runs the plan.  This will simply submit the plan to the standard test \n    runner.\n    \n    @returns {Plan} receiver\n  */\n  run: function() {\n    this._module = this._tests = this._setup = this._teardown = null; // reset\n\n    var logger = this.logger;\n    require('system/test').run(this, logger);\n    \n    return this ;\n  },\n  \n  /**\n    Changes the current module.  Also resets the current setup/teardown\n    \n    @param {String} name the module name\n    @returns {Plan} receiver\n  */\n  module: function(name) {\n    this._module = name;\n    name = \"test module: \" + name;\n    \n    var tests = this[name];\n    if (!tests) tests = this[name] = {};\n    this._tests = tests;\n    \n    this._setup = this._teardown = null ; // reset\n    return this ;\n  },\n  \n  /**\n    Changes the current setup method.\n    \n    @param {Function} func new setup function\n    @returns {Plan} receiver\n  */\n  setup: function(func) {\n    this._setup = func;\n    return this ;\n  },\n\n  /**\n    Changes the current teardown method.\n    \n    @param {Function} func new teardown function\n    @returns {Plan} receiver\n  */\n  teardown: function(func) {\n    this._teardown = func;\n    return this ;\n  },\n  \n  /**\n    Adds a new test to the test plan in the current module.\n    \n    @param {String} testName the test name\n    @param {Function} func the test function to run\n    @returns {Plan} receiver\n  */\n  addTest: function(testName, func) {\n    \n    // get into default module if needed.\n    if (!this._module) this.module('default'); \n\n    // generate a wrap with setup and teardown...\n    var setup = this._setup, teardown = this._teardown;\n    \n    testName = \"test \" + testName;\n    this._tests[testName] = function() {\n      if (setup) setup();\n      if (func) func();\n      if (teardown) teardown();\n    };\n  }\n  \n};\n\n/**\n  Call this method to start a new test plan.  This should appear at the top of\n  every test.  Build tools may include this automatically for you.\n  \n  @param {String} planName the name of the new plan (optional)\n  @returns {Plan} the new plan instance\n*/\nplan = function plan(planName) { \n  return new Plan(planName).begin();\n};\n\n/**\n  Call this method to finish with the current plan, restoring any previous \n  plan.\n  \n  @returns {Plan} the plan that was just ended\n*/\nplan.end = function() {\n  return CoreTest.plan.end();\n};\n\n/**\n  Ends the current plan and then runs it.\n  \n  @returns {Plan} the plan that was run.\n*/\nplan.run = function() {\n  return CoreTest.plan.end().run();\n};\n\n/**\n  Optionally specify an alternate logger for the plan.  Pass with no params\n  to get the current logger.\n  \n  @param {Object} logger alternate logger\n  @returns {Plan} the plan that was run.\n*/\nplan.logger = function(logger) {\n  if (arguments.length === 0) return CoreTest.plan.logger;\n  else CoreTest.plan.logger = logger;\n  return logger;  \n};\n\n/**\n  Begins a new module in the plan.  Optionally pass a hash with setup and \n  teardown methods for the module.  Future tests will be placed inside of \n  this module automatically.\n  \n  @param {String} moduleName the name of the module\n  @param {Hash} opts optional setup and teardown methods for module\n  @returns {void}\n*/\nmodule = function module(moduleName, opts) {\n  if (!CoreTest.plan) plan('unknown'); // begin a plan if needed\n  CoreTest.plan.module(moduleName);\n  if (opts && opts.setup) CoreTest.plan.setup(opts.setup);\n  if (opts && opts.teardown) CoreTest.plan.teardown(opts.teardown);\n};\n\n/**\n  Changes the setup method for the remaining tests in the current module. \n  You can use this instead of passing options to the module() helper.\n  \n  @param {Function} func setup function\n  @returns {void}\n*/\nsetup = function setup(func) {\n  if (!CoreTest.plan) plan('unknown'); // begin a plan if needed\n  CoreTest.plan.setup(func);\n};\n\n/**\n  Changes the teardown method for the remaining tests in the current module. \n  You can use this instead of passing options to the module() helper.\n  \n  @param {Function} func teardown function\n  @returns {void}\n*/\nteardown = function teardown(func) {\n  if (!CoreTest.plan) plan('unknown'); // begin a plan if needed\n  CoreTest.plan.teardown(func);\n};\n\n/**\n  Adds the named unit test to the current module.\n  \n  @param {String} desc description of the unit test\n  @param {Function} func actual unit test to run\n  @returns {void}\n*/\ntest = function test(desc, func) {\n  if (!CoreTest.plan) plan('unknown'); // begin a plan if needed\n  CoreTest.plan.addTest(desc, func);\n};\n;exports.Plan = Plan;\nexports.test = test;\nexports.module = module;\nexports.plan = plan;\nexports.setup = setup;\nexports.teardown = teardown;\n");
/* >>>>>>>>>> BEGIN source/system/suite.js */
tiki.module('core_test:system/suite',"var $m__ = require('core_test:core'), CoreTest=$m__.CoreTest;var $m__ = require('core_test:system/plan'), Plan=$m__.Plan,test=$m__.test,module=$m__.module,plan=$m__.plan,setup=$m__.setup,teardown=$m__.teardown;var utils = require('core_test:utils');// ==========================================================================\n// Project:   SproutCore Costello - Property Observing Library\n// Copyright: \u00a92006-2009 Sprout Systems, Inc. and contributors.\n//            Portions \u00a92008-2009 Apple Inc. All rights reserved.\n// License:   Licened under MIT license (see license.js)\n// ==========================================================================\n\n/*globals CoreTest module */\n\n\"import core system/plan\";\n\"import utils as utils\";\n\"export package\";\n\n/** @class\n\n  A test Suite defines a group of reusable unit tests that can be added to a \n  test plan at any time by calling the generate() method.  Suites are most\n  useful for defining groups of tests that validate compliance with a mixin.\n  You can then generate customized versions of the test suite for different\n  types of objects to ensure that both the mixin and the object implementing\n  the mixin use the API properly.\n  \n  h1. Using a Suite\n  \n  To use a Suite, call the generate() method on the suite inside on of your\n  unit test files.  This will generate new modules and tests in the suite\n  and add them to your test plan.\n  \n  Usually you will need to customize the suite to apply to a specific object.\n  You can supply these customizations through an attribute hash passed to the\n  generate() method.  See the documentation on the specific test suite for\n  information on the kind of customizations you may need to provide.\n  \n  h2. Example\n  \n  {{{\n    // generates the SC.ArrayTestSuite tests for a built-in array.\n    SC.ArrayTests.generate('Array', {\n      newObject: function() { return []; }\n    });\n  }}}\n  \n  h1. Defining a Suite\n  \n  To define a test suite, simply call the extend() method, passing any \n  attributs you want to define on the stuie along with this method.  You can\n  then add functions that will define the test suite with the define() method.\n  \n  Functions you pass to define will have an instance of the test suite passed\n  as their first parameter when invoked.\n\n  h2. Example \n  \n  {{{\n    SC.ArrayTests = CoreTest.Suite.create(\"Verify SC.Array compliance\", {\n      \n      // override to generate a new object that implements SC.Array\n      newObject: function() { return null; }\n    });\n    \n    SC.ArrayTests.define(function(T) {\n      T.module(\"length tests\");\n      \n      test(\"new length\", function() {\n        equals(T.object.get('length'), 0, 'array length');\n      });\n      \n    });\n  }}}\n  \n  @since SproutCore 1.0\n  \n*/\nCoreTest.Suite = /** @scope CoreTest.Suite.prototype */ {\n\n  /**\n    Call this method to define a new test suite.  Pass one or more hashes of\n    properties you want added to the new suite.  \n    \n    @param {Hash} attrs one or more attribute hashes\n    @returns {CoreTest.Suite} subclass of suite.\n  */\n  create: function(desc, attrs) {\n    var len = arguments.length,\n        ret = utils.beget(this),\n        idx;\n        \n    // copy any attributes\n    for(idx=1;idx<len;idx++) utils.mixin(ret, arguments[idx]);\n    \n    if (desc) ret.basedesc = desc;\n    \n    // clone so that new definitions will be kept separate\n    ret.definitions = ret.definitions.slice();\n    \n    return ret ;\n  },\n\n  /**\n    Generate a new test suite instance, adding the suite definitions to the \n    current test plan.  Pass a description of the test suite as well as one or\n    more attribute hashes to apply to the test plan.\n    \n    The description you add will be prefixed in front of the 'desc' property\n    on the test plan itself.\n    \n    @param {String} desc suite description\n    @param {Hash} attrs one or more attribute hashes\n    @returns {CoreTest.Suite} suite instance\n  */\n  generate: function(desc, attrs) {\n    var len = arguments.length,\n        ret = utils.beget(this),\n        idx, defs;\n        \n    // apply attributes - skip first argument b/c it is a string\n    for(idx=1;idx<len;idx++) utils.mixin(ret, arguments[idx]);    \n    ret.subdesc = desc ;\n    \n    // invoke definitions\n    defs = ret.definitions ;\n    len = defs.length;\n    for(idx=0;idx<len;idx++) defs[idx].call(ret, ret);\n    \n    return ret ;\n  },\n  \n  /**\n    Adds the passed function to the array of definitions that will be invoked\n    when the suite is generated.\n    \n    The passed function should expect to have the TestSuite instance passed\n    as the first and only parameter.  The function should actually define \n    a module and tests, which will be added to the test suite.\n    \n    @param {Function} func definition function\n    @returns {CoreTest.Suite} receiver\n  */\n  define: function(func) {\n    this.definitions.push(func);\n    return this ;\n  },\n  \n  /** \n    Definition functions.  These are invoked in order when  you generate a \n    suite to add unit tests and modules to the test plan.\n  */\n  definitions: [],\n  \n  /**\n    Generates a module description by merging the based description, sub \n    description and the passed description.  This is usually used inside of \n    a suite definition function.\n    \n    @param {String} str detailed description for this module\n    @returns {String} generated description\n  */\n  desc: function(str) {\n    return this.basedesc.fmt(this.subdesc, str);\n  },\n  \n  /**\n    The base description string.  This should accept two formatting options,\n    a sub description and a detailed description.  This is the description\n    set when you call extend()\n  */\n  basedesc: \"%@ > %@\",\n  \n  /**\n    Default setup method for use with modules.  This method will call the\n    newObject() method and set its return value on the object property of \n    the receiver.\n  */\n  setup: function() {\n    this.object = this.newObject();\n  },\n  \n  /**\n    Default teardown method for use with modules.  This method will call the\n    destroyObejct() method, passing the current object property on the \n    receiver.  It will also clear the object property.\n  */\n  teardown: function() {\n    if (this.object) this.destroyObject(this.object);\n    this.object = null;\n  },\n  \n  /**\n    Default method to create a new object instance.  You will probably want\n    to override this method when you generate() a suite with a function that\n    can generate the type of object you want to test.\n    \n    @returns {Object} generated object\n  */\n  newObject: function() { return null; },\n  \n  /**\n    Default method to destroy a generated object instance after a test has \n    completed.  If you override newObject() you can also overried this method\n    to cleanup the object you just created.\n    \n    Default method does nothing.\n  */\n  destroyObject: function(obj) { \n    // do nothing.\n  },\n  \n  /**\n    Generates a default module with the description you provide.  This is \n    a convenience function for use inside of a definition function.  You could\n    do the same thing by calling:\n    \n    {{{\n      var T = this ;\n      module(T.desc(description), {\n        setup: function() { T.setup(); },\n        teardown: function() { T.teardown(); }\n      }\n    }}}\n    \n    @param {String} desc detailed descrition\n    @returns {CoreTest.Suite} receiver\n  */\n  module: function(desc) {\n    var T = this ;\n    module(T.desc(desc), {\n      setup: function() { T.setup(); },\n      teardown: function() { T.teardown(); }\n    });\n  }\n  \n};\n;");
/* >>>>>>>>>> BEGIN source/system/test.js */
tiki.module('core_test:system/test',"var $m__ = require('tiki:index'), setupDisplayNames=$m__.setupDisplayNames,Loader=$m__.Loader,Promise=$m__.Promise,Sandbox=$m__.Sandbox;var $m__ = require('tiki/system:index'), ready=$m__.ready,unload=$m__.unload,global=$m__.global,Invocation=$m__.Invocation,Logger=$m__.Logger,console=$m__.console,PLATFORM=$m__.PLATFORM,PLATFORM_PACKAGE=$m__.PLATFORM_PACKAGE,info=$m__.info,env=$m__.env,reactor=$m__.reactor,Retainable=$m__.Retainable;var $m__ = require('tiki/system:core'), T_ERROR=$m__.T_ERROR,T_OBJECT=$m__.T_OBJECT,T_NULL=$m__.T_NULL,T_CLASS=$m__.T_CLASS,T_HASH=$m__.T_HASH,T_FUNCTION=$m__.T_FUNCTION,T_UNDEFINED=$m__.T_UNDEFINED,T_NUMBER=$m__.T_NUMBER,T_BOOL=$m__.T_BOOL,T_ARRAY=$m__.T_ARRAY,T_STRING=$m__.T_STRING,T_BOOLEAN=$m__.T_BOOLEAN,YES=$m__.YES,NO=$m__.NO,isArray=$m__.isArray,typeOf=$m__.typeOf,A=$m__.A,generateGuid=$m__.generateGuid,guidFor=$m__.guidFor,mixin=$m__.mixin,setupDisplayNames=$m__.setupDisplayNames;var $m__ = require('core_test:core'), CoreTest=$m__.CoreTest;var run,start,stop,asyncTester;// ==========================================================================\n// Project:   SproutCore Unit Testing Library\n// Copyright: \u00a92006-2009 Sprout Systems, Inc. and contributors.\n//            Portions \u00a92008-2009 Apple Inc. All rights reserved.\n// License:   Licened under MIT license (see license.js)\n// ==========================================================================\n/*globals run typeOf T_FUNCTION T_OBJECT T_HASH A PLATFORM_PACKAGE */\n\n\"import package tiki\";\n\"import package tiki/system\";\n\"import tiki/system:core core\";\n\"export run\";\n\"export package start stop asyncTester\";\n\nvar timer = require(PLATFORM_PACKAGE).timer;\n\nfunction _beginGroup(logger, moduleName) {\n  if (moduleName && logger) {\n    if (logger.moduleDidBegin) logger.moduleDidBegin(moduleName);\n    else if (logger.group) logger.group(moduleName);\n  }\n  \n  return true;\n}\n\nvar _finishTest = null;\nvar _asyncTester = null;\n\n/**\n  Wraps a callback used in asynchronous calls to properly handle test \n  behavior. Notably, if the callback function throws an exception,\n  this wrapper will catch the exception, log it and restart the\n  test running process (which would previously have been stopped\n  via a call to stop()).\n  \n  @param {Function} callback  the callback function to wrap\n*/\nfunction asyncTester(callback) {\n    return function() {\n        var args = Array.prototype.slice.call(arguments);\n        args.splice(0, 0, callback);\n        console.log(\"args: \", args);\n        return _asyncTester.apply(this, args);\n    };\n}\n\nfunction _runTest(tests, testName, testFunc, logger) {\n  var inGroup = testName && logger;\n    \n  if (inGroup) {\n    if (logger.testDidBegin) logger.testDidBegin(testName);\n    else if (logger.group) logger.group(testName);\n  }\n\n  // save the core test logger...\n  var oldLogger = CoreTest.logger;\n  CoreTest.logger = logger;\n  \n  try {\n    testFunc.call(tests, testName);\n  } catch(e) {\n    CoreTest.logger = oldLogger;\n    if (logger) logger.error(e);\n  }\n  \n  _finishTest = function(errmsg) {\n      if (errmsg && logger) {\n          logger.error(errmsg);\n      }\n\n      if (inGroup) {\n        if (logger.testDidEnd) logger.testDidEnd(testName);\n        else if (logger.groupEnd) logger.groupEnd(testName);\n      }\n      CoreTest.logger = oldLogger;\n      _finishTest = null;\n  };\n  \n  _asyncTester = function(callback) {\n      try {\n          callback.apply(this, Array.prototype.slice.call(arguments, 1));\n      } catch(e) {\n          if (logger) logger.error(e);\n          if (blocking) start();\n      }\n  };\n  \n  if (!blocking) _finishTest();\n}\n\nfunction _endGroup(logger, moduleName) {\n  if (logger.moduleDidEnd) logger.moduleDidEnd(moduleName);\n  else if (logger.groupEnd) logger.groupEnd(moduleName);\n}\n\nfunction _beginPlan(logger, plan) {\n  if (logger.planDidBegin) logger.planDidBegin(plan);\n  else logger.info(\"Beginning plan: %@\".fmt(plan ? plan.id : '(unknown)'));\n}\n\nfunction _endPlan(logger, plan) {\n  if (logger.planDidBegin) logger.planDidEnd(plan);\n  else logger.info(\"Ending plan: %@\".fmt(plan ? plan.id : '(unknown)'));\n}\n\nvar queue = [];\nvar blocking = false;\nvar currentTimer = null;\n\nfunction _queue(func, arg1, arg2) {\n  queue.push({ \n    func: func, \n    args: A(arguments).slice(1) \n  }); \n}\n\nvar scheduled = false;\n\nfunction _flush() {\n  scheduled = false;\n  var start = new Date().getTime(),\n      opts;\n  while(!blocking && ((new Date().getTime() - start) < 100) && (opts = queue.shift())) {\n    if (opts) opts.func.apply(this, opts.args);\n  }\n  if (!blocking && queue.length>0) _schedule();\n}\n\nfunction _schedule() {\n  if (!scheduled) {\n    scheduled = true;\n    timer.schedule(0, _flush);\n  }\n}\n\n/**\n  Restarts the test running after pausing for asynchronous events\n  (see stop()).\n  \n  @returns {void}\n*/\nfunction start() {\n    _start();\n}\n\nfunction _start(errorForPreviousTest) {\n    // A slight delay, to avoid any current callbacks\n    timer.schedule(13, function() {\n        if (currentTimer) {\n            timer.cancel(currentTimer);\n        }\n        \n        if (_finishTest) _finishTest(errorForPreviousTest);\n \n        blocking = false;\n        _schedule();\n    });\n}\n\n/**\n  Stops running the queue of tests while waiting for asynchronous\n  events to finish. start() should be called once the asynchronous\n  behavior is done. A test failure will be logged if start is not\n  called before the timeout is reached.\n  \n  @param {Number} timeout milliseconds in which this test should complete\n  @returns {void}\n*/\nfunction stop(timeout) {\n    blocking = true;\n    \n    currentTimer = timer.schedule(timeout, function() {\n        _start(\"Test timed out\");\n    });\n}\n\n\n/**\n  Runs any tests defined in the passed array of unit tests.  Optionally pass\n  a logger as a second argument which will be used to output the test.\n  \n  @param {Hash} tests tests to run. looks for any item beginning with 'test'\n  @param {Logger} logger optional logger to use for output\n  @param {String} moduleName optional moduleName to use when grouping tests\n  @returns {void}\n*/\nrun = function run(tests, logger, moduleName) {\n  var prevLogger, key, value, inGroup = false;\n  \n  prevLogger = CoreTest.logger;\n  \n  if (!logger) {\n    if (require('system').PLATFORM === 'classic') {\n      logger = require('browser/logger').logger;\n    } else logger = require('system').console;\n  }\n\n  CoreTest.logger = logger;\n  \n  _queue(_beginPlan, logger, tests);\n  \n  for(key in tests) {\n    if (!tests.hasOwnProperty(key)) continue;\n    if (key.indexOf('test') !== 0) continue ;\n\n    value = tests[key];\n    switch(typeOf(value)) {\n      case T_FUNCTION:\n        if (!inGroup) {\n          inGroup = true;\n          _queue(_beginGroup, logger, moduleName);\n        }\n        \n        _queue(_runTest, tests, key, value, logger);\n        break;\n        \n      case T_HASH:\n      case T_OBJECT:\n        if (!inGroup) {\n          inGroup = true; \n          _queue(_beginGroup, logger, moduleName);\n        }\n        \n        run(value, logger, key.slice(4));\n        break;\n    }\n  }\n  \n  if (inGroup) _queue(_endGroup, logger, moduleName);\n  _queue(_endPlan, logger, tests);\n  \n  _schedule();  \n  CoreTest.logger = prevLogger;\n};\n\nCoreTest.run = run; // preferred way to access this\nCoreTest.stop = stop;\nCoreTest.start = start;\n;exports.run = run;\nexports.start = start;\nexports.stop = stop;\nexports.asyncTester = asyncTester;\n");
/* >>>>>>>>>> BEGIN package_exports.js */
tiki.module('core_test:index', function(require, exports, module) {
var m;
m = require('core_test:browser/logger');
exports.BrowserLogger = m.BrowserLogger;
m = require('core_test:core');
exports.CoreTest = m.CoreTest;
m = require('core_test:system/assert');
exports.AssertionError = m.AssertionError;
exports.ok = m.ok;
exports.equal = m.equal;
exports.equals = m.equals;
exports.notEqual = m.notEqual;
exports.deepEqual = m.deepEqual;
exports.same = m.same;
exports.deepNotEqual = m.deepNotEqual;
exports.shouldThrow = m.shouldThrow;
require('core_test:system/dump');
require('core_test:system/equiv');
require('core_test:system/ext');
m = require('core_test:system/plan');
exports.Plan = m.Plan;
exports.test = m.test;
exports.module = m.module;
exports.plan = m.plan;
exports.setup = m.setup;
exports.teardown = m.teardown;
require('core_test:system/suite');
m = require('core_test:system/test');
exports.start = m.start;
exports.stop = m.stop;
exports.asyncTester = m.asyncTester;
});

; tiki.script('core_test:en/7a2aea76f269c0cc7f8d3ce26c88cdae21c54665/javascript.js');