# Developer Guide #

With the exception of features in the Experimental section, the APIs and
features documented in the Developer Guide are relatively stable.  We intend
to add new APIs here and extend existing ones, but will avoid making
incompatible changes to them unless absolutely necessary.

### [Tutorials](dev-guide/addon-development/tutorials.html) ###
Practical explanations of how to develop add-ons with the SDK. If you're not
sure where to start, have a look at the [Getting
 Started](dev-guide/addon-development/getting-started.html) tutorial.

### [Programming Guides](dev-guide/addon-development/guides.html) ###
Standalone articles that provide more in-depth explanation of particular
aspects of programming with the SDK.

### [Reference](dev-guide/addon-development/reference.html) ###
Detailed documentation for the high-level APIs and tools in the SDK. In
particular, this section includes API reference documentation for the
high-level modules supplied in the
[addon-kit](packages/addon-kit/addon-kit.html) package.

### [Experimental](dev-guide/addon-development/experimental.html) ###
Documentation of features which are potentially useful to add-on developers,
but are not yet stabilized, and which we expect to change in incompatible
ways in the future.
