<!-- This Source Code Form is subject to the terms of the Mozilla Public
   - License, v. 2.0. If a copy of the MPL was not distributed with this
   - file, You can obtain one at http://mozilla.org/MPL/2.0/. -->

The `l10n` module enables add-ons to localize strings appearing in the
add-on's JavaScript code.

To learn how to use this module to write localizable code, read the
[Localization tutorial](dev-guide/tutorials/l10n.html).

Note that you can't currently use localize strings appearing in content
scripts or HTML files.

<api name="get">
@function
  This function takes a string parameter which it uses as an identifier
  to look up and return a localized string in the locale currently set for
  Firefox. Localized strings are supplied by the add-on developer in
  [`.properties`](http://en.wikipedia.org/wiki/.properties) files
  stored in the add-ons "locale" directory.

  The [gettext](https://www.gnu.org/software/gettext/gettext.html) tools
  uses "_" for the name of the function that retrieves localized strings.
  For compatibility with tools that expect this syntax, you can assign
  this function to "_":

    var _ = require("l10n").get;

  Given a `.properties` file for the current locale containing
  an entry like:

<pre>
hello_string= Hello!
</pre>

  and the following code:

    var _ = require("l10n").get;
    console.log(_("hello_string"));

  the following output will be logged:

<pre>
info: Hello!
</pre>

  If this function can't find the string referenced by the identifier
  parameter, it returns the identifier itself. This enables you to write
  functional, localizable code without localizing any strings - just make
  the identifiers the default language:

    var _ = require("l10n").get;
    console.log(_("Hello!"));

  However, this will make it more difficult to maintain your code if you
  have many localizations, because any changes to the identifier values
  break all your `.properties` files.

  If you're supplying different localizations for a string depending on
  the number of items (that is, whether to use a singular or plural form)
  then `get()` takes a second integer parameter which indicates the
  number of items there are.

  You can supply one or more placeholders to `get()`, which are strings,
  such as proper names, that should not be translated themselves but instead
  should be inserted into the translated string.

  You can't use plurals and placeholders in the same expression: if you do,
  the placeholders will be ignored.

@returns {string}
  The localized string referenced by the identifier parameter passed in, or
  the identifier itself if no referent for the identifier can be found.
@param identifier {string}
  A identifier for the localization of a particular string in the current
  locale.
@param [count] {integer}
  Optional parameter.
  If you're supplying different localizations for a string for singular or
  plural forms, this parameter is the number of items there are in this
  case.

      var _ = require("l10n").get;
      console.log(_("child_id", 1));
      console.log(_("child_id", 2));

  See the tutorial on [plural support](dev-guide/tutorials/l10n.html#Plurals)
  for more information.

  Note that if you use this parameter, you can't supply any placeholders.
@param [placeholder1...n] {string}
  Optional parameters.
  If you do not include the count parameter, you can supply one or
  more placeholder strings that are to be inserted into the translated
  string at locations defined by the translator.

  If you supply multiple placeholders, each one is a separate string
  parameter.

      var _ = require("l10n").get;
      console.log(_("home_town", "Alan", "Norwich"));

  See the tutorial on
  [placeholder support](dev-guide/tutorials/l10n.html#Placeholders) for more
  information.

</api>
