/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttrStrEnumeration;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERSet;

public class LDAPAttribute {
    private String name;
    private Vector values;

    public LDAPAttribute(LDAPAttribute attr) {
        this.name = attr.name;
        this.values = (Vector)attr.values.clone();
    }

    public LDAPAttribute(String attrName) {
        this.name = attrName;
        this.values = new Vector();
    }

    public LDAPAttribute(String attrName, byte[] attrValue) {
        this.name = attrName;
        this.values = new Vector();
        this.addValue(attrValue);
    }

    public LDAPAttribute(String attrName, String attrValue) {
        this.name = attrName;
        this.values = new Vector();
        this.addValue(attrValue);
    }

    public LDAPAttribute(String attrName, String[] attrValues) {
        this.name = attrName;
        this.values = new Vector();
        if (attrValues != null) {
            int i = 0;
            while (i < attrValues.length) {
                this.addValue(attrValues[i]);
                ++i;
            }
            return;
        }
        String b = null;
        this.addValue(b);
    }

    public LDAPAttribute(BERElement element) throws IOException {
        this.values = new Vector();
        BERSequence seq = (BERSequence)element;
        BEROctetString type = (BEROctetString)seq.elementAt(0);
        byte[] buf = type.getValue();
        if (buf == null) {
            this.name = null;
        } else {
            try {
                this.name = new String(buf, "UTF8");
            }
            catch (Throwable throwable) {}
        }
        BERSet set = (BERSet)seq.elementAt(1);
        if (set.size() > 0) {
            int i = 0;
            while (i < set.size()) {
                BEROctetString val = (BEROctetString)set.elementAt(i);
                this.addValue(val.getValue());
                ++i;
            }
        }
    }

    public int size() {
        return this.values.size();
    }

    public Enumeration getStringValues() {
        return LDAPAttrStrEnumeration.getStringEnumeration(this.values);
    }

    public Enumeration getByteValues() {
        return this.values.elements();
    }

    public String getName() {
        return this.name;
    }

    public static String[] getSubtypes(String attrName) {
        StringTokenizer st = new StringTokenizer(attrName, ";");
        if (st.hasMoreElements()) {
            st.nextElement();
            String[] subtypes = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreElements()) {
                subtypes[i++] = (String)st.nextElement();
            }
            return subtypes;
        }
        return null;
    }

    public String[] getSubtypes() {
        return LDAPAttribute.getSubtypes(this.name);
    }

    public String getLangSubtype() {
        String[] subTypes = this.getSubtypes();
        if (subTypes != null) {
            int i = 0;
            while (i < subTypes.length) {
                if (subTypes[i].length() >= 5 && subTypes[i].substring(0, 5).equalsIgnoreCase("lang-")) {
                    return subTypes[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static String getBaseName(String attrName) {
        String basename = attrName;
        StringTokenizer st = new StringTokenizer(attrName, ";");
        if (st.hasMoreElements()) {
            basename = (String)st.nextElement();
        }
        return basename;
    }

    public String getBaseName() {
        return LDAPAttribute.getBaseName(this.name);
    }

    public boolean hasSubtype(String subtype) {
        String[] mytypes = this.getSubtypes();
        int i = 0;
        while (i < mytypes.length) {
            if (subtype.equalsIgnoreCase(mytypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasSubtypes(String[] subtypes) {
        int i = 0;
        while (i < subtypes.length) {
            if (!this.hasSubtype(subtypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized void addValue(String attrValue) {
        if (attrValue == null) {
            this.values.addElement(attrValue);
            return;
        }
        try {
            byte[] b = attrValue.getBytes("UTF8");
            this.addValue(b);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public synchronized void addValue(byte[] attrValue) {
        this.values.addElement(attrValue);
    }

    public synchronized void removeValue(String attrValue) {
        if (attrValue == null) {
            this.values.addElement(attrValue);
            return;
        }
        try {
            byte[] b = attrValue.getBytes("UTF8");
            this.removeValue(b);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public synchronized void removeValue(byte[] attrValue) {
        int i = 0;
        while (i < this.values.size()) {
            byte[] obj = (byte[])this.values.elementAt(i);
            if (this.equalValue(attrValue, obj)) {
                this.values.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    private boolean equalValue(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public BERElement getBERElement() {
        try {
            BERSequence seq = new BERSequence();
            seq.addElement(new BEROctetString(this.name));
            BERSet set = new BERSet();
            int i = 0;
            while (i < this.values.size()) {
                set.addElement(new BEROctetString((byte[])this.values.elementAt(i)));
                ++i;
            }
            seq.addElement(set);
            return seq;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String getParamString() {
        String s = "";
        if (this.values.size() > 0) {
            int i = 0;
            while (i < this.values.size()) {
                if (i != 0) {
                    s = String.valueOf(s) + ",";
                }
                byte[] val = (byte[])this.values.elementAt(i);
                try {
                    s = String.valueOf(s) + LDAPAttrStrEnumeration.convertToUTF8(val);
                }
                catch (Exception exception) {
                    s = val != null ? String.valueOf(s) + val.length + " bytes" : String.valueOf(s) + "0 bytes";
                }
                ++i;
            }
        }
        return "{type='" + this.name + "', values='" + s + "'}";
    }

    public String toString() {
        return "LDAPAttribute " + this.getParamString();
    }
}

