/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;

public class LDAPAttributeSet {
    private int current;
    private Vector attrs;
    Hashtable attrHash;

    public LDAPAttributeSet() {
        this.attrs = new Vector();
        this.attrHash = new Hashtable();
        this.current = 0;
    }

    LDAPAttributeSet(LDAPAttribute[] attrs) {
        this.attrs = new Vector();
        this.attrHash = new Hashtable();
        this.current = 0;
        int j = 0;
        while (j < attrs.length) {
            this.attrs.addElement(attrs[j]);
            this.attrHash.put(attrs[j].getName().toLowerCase(), attrs[j]);
            ++j;
        }
    }

    protected LDAPAttributeSet(LDAPAttributeSet set) {
        LDAPAttributeSet lDAPAttributeSet = this;
        synchronized (lDAPAttributeSet) {
            this.attrs = (Vector)set.attrs.clone();
        }
        this.attrHash = new Hashtable();
        int i = 0;
        while (i < this.attrs.size()) {
            LDAPAttribute attr = (LDAPAttribute)this.attrs.elementAt(i);
            this.attrHash.put(attr.getName().toLowerCase(), attr);
            ++i;
        }
        this.current = 0;
    }

    public Enumeration getAttributes() {
        return this.attrs.elements();
    }

    public LDAPAttributeSet getSubset(String subtype) {
        LDAPAttributeSet attrs = new LDAPAttributeSet();
        if (subtype == null) {
            return attrs;
        }
        StringTokenizer st = new StringTokenizer(subtype, ";");
        if (st.countTokens() < 1) {
            return attrs;
        }
        String[] searchTypes = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            searchTypes[i] = (String)st.nextElement();
            ++i;
        }
        Enumeration attrEnum = this.getAttributes();
        while (attrEnum.hasMoreElements()) {
            LDAPAttribute attr = (LDAPAttribute)attrEnum.nextElement();
            if (!attr.hasSubtypes(searchTypes)) continue;
            attrs.add(new LDAPAttribute(attr));
        }
        return attrs;
    }

    public LDAPAttribute getAttribute(String attrName) {
        return (LDAPAttribute)this.attrHash.get(attrName.toLowerCase());
    }

    public LDAPAttribute getAttribute(String attrName, String lang) {
        if (lang == null || lang.length() < 1) {
            return this.getAttribute(attrName);
        }
        String langLower = lang.toLowerCase();
        if (langLower.length() < 5 || !langLower.substring(0, 5).equals("lang-")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(langLower, "-");
        st.nextToken();
        String[] langComponents = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            langComponents[i] = st.nextToken();
            ++i;
        }
        String searchBasename = LDAPAttribute.getBaseName(attrName);
        String[] searchTypes = LDAPAttribute.getSubtypes(attrName);
        LDAPAttribute found = null;
        int matchCount = 0;
        i = 0;
        while (i < this.attrs.size()) {
            boolean isCandidate = false;
            LDAPAttribute attr = (LDAPAttribute)this.attrs.elementAt(i);
            if (attr.getBaseName().equalsIgnoreCase(searchBasename)) {
                if (searchTypes == null || searchTypes.length < 1) {
                    isCandidate = true;
                } else if (attr.hasSubtypes(searchTypes)) {
                    isCandidate = true;
                }
            }
            String attrLang = null;
            if (isCandidate) {
                attrLang = attr.getLangSubtype();
                if (attrLang == null) {
                    found = attr;
                } else {
                    st = new StringTokenizer(attrLang.toLowerCase(), "-");
                    st.nextToken();
                    if (st.countTokens() <= langComponents.length) {
                        int j = 0;
                        while (st.hasMoreTokens()) {
                            if (!langComponents[j].equals(st.nextToken())) {
                                j = 0;
                                break;
                            }
                            ++j;
                        }
                        if (j > matchCount) {
                            found = attr;
                            matchCount = j;
                        }
                    }
                }
            }
            ++i;
        }
        return found;
    }

    public LDAPAttribute elementAt(int index) {
        return (LDAPAttribute)this.attrs.elementAt(index);
    }

    public void removeElementAt(int index) {
        this.attrs.removeElementAt(index);
    }

    public int size() {
        return this.attrs.size();
    }

    public synchronized void add(LDAPAttribute attr) {
        this.attrs.addElement(attr);
        this.attrHash.put(attr.getName().toLowerCase(), attr);
    }

    public synchronized void remove(String name) {
        int i = 0;
        while (i < this.attrs.size()) {
            LDAPAttribute attr = (LDAPAttribute)this.attrs.elementAt(i);
            if (name.equalsIgnoreCase(attr.getName())) {
                this.attrs.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    public String toString() {
        String s = "LDAPAttributeSet: ";
        if (this.attrs.size() > 0) {
            int i = 0;
            while (i < this.attrs.size()) {
                s = String.valueOf(s) + this.attrs.elementAt(i).toString();
                ++i;
            }
        }
        return s;
    }
}

