/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.util.RDN;

public final class DN {
    Vector m_rdns = new Vector();
    boolean m_rfc = true;
    public static final char[] ESCAPED_CHAR = new char[]{',', '+', '\"', '\\', '<', '>', ';'};

    public DN() {
    }

    public DN(String dn) {
        if (dn == null) {
            return;
        }
        if (this.isRFC(dn)) {
            StringBuffer buffer = new StringBuffer(dn);
            int i = 0;
            StringBuffer rbuffer = new StringBuffer();
            while (i < buffer.length()) {
                rbuffer.append(buffer.charAt(i));
                if (buffer.charAt(i) == '\\') {
                    char c = buffer.charAt(i + 1);
                    int j = 0;
                    while (j < ESCAPED_CHAR.length) {
                        if (c == ESCAPED_CHAR[j]) {
                            rbuffer.append(buffer.charAt(++i));
                            break;
                        }
                        ++j;
                    }
                } else if (buffer.charAt(i) == ',') {
                    rbuffer.setLength(rbuffer.length() - 1);
                    if (!this.appendRDN(rbuffer)) {
                        return;
                    }
                    rbuffer = new StringBuffer();
                }
                ++i;
            }
            if (!this.appendRDN(rbuffer)) {
                return;
            }
        } else {
            if (dn.indexOf(47) != -1) {
                this.m_rfc = false;
                StringTokenizer st = new StringTokenizer(dn, "/");
                Vector<RDN> rdns = new Vector<RDN>();
                while (st.hasMoreTokens()) {
                    String rdn = st.nextToken();
                    if (RDN.isRDN(rdn)) {
                        rdns.addElement(new RDN(rdn));
                        continue;
                    }
                    return;
                }
                int i = rdns.size() - 1;
                while (i >= 0) {
                    this.m_rdns.addElement(rdns.elementAt(i));
                    --i;
                }
                return;
            }
            if (RDN.isRDN(dn)) {
                this.m_rdns.addElement(new RDN(dn));
            }
        }
    }

    public void addRDNToFront(RDN rdn) {
        this.m_rdns.insertElementAt(rdn, 0);
    }

    public void addRDNToBack(RDN rdn) {
        this.m_rdns.addElement(rdn);
    }

    public void addRDN(RDN rdn) {
        if (this.m_rfc) {
            this.addRDNToFront(rdn);
            return;
        }
        this.addRDNToBack(rdn);
    }

    public int countRDNs() {
        return this.m_rdns.size();
    }

    public Vector getRDNs() {
        return this.m_rdns;
    }

    public String[] explodeDN(boolean noTypes) {
        if (this.m_rdns.size() == 0) {
            return null;
        }
        String[] str = new String[this.m_rdns.size()];
        int i = 0;
        while (i < this.m_rdns.size()) {
            str[i] = noTypes ? ((RDN)this.m_rdns.elementAt(i)).getValue() : ((RDN)this.m_rdns.elementAt(i)).toString();
            ++i;
        }
        return str;
    }

    public boolean isRFC() {
        return this.m_rfc;
    }

    public String toRFCString() {
        String dn = "";
        int i = 0;
        while (i < this.m_rdns.size()) {
            if (i != 0) {
                dn = String.valueOf(dn) + ",";
            }
            dn = String.valueOf(dn) + ((RDN)this.m_rdns.elementAt(i)).toString();
            ++i;
        }
        return dn;
    }

    public String toOSFString() {
        String dn = "";
        int i = 0;
        while (i < this.m_rdns.size()) {
            if (i != 0) {
                dn = "/" + dn;
            }
            RDN rdn = (RDN)this.m_rdns.elementAt(i);
            dn = String.valueOf(rdn.toString()) + dn;
            ++i;
        }
        return dn;
    }

    public String toString() {
        if (this.m_rfc) {
            return this.toRFCString();
        }
        return this.toOSFString();
    }

    public static boolean isDN(String dn) {
        DN newdn = new DN(dn);
        return newdn.countRDNs() > 0;
    }

    public boolean equals(DN dn) {
        return dn.toRFCString().toUpperCase().equals(this.toRFCString().toUpperCase());
    }

    public DN getParent() {
        DN newdn = new DN();
        int i = this.m_rdns.size() - 1;
        while (i > 0) {
            newdn.addRDN((RDN)this.m_rdns.elementAt(i));
            --i;
        }
        return newdn;
    }

    public boolean contains(DN dn) {
        Vector rdns1 = dn.m_rdns;
        Vector rdns2 = this.m_rdns;
        int i = rdns1.size() - 1;
        int j = rdns2.size() - 1;
        while (i >= 0 && j >= 0) {
            RDN rdn1 = (RDN)rdns1.elementAt(i);
            RDN rdn2 = (RDN)rdns2.elementAt(j);
            if (!rdn2.equals(rdn1)) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    private boolean isRFC(String dn) {
        int index = dn.indexOf(44);
        while (index > 0 && index < dn.length() - 1) {
            if (dn.charAt(index - 1) != '\\') {
                return true;
            }
            index = dn.indexOf(44, index + 1);
        }
        return false;
    }

    private boolean appendRDN(StringBuffer buffer) {
        String rdn = new String(buffer);
        if (RDN.isRDN(rdn)) {
            this.m_rdns.addElement(new RDN(rdn));
            return true;
        }
        this.m_rdns.removeAllElements();
        return false;
    }
}

