/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer;

import java.awt.image.MemoryImageSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import netscape.plugin.composer.Document;
import netscape.plugin.composer.ImageEncoder;
import netscape.plugin.composer.Plugin;

class ImageEncoderPlugin
extends Plugin {
    private ImageEncoder encoder;
    private int width;
    private int height;
    private byte[][] pixels;
    private String fileName;

    public ImageEncoderPlugin(ImageEncoder encoder, int width, int height, byte[][] pixels, String fileName) {
        this.encoder = encoder;
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.fileName = fileName;
    }

    public boolean perform(Document document) throws IOException {
        int length = this.width * this.height;
        int[] pixels2 = new int[length];
        int i = 0;
        int y = 0;
        while (y < this.height) {
            int j = 0;
            byte[] line = this.pixels[y];
            int x = 0;
            while (x < this.width) {
                pixels2[i++] = 0xFF000000 | (0xFF & line[j]) << 16 | (0xFF & line[j + 1]) << 8 | 0xFF & line[j + 2];
                j += 3;
                ++x;
            }
            ++y;
        }
        MemoryImageSource source = new MemoryImageSource(this.width, this.height, pixels2, 0, this.width);
        ByteArrayOutputStream temp = new ByteArrayOutputStream(this.width * this.height / 2);
        boolean result = this.encoder.encode(source, temp);
        if (result) {
            SecurityManager.enablePrivilege((String)"SuperUser");
            FileOutputStream output = new FileOutputStream(new File(this.fileName));
            ((OutputStream)output).write(temp.toByteArray());
            ((OutputStream)output).close();
        }
        return result;
    }
}

