/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer.io;

import java.util.Enumeration;
import java.util.Hashtable;
import netscape.plugin.composer.io.FooStringBuffer;
import netscape.plugin.composer.io.Token;

public class Tag
extends Token {
    private String name;
    private boolean open;
    private Hashtable attributes;
    private static String emptyString = "";

    public Tag(String name) {
        this(name, true);
    }

    public Tag(String name, boolean open) {
        this.name = name.toUpperCase();
        this.open = open;
    }

    public Object clone() {
        Tag result = null;
        try {
            result = (Tag)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        if (result.attributes != null) {
            result.attributes = (Hashtable)result.attributes.clone();
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClose() {
        return !this.open;
    }

    public void clearAttributes() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    public String addAttribute(String name, String value) {
        name = name.toUpperCase();
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        if (value == null || value.length() == 0) {
            value = emptyString;
        }
        return this.attributes.put(name, value);
    }

    public String removeAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.remove(name);
    }

    public String lookupAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(name);
    }

    public boolean containsAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.get(name) != null;
    }

    public Enumeration getAttributes() {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        return this.attributes.keys();
    }

    public boolean hasAttributes() {
        if (this.attributes == null) {
            return false;
        }
        return !this.attributes.isEmpty();
    }

    public String toString() {
        FooStringBuffer sbuf = new FooStringBuffer();
        sbuf.append('<');
        if (!this.open) {
            sbuf.append('/');
        }
        sbuf.append(this.name.toString());
        if (this.attributes != null) {
            Enumeration e = this.attributes.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                sbuf.append(' ');
                sbuf.append(name.toString());
                String value = (String)this.attributes.get(name);
                if (value == emptyString) continue;
                sbuf.append('=');
                sbuf.append(Tag.QuoteValue(value));
            }
        }
        sbuf.append('>');
        return sbuf.toString();
    }

    public int hashCode() {
        int code = this.name.hashCode() + (this.open ? 1 : 0);
        if (this.attributes != null) {
            Enumeration e = this.attributes.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = (String)this.attributes.get(name);
                code = code ^ name.hashCode() << 3 ^ value.hashCode() << 13;
            }
        }
        return code;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof Tag) {
            Tag t = (Tag)other;
            if (!this.name.equals(t.name)) {
                return false;
            }
            if (this.attributes != null && t.attributes == null || this.attributes == null && t.attributes != null) {
                return false;
            }
            if (this.attributes == null) {
                return true;
            }
            if (this.attributes.size() != t.attributes.size()) {
                return false;
            }
            Enumeration e = this.attributes.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value1 = (String)this.attributes.get(name);
                String value2 = (String)t.attributes.get(name);
                if (!(value1 != null ? !value1.equals(value2) : value2 != null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String QuoteValue(String value) {
        return "\"" + value + "\"";
    }
}

