/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.AlertContentView;
import netscape.application.Bitmap;
import netscape.application.Button;
import netscape.application.Color;
import netscape.application.ExternalWindow;
import netscape.application.FastStringBuffer;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.Image;
import netscape.application.InternalAlertBorder;
import netscape.application.InternalWindow;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.TextField;
import netscape.application.TextParagraphFormat;
import netscape.application.TextView;
import netscape.application.Window;
import netscape.util.Hashtable;

public class Alert {
    public static final int DEFAULT_OPTION = 1;
    public static final int SECOND_OPTION = 2;
    public static final int THIRD_OPTION = 3;
    private final int MIN_WIDTH = 200;
    private final int WIDTH_MARGIN = 7;
    private final int TOP_MARGIN = 8;
    private final int BOTTOM_MARGIN = 8;
    private final int TEXT_TOP_MARGIN = 0;
    private final int TEXT_BOTTOM_MARGIN = 3;
    private final int BUTTON_HORIZ_MARGIN = 6;
    private final int TITLE_LEFT_MARGIN = 3;
    private final float BUTTON_CENTER_RATIO = 0.6666667f;
    static final String DEFAULT_ACTION = "performDefaultAction";
    static final String SECOND_ACTION = "performSecondAction";
    static final String THIRD_ACTION = "performThirdAction";
    private final int MIN_BUTTON_WIDTH = 50;
    private Window window;
    private AlertContentView contentView = new AlertContentView(this, 0, 0, 100, 100);
    private TextField titleTextField;
    private TextView messageTextView;
    private Button defaultButton;
    private Button secondButton;
    private Button thirdButton;
    private int result;
    private Button bitmapContainer;

    public static Image notificationImage() {
        return Bitmap.bitmapNamed("netscape/application/alertNotification.gif");
    }

    public static Image questionImage() {
        return Bitmap.bitmapNamed("netscape/application/alertQuestion.gif");
    }

    public static Image warningImage() {
        return Bitmap.bitmapNamed("netscape/application/alertWarning.gif");
    }

    public static int runAlertInternally(String title, String message, String defaultOption, String secondOption, String thirdOption) {
        return Alert.runAlertInternally(null, title, message, defaultOption, secondOption, thirdOption);
    }

    public static int runAlertExternally(String title, String message, String defaultOption, String secondOption, String thirdOption) {
        return Alert.runAlertExternally(null, title, message, defaultOption, secondOption, thirdOption);
    }

    public static int runAlertInternally(Image image, String title, String message, String defaultOption, String secondOption, String thirdOption) {
        Alert alert = new Alert(title, message, defaultOption, secondOption, thirdOption);
        alert.setImage(image);
        return alert.run(false);
    }

    public static int runAlertExternally(Image image, String title, String message, String defaultOption, String secondOption, String thirdOption) {
        Alert alert = new Alert(title, message, defaultOption, secondOption, thirdOption);
        alert.setImage(image);
        return alert.run(true);
    }

    private Alert(String title, String message, String positiveOption, String negativeOption, String alternateOption) {
        this.contentView.setVertResizeInstruction(16);
        this.contentView.setHorizResizeInstruction(2);
        this.bitmapContainer = new Button(0, 0, 100, 100);
        this.bitmapContainer.setEnabled(false);
        this.bitmapContainer.setBordered(false);
        Size sz = this.bitmapContainer.minSize();
        this.bitmapContainer.sizeTo(sz.width, sz.height);
        this.contentView.addSubview(this.bitmapContainer);
        this.titleTextField = new TextField(0, 0, 100, 0);
        this.titleTextField.setFont(new Font(Font.defaultFont().name(), 1, 18));
        this.titleTextField.setJustification(0);
        this.titleTextField.setStringValue(title);
        this.titleTextField.setBorder(null);
        this.titleTextField.setBackgroundColor(Color.lightGray);
        this.titleTextField.setEditable(false);
        this.contentView.addSubview(this.titleTextField);
        this.messageTextView = new TextView(0, 0, 100, 20);
        this.messageTextView.setEditable(false);
        this.messageTextView.setSelectable(false);
        this.messageTextView.setString("\n" + message + "\n");
        this.messageTextView.setBackgroundColor(Color.lightGray);
        Hashtable defaultAttributes = this.messageTextView.defaultAttributes();
        TextParagraphFormat format = (TextParagraphFormat)defaultAttributes.get("ParagraphFormatKey");
        defaultAttributes = (Hashtable)defaultAttributes.clone();
        format = (TextParagraphFormat)format.clone();
        format.setLeftMargin(0);
        format.setLeftIndent(0);
        format.setRightMargin(0);
        defaultAttributes.put("ParagraphFormatKey", format);
        this.messageTextView.setDefaultAttributes(defaultAttributes);
        this.contentView.addSubview(this.messageTextView);
        this.defaultButton = new Button(0, 0, 100, 20);
        this.defaultButton.setTitle(positiveOption);
        this.defaultButton.setTarget(this.contentView);
        this.defaultButton.setCommand(DEFAULT_ACTION);
        this.contentView.addSubview(this.defaultButton);
        if (negativeOption != null) {
            this.secondButton = new Button(0, 0, 100, 20);
            this.secondButton.setTitle(negativeOption);
            this.secondButton.setTarget(this.contentView);
            this.secondButton.setCommand(SECOND_ACTION);
            this.contentView.addSubview(this.secondButton);
        }
        if (alternateOption != null) {
            this.thirdButton = new Button(0, 0, 100, 20);
            this.thirdButton.setTitle(alternateOption);
            this.thirdButton.setTarget(this.contentView);
            this.thirdButton.setCommand(THIRD_ACTION);
            this.contentView.addSubview(this.thirdButton);
        }
    }

    private void setImage(Image anImage) {
        this.bitmapContainer.setImage(anImage);
        Size sz = this.bitmapContainer.minSize();
        this.bitmapContainer.sizeTo(sz.width, sz.height);
    }

    private void calculateLayout() {
        int buttonRowWidth;
        int minWidth = 200;
        boolean centerButtons = false;
        int centeredButtonSpacing = 0;
        int buttonOffset = 0;
        FontMetrics fm = new FontMetrics(this.titleTextField.font());
        minWidth = this.max(minWidth, fm.stringWidth(this.titleTextField.stringValue()) + 14 + 3 + this.bitmapContainer.width());
        this.titleTextField.sizeTo(100, fm.stringHeight());
        Size reqSize = this.requiredSizeToPreserveLinesInTextView(this.messageTextView);
        minWidth = this.max(minWidth, reqSize.width + 14);
        this.messageTextView.sizeTo(reqSize.width, reqSize.height);
        Size buttonSize = new Size();
        int buttonCount = 1;
        fm = new FontMetrics(this.defaultButton.font());
        buttonSize.width = this.max(fm.stringWidth(this.defaultButton.title()) + 10, 50);
        buttonSize.height = fm.stringHeight() + 4;
        if (this.secondButton != null) {
            buttonSize.width = this.max(buttonSize.width, fm.stringWidth(this.secondButton.title()) + 10);
            ++buttonCount;
        }
        if (this.thirdButton != null) {
            buttonSize.width = this.max(buttonSize.width, fm.stringWidth(this.thirdButton.title()) + 10);
            ++buttonCount;
        }
        if ((buttonRowWidth = 14 + buttonCount * buttonSize.width + (buttonCount - 1) * 6) < minWidth && (float)buttonRowWidth / (float)minWidth > 0.6666667f) {
            buttonOffset = (minWidth - buttonCount * buttonSize.width) / (1 + buttonCount);
            centeredButtonSpacing = (int)((double)buttonOffset * 0.8571428571428571);
            buttonOffset = (minWidth - buttonCount * buttonSize.width - (buttonCount - 1) * centeredButtonSpacing) / 2;
            centerButtons = true;
        } else {
            centerButtons = false;
            minWidth = this.max(minWidth, buttonRowWidth);
        }
        Rect rect = new Rect();
        rect.x = 7;
        rect.y = 8;
        if (this.bitmapContainer.image() != null) {
            if (this.bitmapContainer.superview() == null) {
                this.contentView.addSubview(this.bitmapContainer);
            }
            this.bitmapContainer.moveTo(rect.x, rect.y);
        } else {
            this.bitmapContainer.removeFromSuperview();
        }
        if (this.bitmapContainer.image() != null) {
            rect.x += this.bitmapContainer.width() + 3;
            rect.y = 8 + this.bitmapContainer.height() - this.titleTextField.height() + fm.descent() + 1;
        } else {
            rect.y = 8;
        }
        rect.width = minWidth - 14 - 3 - this.bitmapContainer.width();
        rect.height = this.titleTextField.bounds.height;
        this.titleTextField.setBounds(rect);
        rect.y = this.bitmapContainer.y() + this.bitmapContainer.height() > rect.y + rect.height ? this.bitmapContainer.y() + this.bitmapContainer.height() : (rect.y += rect.height);
        rect.x = 7;
        rect.width = this.messageTextView.bounds.width;
        rect.height = this.messageTextView.bounds.height;
        this.messageTextView.setBounds(rect);
        rect.y += rect.height + 3;
        if (centerButtons) {
            rect.x = buttonOffset;
            rect.width = buttonSize.width;
            rect.height = buttonSize.height;
            this.defaultButton.setBounds(rect);
            if (this.secondButton != null) {
                rect.x += rect.width + centeredButtonSpacing;
                this.secondButton.setBounds(rect);
            }
            if (this.thirdButton != null) {
                rect.x += rect.width + centeredButtonSpacing;
                this.thirdButton.setBounds(rect);
            }
        } else {
            rect.x = minWidth - (7 + buttonSize.width * buttonCount + 6 * (buttonCount - 1));
            rect.width = buttonSize.width;
            rect.height = buttonSize.height;
            this.defaultButton.setBounds(rect);
            rect.x += buttonSize.width + 6;
            if (this.secondButton != null) {
                this.secondButton.setBounds(rect);
                rect.x += buttonSize.width + 6;
            }
            if (this.thirdButton != null) {
                this.thirdButton.setBounds(rect);
            }
        }
        Size sz = new Size();
        sz.width = minWidth;
        sz.height = rect.y + buttonSize.height + 8;
        this.contentView.sizeTo(sz.width, sz.height);
    }

    private int run(boolean useExternalWindow) {
        this.calculateLayout();
        if (useExternalWindow) {
            this.window = new ExternalWindow(1);
        } else {
            this.window = new InternalWindow();
            InternalAlertBorder border = new InternalAlertBorder((InternalWindow)this.window);
            ((InternalWindow)this.window).setBorder(border);
        }
        this.window.setResizable(false);
        Size minSize = this.window.windowSizeForContentSize(this.contentView.bounds.width, this.contentView.bounds.height);
        this.window.sizeTo(minSize.width, minSize.height);
        this.window.addSubview(this.contentView);
        this.window.center();
        this.window.showModally();
        return this.result;
    }

    private int max(int i, int j) {
        if (i > j) {
            return i;
        }
        return j;
    }

    private Size requiredSizeToPreserveLinesInTextView(TextView aTextView) {
        FontMetrics fm = new FontMetrics(aTextView.font());
        FastStringBuffer sb = new FastStringBuffer();
        int maxLineWidth = 0;
        int lineCount = 1;
        int i = 0;
        int c = aTextView.length();
        while (i < c) {
            char ch = aTextView.characterAt(i);
            if (ch == '\n') {
                maxLineWidth = this.max(maxLineWidth, fm.stringWidth(sb.toString()));
                sb.truncateToLength(0);
                ++lineCount;
            } else {
                sb.append(ch);
            }
            ++i;
        }
        if (sb.length() != 0) {
            maxLineWidth = this.max(maxLineWidth, fm.stringWidth(sb.toString()));
        }
        Size result = new Size();
        result.width = maxLineWidth;
        result.height = fm.stringHeight() * lineCount;
        return result;
    }

    void setResult(int aResult) {
        this.result = aResult;
    }

    void hide() {
        this.window.hide();
    }
}

