/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Bitmap;
import netscape.application.Border;
import netscape.application.CheckButtonImage;
import netscape.application.Color;
import netscape.application.DrawingSequence;
import netscape.application.DrawingSequenceOwner;
import netscape.application.Font;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.Sound;
import netscape.application.Target;
import netscape.application.Timer;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Button
extends View
implements Target,
DrawingSequenceOwner,
FormElement {
    Font _titleFont;
    Color _titleColor = Color.black;
    Color _disabledTitleColor = Color.gray;
    Color _raisedColor;
    Color _loweredColor;
    Image _image;
    Image _altImage;
    Border _raisedBorder;
    Border _loweredBorder;
    Sound _downSound;
    Sound _upSound;
    Timer _actionTimer;
    Target _target;
    String _title = "";
    String _command;
    String _altTitle = "";
    int _type;
    int _imagePosition;
    int _repeatDelay = 75;
    boolean _state;
    boolean _enabled = true;
    boolean _bordered = true;
    boolean _highlighted;
    boolean _oldState;
    boolean transparent = false;
    private int _clickCount;
    private boolean _performingAction;
    static Vector _fieldDescription;
    public static final int PUSH_TYPE = 0;
    public static final int TOGGLE_TYPE = 1;
    public static final int RADIO_TYPE = 2;
    public static final int CONTINUOUS_TYPE = 3;
    public static final int IMAGE_ON_LEFT = 0;
    public static final int IMAGE_ON_RIGHT = 1;
    public static final int IMAGE_ABOVE = 2;
    public static final int IMAGE_BELOW = 3;
    public static final int IMAGE_BENEATH = 4;
    public static final String SEND_COMMAND = "sendCommand";
    public static final String CLICK = "click";
    public static final String SELECT_NEXT_RADIO_BUTTON = "selectNextRadioButton";
    public static final String SELECT_PREVIOUS_RADIO_BUTTON = "selectPreviousRadioButton";
    static final String TITLE_KEY = "title";
    static final String ALT_TITLE_KEY = "altTitle";
    static final String TITLE_FONT_KEY = "titleFont";
    static final String TITLE_COLOR_KEY = "titleColor";
    static final String DISABLED_TITLE_COLOR_KEY = "disabledTitleColor";
    static final String RAISED_COLOR_KEY = "raisedColor";
    static final String LOWERED_COLOR_KEY = "loweredColor";
    static final String IMAGE_KEY = "image";
    static final String ALT_IMAGE_KEY = "altImage";
    static final String DOWN_SOUND_KEY = "downSound";
    static final String UP_SOUND_KEY = "upSound";
    static final String TARGET_KEY = "target";
    static final String COMMAND_KEY = "command";
    static final String TYPE_KEY = "type";
    static final String IMAGE_POSITION_KEY = "imagePosition";
    static final String REPEAT_DELAY_KEY = "repeatDelay";
    static final String STATE_KEY = "state";
    static final String ENABLED_KEY = "enabled";
    static final String BORDERED_KEY = "bordered";
    static final String TRANSPARENT_KEY = "transparent";
    static final String RAISED_BORDER_KEY = "raisedBorder";
    static final String LOWERED_BORDER_KEY = "loweredBorder";

    public static Button createPushButton(int x, int y, int width, int height) {
        Button pushButton = new Button(x, y, width, height);
        pushButton.setType(0);
        return pushButton;
    }

    public static Button createCheckButton(int x, int y, int width, int height) {
        Button checkButton = new Button(x, y, width, height);
        checkButton.setType(1);
        checkButton.setTransparent(true);
        checkButton.setImage(new CheckButtonImage(false));
        checkButton.setAltImage(new CheckButtonImage(true));
        checkButton.setImagePosition(0);
        return checkButton;
    }

    public static Button createRadioButton(int x, int y, int width, int height) {
        Button radioButton = new Button(x, y, width, height);
        radioButton.setType(2);
        radioButton.setImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOff.gif"));
        radioButton.setAltImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOn.gif"));
        radioButton.setImagePosition(0);
        radioButton.setTransparent(true);
        return radioButton;
    }

    public Button() {
        this(0, 0, 0, 0);
    }

    public Button(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public Button(int x, int y, int width, int height) {
        super(x, y, width, height);
        this._titleFont = Font.defaultFont();
        this._raisedBorder = BezelBorder.raisedButtonBezel();
        this._loweredBorder = BezelBorder.loweredButtonBezel();
        this._raisedColor = Color.lightGray;
        this._loweredColor = Color.lightGray;
        this._setupKeyboard();
    }

    public void setTitle(String aString) {
        this._title = aString == null ? "" : aString;
        this.draw();
    }

    public String title() {
        return this._title;
    }

    public void setAltTitle(String aString) {
        this._altTitle = aString == null ? "" : aString;
        this.setDirty(true);
    }

    public String altTitle() {
        return this._altTitle;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this._enabled) {
            this._enabled = enabled;
            this.setDirty(true);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    void _setState(boolean newState) {
        if (newState != this._state) {
            this._state = newState;
            this.draw();
        }
    }

    void selectNextRadioButton(boolean forward) {
        View sv = this.superview();
        if (sv != null) {
            View peer;
            Vector peers = sv.subviews();
            int index = peers.indexOfIdentical(this);
            int count = peers.count();
            do {
                if (forward) {
                    if (++index == count) {
                        index = 0;
                    }
                } else if (--index < 0) {
                    index = count - 1;
                }
                if (!((peer = (View)peers.elementAt(index)) instanceof Button) || ((Button)peer).type() != 2) continue;
                ((Button)peer).setState(true);
                this.rootView().selectView(peer, true);
                return;
            } while (peer != this);
        }
    }

    Button _otherActive() {
        if (this.superview() == null) {
            return null;
        }
        Vector peers = this.superview().peersForSubview(this);
        int i = peers.count();
        while (i-- > 0) {
            Button nextPeer;
            View nextView = (View)peers.elementAt(i);
            if (!(nextView instanceof Button) || nextView == this || (nextPeer = (Button)nextView).type() != 2 || !nextPeer.isEnabled() || !nextPeer.state()) continue;
            return nextPeer;
        }
        return null;
    }

    public void setState(boolean newState) {
        this.rootView();
        if (this._type == 2) {
            Button otherActive;
            if (newState == this.state()) {
                return;
            }
            if (newState && (otherActive = this._otherActive()) != null) {
                otherActive._setState(false);
            }
        }
        this._setState(newState);
    }

    public boolean state() {
        return this._state;
    }

    public void setTarget(Target aTarget) {
        this._target = aTarget;
    }

    public Target target() {
        return this._target;
    }

    public void setCommand(String command) {
        this._command = command;
    }

    public String command() {
        return this._command;
    }

    public Size imageAreaSize() {
        Size theSize = this._image != null ? new Size(this._image.width(), this._image.height()) : new Size();
        if (this._altImage != null) {
            if (this._altImage.width() > theSize.width) {
                theSize.width = this._altImage.width();
            }
            if (this._altImage.height() > theSize.height) {
                theSize.height = this._altImage.height();
            }
        }
        return theSize;
    }

    Size minStringSize(String string) {
        int substringWidth;
        int newline = string.indexOf(10);
        if (newline == -1) {
            return this._titleFont.fontMetrics().stringSize(string);
        }
        Size theSize = new Size(0, this._titleFont.fontMetrics().stringHeight());
        int lineCount = 1;
        String titleRemainder = string;
        while (newline != -1) {
            substringWidth = this._titleFont.fontMetrics().stringWidth(titleRemainder.substring(0, newline));
            if (substringWidth > theSize.width) {
                theSize.width = substringWidth;
            }
            ++lineCount;
            titleRemainder = titleRemainder.substring(newline + 1);
            newline = titleRemainder.indexOf(10);
        }
        substringWidth = this._titleFont.fontMetrics().stringWidth(titleRemainder);
        if (substringWidth > theSize.width) {
            theSize.width = substringWidth;
        }
        theSize.height *= lineCount;
        return theSize;
    }

    public Size minSize() {
        boolean hasImage;
        Size theSize = null;
        Size altSize = null;
        boolean hasTitle = false;
        if (this._minSize != null) {
            return new Size(this._minSize);
        }
        if (this._title != null && this._title.length() > 0) {
            theSize = this.minStringSize(this._title);
            hasTitle = true;
        }
        if (this._altTitle != null && this._altTitle.length() > 0) {
            altSize = this.minStringSize(this._altTitle);
            hasTitle = true;
        }
        if (theSize == null) {
            theSize = altSize;
        } else if (altSize != null) {
            if (theSize.width < altSize.width) {
                theSize.width = altSize.width;
            }
            if (theSize.height < altSize.height) {
                theSize.height = altSize.height;
            }
        }
        if (theSize != null) {
            if (theSize.width > 0) {
                theSize.sizeBy(3, 0);
            }
        } else {
            theSize = new Size();
        }
        Size imageAreaSize = this.imageAreaSize();
        boolean bl = hasImage = imageAreaSize.width > 0 || imageAreaSize.height > 0;
        if (hasImage) {
            if (this._imagePosition == 2 || this._imagePosition == 3) {
                if (theSize.width < imageAreaSize.width) {
                    theSize.width = imageAreaSize.width;
                }
                theSize.height += imageAreaSize.height + 2;
            } else if (hasTitle && this._imagePosition != 4) {
                theSize.sizeBy(imageAreaSize.width + 2, 0);
                if (imageAreaSize.height > theSize.height) {
                    theSize.height = imageAreaSize.height;
                }
            } else {
                if (imageAreaSize.width > theSize.width) {
                    theSize.width = imageAreaSize.width;
                }
                if (imageAreaSize.height > theSize.height) {
                    theSize.height = imageAreaSize.height;
                }
            }
        }
        if (this._bordered) {
            theSize.sizeBy(3, 3);
        }
        return theSize;
    }

    public void setFont(Font aFont) {
        if (aFont == null) {
            this._titleFont = Font.defaultFont();
            return;
        }
        this._titleFont = aFont;
    }

    public Font font() {
        return this._titleFont;
    }

    public void setTitleColor(Color aColor) {
        if (aColor == null) {
            this._titleColor = Color.black;
            return;
        }
        this._titleColor = aColor;
    }

    public Color titleColor() {
        return this._titleColor;
    }

    public void setDisabledTitleColor(Color aColor) {
        if (aColor == null) {
            this._disabledTitleColor = Color.gray;
            return;
        }
        this._disabledTitleColor = aColor;
    }

    public Color disabledTitleColor() {
        return this._disabledTitleColor;
    }

    public void setRaisedColor(Color aColor) {
        if (aColor == null) {
            this._raisedColor = Color.lightGray;
            return;
        }
        this._raisedColor = aColor;
    }

    public Color raisedColor() {
        return this._raisedColor;
    }

    public void setLoweredColor(Color aColor) {
        if (aColor == null) {
            this._loweredColor = Color.lightGray;
            return;
        }
        this._loweredColor = aColor;
    }

    public Color loweredColor() {
        return this._loweredColor;
    }

    public void setImage(Image anImage) {
        this._image = anImage;
        if (anImage instanceof DrawingSequence) {
            DrawingSequence sequence = (DrawingSequence)anImage;
            sequence.setOwner(this);
        }
    }

    public Image image() {
        return this._image;
    }

    public void setAltImage(Image anImage) {
        this._altImage = anImage;
        if (anImage instanceof DrawingSequence) {
            DrawingSequence sequence = (DrawingSequence)anImage;
            sequence.setOwner(this);
        }
    }

    public Image altImage() {
        return this._altImage;
    }

    public void setRaisedBorder(Border border) {
        this._raisedBorder = border;
    }

    public Border raisedBorder() {
        return this._raisedBorder;
    }

    public void setLoweredBorder(Border border) {
        this._loweredBorder = border;
    }

    public Border loweredBorder() {
        return this._loweredBorder;
    }

    public void setMouseDownSound(Sound aSound) {
        this._downSound = aSound;
        if (this._type == 3 && this._downSound != null) {
            this._downSound.setLoops(true);
        }
    }

    public Sound mouseDownSound() {
        return this._downSound;
    }

    public void setMouseUpSound(Sound aSound) {
        this._upSound = aSound;
    }

    public Sound mouseUpSound() {
        return this._upSound;
    }

    public void setBordered(boolean flag) {
        this._bordered = flag;
        if (this._bordered) {
            this.setTransparent(false);
        }
    }

    public boolean isBordered() {
        return this._bordered;
    }

    public void setType(int buttonType) {
        if (buttonType < 0 || buttonType > 3) {
            throw new InconsistencyException("Invalid Button type: " + buttonType);
        }
        this._type = buttonType;
        this.setState(false);
        if (this._type == 3) {
            if (this._downSound != null) {
                this._downSound.setLoops(true);
            }
        } else if (this._downSound != null) {
            this._downSound.setLoops(false);
        }
        this._setupKeyboard();
    }

    public int type() {
        return this._type;
    }

    public void setRepeatDelay(int milliseconds) {
        if (milliseconds > 0) {
            this._repeatDelay = milliseconds;
            if (this._actionTimer != null) {
                this._actionTimer.setDelay(this._repeatDelay);
            }
        }
    }

    public int repeatDelay() {
        return this._repeatDelay;
    }

    public void setImagePosition(int aPosition) {
        if (aPosition < 0 || aPosition > 4) {
            return;
        }
        this._imagePosition = aPosition;
    }

    public int imagePosition() {
        return this._imagePosition;
    }

    public void setTransparent(boolean flag) {
        this.transparent = flag;
        if (this.transparent) {
            this._bordered = false;
        }
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    protected void ancestorWasAddedToViewHierarchy(View aView) {
        super.ancestorWasAddedToViewHierarchy(aView);
        if (this._type == 2 && this._state) {
            this._state = false;
            this.setState(true);
        }
    }

    public void drawViewTitleInRect(Graphics g, String title, Font titleFont, Rect textBounds, int justification) {
        if (title == null || title.length() == 0) {
            return;
        }
        if (this._enabled) {
            g.setColor(this._titleColor);
        } else {
            g.setColor(this._disabledTitleColor);
        }
        g.setFont(titleFont);
        int newline = title.indexOf(10);
        if (newline == -1) {
            g.drawStringInRect(title, textBounds, justification);
            return;
        }
        Rect tmpRect = new Rect(textBounds);
        tmpRect.height = this._titleFont.fontMetrics().stringHeight();
        String titleRemainder = title;
        while (newline != -1) {
            g.drawStringInRect(titleRemainder.substring(0, newline), tmpRect, justification);
            tmpRect.y += tmpRect.height;
            titleRemainder = titleRemainder.substring(newline + 1);
            newline = titleRemainder.indexOf(10);
        }
        g.drawStringInRect(titleRemainder, tmpRect, justification);
    }

    public void drawViewInterior(Graphics g, String title, Image image, Rect interiorRect) {
        int justification;
        Size imageAreaSize = this.imageAreaSize();
        if (this._imagePosition == 0) {
            int justification2;
            int x = title == null || title.length() == 0 ? interiorRect.x + 1 + (interiorRect.width - imageAreaSize.width - 2) / 2 : interiorRect.x + 1;
            if (image != null) {
                image.drawAt(g, x, interiorRect.y + (interiorRect.height - imageAreaSize.height) / 2);
            }
            if (imageAreaSize.width > 0) {
                interiorRect.moveBy(imageAreaSize.width + 3, 0);
                interiorRect.sizeBy(-(imageAreaSize.width + 4), 0);
                justification2 = 0;
            } else {
                interiorRect.moveBy(1, 0);
                interiorRect.sizeBy(-2, 0);
                justification2 = 1;
            }
            this.drawViewTitleInRect(g, title, this._titleFont, interiorRect, justification2);
            return;
        }
        if (this._imagePosition == 2) {
            if (image != null) {
                image.drawAt(g, interiorRect.x + (interiorRect.width - imageAreaSize.width) / 2, interiorRect.y + 2);
            }
            int charHeight = this._titleFont.fontMetrics().charHeight();
            interiorRect.setBounds(interiorRect.x + 1, interiorRect.maxY() - charHeight - 1, interiorRect.width - 2, charHeight);
            this.drawViewTitleInRect(g, title, this._titleFont, interiorRect, 1);
            return;
        }
        if (this._imagePosition == 3) {
            if (image != null) {
                image.drawAt(g, interiorRect.x + (interiorRect.width - imageAreaSize.width) / 2, interiorRect.maxY() - imageAreaSize.height - 2);
            }
            interiorRect.setBounds(interiorRect.x + 1, interiorRect.y + 1, interiorRect.width - 2, this._titleFont.fontMetrics().charHeight());
            this.drawViewTitleInRect(g, title, this._titleFont, interiorRect, 1);
            return;
        }
        if (image != null && this._imagePosition == 4) {
            image.drawAt(g, interiorRect.x + (interiorRect.width - imageAreaSize.width) / 2, interiorRect.y + (interiorRect.height - imageAreaSize.height) / 2);
            justification = 1;
        } else if (imageAreaSize.width == 0) {
            interiorRect.moveBy(2, 0);
            justification = 1;
        } else {
            justification = 0;
        }
        int x = title == null || title.length() == 0 ? interiorRect.x + 1 + (interiorRect.width - imageAreaSize.width - 2) / 2 : interiorRect.maxX() - imageAreaSize.width - 1;
        if (image != null && this._imagePosition == 1) {
            image.drawAt(g, x, interiorRect.y + (interiorRect.height - imageAreaSize.height) / 2);
        }
        this.drawViewTitleInRect(g, title, this._titleFont, interiorRect, justification);
    }

    public void drawViewBackground(Graphics g, Rect interiorRect, boolean drawDownState) {
        if (this._bordered) {
            interiorRect.sizeBy(-3, -3);
            if (drawDownState) {
                this._loweredBorder.drawInRect(g, 0, 0, this.bounds.width, this.bounds.height);
                g.setColor(this._loweredColor);
                g.fillRect(this._loweredBorder.leftMargin(), this._loweredBorder.topMargin(), this.bounds.width - this._loweredBorder.widthMargin(), this.bounds.height - this._loweredBorder.heightMargin());
                interiorRect.moveBy(2, 2);
                return;
            }
            this._raisedBorder.drawInRect(g, 0, 0, this.bounds.width, this.bounds.height);
            g.setColor(this._raisedColor);
            g.fillRect(this._raisedBorder.leftMargin(), this._raisedBorder.topMargin(), this.bounds.width - this._raisedBorder.widthMargin(), this.bounds.height - this._raisedBorder.heightMargin());
            interiorRect.moveBy(1, 1);
            return;
        }
        if (!this.isTransparent()) {
            if (drawDownState) {
                g.setColor(this._loweredColor);
            } else {
                g.setColor(this._raisedColor);
            }
            g.fillRect(0, 0, this.bounds.width, this.bounds.height);
        }
    }

    public void drawView(Graphics g) {
        DrawingSequence sequence;
        Image theImage = null;
        boolean drawDownState = this._highlighted ? !this._state : this._state;
        Rect interiorRect = Rect.newRect(0, 0, this.bounds.width, this.bounds.height);
        this.drawViewBackground(g, interiorRect, drawDownState);
        if (this._image instanceof DrawingSequence) {
            DrawingSequence sequence2 = (DrawingSequence)this._image;
            if (sequence2.isAnimating()) {
                theImage = this._image;
            } else if (this._altImage instanceof DrawingSequence) {
                theImage = this._altImage;
            }
        } else if (this._altImage instanceof DrawingSequence && (sequence = (DrawingSequence)this._altImage).isAnimating()) {
            theImage = this._altImage;
        }
        if (theImage == null) {
            theImage = this._image;
            if (drawDownState && this._altImage != null) {
                theImage = this._altImage;
            }
        }
        String theTitle = drawDownState && this._altTitle != null && this._altTitle.length() != 0 ? this._altTitle : this._title;
        if (theImage == null && (theTitle == null || theTitle.length() == 0)) {
            Rect.returnRect(interiorRect);
            return;
        }
        this.drawViewInterior(g, theTitle, theImage, interiorRect);
        Rect.returnRect(interiorRect);
    }

    Button _activeForPoint(int x, int y) {
        if (this.superview() == null) {
            return null;
        }
        Vector peers = this.superview().peersForSubview(this);
        Point point = Point.newPoint();
        int i = peers.count();
        while (i-- > 0) {
            Button nextPeer;
            View nextView = (View)peers.elementAt(i);
            if (!(nextView instanceof Button) || nextView == this || (nextPeer = (Button)nextView).type() != 2) continue;
            this.convertToView(nextView, x, y, point);
            if (!nextPeer.containsPoint(point.x, point.y)) continue;
            Point.returnPoint(point);
            return nextPeer;
        }
        Point.returnPoint(point);
        return null;
    }

    public boolean mouseDown(MouseEvent event) {
        if (!this._enabled) {
            return false;
        }
        if (!this.containsPoint(event.x, event.y)) {
            return false;
        }
        if (this._type == 2) {
            Button otherActive = this._otherActive();
            if (otherActive != null) {
                otherActive._setState(false);
            }
            this._oldState = this._state;
            this._state = false;
        }
        this._clickCount = event.clickCount;
        if (this._type == 1 || this._type == 2) {
            this.setHighlighted(true);
        } else {
            this.setState(true);
        }
        if (this._downSound != null) {
            this._downSound.play();
        }
        if (this._altImage instanceof DrawingSequence) {
            DrawingSequence sequence = (DrawingSequence)this._altImage;
            sequence.start();
        }
        if (this._type == 3 && this._actionTimer == null) {
            this.sendCommand();
            this._actionTimer = new Timer(this, SEND_COMMAND, this._repeatDelay);
            this._actionTimer.setInitialDelay(300);
            this._actionTimer.start();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    void _buttonDown() {
        block4: {
            if (!(this._image instanceof DrawingSequence)) break block4;
            sequence = (DrawingSequence)this._image;
            if (!sequence.doesLoop()) ** GOTO lbl7
            sequence.stop();
            break block4;
lbl-1000:
            // 1 sources

            {
                sequence.stop();
lbl7:
                // 2 sources

                ** while (sequence.isAnimating())
            }
        }
        if (this._altImage instanceof DrawingSequence) {
            sequence = (DrawingSequence)this._altImage;
            sequence.start();
        }
        if (this._type == 3 && this._upSound != null) {
            this._upSound.stop();
        }
        if (this._downSound != null) {
            this._downSound.play();
        }
    }

    /*
     * Unable to fully structure code
     */
    void _buttonUp() {
        block4: {
            if (!(this._altImage instanceof DrawingSequence)) break block4;
            sequence = (DrawingSequence)this._altImage;
            if (!sequence.doesLoop()) ** GOTO lbl7
            sequence.stop();
            break block4;
lbl-1000:
            // 1 sources

            {
                sequence.stop();
lbl7:
                // 2 sources

                ** while (sequence.isAnimating())
            }
        }
        if (this._image instanceof DrawingSequence) {
            sequence = (DrawingSequence)this._image;
            sequence.start();
        }
        if (this._type == 3 && this._downSound != null) {
            this._downSound.stop();
        }
        if (this._upSound != null) {
            this._upSound.play();
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (!this._enabled) {
            return;
        }
        if (this._type == 2 && !this.containsPoint(event.x, event.y)) {
            Button newButton = this._activeForPoint(event.x, event.y);
            if (newButton != null) {
                this.setHighlighted(false);
                newButton.setHighlighted(true);
                this.rootView().setMouseView(newButton);
            }
            return;
        }
        if (this.containsPoint(event.x, event.y)) {
            if (!this._state && !this._highlighted) {
                this._buttonDown();
                if (this._type == 1 || this._type == 2) {
                    this.setHighlighted(true);
                } else {
                    this.setState(true);
                }
                if (this._type == 3) {
                    this.sendCommand();
                    this._actionTimer = new Timer(this, SEND_COMMAND, 100);
                    this._actionTimer.start();
                    return;
                }
            }
        } else if (this._state || this._highlighted) {
            this._buttonUp();
            if (this._type == 3 && this._actionTimer != null) {
                this._actionTimer.stop();
                this._actionTimer = null;
            }
            if (this._type == 1 || this._type == 2) {
                this.setHighlighted(false);
                return;
            }
            this.setState(false);
        }
    }

    public void mouseUp(MouseEvent event) {
        boolean mouseOverButton;
        if (!this._enabled) {
            return;
        }
        if (this._type == 2) {
            if (this._highlighted) {
                this._highlighted = false;
                this.setState(true);
            }
            if (this._state != this._oldState) {
                this.sendCommand();
            }
            this._oldState = false;
            if (this.canBecomeSelectedView() && this.rootView() != null) {
                this.rootView().selectView(this, true);
            }
            return;
        }
        if (this._actionTimer != null) {
            this._actionTimer.stop();
            this._actionTimer = null;
        }
        if (mouseOverButton = this.containsPoint(event.x, event.y)) {
            this._buttonUp();
        }
        if (this._type == 3) {
            this._state = false;
            if (mouseOverButton) {
                this.setDirty(true);
            }
            if (this.canBecomeSelectedView() && this.rootView() != null) {
                this.rootView().selectView(this, true);
            }
            return;
        }
        if (this._type == 1) {
            if (mouseOverButton) {
                this._highlighted = false;
                this._state = !this._state;
            } else {
                this._highlighted = false;
            }
            if (mouseOverButton) {
                this.setDirty(true);
            }
            if (mouseOverButton) {
                this.sendCommand();
            }
        } else {
            if (this._type != 3 && mouseOverButton) {
                this.sendCommand();
            }
            this._state = false;
            if (mouseOverButton) {
                this.setDirty(true);
            }
        }
        if (this.canBecomeSelectedView() && this.rootView() != null) {
            this.rootView().selectView(this, true);
        }
    }

    public int clickCount() {
        if (this._performingAction) {
            return this._clickCount;
        }
        return 0;
    }

    public void click() {
        if (!this._enabled) {
            return;
        }
        if (this._type == 2 && this._state) {
            return;
        }
        if (this._type == 1 || this._type == 2) {
            this.setState(!this._state);
            this.application().syncGraphics();
            this.sendCommand();
            return;
        }
        this.setState(true);
        this.application().syncGraphics();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this._clickCount = 1;
        this.sendCommand();
        this.setState(false);
    }

    public void performCommand(String command, Object data) {
        int type = this.type();
        if (SEND_COMMAND.equals(command)) {
            this.sendCommand();
            return;
        }
        if (CLICK.equals(command)) {
            this.click();
            return;
        }
        if (type == 2 && SELECT_PREVIOUS_RADIO_BUTTON.equals(command)) {
            this.selectNextRadioButton(false);
            return;
        }
        if (type == 2 && SELECT_NEXT_RADIO_BUTTON.equals(command)) {
            this.selectNextRadioButton(true);
            return;
        }
        throw new NoSuchMethodError("unknown command: " + command);
    }

    public void drawingSequenceFrameChanged(DrawingSequence aSequence) {
        this.setDirty(true);
    }

    public void drawingSequenceCompleted(DrawingSequence aSequence) {
    }

    public void sendCommand() {
        this._performingAction = true;
        if (this._target != null) {
            this._target.performCommand(this._command, this);
        }
        this._performingAction = false;
    }

    protected void setHighlighted(boolean highlighted) {
        if (this._highlighted != highlighted) {
            this._highlighted = highlighted;
            this.setDirty(true);
        }
    }

    protected boolean isHighlighted() {
        return this._highlighted;
    }

    public boolean canBecomeSelectedView() {
        if (this.isEnabled() && this.hasKeyboardBindings()) {
            if (this.type() == 2) {
                return this.state();
            }
            return true;
        }
        return false;
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.Button", 2);
        info.addField(TITLE_KEY, (byte)16);
        info.addField(ALT_TITLE_KEY, (byte)16);
        info.addField(TITLE_FONT_KEY, (byte)18);
        info.addField(TITLE_COLOR_KEY, (byte)18);
        info.addField(DISABLED_TITLE_COLOR_KEY, (byte)18);
        info.addField(RAISED_COLOR_KEY, (byte)18);
        info.addField(LOWERED_COLOR_KEY, (byte)18);
        info.addField(IMAGE_KEY, (byte)18);
        info.addField(ALT_IMAGE_KEY, (byte)18);
        info.addField(DOWN_SOUND_KEY, (byte)18);
        info.addField(UP_SOUND_KEY, (byte)18);
        info.addField(TARGET_KEY, (byte)18);
        info.addField(COMMAND_KEY, (byte)16);
        info.addField(TYPE_KEY, (byte)8);
        info.addField(IMAGE_POSITION_KEY, (byte)8);
        info.addField(REPEAT_DELAY_KEY, (byte)8);
        info.addField(STATE_KEY, (byte)0);
        info.addField(ENABLED_KEY, (byte)0);
        info.addField(BORDERED_KEY, (byte)0);
        info.addField(TRANSPARENT_KEY, (byte)0);
        info.addField(RAISED_BORDER_KEY, (byte)18);
        info.addField(LOWERED_BORDER_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeString(TITLE_KEY, this._title);
        encoder.encodeString(ALT_TITLE_KEY, this._altTitle);
        encoder.encodeObject(TITLE_FONT_KEY, this._titleFont);
        encoder.encodeObject(TITLE_COLOR_KEY, this._titleColor);
        encoder.encodeObject(DISABLED_TITLE_COLOR_KEY, this._disabledTitleColor);
        encoder.encodeObject(RAISED_COLOR_KEY, this._raisedColor);
        encoder.encodeObject(LOWERED_COLOR_KEY, this._loweredColor);
        encoder.encodeObject(IMAGE_KEY, this._image);
        encoder.encodeObject(ALT_IMAGE_KEY, this._altImage);
        encoder.encodeObject(TARGET_KEY, (Codable)((Object)this._target));
        encoder.encodeString(COMMAND_KEY, this._command);
        encoder.encodeInt(TYPE_KEY, this._type);
        encoder.encodeInt(IMAGE_POSITION_KEY, this._imagePosition);
        encoder.encodeInt(REPEAT_DELAY_KEY, this._repeatDelay);
        encoder.encodeBoolean(STATE_KEY, this._state);
        encoder.encodeBoolean(ENABLED_KEY, this._enabled);
        encoder.encodeBoolean(BORDERED_KEY, this._bordered);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
        encoder.encodeObject(RAISED_BORDER_KEY, this._raisedBorder);
        encoder.encodeObject(LOWERED_BORDER_KEY, this._loweredBorder);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this._title = decoder.decodeString(TITLE_KEY);
        this._altTitle = decoder.decodeString(ALT_TITLE_KEY);
        this._titleFont = (Font)decoder.decodeObject(TITLE_FONT_KEY);
        this._titleColor = (Color)decoder.decodeObject(TITLE_COLOR_KEY);
        this._disabledTitleColor = (Color)decoder.decodeObject(DISABLED_TITLE_COLOR_KEY);
        this._raisedColor = (Color)decoder.decodeObject(RAISED_COLOR_KEY);
        this._loweredColor = (Color)decoder.decodeObject(LOWERED_COLOR_KEY);
        this._image = (Image)decoder.decodeObject(IMAGE_KEY);
        this._altImage = (Image)decoder.decodeObject(ALT_IMAGE_KEY);
        this._target = (Target)decoder.decodeObject(TARGET_KEY);
        this._command = decoder.decodeString(COMMAND_KEY);
        this._type = decoder.decodeInt(TYPE_KEY);
        this._imagePosition = decoder.decodeInt(IMAGE_POSITION_KEY);
        this._repeatDelay = decoder.decodeInt(REPEAT_DELAY_KEY);
        this._state = decoder.decodeBoolean(STATE_KEY);
        this._enabled = decoder.decodeBoolean(ENABLED_KEY);
        this._bordered = decoder.decodeBoolean(BORDERED_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
        if (decoder.versionForClassName("netscape.application.Button") > 1) {
            this._raisedBorder = (Border)decoder.decodeObject(RAISED_BORDER_KEY);
            this._loweredBorder = (Border)decoder.decodeObject(LOWERED_BORDER_KEY);
        }
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        if (this.type() == 2) {
            this.setCommandForKey(SELECT_NEXT_RADIO_BUTTON, 1007, 0);
            this.setCommandForKey(SELECT_NEXT_RADIO_BUTTON, 1005, 0);
            this.setCommandForKey(SELECT_PREVIOUS_RADIO_BUTTON, 1006, 0);
            this.setCommandForKey(SELECT_PREVIOUS_RADIO_BUTTON, 1004, 0);
            return;
        }
        this.setCommandForKey(CLICK, 10, 0);
    }

    public String formElementText() {
        if (this._type == 1) {
            if (this._state) {
                return "true";
            }
            return "false";
        }
        return this.title();
    }
}

