/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class Point
implements Codable {
    public int x;
    public int y;
    private static Vector _pointCache = new Vector();
    private static boolean _cachePoints = true;
    static final String X_KEY = "x";
    static final String Y_KEY = "y";

    public Point() {
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(Point templatePoint) {
        this.x = templatePoint.x;
        this.y = templatePoint.y;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void moveBy(int deltaX, int deltaY) {
        this.x += deltaX;
        this.y += deltaY;
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof Point)) {
            return false;
        }
        Point aPoint = (Point)anObject;
        return aPoint.x == this.x && aPoint.y == this.y;
    }

    public int hashCode() {
        return this.x ^ this.y;
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.Point", 1);
        info.addField(X_KEY, (byte)8);
        info.addField(Y_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(X_KEY, this.x);
        encoder.encodeInt(Y_KEY, this.y);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.x = decoder.decodeInt(X_KEY);
        this.y = decoder.decodeInt(Y_KEY);
    }

    public void finishDecoding() throws CodingException {
    }

    static Point newPoint(int x, int y) {
        Point thePoint;
        Vector vector = _pointCache;
        synchronized (vector) {
            if (!_cachePoints || _pointCache.isEmpty()) {
                Point point = new Point(x, y);
                Object var5_4 = null;
                return point;
            }
            thePoint = (Point)_pointCache.removeLastElement();
        }
        thePoint.moveTo(x, y);
        return thePoint;
    }

    static Point newPoint(Point templatePoint) {
        if (templatePoint == null) {
            return Point.newPoint(0, 0);
        }
        return Point.newPoint(templatePoint.x, templatePoint.y);
    }

    static Point newPoint() {
        return Point.newPoint(0, 0);
    }

    static void returnPoint(Point aPoint) {
        if (!_cachePoints) {
            return;
        }
        Vector vector = _pointCache;
        synchronized (vector) {
            if (_pointCache.count() < 30) {
                _pointCache.addElement(aPoint);
            }
            return;
        }
    }

    static void returnPoints(Vector points) {
        if (points == null || !_cachePoints) {
            return;
        }
        int i = points.count();
        while (i-- > 0) {
            Point.returnPoint((Point)points.elementAt(i));
        }
        points.removeAllElements();
    }

    static void setShouldCachePoints(boolean flag) {
        Vector vector = _pointCache;
        synchronized (vector) {
            _cachePoints = flag;
            if (!_cachePoints) {
                _pointCache.removeAllElements();
            }
            return;
        }
    }
}

