/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.DragDestination;
import netscape.application.DragSession;
import netscape.application.Event;
import netscape.application.EventFilter;
import netscape.application.ExtendedTarget;
import netscape.application.FastStringBuffer;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.HTMLElement;
import netscape.application.HTMLParser;
import netscape.application.HTMLParsingException;
import netscape.application.HTMLParsingRules;
import netscape.application.Image;
import netscape.application.ImageAttachment;
import netscape.application.KeyEvent;
import netscape.application.MouseEvent;
import netscape.application.ObjectPool;
import netscape.application.Point;
import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.TextAttachment;
import netscape.application.TextFilter;
import netscape.application.TextParagraph;
import netscape.application.TextParagraphFormat;
import netscape.application.TextPositionInfo;
import netscape.application.TextSelection;
import netscape.application.TextStyleRun;
import netscape.application.TextViewHTMLElement;
import netscape.application.TextViewOwner;
import netscape.application.Timer;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class TextView
extends View
implements ExtendedTarget,
EventFilter,
DragDestination,
FormElement {
    public static final String TEXT_ATTACHMENT_STRING = "@";
    public static final String PARAGRAPH_FORMAT_KEY = "ParagraphFormatKey";
    public static final String FONT_KEY = "FontKey";
    public static final String TEXT_COLOR_KEY = "TextColorKey";
    public static final String TEXT_ATTACHMENT_KEY = "TextAttachmentKey";
    public static final String TEXT_ATTACHMENT_BASELINE_OFFSET_KEY = "TextAttachmentBaselineOffsetKey";
    public static final String CARET_COLOR_KEY = "CaretColorKey";
    public static final String LINK_KEY = "LinkKey";
    public static final String LINK_DESTINATION_KEY = "LinkDestinationKey";
    public static final String LINK_COLOR_KEY = "LinkColorKey";
    public static final String PRESSED_LINK_COLOR_KEY = "PressedLinkColorKey";
    static final String LINK_IS_PRESSED_KEY = "_IFCLinkPressedKey";
    static Vector attributesChangingFormatting = new Vector();
    Vector _paragraphVector;
    Color _backgroundColor;
    Color _selectionColor;
    TextParagraph _updateParagraph;
    TextPositionInfo _anchorInfo;
    TextPositionInfo _upInfo;
    TextSelection _selection;
    TextFilter _filter;
    TextViewOwner _owner;
    Hashtable _defaultAttributes;
    Hashtable _typingAttributes;
    Timer _updateTimer;
    Vector _eventVector = new Vector();
    int _charCount;
    int _paragraphSpacing = 0;
    int _updateLine;
    int _downY;
    int _clickCount;
    int _resizeDisabled;
    int _formattingDisabled;
    boolean _drawText = true;
    boolean _editing;
    boolean _useSingleFont = false;
    boolean _editable = true;
    boolean _selectable = true;
    boolean _drawNextParagraph;
    boolean _resizing = false;
    boolean insertionPointVisible = false;
    boolean transparent = false;
    boolean selectLineBreak;
    private Range _selectedRange;
    private Range _wasSelectedRange;
    private TextAttachment _mouseDownTextAttachment;
    private Point _mouseDownTextAttachmentOrigin;
    private FontMetrics _defaultFontMetricsCache;
    private URL _baseURL;
    private Range _clickedRange;
    private Range _firstRange;
    private HTMLParsingRules _htmlParsingRules;
    private int notifyAttachmentDisabled;
    private Range invalidAttachmentRange;
    private static Vector _rectCache;
    private static Vector _vectorCache;
    private static boolean _shouldCache;
    private static boolean _cacheVectors;
    static ObjectPool hashtablePool;
    static ObjectPool rangePool;
    static final String PARAGRAPHVECTOR_KEY = "paragraphVector";
    static final String BACKGROUNDCOLOR_KEY = "backgroundColor";
    static final String SELECTIONCOLOR_KEY = "selectionColor";
    static final String FILTER_KEY = "filter";
    static final String DEFAULTATTRIBUTES_KEY = "defaultAttributes";
    static final String PARASPACING_KEY = "paragraphSpacing";
    static final String USESINGLEFONT_KEY = "useSingleFont";
    static final String EDITABLE_KEY = "editable";
    static final String SELECTABLE_KEY = "selectable";
    static final String TRANSPARENT_KEY = "transparent";
    static final String HTML_PARSING_RULES_KEY = "htmlParsingRules";
    static final String OWNER_KEY = "owner";

    public TextView() {
        this(0, 0, 0, 0);
    }

    public TextView(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public TextView(int x, int y, int width, int height) {
        super(x, y, width, height);
        this._selection = new TextSelection(this);
        this._paragraphVector = new Vector();
        this._backgroundColor = Color.white;
        this._selectionColor = Color.lightGray;
        this._defaultAttributes = new Hashtable();
        this._defaultAttributes.put(FONT_KEY, Font.defaultFont());
        this._defaultAttributes.put(TEXT_COLOR_KEY, Color.black);
        this._defaultAttributes.put(LINK_COLOR_KEY, Color.blue);
        this._defaultAttributes.put(CARET_COLOR_KEY, Color.black);
        this._defaultAttributes.put(PRESSED_LINK_COLOR_KEY, Color.red);
        TextParagraphFormat defaultFormat = new TextParagraphFormat();
        defaultFormat.setLeftMargin(3);
        defaultFormat.setRightMargin(3);
        defaultFormat.setJustification(0);
        int tabPos = 30;
        int i = 0;
        while (i < 20) {
            defaultFormat.addTabPosition(tabPos);
            tabPos += 30;
            ++i;
        }
        this._defaultAttributes.put(PARAGRAPH_FORMAT_KEY, defaultFormat);
        this._wasSelectedRange = new Range(this.selectedRange());
        TextParagraph newParagraph = new TextParagraph(this);
        newParagraph.addRun(new TextStyleRun(newParagraph, "", null));
        this.addParagraph(newParagraph);
        this.reformatAll();
        this._typingAttributes = new Hashtable();
    }

    public void didMoveBy(int deltaX, int deltaY) {
        if (deltaX == 0 && deltaY == 0 && this._updateTimer != null) {
            this._updateTimer.stop();
            this._updateTimer = null;
            this._updateParagraph = null;
        }
        super.didMoveBy(deltaX, deltaY);
    }

    public void sizeBy(int deltaWidth, int deltaHeight) {
        if (!this.isResizingEnabled()) {
            return;
        }
        int origWidth = this.bounds.width;
        this._resizing = true;
        super.sizeBy(deltaWidth, deltaHeight);
        this._resizing = false;
        if (this.bounds.width != origWidth + deltaWidth) {
            this.disableResizing();
            this.reformatAll();
            this.enableResizing();
            this.setDirty(true);
            return;
        }
        if (deltaWidth != 0 || deltaHeight != 0) {
            this.setDirty(true);
        }
    }

    public void didSizeBy(int dw, int dh) {
        if (!this._resizing) {
            this.reformatAll();
        }
        super.didSizeBy(dw, dh);
    }

    public void setTransparent(boolean flag) {
        this.transparent = flag;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean wantsAutoscrollEvents() {
        return true;
    }

    public void drawView(Graphics g) {
        if (!this._drawText) {
            if (this._updateParagraph != null) {
                this._updateParagraph.drawLine(g, this._updateLine);
            }
        } else {
            int count = this._paragraphVector.count();
            int minY = g.clipRect().y;
            int maxY = g.clipRect().maxY();
            Rect rect = Rect.newRect(0, 0, this.width(), this.height());
            int i = 0;
            while (i < count) {
                TextParagraph nextParagraph = (TextParagraph)this._paragraphVector.elementAt(i);
                if (nextParagraph._y <= maxY && nextParagraph._y + nextParagraph._height >= minY) {
                    nextParagraph.drawView(g, rect);
                }
                ++i;
            }
            Rect.returnRect(rect);
        }
        if (this._selection._insertionPointShowing) {
            Rect r = this._selection.insertionPointRect();
            Color caretColor = null;
            if (g.clipRect().intersects(r)) {
                TextPositionInfo insertionPointInfo = this._selection.insertionPointInfo();
                TextStyleRun run = this._runForIndex(insertionPointInfo._absPosition);
                Hashtable attr = run.attributes();
                if (attr != null) {
                    caretColor = (Color)attr.get(CARET_COLOR_KEY);
                }
                if (caretColor == null) {
                    caretColor = (Color)this._defaultAttributes.get(CARET_COLOR_KEY);
                }
                if (caretColor == null) {
                    caretColor = Color.black;
                }
                g.setColor(caretColor);
                g.fillRect(r);
            }
        }
    }

    public Object filterEvents(Vector events) {
        int i = 0;
        while (i < events.count()) {
            Event event = (Event)events.elementAt(i);
            if (event instanceof KeyEvent && event.type() == -11) {
                if (this._filter != null) {
                    if (this._filter.acceptsEvent(this, (KeyEvent)event, this._eventVector)) {
                        this._eventVector.addElement(event);
                    }
                } else {
                    this._eventVector.addElement(event);
                }
                events.removeElementAt(i);
                --i;
            }
            ++i;
        }
        return null;
    }

    public boolean mouseDown(MouseEvent event) {
        Hashtable attr;
        TextStyleRun run;
        Codable r;
        this._mouseDownTextAttachment = null;
        this._clickedRange = null;
        if (this.isEditable() || this.isSelectable()) {
            this.setFocusedView();
        }
        if (!this.rootView().mouseStillDown()) {
            this.rootView().adjustForExpectedMouseDownCount();
            if (!this.rootView().mouseStillDown()) {
                return true;
            }
        }
        this._selection.hideInsertionPoint();
        this._clickCount = event.clickCount();
        this._anchorInfo = this.positionForPoint(event.x, event.y, false);
        TextPositionInfo absoluteAnchorInfo = this.positionForPoint(event.x, event.y, true);
        this.selectLineBreak = this._anchorInfo != null && this._anchorInfo._endOfLine ? ((Rect)(r = new Rect(this._anchorInfo._x, this._anchorInfo._y, this.bounds.width, this._anchorInfo._lineHeight))).contains(event.x, event.y) : false;
        if (absoluteAnchorInfo != null && (run = this._runForIndex(absoluteAnchorInfo._absPosition)) != null && (attr = run.attributes()) != null) {
            boolean result;
            Rect rect;
            TextAttachment item = (TextAttachment)attr.get(TEXT_ATTACHMENT_KEY);
            if (item != null && run.rangeIndex() == absoluteAnchorInfo._absPosition && (rect = run.textAttachmentBoundsForOrigin(absoluteAnchorInfo._x, absoluteAnchorInfo._y, run._paragraph._baselines[absoluteAnchorInfo._lineNumber])) != null && rect.contains(event.x, event.y) && (result = item.mouseDown(new MouseEvent(event.timeStamp, event.type, event.x - rect.x, event.y - rect.y, event.modifiers)))) {
                this._mouseDownTextAttachment = item;
                this._mouseDownTextAttachmentOrigin = new Point(rect.x, rect.y);
                return true;
            }
            if (!this.isEditable() && attr.get(LINK_KEY) != null && this.runUnderMouse(run, event.x, event.y) && this._clickCount == 1) {
                this._clickedRange = this.linkRangeForPosition(absoluteAnchorInfo._absPosition);
                this.highlightLinkWithRange(this._clickedRange, true);
            }
        }
        if (!this.isSelectable() && this._clickedRange == null) {
            return false;
        }
        this._firstRange = null;
        if (this._clickCount > 1) {
            if (!this.selectLineBreak) {
                switch (this._clickCount) {
                    case 2: {
                        this._firstRange = this.groupForIndex(this._anchorInfo._absPosition);
                        break;
                    }
                    default: {
                        this._firstRange = this.paragraphForIndex(this._anchorInfo._absPosition);
                    }
                }
                if (this._firstRange != null && !this._firstRange.isNullRange()) {
                    if (event.isShiftKeyDown()) {
                        r = new Range(this.selectedRange());
                        ((Range)r).unionWith(this._firstRange.index, this._firstRange.length);
                        this._selection.setRange(((Range)r).index, ((Range)r).index + ((Range)r).length, null, false);
                    } else {
                        this._selection.setRange(this._firstRange.index, this._firstRange.lastIndex() + 1, null, false);
                    }
                    this._selectionChanged();
                }
                return true;
            }
            this._firstRange = new Range(this._anchorInfo._absPosition, 0);
        }
        if (event.isShiftKeyDown()) {
            this._selection.setRange(this._selection.orderedSelectionStart(), this._anchorInfo._absPosition, null, false);
        } else {
            this._selection.setInsertionPoint(this._anchorInfo);
        }
        this._selectionChanged();
        this._upInfo = null;
        this._downY = this._anchorInfo._y + this._anchorInfo._lineHeight;
        return true;
    }

    public void mouseDragged(MouseEvent event) {
        if (this._mouseDownTextAttachment != null) {
            this._mouseDownTextAttachment.mouseDragged(new MouseEvent(event.timeStamp, event.type, event.x - this._mouseDownTextAttachmentOrigin.x, event.y - this._mouseDownTextAttachmentOrigin.y, event.modifiers));
            return;
        }
        Point realPoint = new Point(event.x, event.y);
        if (realPoint.x >= this.bounds.width) {
            realPoint.x = this.bounds.width - 1;
        } else if (realPoint.x < 0) {
            realPoint.x = 0;
        }
        if (realPoint.y >= this.bounds.height) {
            realPoint.y = this.bounds.height - 1;
        } else if (realPoint.y < 0) {
            realPoint.y = 0;
        }
        TextPositionInfo newUp = this.positionForPoint(realPoint.x, realPoint.y, false);
        if (this._clickedRange != null) {
            TextStyleRun runForMouse = this._runForIndex(newUp._absPosition);
            Hashtable runAttr = runForMouse.attributes();
            if (runAttr != null && runAttr.get(LINK_KEY) != null && this.runUnderMouse(runForMouse, event.x, event.y)) {
                Range newClickedRange = this.linkRangeForPosition(newUp._absPosition);
                if (!newClickedRange.equals(this._clickedRange)) {
                    this.highlightLinkWithRange(this._clickedRange, false);
                    this._clickedRange = newClickedRange;
                    this.highlightLinkWithRange(this._clickedRange, true);
                }
                return;
            }
            this.highlightLinkWithRange(this._clickedRange, false);
            this._clickedRange = null;
        }
        if (!this.isSelectable()) {
            return;
        }
        if (newUp == null) {
            return;
        }
        if (!this.containsPointInVisibleRect(event.x, event.y)) {
            Rect tmpRect = TextView.newRect(newUp._x, newUp._y, 1, newUp._lineHeight);
            this.scrollRectToVisible(tmpRect);
            TextView.returnRect(tmpRect);
        }
        int anchorPosition = this._anchorInfo._absPosition;
        boolean selectionChanged = this._upInfo != null && newUp._absPosition != this._upInfo._absPosition;
        this._upInfo = newUp;
        if (selectionChanged) {
            Range last;
            switch (this._clickCount) {
                case 0: 
                case 1: {
                    this._selection.setRange(anchorPosition, this._upInfo._absPosition, this._upInfo, this.selectLineBreak);
                    this._selectionChanged();
                    return;
                }
                case 2: {
                    last = this.groupForIndex(this._upInfo._absPosition);
                    break;
                }
                default: {
                    last = this.paragraphForIndex(this._upInfo._absPosition);
                }
            }
            if (this._firstRange != null && !this._firstRange.isNullRange() && !last.isNullRange()) {
                last.unionWith(this._firstRange);
                if (!last.equals(this.selectedRange())) {
                    this._selection.setRange(last.index, last.lastIndex() + 1, null, this.selectLineBreak);
                    this._selectionChanged();
                }
            }
        }
    }

    public void mouseUp(MouseEvent event) {
        if (this._mouseDownTextAttachment != null) {
            this._mouseDownTextAttachment.mouseUp(new MouseEvent(event.timeStamp, event.type, event.x - this._mouseDownTextAttachmentOrigin.x, event.y - this._mouseDownTextAttachmentOrigin.y, event.modifiers));
            this._mouseDownTextAttachment = null;
            this._mouseDownTextAttachmentOrigin = null;
            return;
        }
        if (this._clickedRange != null) {
            TextPositionInfo upPosition = this.positionForPoint(event.x, event.y, true);
            Range newClickedRange = this.linkRangeForPosition(upPosition._absPosition);
            this.highlightLinkWithRange(this._clickedRange, false);
            if (newClickedRange != null && newClickedRange.equals(this._clickedRange) && this._owner != null) {
                TextStyleRun run = this._runForIndex(this._clickedRange.index);
                Hashtable runAttr = run.attributes();
                String urlStr = null;
                if (runAttr != null && (urlStr = (String)runAttr.get(LINK_KEY)) != null && this.runsUnderMouse(this.runsForRange(this._clickedRange), event.x, event.y)) {
                    this._owner.linkWasSelected(this, this._clickedRange, urlStr);
                }
            }
            this._clickedRange = null;
        }
        if (!this.isSelectable()) {
            return;
        }
        if (this._upInfo == null || this._upInfo._absPosition == this._anchorInfo._absPosition) {
            this._selection.showInsertionPoint();
        }
        this._firstRange = null;
    }

    public int cursorForPoint(int x, int y) {
        Hashtable attr;
        TextStyleRun run;
        if (this.isEditable()) {
            return 2;
        }
        TextPositionInfo info = this.positionForPoint(x, y, true);
        if (info != null && (run = this._runForIndex(info._absPosition)) != null && (attr = run.attributes()) != null && attr.get(LINK_KEY) != null && this.runUnderMouse(run, x, y)) {
            return 12;
        }
        if (this.isSelectable()) {
            return 2;
        }
        return 0;
    }

    public void performCommand(String command, Object data) {
        if (command.equals("refreshBitmap")) {
            this.refreshBitmap(data);
        } else {
            if (command != null && command.equals("setFont")) {
                this.processSetFont((Font)data);
                return;
            }
            if (command.equals("cut")) {
                this.cut();
            } else if (command.equals("copy")) {
                this.copy();
            } else if (command.equals("paste")) {
                this.paste();
            } else if (!(data instanceof Timer)) {
                return;
            }
        }
        if (this._updateParagraph == null) {
            if (this._updateTimer != null) {
                this._updateTimer.stop();
                this._updateTimer = null;
            }
            return;
        }
        this._drawText = false;
        Rect updateRect = this._updateParagraph.rectForLine(this._updateLine);
        this.draw(updateRect);
        TextView.returnRect(updateRect);
        this._drawText = true;
        ++this._updateLine;
        if (this._updateLine >= this._updateParagraph._breakCount) {
            if (!this._drawNextParagraph) {
                this._updateParagraph = null;
            } else {
                int index = this._paragraphVector.indexOfIdentical(this._updateParagraph) + 1;
                if (index == 0 || index >= this._paragraphVector.count()) {
                    this._updateParagraph = null;
                } else {
                    this._updateParagraph = (TextParagraph)this._paragraphVector.elementAt(index);
                    this._updateLine = 0;
                }
            }
        }
        if (this._updateParagraph == null && this._updateTimer != null) {
            this._updateTimer.stop();
            this._updateTimer = null;
        }
    }

    public boolean canPerformCommand(String command) {
        if (command.equals("setFont")) {
            return !this.usesSingleFont() && this.isEditable();
        }
        return command.equals("refreshBitmap") || command.equals("copy") || this.isEditable() && command.equals("cut") || this.isEditable() && command.equals("paste");
    }

    public void keyDown(KeyEvent event) {
        if (event.isPageUpKey()) {
            TextPositionInfo newPosition;
            Rect visibleRect = new Rect();
            this.computeVisibleRect(visibleRect);
            visibleRect.y -= visibleRect.height - 1;
            if (visibleRect.y < 0) {
                visibleRect.y = 0;
            }
            if ((newPosition = this.positionForPoint(visibleRect.x, visibleRect.y, true)) != null) {
                visibleRect.y = newPosition._y;
            }
            this.scrollRectToVisible(visibleRect);
            return;
        }
        if (event.isPageDownKey()) {
            TextPositionInfo newPosition;
            Rect visibleRect = new Rect();
            this.computeVisibleRect(visibleRect);
            TextPositionInfo currentPosition = this.positionForPoint(visibleRect.x, visibleRect.y, true);
            visibleRect.y += visibleRect.height - 1;
            if (visibleRect.y > this.bounds.height - visibleRect.height) {
                visibleRect.y = this.bounds.height - visibleRect.height;
            }
            if ((newPosition = this.positionForPoint(visibleRect.x, visibleRect.y, true)) != null) {
                visibleRect.y = newPosition._y;
                if (currentPosition != null && currentPosition._absPosition == newPosition._absPosition) {
                    visibleRect.y += newPosition._lineHeight;
                }
            }
            this.scrollRectToVisible(visibleRect);
            return;
        }
        if (!this.isEditable()) {
            return;
        }
        if (!this.hasSelection()) {
            return;
        }
        if (this._filter != null) {
            if (this._filter.acceptsEvent(this, event, this._eventVector)) {
                this._eventVector.addElement(event);
            }
        } else {
            this._eventVector.addElement(event);
        }
        this.application().eventLoop().filterEvents(this);
        while (!this._eventVector.isEmpty()) {
            this._keyDown();
        }
    }

    public DragDestination acceptsDrag(DragSession session, int x, int y) {
        String type = session.dataType();
        if (this.isEditable() && this.hasSelection() && ("netscape.application.Color".equals(type) || "netscape.application.Image".equals(type))) {
            return this;
        }
        return null;
    }

    public boolean dragEntered(DragSession session) {
        return true;
    }

    public boolean dragMoved(DragSession session) {
        return true;
    }

    public void dragExited(DragSession session) {
    }

    public boolean dragDropped(DragSession session) {
        if (!this.isEditable() || !this.hasSelection()) {
            return false;
        }
        Object dragItem = session.data();
        if (dragItem == null) {
            return false;
        }
        if (dragItem instanceof Color) {
            Range r = this.selectedRange();
            if (r.length > 0) {
                this.addAttributeForRange(TEXT_COLOR_KEY, dragItem, r);
            } else {
                this.addTypingAttribute(TEXT_COLOR_KEY, dragItem);
            }
            return true;
        }
        if (dragItem instanceof Image) {
            this.replaceRangeWithTextAttachment(this.selectedRange(), new ImageAttachment((Image)dragItem));
            return true;
        }
        return false;
    }

    public void startFocus() {
        this._setEditing(true);
        this.showInsertionPoint();
        this._selection._startFlashing();
        if (this.isEditable() && this._owner != null) {
            this._owner.textEditingDidBegin(this);
        }
        if (this.hasSelection()) {
            Range r = this.selectedRange();
            if (r.length > 0) {
                this.dirtyRange(r);
                return;
            }
        } else {
            this.selectRange(new Range(0, 0));
        }
    }

    public void stopFocus() {
        this._selection._stopFlashing();
        this.hideInsertionPoint();
        this._setEditing(false);
        if (this.isEditable() && this._owner != null) {
            this._owner.textEditingDidEnd(this);
        }
        if (this.hasSelection()) {
            Range r = this.selectedRange();
            if (r.length > 0) {
                this.dirtyRange(r);
            }
        }
    }

    public void pauseFocus() {
        this._selection._stopFlashing();
        this.hideInsertionPoint();
    }

    public void resumeFocus() {
        this.showInsertionPoint();
        this._selection._startFlashing();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int c = this._paragraphVector.count();
        while (i < c) {
            sb.append(this._paragraphVector.elementAt(i).toString());
            ++i;
        }
        return sb.toString();
    }

    public void setFilter(TextFilter aFilter) {
        this._filter = aFilter;
    }

    public TextFilter filter() {
        return this._filter;
    }

    public void setOwner(TextViewOwner owner) {
        this._owner = owner;
    }

    public TextViewOwner owner() {
        return this._owner;
    }

    public void disableResizing() {
        ++this._resizeDisabled;
    }

    public void enableResizing() {
        --this._resizeDisabled;
        if (this._resizeDisabled < 0) {
            this._resizeDisabled = 0;
        }
    }

    public boolean isResizingEnabled() {
        return this._resizeDisabled == 0;
    }

    public void sizeToMinSize() {
        this.sizeBy(0, this.adjustCharCountsAndSpacing() - this.bounds.height);
    }

    public void scrollRangeToVisible(Range aRange) {
        if (aRange.index == 0 && aRange.length == 0) {
            this.scrollRectToVisible(new Rect(0, 0, 1, 1));
            return;
        }
        if (aRange.index >= this.length()) {
            this.scrollRectToVisible(new Rect(this.width() - 1, this.height() - 1, 1, 1));
            return;
        }
        if (aRange.length == 0) {
            TextPositionInfo top = this.positionInfoForIndex(aRange.index);
            this.scrollRectToVisible(new Rect(top._x, top._y + top._lineHeight, 1, top._lineHeight));
            return;
        }
        TextPositionInfo top = this.positionInfoForIndex(aRange.index);
        TextPositionInfo bottom = this.positionInfoForIndex(aRange.index + aRange.length);
        int y1 = top._y;
        int y2 = bottom._y + bottom._lineHeight;
        if (top._y == bottom._y) {
            this.scrollRectToVisible(new Rect(top._x, y1, bottom._x - top._x, y2 - y1));
            return;
        }
        this.scrollRectToVisible(new Rect(0, y1, this.width(), y2 - y1));
    }

    public void setUseSingleFont(boolean flag) {
        this._useSingleFont = flag;
    }

    public boolean usesSingleFont() {
        return this._useSingleFont;
    }

    public void setDefaultAttributes(Hashtable attributes) {
        this._defaultAttributes = attributes;
        if (attributes.get(FONT_KEY) != null) {
            this._defaultFontMetricsCache = null;
        }
        if (attributes.get(PARAGRAPH_FORMAT_KEY) == null) {
            TextParagraphFormat defaultFormat = new TextParagraphFormat();
            defaultFormat.setLeftMargin(3);
            defaultFormat.setRightMargin(3);
            defaultFormat.setJustification(0);
            this._defaultAttributes.put(PARAGRAPH_FORMAT_KEY, defaultFormat);
        }
        this.reformatAll();
        Range r = TextView.allocateRange(0, this.length());
        this.dirtyRange(r);
        TextView.recycleRange(r);
    }

    public Hashtable defaultAttributes() {
        return this._defaultAttributes;
    }

    public void addTypingAttribute(String key, Object value) {
        Hashtable tmp = new Hashtable();
        tmp.put(key, value);
        tmp = TextView.attributesByRemovingStaticAttributes(tmp);
        Enumeration keys = tmp.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            this._typingAttributes.put(k, tmp.get(k));
        }
    }

    public Hashtable typingAttributes() {
        return this._typingAttributes;
    }

    public void setTypingAttributes(Hashtable attr) {
        if (attr == null) {
            this._typingAttributes = new Hashtable();
            return;
        }
        this._typingAttributes = TextView.attributesByRemovingStaticAttributes(attr);
    }

    public void setBackgroundColor(Color aColor) {
        if (aColor != null) {
            this._backgroundColor = aColor;
        }
    }

    public Color backgroundColor() {
        return this._backgroundColor;
    }

    public void setSelectionColor(Color aColor) {
        if (aColor != null) {
            this._selectionColor = aColor;
        }
    }

    public Color selectionColor() {
        return this._selectionColor;
    }

    public void setEditable(boolean flag) {
        if (this._editable != flag) {
            this._editable = flag;
            this.setSelectable(true);
        }
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setSelectable(boolean flag) {
        if (this._selectable != flag) {
            this._selectable = flag;
            RootView rootView = this.rootView();
            if (rootView != null) {
                rootView.updateCursor();
            }
        }
    }

    public boolean isSelectable() {
        return this._selectable;
    }

    public void setFont(Font aFont) {
        if (aFont == null) {
            return;
        }
        this.addDefaultAttribute(FONT_KEY, aFont);
    }

    public Font font() {
        return (Font)this._defaultAttributes.get(FONT_KEY);
    }

    public void setTextColor(Color aColor) {
        if (aColor != null) {
            this.addDefaultAttribute(TEXT_COLOR_KEY, aColor);
        }
    }

    public Color textColor() {
        Color res = (Color)this._defaultAttributes.get(TEXT_COLOR_KEY);
        if (res == null) {
            return Color.black;
        }
        return res;
    }

    public void setCaretColor(Color aColor) {
        if (aColor != null) {
            this.addDefaultAttribute(CARET_COLOR_KEY, aColor);
        }
    }

    public Color caretColor() {
        Color res = (Color)this._defaultAttributes.get(CARET_COLOR_KEY);
        if (res == null) {
            return Color.black;
        }
        return res;
    }

    public void replaceRangeWithString(Range r, String aString) {
        boolean insertReturn = true;
        if (this._owner != null) {
            this._owner.textWillChange(this, r);
        }
        if (r.equals(new Range(0, this.length()))) {
            this.replaceContentWithString(aString);
            if (this._owner != null) {
                this._owner.textDidChange(this, new Range(0, this.length()));
            }
            return;
        }
        this.disableResizing();
        int paragraphIndex = this._paragraphIndexForIndex(r.index);
        this.deleteRange(r, null);
        if (aString == null || aString.equals("")) {
            this.enableResizing();
            if (paragraphIndex > 0) {
                this.sizeBy(0, this.adjustCharCountsAndSpacing(paragraphIndex - 1) - this.bounds.height);
            } else {
                this.sizeToMinSize();
            }
            if (this._owner != null) {
                this._owner.textDidChange(this, new Range(r.index, 0));
            }
            return;
        }
        this.disableAttachmentNotification();
        int insertionPoint = r.index;
        int start = 0;
        int end = aString.indexOf(10);
        if (end == -1) {
            this.insertString(aString, insertionPoint);
            this.enableResizing();
            if (paragraphIndex > 0) {
                this.sizeBy(0, this.adjustCharCountsAndSpacing(paragraphIndex - 1) - this.bounds.height);
            } else {
                this.sizeToMinSize();
            }
            this.enableAttachmentNotification();
            if (this._owner != null) {
                this._owner.textDidChange(this, new Range(r.index, aString.length()));
            }
            return;
        }
        this.insertString(aString.substring(start, end), insertionPoint, true);
        this.insertReturn(insertionPoint + (end - start));
        insertionPoint += end - start + 1;
        int lastIndex = aString.length() - 1;
        while (end < lastIndex) {
            start = end + 1;
            if ((end = aString.indexOf(10, start)) == -1) {
                end = lastIndex + 1;
                insertReturn = false;
            }
            if (end > start) {
                String subString = aString.substring(start, end);
                this.insertString(subString, insertionPoint, true);
                if (insertReturn) {
                    this.insertReturn(insertionPoint + (end - start));
                }
                insertionPoint += end - start + 1;
                continue;
            }
            this.insertReturn(insertionPoint);
            ++insertionPoint;
        }
        this.enableResizing();
        if (paragraphIndex > 0) {
            this.sizeBy(0, this.adjustCharCountsAndSpacing(paragraphIndex - 1) - this.bounds.height);
        } else {
            this.sizeToMinSize();
        }
        this.enableAttachmentNotification();
        if (this._owner != null) {
            this._owner.textDidChange(this, new Range(r.index, aString.length()));
        }
    }

    public String stringForRange(Range r) {
        TextParagraph leftP = this._paragraphForIndex(r.index);
        TextParagraph rightP = this._paragraphForIndex(r.index + r.length);
        if (leftP == null) {
            return null;
        }
        if (rightP == null) {
            rightP = this.lastParagraph();
        }
        if (leftP == rightP) {
            return leftP.stringForRange(r);
        }
        StringBuffer sb = new StringBuffer();
        Range intersection = TextView.allocateRange();
        int i = this._paragraphVector.indexOfIdentical(leftP);
        int c = this._paragraphVector.indexOfIdentical(rightP);
        while (i <= c) {
            intersection.index = r.index;
            intersection.length = r.length;
            TextParagraph p = (TextParagraph)this._paragraphVector.elementAt(i);
            intersection.intersectWith(p.range());
            sb.append(p.stringForRange(intersection));
            ++i;
        }
        TextView.recycleRange(intersection);
        return sb.toString();
    }

    public void setAttributesForRange(Hashtable attributes, Range r) {
        Range paragraphsRange = this.paragraphsRangeForRange(r);
        int i = paragraphsRange.index;
        int c = paragraphsRange.index + paragraphsRange.length;
        while (i < c) {
            ((TextParagraph)this._paragraphVector.elementAt(i)).setFormat(null);
            ++i;
        }
        Vector runsVector = this.createAndReturnRunsForRange(r);
        i = 0;
        c = runsVector.count();
        while (i < c) {
            TextStyleRun run = (TextStyleRun)runsVector.elementAt(i);
            run.setAttributes(null);
            ++i;
        }
        this.addAttributesForRange(attributes, r);
    }

    public Hashtable attributesAtIndex(int anIndex) {
        TextStyleRun r = this._runForIndex(anIndex);
        TextParagraph p = this._paragraphForIndex(anIndex);
        if (r != null && p != null) {
            Hashtable attr = r.attributes();
            if (attr == null) {
                TextParagraphFormat f = p.format();
                if (f == null) {
                    return this._defaultAttributes;
                }
                Hashtable h = (Hashtable)this._defaultAttributes.clone();
                h.put(PARAGRAPH_FORMAT_KEY, f);
                return h;
            }
            TextParagraphFormat f = p.format();
            Hashtable h = (Hashtable)attr.clone();
            if (f != null) {
                h.put(PARAGRAPH_FORMAT_KEY, f);
            } else {
                h.put(PARAGRAPH_FORMAT_KEY, this._defaultAttributes.get(PARAGRAPH_FORMAT_KEY));
            }
            return h;
        }
        return this._defaultAttributes;
    }

    public int length() {
        return this._charCount - 1;
    }

    public String string() {
        Range r = TextView.allocateRange(0, this.length());
        String result = this.stringForRange(r);
        TextView.recycleRange(r);
        return result;
    }

    public void setString(String textString) {
        Range r = TextView.allocateRange(0, this.length());
        this.replaceRangeWithString(r, textString);
        TextView.recycleRange(r);
    }

    public Range appendString(String aString) {
        Range r = TextView.allocateRange(this.length(), 0);
        this.replaceRangeWithString(r, aString);
        r.length = aString.length();
        return r;
    }

    public void replaceRangeWithTextAttachment(Range r, TextAttachment aTextAttachment) {
        this.replaceRangeWithString(r, TEXT_ATTACHMENT_STRING);
        Hashtable h = new Hashtable();
        h.put(TEXT_ATTACHMENT_KEY, aTextAttachment);
        Range r2 = TextView.allocateRange(r.index, 1);
        this.addAttributesForRange(h, r2);
        TextView.recycleRange(r2);
    }

    public void addAttributesForRange(Hashtable attributes, Range range) {
        if (this._owner != null) {
            this._owner.attributesWillChange(this, range);
        }
        this.addAttributesForRangeWithoutNotification(attributes, range);
        if (this._owner != null) {
            this._owner.attributesDidChange(this, range);
        }
    }

    public void addAttributeForRange(String attribute, Object value, Range range) {
        Hashtable h = new Hashtable();
        h.put(attribute, value);
        this.addAttributesForRange(h, range);
    }

    public void removeAttributeForRange(String attribute, Range r) {
        Vector runVector = this.runsForRange(r);
        Range effectiveRange = TextView.allocateRange();
        int i = 0;
        int c = runVector.count();
        while (i < c) {
            Range rr = (Range)runVector.elementAt(i);
            TextStyleRun run = this._runForIndex(rr.index);
            Hashtable attr = run.attributes();
            if (attr != null && attr.get(attribute) != null) {
                Hashtable newAttr = (Hashtable)attr.clone();
                newAttr.remove(attribute);
                effectiveRange.index = r.index;
                effectiveRange.length = r.length;
                effectiveRange.intersectWith(rr);
                this.setAttributesForRange(newAttr, effectiveRange);
            }
            ++i;
        }
    }

    public void addDefaultAttribute(String attribute, Object value) {
        Hashtable defAttr = this.defaultAttributes();
        defAttr.put(attribute, value);
        this.setDefaultAttributes(defAttr);
    }

    public Vector runsForRange(Range aRange) {
        int c;
        TextStyleRun endRun;
        Vector result = new Vector();
        boolean sameParagraph = false;
        if (aRange.length == 0) {
            Range r = this.runForIndex(aRange.index);
            if (!r.isNullRange()) {
                result.addElement(r);
            }
            return result;
        }
        TextStyleRun startRun = this._runForIndex(aRange.index);
        if (startRun == null) {
            startRun = this._runForIndex(0);
        }
        if ((endRun = this._runForIndex(aRange.index + aRange.length() - 1)) == null) {
            endRun = this._runForIndex(this.length() - 1);
        }
        Vector runs = startRun.paragraph().runVector();
        if (startRun.paragraph() == endRun.paragraph()) {
            c = runs.indexOfIdentical(endRun) + 1;
            sameParagraph = true;
        } else {
            c = runs.count();
            sameParagraph = false;
        }
        int i = runs.indexOfIdentical(startRun);
        while (i < c) {
            result.addElement(((TextStyleRun)runs.elementAt(i)).range());
            ++i;
        }
        if (!sameParagraph) {
            i = this._paragraphVector.indexOfIdentical(startRun.paragraph()) + 1;
            c = this._paragraphVector.indexOfIdentical(endRun.paragraph());
            while (i < c) {
                runs = ((TextParagraph)this._paragraphVector.elementAt(i)).runVector();
                int j = 0;
                int d = runs.count();
                while (j < d) {
                    result.addElement(((TextStyleRun)runs.elementAt(j)).range());
                    ++j;
                }
                ++i;
            }
            runs = endRun.paragraph().runVector();
            i = 0;
            c = runs.indexOfIdentical(endRun);
            while (i <= c) {
                result.addElement(((TextStyleRun)runs.elementAt(i)).range());
                ++i;
            }
        }
        return result;
    }

    public Vector paragraphsForRange(Range aRange) {
        Range pr = this.paragraphsRangeForRange(aRange);
        Vector result = new Vector();
        int i = pr.index;
        int c = pr.index + pr.length;
        while (i < c) {
            Range r = ((TextParagraph)this._paragraphVector.elementAt(i)).range();
            if (i == c - 1) {
                --r.length;
            }
            result.addElement(r);
            ++i;
        }
        return result;
    }

    public Range runForIndex(int anIndex) {
        TextStyleRun run = this._runForIndex(anIndex);
        if (run == null) {
            return TextView.allocateRange();
        }
        return run.range();
    }

    public Range paragraphForIndex(int anIndex) {
        Range pr = TextView.allocateRange(anIndex, 0);
        Vector v = this.paragraphsForRange(pr);
        TextView.recycleRange(pr);
        if (v.count() > 0) {
            return (Range)v.elementAt(0);
        }
        return TextView.allocateRange();
    }

    public Range paragraphForPoint(int x, int y) {
        TextParagraph p = this._paragraphForPoint(x, y);
        if (p != null) {
            return p.range();
        }
        return TextView.allocateRange();
    }

    public Range runForPoint(int x, int y) {
        TextStyleRun run;
        TextPositionInfo info = this.positionForPoint(x, y, true);
        if (info != null && (run = this._runForIndex(info._absPosition)) != null) {
            return run.range();
        }
        return TextView.allocateRange();
    }

    public int indexForPoint(int x, int y) {
        TextPositionInfo info = this.positionForPoint(x, y, true);
        if (info != null) {
            return info._absPosition;
        }
        return -1;
    }

    public Vector rectsForRange(Range aRange) {
        return this.rectsForRange(aRange, null);
    }

    public Range selectedRange() {
        if (this._selectedRange == null) {
            this._selectedRange = TextView.allocateRange();
        }
        this._selectedRange.index = this._selection.selectionStart();
        if (this._selectedRange.index < 0) {
            return TextView.allocateRange();
        }
        this._selectedRange.length = this._selection.selectionEnd() - this._selection.selectionStart();
        return this._selectedRange;
    }

    public void selectRange(Range aRange) {
        if (aRange.isNullRange()) {
            this._selection.clearRange();
        } else {
            this._selection.setRange(aRange.index(), aRange.lastIndex() + 1);
        }
        this._selectionChanged();
    }

    public boolean hasSelection() {
        Range r = this.selectedRange();
        return !r.isNullRange();
    }

    public void insertHTMLElementsInRange(Vector components, Range aRange, Hashtable attributes) {
        int[] lengths = new int[components.count()];
        int offset = 0;
        int length = 0;
        Hashtable context = new Hashtable();
        FastStringBuffer fb = new FastStringBuffer();
        if (attributes == null) {
            attributes = this.defaultAttributes();
        }
        Hashtable initialAttributes = TextView.attributesByRemovingStaticAttributes(attributes);
        this.setDirty(true);
        this.disableResizing();
        fb.setDoublesCapacityWhenGrowing(true);
        int i = 0;
        int c = components.count();
        while (i < c) {
            ((TextViewHTMLElement)components.elementAt(i)).appendString(context, fb);
            if (i == 0) {
                length = lengths[0] = fb.length();
            } else {
                lengths[i] = fb.length() - length;
                length += lengths[i];
            }
            ++i;
        }
        this.replaceRangeWithString(aRange, fb.toString());
        this.disableFormatting();
        i = 0;
        c = components.count();
        while (i < c) {
            ((TextViewHTMLElement)components.elementAt(i)).setAttributesStartingAt(aRange.index + offset, initialAttributes, this, context);
            offset += lengths[i];
            ++i;
        }
        this.enableFormatting();
        this.reformatAll();
        this.enableResizing();
        this.sizeToMinSize();
    }

    public void importHTMLInRange(InputStream inputStream, Range aRange, URL baseURL) throws IOException, HTMLParsingException {
        this.importHTMLInRange(inputStream, aRange, baseURL, this.defaultAttributes());
    }

    public void importHTMLInRange(InputStream inputStream, Range aRange, URL baseURL, Hashtable attributes) throws IOException, HTMLParsingException {
        Vector components = new Vector();
        this.validateHTMLParsingRules();
        HTMLParser parser = new HTMLParser(inputStream, this._htmlParsingRules);
        try {
            HTMLElement component;
            while ((component = parser.nextHTMLElement()) != null) {
                components.addElement(component);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new InconsistencyException("Cannot intantiate HTML storage");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InconsistencyException("Cannot access HTML storage classes");
        }
        this.setBaseURL(baseURL);
        this.insertHTMLElementsInRange(components, aRange, attributes);
    }

    public void importHTMLFromURLString(String urlString) {
        Range r = TextView.allocateRange(0, this.length());
        try {
            URL url = new URL(urlString);
            InputStream in = url.openStream();
            this.importHTMLInRange(in, r, url, this.defaultAttributes());
            r.index = 0;
            r.length = 0;
            this.selectRange(r);
            this.scrollRangeToVisible(r);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad URL " + urlString);
        }
        catch (IOException iOException) {
            System.err.println("IOException while reading " + urlString);
        }
        catch (HTMLParsingException e) {
            System.err.println("At line " + e.lineNumber() + ":" + e);
        }
        TextView.recycleRange(r);
    }

    public void setHTMLParsingRules(HTMLParsingRules newRules) {
        this._htmlParsingRules = newRules;
    }

    public HTMLParsingRules htmlParsingRules() {
        this.validateHTMLParsingRules();
        return this._htmlParsingRules;
    }

    public Range runWithLinkDestinationNamed(String aName) {
        TextStyleRun run = null;
        Range result = null;
        int i = 0;
        int c = this._paragraphVector.count();
        while (i < c) {
            TextParagraph paragraph = (TextParagraph)this._paragraphVector.elementAt(i);
            int j = 0;
            int d = paragraph._runVector.count();
            while (j < d) {
                String name;
                run = (TextStyleRun)paragraph._runVector.elementAt(j);
                if (run._attributes != null && (name = (String)run._attributes.get(LINK_DESTINATION_KEY)) != null && name.equals(aName)) {
                    result = run.range();
                    break;
                }
                ++j;
            }
            if (result != null) break;
            ++i;
        }
        if (result == null) {
            return new Range();
        }
        if (run != null) {
            Range initialResult = result;
            while (result.length == 0) {
                if ((run = this.runAfter(run)) != null) {
                    result = run.range();
                    continue;
                }
                result = initialResult;
                break;
            }
        }
        return result;
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.TextView", 2);
        info.addField(PARAGRAPHVECTOR_KEY, (byte)18);
        info.addField(BACKGROUNDCOLOR_KEY, (byte)18);
        info.addField(SELECTIONCOLOR_KEY, (byte)18);
        info.addField(FILTER_KEY, (byte)18);
        info.addField(DEFAULTATTRIBUTES_KEY, (byte)18);
        info.addField(PARASPACING_KEY, (byte)8);
        info.addField(USESINGLEFONT_KEY, (byte)0);
        info.addField(EDITABLE_KEY, (byte)0);
        info.addField(SELECTABLE_KEY, (byte)0);
        info.addField(TRANSPARENT_KEY, (byte)0);
        info.addField(HTML_PARSING_RULES_KEY, (byte)18);
        info.addField(OWNER_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(PARAGRAPHVECTOR_KEY, this._paragraphVector);
        encoder.encodeObject(BACKGROUNDCOLOR_KEY, this._backgroundColor);
        encoder.encodeObject(SELECTIONCOLOR_KEY, this._selectionColor);
        encoder.encodeObject(FILTER_KEY, (Codable)((Object)this._filter));
        encoder.encodeObject(DEFAULTATTRIBUTES_KEY, this._defaultAttributes);
        encoder.encodeInt(PARASPACING_KEY, this._paragraphSpacing);
        encoder.encodeBoolean(USESINGLEFONT_KEY, this._useSingleFont);
        encoder.encodeBoolean(EDITABLE_KEY, this._editable);
        encoder.encodeBoolean(SELECTABLE_KEY, this._selectable);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
        encoder.encodeObject(HTML_PARSING_RULES_KEY, this._htmlParsingRules);
        encoder.encodeObject(OWNER_KEY, this._owner);
    }

    public void decode(Decoder decoder) throws CodingException {
        int version = decoder.versionForClassName("netscape.application.TextView");
        super.decode(decoder);
        this._paragraphVector = (Vector)decoder.decodeObject(PARAGRAPHVECTOR_KEY);
        this._backgroundColor = (Color)decoder.decodeObject(BACKGROUNDCOLOR_KEY);
        this._selectionColor = (Color)decoder.decodeObject(SELECTIONCOLOR_KEY);
        this._filter = (TextFilter)decoder.decodeObject(FILTER_KEY);
        this._defaultAttributes = (Hashtable)decoder.decodeObject(DEFAULTATTRIBUTES_KEY);
        this._paragraphSpacing = decoder.decodeInt(PARASPACING_KEY);
        this._useSingleFont = decoder.decodeBoolean(USESINGLEFONT_KEY);
        this._editable = decoder.decodeBoolean(EDITABLE_KEY);
        this._selectable = decoder.decodeBoolean(SELECTABLE_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
        if (version >= 2) {
            this._htmlParsingRules = (HTMLParsingRules)decoder.decodeObject(HTML_PARSING_RULES_KEY);
            this._owner = (TextViewOwner)decoder.decodeObject(OWNER_KEY);
        }
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
        this._defaultFontMetricsCache = null;
        int i = this._paragraphVector.count();
        while (i-- > 0) {
            TextParagraph nextParagraph = (TextParagraph)this._paragraphVector.elementAt(i);
            nextParagraph.setOwner(this);
        }
        this.reformatAll();
    }

    public int lineCount() {
        int result = 0;
        int i = 0;
        int c = this._paragraphVector.count();
        while (i < c) {
            TextParagraph p = (TextParagraph)this._paragraphVector.elementAt(i);
            result += p.lineCount();
            ++i;
        }
        return result;
    }

    public URL baseURL() {
        return this._baseURL;
    }

    public boolean canBecomeSelectedView() {
        return this.isEditable() || this.isSelectable();
    }

    public void willBecomeSelected() {
        this.setFocusedView();
    }

    public static String stringWithoutCarriageReturns(String aString) {
        FastStringBuffer sb = new FastStringBuffer();
        int i = 0;
        int c = aString.length();
        while (i < c) {
            char ch = aString.charAt(i);
            if (ch != '\r' || i + 1 >= c || aString.charAt(i + 1) != '\n') {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    FontMetrics defaultFontMetrics() {
        if (this._defaultFontMetricsCache == null) {
            this._defaultFontMetricsCache = this.font().fontMetrics();
        }
        return this._defaultFontMetricsCache;
    }

    static Hashtable attributesByRemovingStaticAttributes(Hashtable attributes) {
        if (attributes == null) {
            return null;
        }
        Hashtable h = (Hashtable)attributes.clone();
        h.remove(TEXT_ATTACHMENT_KEY);
        h.remove(TEXT_ATTACHMENT_BASELINE_OFFSET_KEY);
        return h;
    }

    private void addParagraph(TextParagraph aParagraph) {
        if (aParagraph == null) {
            return;
        }
        aParagraph.setOwner(this);
        this._paragraphVector.addElement(aParagraph);
    }

    synchronized void _setEditing(boolean flag) {
        this._editing = flag;
    }

    synchronized boolean isEditing() {
        return this._editing;
    }

    private void reformatAll() {
        Range wasSelectedRange = this.selectedRange();
        int currentHeight = 0;
        this._charCount = 0;
        int count = this._paragraphVector.count();
        if (!this.formattingEnabled()) {
            return;
        }
        int i = 0;
        while (i < count) {
            TextParagraph nextParagraph = (TextParagraph)this._paragraphVector.elementAt(i);
            nextParagraph._y = currentHeight;
            nextParagraph._startChar = this._charCount;
            nextParagraph.computeLineBreaksAndHeights(this.bounds.width);
            currentHeight += nextParagraph._height + this._paragraphSpacing;
            this._charCount += nextParagraph._charCount;
            ++i;
        }
        this.sizeBy(0, currentHeight - this.bounds.height);
        this.notifyAttachmentsForRange(new Range(0, this.length()), true);
        this.selectRange(wasSelectedRange);
    }

    void disableFormatting() {
        ++this._formattingDisabled;
    }

    void enableFormatting() {
        --this._formattingDisabled;
        if (this._formattingDisabled < 0) {
            this._formattingDisabled = 0;
        }
    }

    boolean formattingEnabled() {
        return this._formattingDisabled == 0;
    }

    private void formatParagraphAtIndex(int pIndex) {
        TextParagraph nextParagraph;
        int currentHeight;
        Range changedRange = new Range();
        if (!this.formattingEnabled()) {
            return;
        }
        if (pIndex == -1) {
            return;
        }
        TextParagraph aParagraph = (TextParagraph)this._paragraphVector.elementAt(pIndex);
        int index = pIndex - 1;
        if (index < -1) {
            return;
        }
        if (index == -1) {
            this._charCount = 0;
            currentHeight = 0;
        } else {
            nextParagraph = (TextParagraph)this._paragraphVector.elementAt(index);
            this._charCount = nextParagraph._startChar + nextParagraph._charCount;
            currentHeight = nextParagraph._y + nextParagraph._height + this._paragraphSpacing;
        }
        aParagraph.setY(currentHeight);
        aParagraph.setStartChar(this._charCount);
        aParagraph.computeLineBreaksAndHeights(this.bounds.width);
        this._charCount += aParagraph._charCount;
        currentHeight += aParagraph._height + this._paragraphSpacing;
        int count = this._paragraphVector.count();
        int i = pIndex + 1;
        while (i < count) {
            nextParagraph = (TextParagraph)this._paragraphVector.elementAt(i);
            nextParagraph.setY(currentHeight);
            nextParagraph.setStartChar(this._charCount);
            currentHeight += nextParagraph._height + this._paragraphSpacing;
            this._charCount += nextParagraph._charCount;
            ++i;
        }
        changedRange.index = aParagraph._startChar;
        changedRange.unionWith(this.lastParagraph().range());
        this.sizeBy(0, currentHeight - this.bounds.height);
        this.notifyAttachmentsForRange(changedRange, true);
    }

    private void formatParagraph(TextParagraph aParagraph) {
        this.formatParagraphAtIndex(this._paragraphVector.indexOfIdentical(aParagraph));
    }

    private int adjustCharCountsAndSpacing(int pIndex) {
        TextParagraph nextParagraph;
        this._charCount = 0;
        int currentHeight = 0;
        if (pIndex > 0) {
            nextParagraph = (TextParagraph)this._paragraphVector.elementAt(pIndex - 1);
            currentHeight = nextParagraph._y + nextParagraph._height + this._paragraphSpacing;
            this._charCount = nextParagraph._startChar + nextParagraph._charCount;
        }
        int count = this._paragraphVector.count();
        int i = pIndex;
        while (i < count) {
            nextParagraph = (TextParagraph)this._paragraphVector.elementAt(i);
            nextParagraph._y = currentHeight;
            nextParagraph._startChar = this._charCount;
            currentHeight += nextParagraph._height + this._paragraphSpacing;
            this._charCount += nextParagraph._charCount;
            ++i;
        }
        return currentHeight;
    }

    private int adjustCharCountsAndSpacing() {
        return this.adjustCharCountsAndSpacing(0);
    }

    int _paragraphIndexForIndex(int absPosition) {
        int count = this._paragraphVector.count();
        if (absPosition > this.length() / 2) {
            int i = count - 1;
            while (i >= 0) {
                TextParagraph nextParagraph = (TextParagraph)this._paragraphVector.elementAt(i);
                if (absPosition >= nextParagraph._startChar && absPosition < nextParagraph._startChar + nextParagraph._charCount) {
                    return i;
                }
                --i;
            }
        } else {
            int i = 0;
            while (i < count) {
                TextParagraph nextParagraph = (TextParagraph)this._paragraphVector.elementAt(i);
                if (absPosition >= nextParagraph._startChar && absPosition < nextParagraph._startChar + nextParagraph._charCount) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    TextParagraph _paragraphForIndex(int absPosition) {
        int p = this._paragraphIndexForIndex(absPosition);
        if (p != -1) {
            return (TextParagraph)this._paragraphVector.elementAt(p);
        }
        return null;
    }

    private TextParagraph _paragraphForPoint(int x, int y) {
        if (y < 0) {
            y = 0;
            x = 0;
        }
        int count = this._paragraphVector.count();
        int minY = 0;
        int i = 0;
        while (i < count) {
            TextParagraph nextParagraph = (TextParagraph)this._paragraphVector.elementAt(i);
            int maxY = minY + nextParagraph._height;
            if (y >= minY && y < maxY) {
                return nextParagraph;
            }
            minY = maxY;
            ++i;
        }
        return null;
    }

    TextPositionInfo positionInfoForIndex(int index) {
        TextParagraph p = this._paragraphForIndex(index);
        if (p == null) {
            p = this.lastParagraph();
        }
        return p._infoForPosition(index);
    }

    private TextPositionInfo positionForPoint(int x, int y, boolean absolute) {
        TextParagraph theParagraph;
        if (y < 0) {
            y = 0;
            x = 0;
        }
        if ((theParagraph = this._paragraphForPoint(x, y)) == null) {
            if (this._charCount == 0) {
                return this.lastParagraph().infoForPosition(this._charCount, y);
            }
            return this.lastParagraph().infoForPosition(this._charCount - 1, y);
        }
        return theParagraph.positionForPoint(x, y, absolute);
    }

    void drawInsertionPoint() {
        Rect tmpRect = this._selection.insertionPointRect();
        this.addDirtyRect(tmpRect);
        TextView.returnRect(tmpRect);
    }

    private void insertString(String aString, int insertionPoint) {
        this.insertString(aString, insertionPoint, false);
    }

    private void insertString(String aString, int insertionPoint, boolean formatParagraph) {
        int insertCount = 0;
        if (aString == null) {
            return;
        }
        int paragraphIndex = this._paragraphIndexForIndex(insertionPoint);
        if (paragraphIndex == -1) {
            return;
        }
        TextParagraph editParagraph = (TextParagraph)this._paragraphVector.elementAt(paragraphIndex);
        if (editParagraph == null) {
            return;
        }
        TextParagraph lastParagraph = this.lastParagraph();
        if (lastParagraph != null) {
            int oldHeight = lastParagraph._y + lastParagraph._height;
        } else {
            boolean oldHeight = false;
        }
        TextPositionInfo insertionPointInfo = this.positionInfoForIndex(insertionPoint);
        if (insertionPointInfo == null) {
            insertionPointInfo = editParagraph.infoForPosition(insertionPoint, -1);
        }
        TextPositionInfo newPosition = editParagraph.insertCharOrStringAt('\u0000', aString, insertionPoint);
        insertCount = aString.length();
        this._charCount += insertCount;
        if (newPosition == null) {
            this._selection.showInsertionPoint();
            return;
        }
        if (this.isDirty() && this.dirtyRect == null) {
            Range r = new Range(editParagraph._startChar, this.length() - editParagraph._startChar);
            this.notifyAttachmentsForRange(r, true);
            return;
        }
        if (formatParagraph) {
            this.formatParagraphAtIndex(paragraphIndex);
        }
        newPosition.setAbsPosition(insertionPoint + insertCount);
        TextParagraphFormat format = editParagraph.currentParagraphFormat();
        if (newPosition._redrawCurrentLineOnly && format._justification == 0) {
            TextParagraph oldUpdate = this._updateParagraph;
            int oldLine = this._updateLine;
            this._updateParagraph = editParagraph;
            this._updateLine = newPosition._updateLine;
            this._drawText = false;
            Rect updateRect = editParagraph.rectForLine(newPosition._lineNumber);
            updateRect.setBounds(insertionPointInfo._x, updateRect.y, updateRect.width - (insertionPointInfo._x - updateRect.x), updateRect.height);
            this.addDirtyRect(updateRect);
            TextView.returnRect(updateRect);
            this._drawText = true;
            this._updateParagraph = oldUpdate;
            this._updateLine = oldLine;
            this.notifyAttachmentsForRange(newPosition.lineRange(), true);
            return;
        }
        if (newPosition._redrawCurrentParagraphOnly || newPosition._redrawCurrentLineOnly) {
            Range r = editParagraph.range();
            this.notifyAttachmentsForRange(r, true);
            this.dirtyRange(r);
            return;
        }
        Range r = new Range(editParagraph._startChar, this.length() - editParagraph._startChar);
        this.notifyAttachmentsForRange(r, true);
        this.dirtyRange(r);
    }

    private void fastDeleteChar(boolean after) {
        TextPositionInfo newPosition;
        TextParagraph editParagraph;
        if (!this.isEditing()) {
            return;
        }
        int insertionPoint = this._selection.insertionPoint();
        if (!after && insertionPoint == 0) {
            return;
        }
        if (after && insertionPoint == this.length()) {
            return;
        }
        if (after) {
            ++insertionPoint;
        }
        if ((editParagraph = this._paragraphForIndex(insertionPoint)) == null) {
            return;
        }
        this.notifyAttachmentsForRange(new Range(insertionPoint, 1), false);
        TextParagraph lastParagraph = this.lastParagraph();
        if (lastParagraph != null) {
            int oldHeight = lastParagraph._y + lastParagraph._height;
        } else {
            boolean oldHeight = false;
        }
        if (editParagraph._startChar == insertionPoint && !this.isOnlyParagraph(editParagraph)) {
            int index = this._paragraphVector.indexOfIdentical(editParagraph);
            TextParagraph previousParagraph = (TextParagraph)this._paragraphVector.elementAt(index - 1);
            if (previousParagraph != null) {
                previousParagraph.subsumeParagraph(editParagraph);
                this._paragraphVector.removeElement(editParagraph);
                editParagraph = previousParagraph;
                this.formatParagraph(editParagraph);
            }
            newPosition = insertionPoint == 0 ? editParagraph.infoForPosition(0, -1) : editParagraph.infoForPosition(insertionPoint - 1, -1);
        } else {
            newPosition = editParagraph.removeCharAt(insertionPoint);
            --this._charCount;
        }
        TextPositionInfo insertionPointInfo = newPosition;
        int newHeight = this.adjustCharCountsAndSpacing();
        this.sizeBy(0, newHeight - this.bounds.height);
        if (newPosition == null) {
            this._selection.showInsertionPoint();
            return;
        }
        this.notifyAttachmentsForRange(newPosition._textRun._paragraph.range(), true);
        if (!after) {
            if (insertionPoint == 0) {
                newPosition.setAbsPosition(0);
            } else {
                newPosition.setAbsPosition(insertionPoint - 1);
            }
            this._selection.setInsertionPoint(newPosition);
            this._selectionChanged();
        } else {
            this._selection.setInsertionPoint(newPosition);
        }
        TextParagraphFormat format = editParagraph.currentParagraphFormat();
        if (newPosition._redrawCurrentLineOnly && format._justification == 0) {
            TextParagraph oldUpdate = this._updateParagraph;
            int oldLine = this._updateLine;
            this._updateParagraph = editParagraph;
            this._updateLine = newPosition._updateLine;
            this._drawText = false;
            Rect updateRect = editParagraph.rectForLine(newPosition._lineNumber);
            updateRect.setBounds(insertionPointInfo._x, updateRect.y, updateRect.width - (insertionPointInfo._x - updateRect.x), updateRect.height);
            this.addDirtyRect(updateRect);
            TextView.returnRect(updateRect);
            this._drawText = true;
            this._updateParagraph = oldUpdate;
            this._updateLine = oldLine;
            return;
        }
        if (newPosition._redrawCurrentParagraphOnly || newPosition._redrawCurrentLineOnly) {
            this.dirtyRange(editParagraph.range());
            return;
        }
        Range dirtyRange = TextView.allocateRange(editParagraph._startChar, this.length() - editParagraph._startChar);
        this.dirtyRange(dirtyRange);
        TextView.recycleRange(dirtyRange);
    }

    private Rect insertReturn() {
        if (this._selection.isARange()) {
            this.deleteSelection();
        }
        int insertionPoint = this._selection.insertionPoint();
        Rect result = this.insertReturn(insertionPoint);
        this._selection.setRange(insertionPoint + 1, insertionPoint + 1);
        this._selectionChanged();
        return result;
    }

    private Rect insertReturn(int insertionPoint) {
        TextParagraph editParagraph;
        int index = this._paragraphIndexForIndex(insertionPoint);
        if (index == -1) {
            index = this._paragraphVector.count() - 1;
        }
        TextParagraph oldPara = editParagraph = (TextParagraph)this._paragraphVector.elementAt(index);
        editParagraph = editParagraph.createNewParagraphAt(insertionPoint);
        this.formatParagraphAtIndex(index);
        ++this._charCount;
        this._paragraphVector.insertElementAt(editParagraph, index + 1);
        this.formatParagraphAtIndex(index + 1);
        return TextView.newRect(0, oldPara._y, this.bounds.width, this.bounds.height - oldPara._y);
    }

    private TextStyleRun _runForIndex(int index) {
        int length = this.length();
        if (length > 0 && index >= length) {
            return this._runForIndex(length - 1);
        }
        if (index >= 0) {
            TextParagraph p = this._paragraphForIndex(index);
            if (p != null) {
                return p.runForCharPosition(index);
            }
            return null;
        }
        return null;
    }

    private boolean equalsAttributesHint(Hashtable a1, Hashtable a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        return false;
    }

    private void _keyDown() {
        TextPositionInfo lineInfo;
        Range r;
        Event revEvent = (Event)this._eventVector.removeFirstElement();
        if (!(revEvent instanceof KeyEvent)) {
            return;
        }
        KeyEvent event = (KeyEvent)revEvent;
        if (event.key == 1022) {
            return;
        }
        this._selection.disableInsertionPoint();
        int insertionPoint = this._selection.insertionPoint();
        TextParagraph editParagraph = this._paragraphForIndex(insertionPoint);
        boolean scrollToVisible = true;
        if (event.isReturnKey()) {
            r = new Range(this.selectedRange());
            if (this._owner != null) {
                this._owner.textWillChange(this, r);
            }
            Rect updateRect = this.insertReturn();
            if (this._owner != null) {
                r.length = 1;
                this._owner.textDidChange(this, r);
            }
            this.draw(updateRect);
            TextView.returnRect(updateRect);
        } else if (event.isLeftArrowKey()) {
            if (event.isShiftKeyDown()) {
                int newPos = this._selection.orderedSelectionEnd() - 1;
                if (newPos < 0) {
                    newPos = 0;
                }
                this._selection.setRange(this._selection.orderedSelectionStart(), newPos, true);
            } else if (insertionPoint == -1) {
                this._selection.setRange(this._selection.selectionStart(), this._selection.selectionStart(), true);
            } else {
                int newPos = insertionPoint - 1;
                if (newPos < 0) {
                    newPos = 0;
                }
                this._selection.setRange(newPos, newPos, true);
            }
            this._selectionChanged();
        } else if (event.isRightArrowKey()) {
            if (event.isShiftKeyDown()) {
                this._selection.setRange(this._selection.orderedSelectionStart(), this._selection.orderedSelectionEnd() + 1, false);
            } else if (insertionPoint == -1) {
                this._selection.setRange(this._selection.selectionEnd(), this._selection.selectionEnd());
            } else {
                this._selection.setRange(insertionPoint + 1, insertionPoint + 1, false);
            }
            this._selectionChanged();
        } else if (event.isUpArrowKey()) {
            TextPositionInfo currentPosition = this._selection.orderedSelectionEndInfo();
            TextPositionInfo newPosition = this.positionForPoint(currentPosition._x, currentPosition._y - 1, false);
            if (newPosition != null) {
                newPosition.representCharacterBeforeEndOfLine();
                if (event.isShiftKeyDown()) {
                    if (newPosition._absPosition == currentPosition._absPosition && newPosition._absPosition > 0) {
                        this._selection.setRange(this._selection.orderedSelectionStart(), newPosition._absPosition - 1, null, false, true);
                    } else {
                        this._selection.setRange(this._selection.orderedSelectionStart(), newPosition._absPosition, newPosition, false, true);
                    }
                } else if (currentPosition._lineNumber != 0 || currentPosition._textRun._paragraph != this._paragraphVector.elementAt(0)) {
                    this._selection.setInsertionPoint(newPosition);
                }
                this._selectionChanged();
            }
        } else if (event.isDownArrowKey()) {
            TextPositionInfo currentPosition = this._selection.orderedSelectionEndInfo();
            currentPosition.representCharacterBeforeEndOfLine();
            TextPositionInfo newPosition = this.positionForPoint(currentPosition._x, currentPosition._y + currentPosition._lineHeight + 1, false);
            if (newPosition != null) {
                if (event.isShiftKeyDown()) {
                    this._selection.setRange(this._selection.orderedSelectionStart(), newPosition._absPosition, newPosition, false, false);
                } else if (newPosition._textRun._paragraph != currentPosition._textRun._paragraph || newPosition._y != currentPosition._y) {
                    this._selection.setInsertionPoint(newPosition);
                }
                this._selectionChanged();
            }
        } else if (event.isHomeKey()) {
            this.selectedRange();
            lineInfo = this._selection.orderedSelectionEndInfo();
            Range selectedLine = this.lineForPosition(lineInfo);
            TextPositionInfo homeInfo = this.positionInfoForIndex(selectedLine.index);
            if (homeInfo != null) {
                if (homeInfo._y != lineInfo._y) {
                    homeInfo.representCharacterAfterEndOfLine();
                }
                if (event.isShiftKeyDown()) {
                    if (homeInfo._absPosition != lineInfo._absPosition) {
                        this._selection.setRange(this._selection.orderedSelectionStart(), homeInfo._absPosition, homeInfo, false, false);
                    }
                } else {
                    this._selection.setInsertionPoint(homeInfo);
                }
            }
            this._selectionChanged();
        } else if (event.isEndKey()) {
            this.selectedRange();
            lineInfo = this._selection.orderedSelectionEndInfo();
            Range selectedLine = this.lineForPosition(lineInfo);
            TextPositionInfo endInfo = this.positionInfoForIndex(selectedLine.index + selectedLine.length);
            if (endInfo != null) {
                if (endInfo._y != lineInfo._y) {
                    endInfo.representCharacterAfterEndOfLine();
                }
                if (event.isShiftKeyDown()) {
                    if (endInfo._absPosition != lineInfo._absPosition) {
                        this._selection.setRange(this._selection.orderedSelectionStart(), endInfo._absPosition, endInfo, false, false);
                    }
                } else {
                    this._selection.setInsertionPoint(endInfo);
                }
            }
            this._selectionChanged();
        } else if (event.isBackspaceKey()) {
            r = new Range(this.selectedRange());
            if (this._selection.isARange()) {
                if (this._owner != null) {
                    this._owner.textWillChange(this, r);
                }
                this.deleteSelection();
                if (this._owner != null) {
                    r.length = 0;
                    this._owner.textDidChange(this, r);
                }
            } else {
                if (this._owner != null) {
                    --r.index;
                    r.length = 1;
                    this._owner.textWillChange(this, r);
                }
                this.fastDeleteChar(false);
                if (this._owner != null) {
                    r.length = 0;
                    this._owner.textDidChange(this, r);
                }
            }
        } else if (event.isDeleteKey()) {
            r = this.selectedRange();
            if (this._selection.isARange()) {
                if (this._owner != null) {
                    this._owner.textWillChange(this, r);
                }
                this.deleteSelection();
                if (this._owner != null) {
                    r.length = 0;
                    this._owner.textDidChange(this, r);
                }
            } else if (r.index < this.length()) {
                r.length = 1;
                if (this._owner != null) {
                    this._owner.textWillChange(this, r);
                }
                this.fastDeleteChar(true);
                r.length = 0;
                if (this._owner != null) {
                    this._owner.textDidChange(this, r);
                }
            }
        } else if (event.isPrintableKey()) {
            r = this.selectedRange();
            Range newSelection = TextView.allocateRange();
            this.replaceRangeWithString(r, String.valueOf((char)event.key));
            if (this._typingAttributes.count() > 0) {
                newSelection.index = r.index;
                newSelection.length = 1;
                this.addAttributesForRangeWithoutNotification(this._typingAttributes, newSelection);
                this.clearTypingAttributes();
            }
            newSelection.index = r.index + 1;
            newSelection.length = 0;
            this.selectRange(newSelection);
            TextView.recycleRange(newSelection);
        } else if (event.isTabKey()) {
            r = this.selectedRange();
            Range newSelection = TextView.allocateRange();
            this.replaceRangeWithString(r, "\t");
            newSelection.index = r.index + 1;
            newSelection.length = 0;
            this.selectRange(newSelection);
            TextView.recycleRange(newSelection);
        } else {
            scrollToVisible = false;
        }
        if (scrollToVisible) {
            r = new Range(this._selection.orderedSelectionEnd(), 0);
            if (r.index > 0) {
                --r.index;
                ++r.length;
            }
            this.scrollRangeToVisible(r);
        }
        this._selection.enableInsertionPoint();
    }

    private Range paragraphsRangeForRange(Range r) {
        Range result = TextView.allocateRange();
        boolean hasIndex = false;
        int count = this._paragraphVector.count();
        int lastLocation = r.index + r.length;
        int i = 0;
        while (i < count) {
            TextParagraph nextParagraph = (TextParagraph)this._paragraphVector.elementAt(i);
            if (!hasIndex && r.index >= nextParagraph._startChar && r.index < nextParagraph._startChar + nextParagraph._charCount) {
                result.index = i;
                hasIndex = true;
            }
            if (hasIndex && lastLocation >= nextParagraph._startChar && lastLocation < nextParagraph._startChar + nextParagraph._charCount) {
                result.length = i - result.index + 1;
                break;
            }
            ++i;
        }
        return result;
    }

    private Vector createAndReturnRunsForRange(Range aRange) {
        int i;
        TextStyleRun endRun;
        TextParagraph endParagraph;
        boolean sameParagraph;
        int absPosition = aRange.index;
        int endAbsPosition = aRange.index + aRange.length;
        TextParagraph startParagraph = this._paragraphForIndex(absPosition);
        boolean bl = sameParagraph = startParagraph == (endParagraph = this._paragraphForIndex(endAbsPosition));
        if (aRange.length == 0) {
            TextStyleRun startRun = startParagraph.createNewRunAt(absPosition);
            if (startRun.charCount() > 0) {
                startRun = startParagraph.createNewRunAt(absPosition);
            }
            Vector runVector = TextView.newVector();
            runVector.addElement(startRun);
            return runVector;
        }
        TextStyleRun startRun = startParagraph.runForCharPosition(absPosition);
        if (startRun.rangeIndex() != absPosition) {
            startRun = startParagraph.createNewRunAt(absPosition);
        }
        if (endAbsPosition <= (endRun = endParagraph.runForCharPosition(endAbsPosition)).rangeIndex() + endRun.charCount() - 1) {
            endRun = endParagraph.createNewRunAt(endAbsPosition);
            endRun = endParagraph.runBefore(endRun);
        }
        if (sameParagraph) {
            if (startRun == endRun) {
                Vector result = new Vector();
                result.addElement(startRun);
                return result;
            }
            Vector result = startParagraph.runsFromTo(startRun, endRun);
            return result;
        }
        Vector runVector = TextView.newVector();
        runVector.addElement(startRun);
        Vector tmpVector = startParagraph.runsAfter(startRun);
        runVector.addElementsIfAbsent(tmpVector);
        TextView.returnVector(tmpVector);
        int start = i = this._paragraphVector.indexOfIdentical(startParagraph) + 1;
        int end = this._paragraphVector.indexOfIdentical(endParagraph);
        while (i < end) {
            TextParagraph nextParagraph = (TextParagraph)this._paragraphVector.elementAt(i);
            runVector.addElementsIfAbsent(nextParagraph.runVector());
            ++i;
        }
        tmpVector = endParagraph.runsBefore(endRun);
        tmpVector.addElement(endRun);
        runVector.addElementsIfAbsent(tmpVector);
        TextView.returnVector(tmpVector);
        return runVector;
    }

    private void processSetFont(Font aFont) {
        Range s = this.selectedRange();
        if (s.length > 0) {
            Hashtable newAttr = new Hashtable();
            newAttr.put(FONT_KEY, aFont);
            this.addAttributesForRange(newAttr, s);
            return;
        }
        this.addTypingAttribute(FONT_KEY, aFont);
    }

    private void deleteSelection(Vector paragraphVector) {
        Range r = this.selectedRange();
        this.deleteRange(r, paragraphVector);
        this._selection.setRange(r.index, r.index);
        this._selectionChanged();
    }

    private void deleteRange(Range aRange, Vector paragraphVector) {
        TextStyleRun endRun;
        Vector runVector;
        TextParagraph newParagraph = null;
        if (aRange.length == 0) {
            return;
        }
        Range dirtyRange = TextView.allocateRange(aRange.index, this.length() - aRange.index);
        this.dirtyRange(dirtyRange);
        TextView.recycleRange(dirtyRange);
        this.notifyAttachmentsForRange(aRange, false);
        TextPositionInfo rangeStartInfo = this.positionInfoForIndex(aRange.index);
        TextPositionInfo rangeEndInfo = this.positionInfoForIndex(aRange.index + aRange.length);
        TextParagraph startParagraph = rangeStartInfo._textRun._paragraph;
        TextParagraph endParagraph = rangeEndInfo._textRun._paragraph;
        boolean sameParagraph = startParagraph == endParagraph;
        TextStyleRun startRun = rangeStartInfo._textRun;
        if (startRun.rangeIndex() != rangeStartInfo._absPosition) {
            startRun = startParagraph.createNewRunAt(rangeStartInfo._absPosition);
        }
        if (!sameParagraph) {
            runVector = startParagraph.runsAfter(startRun);
            startParagraph.removeRun(startRun);
            startParagraph.removeRuns(runVector);
            if (paragraphVector != null) {
                newParagraph = new TextParagraph(this);
                newParagraph.setFormat(startParagraph._format);
                newParagraph.addRun(startRun);
                newParagraph.addRuns(runVector);
                paragraphVector.addElement(newParagraph);
            }
            runVector.removeAllElements();
            TextView.returnVector(runVector);
        }
        if ((endRun = rangeEndInfo._textRun).rangeIndex() != rangeEndInfo._absPosition) {
            endRun = endParagraph.createNewRunAt(rangeEndInfo._absPosition);
        }
        if (sameParagraph) {
            runVector = startParagraph.runsFromTo(startRun, endRun);
            runVector.removeElement(endRun);
            startParagraph.removeRuns(runVector);
            if (paragraphVector != null) {
                newParagraph = new TextParagraph(this);
                newParagraph.setFormat(startParagraph._format);
                newParagraph.addRuns(runVector);
                paragraphVector.addElement(newParagraph);
            }
            runVector.removeAllElements();
            TextView.returnVector(runVector);
        } else {
            int i;
            int start = i = this._paragraphVector.indexOfIdentical(startParagraph) + 1;
            int end = this._paragraphVector.indexOfIdentical(endParagraph);
            while (i < end) {
                TextParagraph nextParagraph = (TextParagraph)this._paragraphVector.removeElementAt(start);
                if (paragraphVector != null) {
                    paragraphVector.addElement(nextParagraph);
                }
                ++i;
            }
            runVector = endParagraph.runsBefore(endRun);
            endParagraph.removeRuns(runVector);
            if (paragraphVector != null) {
                newParagraph = new TextParagraph(this);
                newParagraph.setFormat(startParagraph._format);
                newParagraph.addRuns(runVector);
                paragraphVector.addElement(newParagraph);
            }
            runVector.removeAllElements();
            TextView.returnVector(runVector);
            startParagraph.subsumeParagraph(endParagraph);
            this._paragraphVector.removeElement(endParagraph);
        }
        this.formatParagraph(startParagraph);
    }

    private void deleteSelection() {
        this.deleteSelection(null);
    }

    boolean isOnlyParagraph(TextParagraph aParagraph) {
        return this._paragraphVector.count() == 1 && this._paragraphVector.contains(aParagraph);
    }

    int selectionStart() {
        return this._selection.selectionStart();
    }

    TextPositionInfo selectionStartInfo() {
        return this._selection.selectionStartInfo();
    }

    int selectionEnd() {
        return this._selection.selectionEnd();
    }

    TextPositionInfo selectionEndInfo() {
        return this._selection.selectionEndInfo();
    }

    boolean hasSelectionRange() {
        return this._selection.isARange();
    }

    TextParagraph lastParagraph() {
        return (TextParagraph)this._paragraphVector.lastElement();
    }

    char characterAt(int absPosition) {
        if (absPosition < 0 || absPosition > this._charCount) {
            return '\u0000';
        }
        TextParagraph theParagraph = this._paragraphForIndex(absPosition);
        if (theParagraph == null) {
            theParagraph = this.lastParagraph();
        }
        return theParagraph.characterAt(absPosition);
    }

    int _positionOfPreviousWord(int absPosition) {
        char previousChar;
        boolean done = false;
        if (absPosition == 0) {
            return 0;
        }
        if ((previousChar = this.characterAt(absPosition--)) == '\n') {
            return absPosition + 1;
        }
        if (previousChar == ' ' || previousChar == '\t') {
            do {
                boolean bl = done = (previousChar = this.characterAt(absPosition--)) != ' ' && previousChar != '\t' || previousChar == '\n';
            } while (absPosition > -1 && !done);
        } else {
            do {
                boolean bl = done = (previousChar = this.characterAt(absPosition--)) == ' ' || previousChar == '\t' || previousChar >= '!' && previousChar <= '/' || previousChar >= ':' && previousChar <= '@' || previousChar >= '[' && previousChar <= '\'' || previousChar >= '{' && previousChar <= '~' || previousChar == '\n';
            } while (absPosition > -1 && !done);
        }
        if (done) {
            return absPosition + 2;
        }
        return 0;
    }

    int _positionOfNextWord(int absPosition) {
        char nextChar;
        char previousChar;
        boolean done = false;
        if (absPosition >= this._charCount) {
            return this._charCount;
        }
        if (absPosition > 0 && (previousChar = this.characterAt(absPosition - 1)) == '\n') {
            return absPosition - 1;
        }
        if ((nextChar = this.characterAt(absPosition++)) == ' ' || nextChar == '\t') {
            do {
                previousChar = nextChar;
                boolean bl = done = (nextChar = this.characterAt(absPosition++)) != ' ' && nextChar != '\t' || nextChar == '\n';
            } while (absPosition < this._charCount && !done);
        } else {
            do {
                previousChar = nextChar;
                boolean bl = done = (nextChar = this.characterAt(absPosition++)) == ' ' || nextChar == '\t' || nextChar >= '!' && nextChar <= '/' || nextChar >= ':' && nextChar <= '@' || nextChar >= '[' && nextChar <= '\'' || nextChar >= '{' && nextChar <= '~' || nextChar == '\n';
            } while (absPosition < this._charCount && !done);
        }
        if (done) {
            return absPosition - 1;
        }
        return this._charCount;
    }

    private void hideInsertionPoint() {
        if (this.insertionPointVisible) {
            this.insertionPointVisible = false;
        }
    }

    private void showInsertionPoint() {
        if (!this.insertionPointVisible) {
            this.insertionPointVisible = true;
        }
    }

    static Rect newRect(int x, int y, int width, int height) {
        Rect theRect;
        Vector vector = _rectCache;
        synchronized (vector) {
            if (!_shouldCache || _rectCache.isEmpty()) {
                Rect rect = new Rect(x, y, width, height);
                Object var7_6 = null;
                return rect;
            }
            theRect = (Rect)_rectCache.removeLastElement();
        }
        theRect.setBounds(x, y, width, height);
        return theRect;
    }

    static Rect newRect(Rect templateRect) {
        Rect theRect;
        Vector vector = _rectCache;
        synchronized (vector) {
            if (!_shouldCache || _rectCache.isEmpty()) {
                Rect rect = new Rect(templateRect);
                Object var4_3 = null;
                return rect;
            }
            theRect = (Rect)_rectCache.removeLastElement();
        }
        theRect.setBounds(templateRect);
        return theRect;
    }

    static Rect newRect() {
        return TextView.newRect(0, 0, 0, 0);
    }

    static void returnRect(Rect r) {
        if (r == null) {
            return;
        }
        if (!_shouldCache) {
            return;
        }
        Vector vector = _rectCache;
        synchronized (vector) {
            if (_rectCache.count() < 50) {
                _rectCache.addElement(r);
            }
            return;
        }
    }

    static void returnRects(Vector rectVector) {
        if (rectVector == null || !_shouldCache) {
            return;
        }
        int i = rectVector.count();
        while (i-- > 0) {
            TextView.returnRect((Rect)rectVector.elementAt(i));
        }
        rectVector.removeAllElements();
    }

    static void setShouldCacheRects(boolean flag) {
        Vector vector = _rectCache;
        synchronized (vector) {
            _shouldCache = flag;
            if (!_shouldCache) {
                _rectCache.removeAllElements();
            }
            return;
        }
    }

    static Vector newVector() {
        Vector theVector;
        Vector vector = _vectorCache;
        synchronized (vector) {
            if (!_shouldCache || _vectorCache.isEmpty()) {
                Vector vector2 = new Vector();
                Object var3_2 = null;
                return vector2;
            }
            theVector = (Vector)_vectorCache.removeLastElement();
        }
        return theVector;
    }

    static void returnVector(Vector aVector) {
        if (!_shouldCache) {
            return;
        }
        Vector vector = _vectorCache;
        synchronized (vector) {
            if (aVector != null && _vectorCache.count() < 15) {
                aVector.removeAllElements();
                _vectorCache.addElement(aVector);
            }
            return;
        }
    }

    static void setShouldCacheVectors(boolean flag) {
        Vector vector = _vectorCache;
        synchronized (vector) {
            _shouldCache = flag;
            if (!_cacheVectors) {
                _vectorCache.removeAllElements();
            }
            return;
        }
    }

    private void _selectionChanged() {
        int start = this._selection.selectionStart();
        int end = this._selection.selectionEnd();
        if (start == this._wasSelectedRange.index && end - start == this._wasSelectedRange.length) {
            return;
        }
        this._wasSelectedRange.index = start;
        this._wasSelectedRange.length = end - start;
        this.clearTypingAttributes();
        if (this._owner != null) {
            this._owner.selectionDidChange(this);
        }
    }

    void dirtyRange(Range aRange) {
        if (this.isDirty() && this.dirtyRect == null) {
            return;
        }
        Range r = TextView.allocateRange(aRange);
        Rect visibleRect = new Rect();
        this.computeVisibleRect(visibleRect);
        r.intersectWith(0, this.length());
        if (this._superview != null && r != null && !r.isNullRange() && r.length > 0) {
            Vector dirtyRects = this.rectsForRange(r, visibleRect);
            int i = 0;
            int c = dirtyRects.count();
            while (i < c) {
                Rect rect = (Rect)dirtyRects.elementAt(i);
                rect.x = 0;
                rect.width = this.bounds.width;
                if (rect.width > 0 && rect.height > 0) {
                    this.addDirtyRect(rect);
                }
                ++i;
            }
        }
        TextView.recycleRange(r);
    }

    private TextParagraphFormat _formatForTextPositionInfo(TextPositionInfo info) {
        TextParagraphFormat f = info._textRun.paragraph().format();
        if (f == null) {
            f = (TextParagraphFormat)this._defaultAttributes.get(PARAGRAPH_FORMAT_KEY);
        }
        return f;
    }

    private TextPositionInfo positionInfoForNextLine(TextPositionInfo info) {
        int nextLineFirstChar = info._textRun.paragraph().characterStartingLine(info._lineNumber + 1);
        if (nextLineFirstChar == -1) {
            int nextParagraphIndex = this._paragraphVector.indexOfIdentical(info._textRun.paragraph()) + 1;
            if (nextParagraphIndex < this._paragraphVector.count()) {
                TextParagraph nextParagraph = (TextParagraph)this._paragraphVector.elementAt(nextParagraphIndex);
                return this.positionInfoForIndex(nextParagraph._startChar);
            }
            return null;
        }
        TextPositionInfo result = this.positionInfoForIndex(nextLineFirstChar);
        return result;
    }

    void setBaseURL(URL baseURL) {
        this._baseURL = baseURL;
    }

    private TextStyleRun runBefore(TextStyleRun aRun) {
        int index;
        TextStyleRun run = aRun.paragraph().runBefore(aRun);
        if (run == null && (index = this._paragraphVector.indexOfIdentical(aRun.paragraph())) > 0) {
            return ((TextParagraph)this._paragraphVector.elementAt(index - 1)).lastRun();
        }
        return run;
    }

    private TextStyleRun runAfter(TextStyleRun aRun) {
        int index;
        TextStyleRun run = aRun.paragraph().runAfter(aRun);
        if (run == null && (index = this._paragraphVector.indexOfIdentical(aRun.paragraph())) < this._paragraphVector.count() - 1) {
            return ((TextParagraph)this._paragraphVector.elementAt(index + 1)).firstRun();
        }
        return run;
    }

    private Range linkRangeForPosition(int index) {
        String url;
        TextStyleRun orig = this._runForIndex(index);
        Hashtable attr = orig.attributes();
        if (attr != null && (url = (String)attr.get(LINK_KEY)) != null) {
            TextStyleRun lastRun;
            TextStyleRun firstRun;
            TextStyleRun run = firstRun = orig;
            while ((run = this.runBefore(run)) != null && (attr = run.attributes()) != null && url.equals((String)attr.get(LINK_KEY))) {
                firstRun = run;
            }
            run = lastRun = orig;
            while ((run = this.runAfter(run)) != null && (attr = run.attributes()) != null && url.equals((String)attr.get(LINK_KEY))) {
                lastRun = run;
            }
            Range result = firstRun.range();
            result.unionWith(lastRun.range());
            return result;
        }
        return null;
    }

    private void highlightLinkWithRange(Range aRange, boolean flag) {
        if (flag) {
            this.addAttributeForRange(LINK_IS_PRESSED_KEY, "", aRange);
        } else {
            this.removeAttributeForRange(LINK_IS_PRESSED_KEY, aRange);
        }
        Range r = this.paragraphsRangeForRange(aRange);
        int i = r.index;
        int c = r.index + r.length;
        while (i < c) {
            ((TextParagraph)this._paragraphVector.elementAt(i)).collectEmptyRuns();
            ++i;
        }
    }

    private boolean runUnderMouse(TextStyleRun run, int x, int y) {
        Vector rects = this.rectsForRange(run.range());
        int i = 0;
        int c = rects.count();
        while (i < c) {
            if (((Rect)rects.elementAt(i)).contains(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean runsUnderMouse(Vector runs, int x, int y) {
        int i = 0;
        int c = runs.count();
        while (i < c) {
            Range r = (Range)runs.elementAt(i);
            TextStyleRun run = this._runForIndex(r.index);
            if (this.runUnderMouse(run, x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean lastParagraphIsEmpty() {
        return this.lastParagraph()._charCount == 0;
    }

    char charAt(int index) {
        String s = this.stringForRange(new Range(index, 1));
        if (s != null && s.length() > 0) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    boolean isWordCharacter(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    Range groupForIndex(int index) {
        int length = this.length();
        int i = index;
        char c = this.charAt(i);
        if (c == '\n') {
            return new Range(i, 1);
        }
        if (c == ' ' || c == '\t') {
            while (i > 0) {
                c = this.charAt(i);
                if (c != ' ' && c != '\t') break;
                --i;
            }
            int relFirstIndex = i + 1;
            i = index;
            while (i < this.length()) {
                c = this.charAt(i);
                if (c != ' ' && c != '\t') break;
                ++i;
            }
            int relLastIndex = i - 1;
            return new Range(relFirstIndex, relLastIndex - relFirstIndex + 1);
        }
        if (!this.isWordCharacter(c)) {
            return new Range(index, 1);
        }
        int relFirstIndex = i;
        while (relFirstIndex > 0) {
            c = this.charAt(relFirstIndex - 1);
            if (!this.isWordCharacter(c)) break;
            --relFirstIndex;
        }
        int relLastIndex = i;
        while (relLastIndex < length - 1) {
            c = this.charAt(relLastIndex + 1);
            if (!this.isWordCharacter(c)) break;
            ++relLastIndex;
        }
        return new Range(relFirstIndex, relLastIndex - relFirstIndex + 1);
    }

    Range lineForPosition(TextPositionInfo info) {
        TextParagraph p = info._textRun._paragraph;
        if (p != null) {
            int lineBegin = info._lineNumber == 0 ? p._startChar : p._startChar + p._lineBreaks[info._lineNumber - 1];
            int lineEnd = p._startChar + p._lineBreaks[info._lineNumber] - 1;
            return new Range(lineBegin, lineEnd - lineBegin + 1);
        }
        return new Range();
    }

    void replaceContentWithString(String aString) {
        TextStyleRun r;
        TextParagraph p;
        this.notifyAttachmentsForRange(new Range(0, this.length()), false);
        this._paragraphVector.removeAllElements();
        int i = 0;
        int c = aString.length();
        while (i < c) {
            int lastIndex;
            int firstIndex;
            int nextBreak = aString.indexOf(10, i);
            if (nextBreak == -1) {
                firstIndex = i;
                lastIndex = c;
                i = c;
            } else {
                firstIndex = i;
                lastIndex = nextBreak;
                i = nextBreak + 1;
            }
            p = new TextParagraph(this);
            r = new TextStyleRun(p, aString, firstIndex, lastIndex, null);
            p.addRun(r);
            this._paragraphVector.addElement(p);
        }
        if (this._paragraphVector.count() == 0 || aString.charAt(c - 1) == '\n') {
            p = new TextParagraph(this);
            r = new TextStyleRun(p, "", null);
            p.addRun(r);
            this._paragraphVector.addElement(p);
        }
        this.setDirty(true);
        this.reformatAll();
    }

    Vector rectsForRange(Range aRange, Rect maxRect) {
        Rect rect;
        Range r = TextView.allocateRange(aRange.index, aRange.length);
        Vector result = new Vector();
        r.intersectWith(0, this.length());
        if (r.length == 0 || r.isNullRange()) {
            TextView.recycleRange(r);
            return result;
        }
        TextPositionInfo start = this.positionInfoForIndex(r.index);
        if (start._endOfLine && !start._endOfParagraph) {
            start.representCharacterAfterEndOfLine();
        }
        TextPositionInfo end = this.positionInfoForIndex(r.index + r.length());
        if (start == null || end == null) {
            TextView.recycleRange(r);
            return result;
        }
        if (start._textRun.paragraph() == end._textRun.paragraph() && start._lineNumber == end._lineNumber) {
            TextParagraphFormat f = this._formatForTextPositionInfo(start);
            if (end._endOfLine) {
                TextParagraph p = start._textRun.paragraph();
                int lineRemainder = p._lineRemainders[start._lineNumber];
                switch (f._justification) {
                    case 1: {
                        result.addElement(new Rect(start._x, start._y, this.bounds.width - f._rightMargin - start._x - lineRemainder / 2, start._lineHeight));
                        break;
                    }
                    case 2: {
                        result.addElement(new Rect(start._x, start._y, this.bounds.width - f._rightMargin - start._x, start._lineHeight));
                        break;
                    }
                    default: {
                        result.addElement(new Rect(start._x, start._y, this.bounds.width - f._rightMargin - start._x - lineRemainder, start._lineHeight));
                        break;
                    }
                }
            } else {
                result.addElement(new Rect(start._x, start._y, end._x - start._x, start._lineHeight));
            }
            TextView.recycleRange(r);
            return result;
        }
        TextParagraphFormat f = this._formatForTextPositionInfo(start);
        TextParagraph p = start._textRun.paragraph();
        int lineRemainder = p._lineRemainders[start._lineNumber];
        switch (f._justification) {
            case 1: {
                rect = new Rect(start._x, start._y, this.bounds.width - f._rightMargin - start._x - lineRemainder / 2, start._lineHeight);
                break;
            }
            case 2: {
                rect = new Rect(start._x, start._y, this.bounds.width - f._rightMargin - start._x, start._lineHeight);
                break;
            }
            default: {
                rect = new Rect(start._x, start._y, this.bounds.width - f._rightMargin - start._x - lineRemainder, start._lineHeight);
            }
        }
        if (rect.height > 0) {
            result.addElement(rect);
        }
        rect = new Rect(0, 0, 0, 0);
        TextPositionInfo info = start;
        boolean done = false;
        int lastY = -1;
        while (!done) {
            if ((info = this.positionInfoForNextLine(info)) == null) break;
            if (info._endOfLine && !info._endOfParagraph) {
                info.representCharacterAfterEndOfLine();
            }
            if (info._y <= lastY) break;
            lastY = info._y;
            if (maxRect != null) {
                if (info._y < maxRect.y) continue;
                if (info._y > maxRect.y + maxRect.height) {
                    done = true;
                    break;
                }
            }
            f = this._formatForTextPositionInfo(info);
            if (info._textRun.paragraph() != end._textRun.paragraph() || info._lineNumber < end._lineNumber) {
                rect.x = info._x;
                rect.y = info._y;
                p = info._textRun.paragraph();
                lineRemainder = p._lineRemainders[info._lineNumber];
                switch (f._justification) {
                    case 1: {
                        rect.width = this.bounds.width - f._rightMargin - rect.x - lineRemainder / 2;
                        break;
                    }
                    case 2: {
                        rect.width = this.bounds.width - f._rightMargin - rect.x;
                        break;
                    }
                    default: {
                        rect.width = this.bounds.width - f._rightMargin - rect.x - lineRemainder;
                    }
                }
                rect.height = info._lineHeight;
            } else {
                rect.x = info._x;
                rect.y = info._y;
                rect.width = end._x - rect.x;
                rect.height = info._lineHeight;
                done = true;
            }
            if (rect.height <= 0) continue;
            Rect lastRect = (Rect)result.lastElement();
            if (lastRect != null && lastRect.x == rect.x && lastRect.width == rect.width) {
                lastRect.height = rect.y + rect.height - lastRect.y;
                continue;
            }
            result.addElement(new Rect(rect));
        }
        TextView.recycleRange(r);
        return result;
    }

    Vector rangesOfVisibleAttachmentsWithBitmap(Bitmap aBitmap) {
        Vector result = new Vector();
        Rect r = new Rect();
        this.computeVisibleRect(r);
        TextPositionInfo info = this.positionForPoint(r.x, r.y, true);
        int firstIndex = info == null ? 0 : (info._absPosition > 0 ? info._absPosition - 1 : 0);
        info = this.positionForPoint(r.x + r.width, r.y + r.height, true);
        int lastIndex = info == null ? this.length() - 1 : (info._absPosition < this.length() - 1 ? info._absPosition + 1 : this.length() - 1);
        TextStyleRun run = this._runForIndex(firstIndex);
        while (run != null) {
            TextAttachment attachment;
            Hashtable attributes = run.attributes();
            if (attributes != null && (attachment = (TextAttachment)attributes.get(TEXT_ATTACHMENT_KEY)) != null && attachment instanceof ImageAttachment && ((ImageAttachment)attachment).image() == aBitmap) {
                result.addElement(run.range());
            }
            if ((run = this.runAfter(run)).rangeIndex() > lastIndex) break;
        }
        return result;
    }

    void refreshBitmap(Object data) {
        Bitmap bm = (Bitmap)data;
        Vector ranges = this.rangesOfVisibleAttachmentsWithBitmap(bm);
        int j = 0;
        int d = ranges.count();
        while (j < d) {
            Range attachmentRange = (Range)ranges.elementAt(j);
            if (!attachmentRange.isNullRange()) {
                Vector v = this.rectsForRange(attachmentRange);
                Rect imageRect = bm.updateRect();
                if (v.count() > 0) {
                    Rect r = (Rect)v.elementAt(0);
                    int i = 1;
                    int c = v.count();
                    while (i < c) {
                        r.unionWith((Rect)v.elementAt(i));
                        ++i;
                    }
                    r.x = 0;
                    r.width = this.bounds.width;
                    r.y += imageRect.y;
                    r.height = imageRect.height;
                    this.addDirtyRect(r);
                }
            }
            ++j;
        }
    }

    boolean attributesChangingFormatting(Hashtable attr) {
        if (attr != null) {
            Vector keysVector = attr.keysVector();
            int i = 0;
            int c = keysVector.count();
            while (i < c) {
                if (attributesChangingFormatting.indexOf(keysVector.elementAt(i)) != -1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    void clearTypingAttributes() {
        if (this._typingAttributes != null) {
            this._typingAttributes.clear();
        }
    }

    void addAttributesForRangeWithoutNotification(Hashtable attributes, Range range) {
        Range runRange;
        TextStyleRun run;
        TextParagraph paragraph;
        int c;
        int i;
        Range paragraphsRange;
        TextParagraphFormat format;
        Range selectedRange = this.selectedRange();
        Range dirtyRange = TextView.allocateRange();
        Vector toBeFormatted = new Vector();
        if (attributes == null) {
            TextView.recycleRange(dirtyRange);
            return;
        }
        TextAttachment ti = (TextAttachment)attributes.get(TEXT_ATTACHMENT_KEY);
        if (ti != null) {
            ti.setOwner(this);
        }
        if ((format = (TextParagraphFormat)attributes.get(PARAGRAPH_FORMAT_KEY)) != null) {
            paragraphsRange = this.paragraphsRangeForRange(range);
            i = paragraphsRange.index;
            c = paragraphsRange.index + paragraphsRange.length;
            while (i < c) {
                paragraph = (TextParagraph)this._paragraphVector.elementAt(i);
                paragraph.setFormat(format);
                toBeFormatted.addElementIfAbsent(paragraph);
                dirtyRange.unionWith(paragraph.range());
                ++i;
            }
            if (attributes.count() == 1) {
                i = 0;
                c = toBeFormatted.count();
                while (i < c) {
                    this.formatParagraph((TextParagraph)toBeFormatted.elementAt(i));
                    ++i;
                }
                this.dirtyRange(dirtyRange);
                if (this.formattingEnabled()) {
                    this._selection.setRange(selectedRange.index, selectedRange.index + selectedRange.length);
                }
                TextView.recycleRange(dirtyRange);
                TextView.recycleRange(paragraphsRange);
                return;
            }
            TextView.recycleRange(paragraphsRange);
        }
        if ((run = this._runForIndex(range.index)) != null) {
            runRange = run.range();
            if (range.equals(runRange)) {
                run.appendAttributes(attributes);
                dirtyRange.unionWith(run.range());
                if (this.attributesChangingFormatting(attributes)) {
                    toBeFormatted.addElementIfAbsent(this._paragraphForIndex(range.index));
                }
                i = 0;
                c = toBeFormatted.count();
                while (i < c) {
                    paragraph = (TextParagraph)toBeFormatted.elementAt(i);
                    this.formatParagraph(paragraph);
                    dirtyRange.unionWith(paragraph.range());
                    ++i;
                }
                this.dirtyRange(dirtyRange);
                if (this.formattingEnabled()) {
                    this._selection.setRange(selectedRange.index, selectedRange.index + selectedRange.length);
                }
                TextView.recycleRange(dirtyRange);
                TextView.recycleRange(runRange);
                return;
            }
            if (range.index >= runRange.index && range.index + range.length <= runRange.index + runRange.length && this.equalsAttributesHint(attributes, run.attributes())) {
                TextView.recycleRange(dirtyRange);
                TextView.recycleRange(runRange);
                return;
            }
        }
        Vector runsVector = this.createAndReturnRunsForRange(range);
        i = 0;
        c = runsVector.count();
        while (i < c) {
            run = (TextStyleRun)runsVector.elementAt(i);
            run.appendAttributes(attributes);
            runRange = run.range();
            dirtyRange.unionWith(runRange);
            TextView.recycleRange(runRange);
            ++i;
        }
        if (this.attributesChangingFormatting(attributes)) {
            paragraphsRange = this.paragraphsRangeForRange(range);
            i = paragraphsRange.index;
            c = paragraphsRange.index + paragraphsRange.length;
            while (i < c) {
                toBeFormatted.addElementIfAbsent(this._paragraphVector.elementAt(i));
                ++i;
            }
            TextView.recycleRange(paragraphsRange);
        }
        i = 0;
        c = toBeFormatted.count();
        while (i < c) {
            paragraph = (TextParagraph)toBeFormatted.elementAt(i);
            this.formatParagraph(paragraph);
            Range pRange = paragraph.range();
            dirtyRange.unionWith(pRange);
            TextView.recycleRange(pRange);
            ++i;
        }
        this.dirtyRange(dirtyRange);
        if (this.formattingEnabled()) {
            this._selection.setRange(selectedRange.index, selectedRange.index + selectedRange.length);
        }
        TextView.recycleRange(dirtyRange);
    }

    void validateHTMLParsingRules() {
        if (this._htmlParsingRules == null) {
            String[] supportedContainers = new String[]{"BODY", "H1", "H2", "H3", "H4", "H5", "H6", "B", "STRONG", "CENTER", "EM", "I", "PRE", "A", "OL", "UL", "LI", "ADDRESS", "BLOCKQUOTE", "DIR", "MENU", "TT", "SAMP", "CODE", "KBD", "VAR", "CITE", "DL", "DT", "DD", "TITLE", "P"};
            String[] supportedMarkers = new String[]{"BR", "HR", "IMG"};
            this._htmlParsingRules = new HTMLParsingRules();
            int i = 0;
            int c = supportedContainers.length;
            while (i < c) {
                this._htmlParsingRules.setClassNameForMarker("netscape.application.TextViewHTMLContainerImp", supportedContainers[i]);
                ++i;
            }
            i = 0;
            c = supportedMarkers.length;
            while (i < c) {
                this._htmlParsingRules.setClassNameForMarker("netscape.application.TextViewHTMLMarkerImp", supportedMarkers[i]);
                ++i;
            }
            this._htmlParsingRules.setStringClassName("netscape.application.TextViewHTMLString");
        }
    }

    void disableAttachmentNotification() {
        ++this.notifyAttachmentDisabled;
    }

    void enableAttachmentNotification() {
        --this.notifyAttachmentDisabled;
        if (this.notifyAttachmentDisabled < 0) {
            this.notifyAttachmentDisabled = 0;
        }
        if (this.notifyAttachmentDisabled == 0 && this.invalidAttachmentRange != null) {
            this.notifyAttachmentsForRange(this.invalidAttachmentRange, true);
            this.invalidAttachmentRange = null;
        }
    }

    void _notifyAttachmentsForRange(Range aRange, boolean added) {
        int paragraphIndex = this._paragraphIndexForIndex(aRange.index);
        int index = aRange.index;
        int lastIndex = aRange.index + aRange.length;
        if (paragraphIndex == -1) {
            return;
        }
        TextParagraph p = (TextParagraph)this._paragraphVector.elementAt(paragraphIndex);
        int runIndex = p.runIndexForCharPosition(index);
        if (runIndex == -1) {
            return;
        }
        TextStyleRun run = (TextStyleRun)p._runVector.elementAt(runIndex);
        index = run.rangeIndex();
        while (index < lastIndex) {
            TextAttachment attachment;
            Hashtable attributes = run.attributes();
            if (attributes != null && (attachment = (TextAttachment)attributes.get(TEXT_ATTACHMENT_KEY)) != null) {
                if (added) {
                    TextPositionInfo info = run._paragraph._infoForPosition(run.rangeIndex());
                    if (info != null) {
                        info.representCharacterAfterEndOfLine();
                        Rect r = run.textAttachmentBoundsForOrigin(info._x, info._y, run._paragraph._baselines[info._lineNumber]);
                        attachment._willShowWithBounds(r);
                    }
                } else {
                    attachment._willHide();
                }
            }
            index += run.charCount();
            if (++runIndex < p._runVector.count()) {
                run = (TextStyleRun)p._runVector.elementAt(runIndex);
                continue;
            }
            ++index;
            if (++paragraphIndex >= this._paragraphVector.count()) break;
            p = (TextParagraph)this._paragraphVector.elementAt(paragraphIndex);
            runIndex = 0;
            if (p._runVector.count() <= 0) break;
            run = (TextStyleRun)p._runVector.elementAt(runIndex);
        }
    }

    void notifyAttachmentsForRange(Range aRange, boolean added) {
        if (!added) {
            this._notifyAttachmentsForRange(aRange, false);
            return;
        }
        if (this.notifyAttachmentDisabled > 0) {
            if (this.invalidAttachmentRange != null) {
                this.invalidAttachmentRange.unionWith(aRange);
                return;
            }
            this.invalidAttachmentRange = new Range(aRange);
            return;
        }
        this._notifyAttachmentsForRange(aRange, true);
    }

    boolean isLeftHalfOfCharacter(int x, int y) {
        TextPositionInfo info = this.positionForPoint(x, y, false);
        TextPositionInfo absoluteInfo = this.positionForPoint(x, y, true);
        if (info == null || absoluteInfo == null) {
            return true;
        }
        return info._absPosition == absoluteInfo._absPosition;
    }

    static Range allocateRange() {
        return TextView.allocateRange(Range.nullRange().index, Range.nullRange().length);
    }

    static Range allocateRange(Range template) {
        return TextView.allocateRange(template.index, template.length);
    }

    static Range allocateRange(int index, int length) {
        Range result = (Range)rangePool.allocateObject();
        result.index = index;
        result.length = length;
        return result;
    }

    static void recycleRange(Range aRange) {
        rangePool.recycleObject(aRange);
    }

    public void copy() {
        Application.setClipboardText(this.stringForRange(this.selectedRange()));
    }

    public void cut() {
        if (this.isEditable()) {
            Range range = this.selectedRange();
            Application.setClipboardText(this.stringForRange(range));
            this.replaceRangeWithString(range, "");
            this.selectRange(new Range(range.index(), 0));
        }
    }

    public void paste() {
        if (this.isEditable()) {
            Range range = this.selectedRange();
            String text = Application.clipboardText();
            if (range == null || range.index == -1 || text == null) {
                return;
            }
            this._selection.disableInsertionPoint();
            this.replaceRangeWithString(range, text);
            range = new Range(range.index() + text.length(), 0);
            this.selectRange(range);
            this.scrollRangeToVisible(range);
            this._selection.enableInsertionPoint();
        }
    }

    public String formElementText() {
        return this.string();
    }

    static {
        attributesChangingFormatting.addElement(TEXT_ATTACHMENT_KEY);
        attributesChangingFormatting.addElement(TEXT_ATTACHMENT_BASELINE_OFFSET_KEY);
        attributesChangingFormatting.addElement(FONT_KEY);
        attributesChangingFormatting.addElement(PARAGRAPH_FORMAT_KEY);
        _rectCache = new Vector();
        _vectorCache = new Vector();
        hashtablePool = new ObjectPool("netscape.util.Hashtable", 32);
        rangePool = new ObjectPool("netscape.application.Range", 32);
    }
}

