/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.InputStream;
import netscape.util.Archive;
import netscape.util.ClassInfo;
import netscape.util.ClassTable;
import netscape.util.CodingException;
import netscape.util.DeserializationException;
import netscape.util.Deserializer;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.IdHashtable;
import netscape.util.Vector;

public class BariumArchiveLoader {
    static final String classVersionsKey = "classVersions";
    static final String classTablesKey = "classTables";
    static final String fieldNamesKey = "fieldNames";
    static final String fieldTypesKey = "fieldTypes";
    static final String instancesKey = "instances";
    static final String classNameKey = "class";
    static final String rootInstancesKey = "rootInstances";
    Archive archive;
    Hashtable archiveDict;
    Hashtable allVersions;
    IdHashtable idForName;
    String[] nameForId;

    public BariumArchiveLoader(Archive archive) {
        this.archive = archive;
    }

    public void readASCII(InputStream in) throws CodingException, DeserializationException, IOException {
        Deserializer deserializer = null;
        if (in instanceof Deserializer) {
            deserializer = (Deserializer)in;
        }
        this.idForName = new IdHashtable(true);
        if (deserializer == null) {
            deserializer = new Deserializer(in);
        }
        this.archiveDict = (Hashtable)deserializer.readObject();
        this.loadVersions();
        this.loadClassTables();
        this.loadInstanceData();
        this.loadRoots();
    }

    void loadVersions() {
        Hashtable versionDict = (Hashtable)this.archiveDict.get(classVersionsKey);
        if (versionDict == null) {
            return;
        }
        this.allVersions = new Hashtable(versionDict.count());
        Enumeration classNameEnum = versionDict.keys();
        while (classNameEnum.hasMoreElements()) {
            String className = (String)classNameEnum.nextElement();
            String versionString = (String)versionDict.get(className);
            int version = Integer.parseInt(versionString);
            this.allVersions.put(className, new Integer(version));
        }
    }

    void loadClassTables() throws CodingException {
        Hashtable allTablesDict = (Hashtable)this.archiveDict.get(classTablesKey);
        if (allTablesDict == null) {
            return;
        }
        Enumeration classNameEnum = allTablesDict.keys();
        while (classNameEnum.hasMoreElements()) {
            String className = (String)classNameEnum.nextElement();
            Hashtable tableDict = (Hashtable)allTablesDict.get(className);
            Object[] fieldNamesArray = (Object[])tableDict.get(fieldNamesKey);
            String[] fieldNames = new String[fieldNamesArray.length];
            System.arraycopy(fieldNamesArray, 0, fieldNames, 0, fieldNames.length);
            Object[] fieldTypesArray = (Object[])tableDict.get(fieldTypesKey);
            byte[] fieldTypes = BariumArchiveLoader.fieldTypesForNames(fieldTypesArray);
            ClassInfo info = new ClassInfo(className);
            int count = fieldNames.length;
            int i = 0;
            while (i < count) {
                info.addField(fieldNames[i], fieldTypes[i]);
                ++i;
            }
            this.guessAtVersions(className, info);
            ClassTable table = new ClassTable(this.archive, info);
            this.archive.addClassTable(table);
        }
    }

    void guessAtVersions(String className, ClassInfo info) {
        Integer version = (Integer)this.allVersions.get(className);
        if (version != null) {
            info.addClass(className, version);
        }
        Vector classNames = new Vector();
        try {
            Class<?> cls = Class.forName(className);
            while (cls != null) {
                classNames.addElement(cls.getName());
                cls = cls.getSuperclass();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("unable to find class: " + className);
            return;
        }
        int i = classNames.count();
        while (--i > 0) {
            className = (String)classNames.elementAt(i);
            version = (Integer)this.allVersions.get(className);
            if (version == null) continue;
            info.addClass(className, version);
        }
    }

    static byte[] fieldTypesForNames(Object[] fieldTypesArray) throws CodingException {
        int count = fieldTypesArray.length;
        byte[] fieldTypes = new byte[count];
        int i = 0;
        while (i < count) {
            String typeName = (String)fieldTypesArray[i];
            fieldTypes[i] = BariumArchiveLoader.typeForName(typeName);
            ++i;
        }
        return fieldTypes;
    }

    static byte typeForName(String typeName) throws CodingException {
        if ((typeName = typeName.toLowerCase()).equals("boolean")) {
            return 0;
        }
        if (typeName.equals("byte")) {
            return 4;
        }
        if (typeName.equals("short")) {
            return 6;
        }
        if (typeName.equals("int")) {
            return 8;
        }
        if (typeName.equals("long")) {
            return 10;
        }
        if (typeName.equals("float")) {
            return 12;
        }
        if (typeName.equals("double")) {
            return 14;
        }
        if (typeName.equals("string")) {
            return 16;
        }
        if (typeName.equals("byte_array")) {
            return 5;
        }
        if (typeName.equals("object")) {
            return 18;
        }
        if (typeName.equals("object_array")) {
            return 19;
        }
        throw new CodingException("unknown type name: " + typeName);
    }

    void loadInstanceData() throws CodingException {
        int id;
        ClassTable table;
        Hashtable instanceDict;
        String name;
        Hashtable allInstancesDict = (Hashtable)this.archiveDict.get(instancesKey);
        if (allInstancesDict == null) {
            return;
        }
        Enumeration nameEnum = allInstancesDict.keys();
        while (nameEnum.hasMoreElements()) {
            name = (String)nameEnum.nextElement();
            instanceDict = (Hashtable)allInstancesDict.get(name);
            if (this.idForName.get(name) != 0) {
                throw new CodingException("duplicate instance name: " + name);
            }
            String className = (String)instanceDict.get(classNameKey);
            if (className == null || className.equals("")) {
                throw new CodingException("missing className for instance: " + name);
            }
            table = this.archive.classTableForName(className);
            if (table == null) {
                throw new CodingException("bad class name for instance: " + name);
            }
            id = table.newIdentifier();
            this.idForName.putKnownAbsent(name, id);
        }
        nameEnum = allInstancesDict.keys();
        while (nameEnum.hasMoreElements()) {
            name = (String)nameEnum.nextElement();
            id = this.idForName.get(name);
            table = this.archive.tableForId[id];
            int row = this.archive.rowForId[id];
            instanceDict = (Hashtable)allInstancesDict.get(name);
            this.loadRow(table, row, instanceDict);
        }
    }

    void loadRow(ClassTable table, int row, Hashtable instanceDict) throws CodingException {
        int i = 0;
        while (i < table.fieldCount) {
            Object value = instanceDict.get(table.fieldNames[i]);
            if (value instanceof Object[]) {
                this.setColumnFromArray(table, row, i, (Object[])value);
            } else if (value instanceof String && !((String)value).equals("")) {
                this.setColumnFromString(table, row, i, (String)value);
            }
            ++i;
        }
    }

    void setColumnFromArray(ClassTable table, int row, int column, Object[] value) throws CodingException {
        if (table.fieldTypes[column] != 19) {
            throw new CodingException("bad data for field " + table.fieldNames[column]);
        }
        int[] array = new int[value.length];
        int i = 0;
        while (i < array.length) {
            int id;
            array[i] = id = this.idForName.get(value[i]);
            ++i;
        }
        table.setIdentifierArrayAt(row, column, array);
    }

    void setColumnFromString(ClassTable table, int row, int column, String value) throws NumberFormatException, CodingException {
        switch (table.fieldTypes[column]) {
            case 0: {
                if (value.equalsIgnoreCase("true")) {
                    table.setBooleanAt(row, column, true);
                    return;
                }
                if (value.equalsIgnoreCase("false")) {
                    table.setBooleanAt(row, column, false);
                    return;
                }
                throw new CodingException("Invalid boolean value");
            }
            case 4: {
                table.setByteAt(row, column, (byte)Integer.parseInt(value));
                return;
            }
            case 6: {
                table.setShortAt(row, column, (short)Integer.parseInt(value));
                return;
            }
            case 8: {
                table.setIntAt(row, column, Integer.parseInt(value));
                return;
            }
            case 10: {
                table.setLongAt(row, column, Long.parseLong(value));
                return;
            }
            case 12: {
                table.setFloatAt(row, column, Float.valueOf(value).floatValue());
                return;
            }
            case 14: {
                table.setDoubleAt(row, column, Double.valueOf(value));
                return;
            }
            case 16: {
                table.setStringAt(row, column, value);
                return;
            }
            case 5: {
                table.setByteArrayAt(row, column, this.bytesFromString(value));
                return;
            }
            case 18: {
                table.setIdentifierAt(row, column, this.idForName.get(value));
                return;
            }
        }
        throw new CodingException("unknown type " + table.fieldTypes[column]);
    }

    /*
     * Unable to fully structure code
     */
    byte[] bytesFromString(String value) {
        if (value == null || value.equals("")) {
            return null;
        }
        count = value.length();
        buf = new byte[count / 2 + 1];
        i = 0;
        outCount = 0;
        ** GOTO lbl16
        {
            if (!Character.isSpace(ch = value.charAt(i++))) {
                if (i >= count) {
                    throw new NumberFormatException("bad byte string");
                }
                nibble = this.nibbleForHexChar(ch);
                ch = value.charAt(i++);
                buf[outCount++] = (byte)((nibble << 4) + this.nibbleForHexChar(ch));
            }
            do {
                if (i < count) continue block0;
lbl16:
                // 2 sources

            } while (i < count);
        }
        tmp = new byte[outCount];
        System.arraycopy(buf, 0, tmp, 0, outCount);
        return tmp;
    }

    int nibbleForHexChar(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new NumberFormatException("bad byte string");
    }

    void loadRoots() throws CodingException {
        Object[] rootsArray = (Object[])this.archiveDict.get(rootInstancesKey);
        if (rootsArray == null || rootsArray.length == 0) {
            throw new CodingException("no root instances");
        }
        int i = 0;
        while (i < rootsArray.length) {
            String name = (String)rootsArray[i];
            int id = name == null || name.equals("") ? 0 : this.idForName.get(name);
            if (id == 0) {
                throw new CodingException("unknown root instance " + name);
            }
            this.archive.addRootIdentifier(id);
            ++i;
        }
    }
}

