/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is Netscape Communications
 * Corporation.  Portions created by Netscape are Copyright (C) 1998
 * Netscape Communications Corporation.  All Rights Reserved.
 */

/* Do not edit - generated by gentags.pl */
#include "nsCRT.h"
#include "nsHTMLTagsEnums.h"

static char* tagTable[] = {
  "A", "ABBR", "ACRONYM", "ADDRESS", "APPLET", "AREA", "B", "BASE", 
  "BASEFONT", "BDO", "BGSOUND", "BIG", "BLINK", "BLOCKQUOTE", "BODY", "BR", 
  "BUTTON", "CAPTION", "CENTER", "CITE", "CODE", "COL", "COLGROUP", "DD", 
  "DEL", "DFN", "DIR", "DIV", "DL", "DT", "EM", "EMBED", "FIELDSET", "FONT", 
  "FORM", "FRAME", "FRAMESET", "H1", "H2", "H3", "H4", "H5", "H6", "HEAD", 
  "HR", "HTML", "I", "IFRAME", "ILAYER", "IMG", "INPUT", "INS", "ISINDEX", 
  "KBD", "KEYGEN", "LABEL", "LAYER", "LEGEND", "LI", "LINK", "LISTING", 
  "MAP", "MENU", "META", "MULTICOL", "NOBR", "NOEMBED", "NOFRAMES", 
  "NOLAYER", "NOSCRIPT", "OBJECT", "OL", "OPTGROUP", "OPTION", "P", "PARAM", 
  "PLAINTEXT", "PRE", "Q", "S", "SAMP", "SCRIPT", "SELECT", "SERVER", 
  "SMALL", "SOUND", "SPACER", "SPAN", "STRIKE", "STRONG", "STYLE", "SUB", 
  "SUP", "TABLE", "TBODY", "TD", "TEXTAREA", "TFOOT", "TH", "THEAD", "TITLE", 
  "TR", "TT", "U", "UL", "VAR", "WBR", "XMP"
};

nsDOMHTMLTag NS_DOMTagToEnum(const char* aTagName) {
  int low = 0;
  int high = NS_HTML_TAG_MAX - 1;
  while (low <= high) {
    int middle = (low + high) >> 1;
    int result = nsCRT::strcasecmp(aTagName, tagTable[middle]);
    if (result == 0)
      return (nsDOMHTMLTag) (middle + 1);
    if (result < 0)
      high = middle - 1; 
    else
      low = middle + 1; 
  }
  return DOMHTMLTag_unknown;
}

const char* NS_DOMEnumToTag(nsDOMHTMLTag aTagID) {
  if ((int(aTagID) <= 0) || (int(aTagID) > NS_HTML_TAG_MAX)) {
    return 0;
  }
  return tagTable[int(aTagID) - 1];
}

