/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */
/* AUTO-GENERATED. DO NOT EDIT!!! */

#include "jsapi.h"
#include "nsJSUtils.h"
#include "nscore.h"
#include "nsIScriptContext.h"
#include "nsIJSScriptObject.h"
#include "nsIScriptObjectOwner.h"
#include "nsIScriptGlobalObject.h"
#include "nsIPtr.h"
#include "nsString.h"
#include "nsIDOMHTMLBodyElement.h"


static NS_DEFINE_IID(kIScriptObjectOwnerIID, NS_ISCRIPTOBJECTOWNER_IID);
static NS_DEFINE_IID(kIJSScriptObjectIID, NS_IJSSCRIPTOBJECT_IID);
static NS_DEFINE_IID(kIScriptGlobalObjectIID, NS_ISCRIPTGLOBALOBJECT_IID);
static NS_DEFINE_IID(kIHTMLBodyElementIID, NS_IDOMHTMLBODYELEMENT_IID);

NS_DEF_PTR(nsIDOMHTMLBodyElement);

//
// HTMLBodyElement property ids
//
enum HTMLBodyElement_slots {
  HTMLBODYELEMENT_ALINK = -1,
  HTMLBODYELEMENT_BACKGROUND = -2,
  HTMLBODYELEMENT_BGCOLOR = -3,
  HTMLBODYELEMENT_LINK = -4,
  HTMLBODYELEMENT_TEXT = -5,
  HTMLBODYELEMENT_VLINK = -6
};

/***********************************************************************/
//
// HTMLBodyElement Properties Getter
//
PR_STATIC_CALLBACK(JSBool)
GetHTMLBodyElementProperty(JSContext *cx, JSObject *obj, jsval id, jsval *vp)
{
  nsIDOMHTMLBodyElement *a = (nsIDOMHTMLBodyElement*)JS_GetPrivate(cx, obj);

  // If there's no private data, this must be the prototype, so ignore
  if (nsnull == a) {
    return JS_TRUE;
  }

  if (JSVAL_IS_INT(id)) {
    switch(JSVAL_TO_INT(id)) {
      case HTMLBODYELEMENT_ALINK:
      {
        nsAutoString prop;
        if (NS_OK == a->GetALink(prop)) {
          nsConvertStringToJSVal(prop, cx, vp);
        }
        else {
          return JS_FALSE;
        }
        break;
      }
      case HTMLBODYELEMENT_BACKGROUND:
      {
        nsAutoString prop;
        if (NS_OK == a->GetBackground(prop)) {
          nsConvertStringToJSVal(prop, cx, vp);
        }
        else {
          return JS_FALSE;
        }
        break;
      }
      case HTMLBODYELEMENT_BGCOLOR:
      {
        nsAutoString prop;
        if (NS_OK == a->GetBgColor(prop)) {
          nsConvertStringToJSVal(prop, cx, vp);
        }
        else {
          return JS_FALSE;
        }
        break;
      }
      case HTMLBODYELEMENT_LINK:
      {
        nsAutoString prop;
        if (NS_OK == a->GetLink(prop)) {
          nsConvertStringToJSVal(prop, cx, vp);
        }
        else {
          return JS_FALSE;
        }
        break;
      }
      case HTMLBODYELEMENT_TEXT:
      {
        nsAutoString prop;
        if (NS_OK == a->GetText(prop)) {
          nsConvertStringToJSVal(prop, cx, vp);
        }
        else {
          return JS_FALSE;
        }
        break;
      }
      case HTMLBODYELEMENT_VLINK:
      {
        nsAutoString prop;
        if (NS_OK == a->GetVLink(prop)) {
          nsConvertStringToJSVal(prop, cx, vp);
        }
        else {
          return JS_FALSE;
        }
        break;
      }
      default:
        return nsCallJSScriptObjectGetProperty(a, cx, id, vp);
    }
  }
  else {
    return nsCallJSScriptObjectGetProperty(a, cx, id, vp);
  }

  return PR_TRUE;
}

/***********************************************************************/
//
// HTMLBodyElement Properties Setter
//
PR_STATIC_CALLBACK(JSBool)
SetHTMLBodyElementProperty(JSContext *cx, JSObject *obj, jsval id, jsval *vp)
{
  nsIDOMHTMLBodyElement *a = (nsIDOMHTMLBodyElement*)JS_GetPrivate(cx, obj);

  // If there's no private data, this must be the prototype, so ignore
  if (nsnull == a) {
    return JS_TRUE;
  }

  if (JSVAL_IS_INT(id)) {
    switch(JSVAL_TO_INT(id)) {
      case HTMLBODYELEMENT_ALINK:
      {
        nsAutoString prop;
        nsConvertJSValToString(prop, cx, *vp);
      
        a->SetALink(prop);
        
        break;
      }
      case HTMLBODYELEMENT_BACKGROUND:
      {
        nsAutoString prop;
        nsConvertJSValToString(prop, cx, *vp);
      
        a->SetBackground(prop);
        
        break;
      }
      case HTMLBODYELEMENT_BGCOLOR:
      {
        nsAutoString prop;
        nsConvertJSValToString(prop, cx, *vp);
      
        a->SetBgColor(prop);
        
        break;
      }
      case HTMLBODYELEMENT_LINK:
      {
        nsAutoString prop;
        nsConvertJSValToString(prop, cx, *vp);
      
        a->SetLink(prop);
        
        break;
      }
      case HTMLBODYELEMENT_TEXT:
      {
        nsAutoString prop;
        nsConvertJSValToString(prop, cx, *vp);
      
        a->SetText(prop);
        
        break;
      }
      case HTMLBODYELEMENT_VLINK:
      {
        nsAutoString prop;
        nsConvertJSValToString(prop, cx, *vp);
      
        a->SetVLink(prop);
        
        break;
      }
      default:
        return nsCallJSScriptObjectSetProperty(a, cx, id, vp);
    }
  }
  else {
    return nsCallJSScriptObjectSetProperty(a, cx, id, vp);
  }

  return PR_TRUE;
}


//
// HTMLBodyElement finalizer
//
PR_STATIC_CALLBACK(void)
FinalizeHTMLBodyElement(JSContext *cx, JSObject *obj)
{
  nsGenericFinalize(cx, obj);
}


//
// HTMLBodyElement enumerate
//
PR_STATIC_CALLBACK(JSBool)
EnumerateHTMLBodyElement(JSContext *cx, JSObject *obj)
{
  return nsGenericEnumerate(cx, obj);
}


//
// HTMLBodyElement resolve
//
PR_STATIC_CALLBACK(JSBool)
ResolveHTMLBodyElement(JSContext *cx, JSObject *obj, jsval id)
{
  return nsGenericResolve(cx, obj, id);
}


/***********************************************************************/
//
// class for HTMLBodyElement
//
JSClass HTMLBodyElementClass = {
  "HTMLBodyElement", 
  JSCLASS_HAS_PRIVATE,
  JS_PropertyStub,
  JS_PropertyStub,
  GetHTMLBodyElementProperty,
  SetHTMLBodyElementProperty,
  EnumerateHTMLBodyElement,
  ResolveHTMLBodyElement,
  JS_ConvertStub,
  FinalizeHTMLBodyElement
};


//
// HTMLBodyElement class properties
//
static JSPropertySpec HTMLBodyElementProperties[] =
{
  {"aLink",    HTMLBODYELEMENT_ALINK,    JSPROP_ENUMERATE},
  {"background",    HTMLBODYELEMENT_BACKGROUND,    JSPROP_ENUMERATE},
  {"bgColor",    HTMLBODYELEMENT_BGCOLOR,    JSPROP_ENUMERATE},
  {"link",    HTMLBODYELEMENT_LINK,    JSPROP_ENUMERATE},
  {"text",    HTMLBODYELEMENT_TEXT,    JSPROP_ENUMERATE},
  {"vLink",    HTMLBODYELEMENT_VLINK,    JSPROP_ENUMERATE},
  {0}
};


//
// HTMLBodyElement class methods
//
static JSFunctionSpec HTMLBodyElementMethods[] = 
{
  {0}
};


//
// HTMLBodyElement constructor
//
PR_STATIC_CALLBACK(JSBool)
HTMLBodyElement(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
{
  return JS_FALSE;
}


//
// HTMLBodyElement class initialization
//
nsresult NS_InitHTMLBodyElementClass(nsIScriptContext *aContext, void **aPrototype)
{
  JSContext *jscontext = (JSContext *)aContext->GetNativeContext();
  JSObject *proto = nsnull;
  JSObject *constructor = nsnull;
  JSObject *parent_proto = nsnull;
  JSObject *global = JS_GetGlobalObject(jscontext);
  jsval vp;

  if ((PR_TRUE != JS_LookupProperty(jscontext, global, "HTMLBodyElement", &vp)) ||
      !JSVAL_IS_OBJECT(vp) ||
      ((constructor = JSVAL_TO_OBJECT(vp)) == nsnull) ||
      (PR_TRUE != JS_LookupProperty(jscontext, JSVAL_TO_OBJECT(vp), "prototype", &vp)) || 
      !JSVAL_IS_OBJECT(vp)) {

    if (NS_OK != NS_InitHTMLElementClass(aContext, (void **)&parent_proto)) {
      return NS_ERROR_FAILURE;
    }
    proto = JS_InitClass(jscontext,     // context
                         global,        // global object
                         parent_proto,  // parent proto 
                         &HTMLBodyElementClass,      // JSClass
                         HTMLBodyElement,            // JSNative ctor
                         0,             // ctor args
                         HTMLBodyElementProperties,  // proto props
                         HTMLBodyElementMethods,     // proto funcs
                         nsnull,        // ctor props (static)
                         nsnull);       // ctor funcs (static)
    if (nsnull == proto) {
      return NS_ERROR_FAILURE;
    }

  }
  else if ((nsnull != constructor) && JSVAL_IS_OBJECT(vp)) {
    proto = JSVAL_TO_OBJECT(vp);
  }
  else {
    return NS_ERROR_FAILURE;
  }

  if (aPrototype) {
    *aPrototype = proto;
  }
  return NS_OK;
}


//
// Method for creating a new HTMLBodyElement JavaScript object
//
extern "C" NS_DOM nsresult NS_NewScriptHTMLBodyElement(nsIScriptContext *aContext, nsISupports *aSupports, nsISupports *aParent, void **aReturn)
{
  NS_PRECONDITION(nsnull != aContext && nsnull != aSupports && nsnull != aReturn, "null argument to NS_NewScriptHTMLBodyElement");
  JSObject *proto;
  JSObject *parent;
  nsIScriptObjectOwner *owner;
  JSContext *jscontext = (JSContext *)aContext->GetNativeContext();
  nsresult result = NS_OK;
  nsIDOMHTMLBodyElement *aHTMLBodyElement;

  if (nsnull == aParent) {
    parent = nsnull;
  }
  else if (NS_OK == aParent->QueryInterface(kIScriptObjectOwnerIID, (void**)&owner)) {
    if (NS_OK != owner->GetScriptObject(aContext, (void **)&parent)) {
      NS_RELEASE(owner);
      return NS_ERROR_FAILURE;
    }
    NS_RELEASE(owner);
  }
  else {
    return NS_ERROR_FAILURE;
  }

  if (NS_OK != NS_InitHTMLBodyElementClass(aContext, (void **)&proto)) {
    return NS_ERROR_FAILURE;
  }

  result = aSupports->QueryInterface(kIHTMLBodyElementIID, (void **)&aHTMLBodyElement);
  if (NS_OK != result) {
    return result;
  }

  // create a js object for this class
  *aReturn = JS_NewObject(jscontext, &HTMLBodyElementClass, proto, parent);
  if (nsnull != *aReturn) {
    // connect the native object to the js object
    JS_SetPrivate(jscontext, (JSObject *)*aReturn, aHTMLBodyElement);
  }
  else {
    NS_RELEASE(aHTMLBodyElement);
    return NS_ERROR_FAILURE; 
  }

  return NS_OK;
}
