/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */
#include "nsCSSAtoms.h"

// XXX make this be autogenerated. doh!

nsIAtom* nsCSSAtoms::activePseudo;

nsIAtom* nsCSSAtoms::firstChildPseudo;
nsIAtom* nsCSSAtoms::focusPseudo;

nsIAtom* nsCSSAtoms::hoverPseudo;

nsIAtom* nsCSSAtoms::langPseudo;
nsIAtom* nsCSSAtoms::linkPseudo;

nsIAtom* nsCSSAtoms::outOfDatePseudo;

nsIAtom* nsCSSAtoms::universalSelector;

nsIAtom* nsCSSAtoms::visitedPseudo;


static nsrefcnt gRefCnt;

void nsCSSAtoms::AddrefAtoms()
{
  if (0 == gRefCnt) {
    activePseudo = NS_NewAtom(":ACTIVE");

    firstChildPseudo = NS_NewAtom(":FIRST-CHILD");
    focusPseudo = NS_NewAtom(":FOCUS");

    hoverPseudo = NS_NewAtom(":HOVER");

    langPseudo = NS_NewAtom(":LANG");
    linkPseudo = NS_NewAtom(":LINK");

    outOfDatePseudo = NS_NewAtom(":OUT-OF-DATE");

    universalSelector = NS_NewAtom("*");

    visitedPseudo = NS_NewAtom(":VISITED");
  }
  ++gRefCnt;
}

void nsCSSAtoms::ReleaseAtoms()
{
  NS_PRECONDITION(gRefCnt != 0, "bad release atoms");
  if (--gRefCnt == 0) {
    NS_RELEASE(activePseudo);

    NS_RELEASE(firstChildPseudo);
    NS_RELEASE(focusPseudo);

    NS_RELEASE(hoverPseudo);

    NS_RELEASE(langPseudo);
    NS_RELEASE(linkPseudo);

    NS_RELEASE(outOfDatePseudo);

    NS_RELEASE(universalSelector);

    NS_RELEASE(visitedPseudo);
  }
}

