/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

/**
 * Tests whether the profiler responds to "sharedLibraries" adequately.
 */

function run_test() {
  get_chrome_actors((client, form) => {
    let actor = form.profilerActor;
    test_sharedlibraries(client, actor, () => {
      client.close().then(() => {
        do_test_finished();
      });
    });
  });

  do_test_pending();
}

function test_sharedlibraries(client, actor, callback) {
  client.request({ to: actor, type: "sharedLibraries" }, response => {
    const libs = response.sharedLibraries;
    Assert.equal(typeof libs, "object");
    Assert.ok(Array.isArray(libs));
    Assert.equal(typeof libs, "object");
    Assert.ok(libs.length >= 1);
    Assert.equal(typeof libs[0], "object");
    Assert.equal(typeof libs[0].name, "string");
    Assert.equal(typeof libs[0].path, "string");
    Assert.equal(typeof libs[0].debugName, "string");
    Assert.equal(typeof libs[0].debugPath, "string");
    Assert.equal(typeof libs[0].arch, "string");
    Assert.equal(typeof libs[0].start, "number");
    Assert.equal(typeof libs[0].end, "number");
    Assert.ok(libs[0].start <= libs[0].end);
    callback();
  });
}
