# Contributing to Thunderbird for Android

Welcome to the Thunderbird for Android project! We're excited to have you here and welcome your contributions.

## Getting Started

Before you start contributing, please take a moment to familiarize yourself with the following:

- **Mozilla Community Participation Guidelines:** [https://www.mozilla.org/en-US/about/governance/policies/participation/](https://www.mozilla.org/en-US/about/governance/policies/participation/)
- **Frequently Asked Questions:** [https://forum.k9mail.app/c/faq](https://forum.k9mail.app/c/faq)
- **Support Forum:** [https://forum.k9mail.app/](https://forum.k9mail.app/)

## Bug Reports and Feature Requests

If you encounter a bug or have a feature request, please follow these steps:

- Search the [existing issues](https://github.com/thunderbird/thunderbird-android/issues?q=is%3Aissue) to see if your issue or feature has already been reported.
- If you can't find an existing issue, please [open a new issue](https://github.com/thunderbird/thunderbird-android/issues/new/choose) on GitHub.

## Translations

If you'd like to help to translate K-9 Mail / Thunderbird for Android, please visit the [Weblate - K-9 Mail/Thunderbird project](https://hosted.weblate.org/projects/tb-android/).

## Contributing Code

Thank you for your willingness to contribute code! Here's how you can get started:

**1. Find an issue:**

- Check the issue tracker for [open issues](https://github.com/thunderbird/thunderbird-android/issues?q=is%3Aissue+is%3Aopen+-label%3Aunconfirmed+-label%3Atb-team).
- Look for issues labeled [good first issue](https://github.com/thunderbird/thunderbird-android/labels/good%20first%20issue) for a good starting point.
- Propose a new feature by [opening a new issue](https://github.com/thunderbird/thunderbird-android/issues/new/choose)
- Avoid issues labeled [unconfirmed](https://github.com/thunderbird/thunderbird-android/labels/unconfirmed) or [tb-team](https://github.com/thunderbird/thunderbird-android/labels/tb-team) as they are not yet ready for contributions.

**2. Discuss your plan:**

- Leave a comment on the issue you want to work on, explaining what you plan to do. This helps avoid duplicate work and gets you feedback from the team.

**3. Fork the repository:**

- Create your own [fork](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/working-with-forks/fork-a-repo) of the Thunderbird for Android repository on GitHub.

**4. Create a branch:**

- Start a new branch from the `main` branch to keep your changes separate.
- Name your branch descriptively (e.g., `fix-issue-123` or `add-feature-xyz`).

**5. Make your changes:**

- Write your code and commit it to your branch.
- Follow our [Code Style Guidelines](https://github.com/thunderbird/thunderbird-android/wiki/CodeStyle)

**6. Test your changes:**

- Run the project's tests to make sure everything works and that your changes don't introduce any regressions.
- If applicable, write new tests to cover your changes.

**7. Push your changes:**

- Upload your branch to your forked repository.

**8. Open a pull request:**

- Create a pull request to merge your changes into the main project.
- Provide a clear and concise description of your changes, including:
  - A reference to the issue you're addressing.
  - A summary of the changes you made.
  - Any relevant screenshots or testing results.

## Thank You!

Thank you for taking the time to contribute to Thunderbird for Android! We appreciate your help in making the project better and more useful for everyone.
