package app.k9mail.core.ui.legacy.designsystem.atom.icon

import app.k9mail.core.ui.legacy.designsystem.R

/**
 * Icons used in the legacy design system.
 *
 * For Material 3 we use mainly Outlined icons. Filled icons are used for special cases.
 *
 * Each object contains the icons as drawableRes.
 */
object Icons {
    object Filled {
        val Star = R.drawable.ic_star_filled
    }

    object Outlined {
        @JvmField
        val AccountCircle = R.drawable.ic_account_circle
        val Add = R.drawable.ic_add
        val AddCircle = R.drawable.ic_add_circle
        val Adjust = R.drawable.ic_adjust
        val Archive = R.drawable.ic_archive
        val ArrowBack = R.drawable.ic_arrow_back
        val Attachment = R.drawable.ic_attachment
        val Block = R.drawable.ic_block
        val Bolt = R.drawable.ic_bolt
        val BugReport = R.drawable.ic_bug_report
        val Check = R.drawable.ic_check
        val CheckCircle = R.drawable.ic_check_circle
        val ChevronRight = R.drawable.ic_chevron_right
        val Close = R.drawable.ic_close
        val Code = R.drawable.ic_code
        val CompareArrows = R.drawable.ic_compare_arrows
        val ContentCopy = R.drawable.ic_content_copy
        val Delete = R.drawable.ic_delete
        val Description = R.drawable.ic_description
        val DoNotDisturbOn = R.drawable.ic_do_not_disturb_on
        val Download = R.drawable.ic_download
        val Draft = R.drawable.ic_draft
        val DragHandle = R.drawable.ic_drag_handle
        val DriveFileMove = R.drawable.ic_drive_file_move
        val Edit = R.drawable.ic_edit
        val Error = R.drawable.ic_error
        val ExpandLess = R.drawable.ic_expand_less
        val ExpandMore = R.drawable.ic_expand_more
        val Favorite = R.drawable.ic_favorite
        val FilterList = R.drawable.ic_filter_list
        val Folder = R.drawable.ic_folder
        val Forum = R.drawable.ic_forum
        val Forward = R.drawable.ic_forward
        val Group = R.drawable.ic_group
        val Healing = R.drawable.ic_healing
        val Help = R.drawable.ic_help

        @JvmField
        val Image = R.drawable.ic_image
        val Inbox = R.drawable.ic_inbox
        val Info = R.drawable.ic_info
        val Key = R.drawable.ic_key
        val Link = R.drawable.ic_link
        val Lock = R.drawable.ic_lock
        val Login = R.drawable.ic_login
        val Mail = R.drawable.ic_mail
        val MarkEmailRead = R.drawable.ic_mark_email_read
        val MarkEmailUnread = R.drawable.ic_mark_email_unread
        val Menu = R.drawable.ic_menu
        val Monitor = R.drawable.ic_monitor
        val MoreVert = R.drawable.ic_more_vert
        val NoEncryption = R.drawable.ic_no_encryption
        val Notifications = R.drawable.ic_notifications
        val Outbox = R.drawable.ic_outbox
        val Person = R.drawable.ic_person
        val PersonAdd = R.drawable.ic_person_add
        val Refresh = R.drawable.ic_refresh

        @JvmField
        val Reply = R.drawable.ic_reply

        @JvmField
        val ReplyAll = R.drawable.ic_reply_all
        val Report = R.drawable.ic_report
        val Save = R.drawable.ic_save
        val Search = R.drawable.ic_search
        val Security = R.drawable.ic_security
        val SelectAll = R.drawable.ic_select_all
        val Send = R.drawable.ic_send
        val Settings = R.drawable.ic_settings
        val Sort = R.drawable.ic_sort
        val Star = R.drawable.ic_star
        val SwapVert = R.drawable.ic_swap_vert
        val Sync = R.drawable.ic_sync
        val TouchApp = R.drawable.ic_touch_app
        val Upload = R.drawable.ic_upload
        val Visibility = R.drawable.ic_visibility
        val Warning = R.drawable.ic_warning
    }
}
