/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

add_task(async function test_check_missing_common_name() {
  const kURL =
    "about:certificate?cert=MIIHVDCCBTygAwIBAgIQOBNAgEopyUI1DYLsLmSWejANBgkqhkiG9w0BAQsFADBYMQswCQYDVQQGEwJUVzESMBAGA1UECgwJ6KGM5pS%2F6ZmiMTUwMwYDVQQDDCzmlL%2FlupzkvLrmnI3lmajmlbjkvY3mhpHorYnnrqHnkIbkuK3lv4MgLSBHMTAeFw0yMDAxMjAwNjExMzBaFw0yMjAxMjAwNjExMzBaMFUxCzAJBgNVBAYTAlRXMQ8wDQYDVQQHDAboh7rngaMxEjAQBgNVBAoMCee4vee1seW6nDEhMB8GA1UEAwwYZW5nbGlzaC5wcmVzaWRlbnQuZ292LnR3MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAyxCtEdUsGqr%2FVCNOMpj1TkDzBn6Gs1RBHHERU%2BsJ1q3ri6rJfydTx0rQKUbcGEMyWB2pga4dNSjzxQZ6%2BebP3kctC0H%2F%2BptEnsIOQcyD2yLN5yg8ejx6Y568z3fbU%2FRAVo4q6qGZzlBfzl2AhZMrp3AiNpQZXjLWgNHYZfirDVur7ImSjECq6atLlZ1yn%2B0RC%2FsGsPKalz5iacuxMYIkWeCvm7piA%2FdXPfw%2FVJxbIEkXMSXXxDNGrBZY0wAcmPeDHZxyLDGDOFLV%2Fpics3ZJ4UjFPphwaXuW94K9NKLcfOu7JaYP6JszpBIEiL8GRl8pMdykkKN%2FRkEZ%2F8pE7Tz%2BswIDAQABo4IDGzCCAxcwHwYDVR0jBBgwFoAU1ustnWH%2BK7twiC64B7FZsPSDImowHQYDVR0OBBYEFDxkjGSuIgKbFKTUvadNfX%2B%2BogdCMHUGCCsGAQUFBwEBBGkwZzA1BggrBgEFBQcwAoYpaHR0cDovL2d0bHNjYS5uYXQuZ292LnR3L0NlcnRzL0dUTFNDQS5jcnQwLgYIKwYBBQUHMAGGImh0dHA6Ly9vY3NwLmd0bHNjYS5uYXQuZ292LnR3L09DU1AwIgYDVR0gBBswGTANBgsrBgEEAYG3I2QAAzAIBgZngQwBAgIwIAYDVR0lAQH%2FBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMCMCMGA1UdEQQcMBqCGGVuZ2xpc2gucHJlc2lkZW50Lmdvdi50dzAgBgNVHQkEGTAXMBUGB2CGdgFkAgExCgYIYIZ2AWQDAwEwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2d0bHNjYS5uYXQuZ292LnR3L2NybC9HVExTQ0EtY29tcGxldGUuY3JsMA4GA1UdDwEB%2FwQEAwIFoDCCAXwGCisGAQQB1nkCBAIEggFsBIIBaAFmAHUApLkJkLQYWBSHuxOizGdwCjw1mAT5G9%2B443fNDsgN3BAAAAFvwZRvQAAABAMARjBEAiAWcMYq5U%2BiRndzk4q7XRQ10ykv%2FBlaHelk0SMi8LeXmAIgY%2BJUd3bzT5nSTCYQMOAMLGE52UWhnIRgxdWRtcg60uAAdQDuS723dc5guuFCaR%2Br4Z5mow9%2BX7By2IMAxHuJeqj9ywAAAW%2FBlHdGAAAEAwBGMEQCIAM72FPgBC6JzvE%2BEkvdp9g9Lt19fnJ6KfWQYNN%2BMylsAiBezZw%2FDzsg22O4Tr0QGYoY7HsnPzsHzxEJVUJGl8HXZQB2AG9Tdqwx8DEZ2JkApFEV%2F3cVHBHZAsEAKQaNsgiaN9kTAAABb8GUfQAAAAQDAEcwRQIgXVJY0MInclLEtJ1AoMPtjja0tvBD0zPHSAyxIgZ%2B3EECIQDTj7KrkhXuZqKr6sF0hqwr%2BiMiByMi7gNjK4DOqxJ7YjANBgkqhkiG9w0BAQsFAAOCAgEAeOXA%2FpFjaSlenGSQSMDbbSXM%2BL2nM0M1yQ8WxM2mxRfAxzyuH%2FDo1UGDmbvu1e6f%2FdA6Gr%2BAdx2EFia3FqIBrnB9BAymlMgYKq3pW67b83k8r6iF5UcwxISE4LXplY8iV12a59EUCHr0YnVUzK3gLN9ocPyGHnsRdzuowU7WRtZ2tMFAlVT2dEGPqG2ZKsIiCBRummp1vNF3b%2BB5g4Y5Hc7Vw1%2F1LgPMsaSPj5%2Fl4YdLCIO2tWYqnpA0LE8xuRXFSRA0fmlZQKr01N0%2B1ar2QRH6PcRJE3EJbgdnsIGDMithZ4a2COinwCWNkuj6lwB83RvfGOdwJfVv9ricvRpdMOs3HSQnRk0q1IreY42VVmtOGt6MfuCPaIMZtI0unkd3GHmCDcoe64HIu7sjdTCqWAR60JZpQ4oM%2BOpzfBulhf44BDh33zM7lNAlEtVN%2BtszLA2S3CCoDTHpUGWkes%2BzkI4qjG5Nd1eGZT%2FtqqWyRc799ROCEAI5SkgZgowqRgzMhkazdyDANLTbg2Edt4OT7O6zrdLg70JTZMxdJ5%2BAnDMmDr8NCH63URFJe72ZBOH4uAeZuV%2Bhbh9v1%2BF2kFaqVBh2VaRdY%2FHGpnoD%2By1bJ7FI1erKUJFt%2FP4ZEYjACkmT7Gtw8NifvECY3cw3aiAY7AMg2Bnk72ySxvBcXedVMU8%3D&cert=MIIGtjCCBJ6gAwIBAgIRAJltX%2Bmt4Wzcjs2%2F7bFKMpUwDQYJKoZIhvcNAQELBQAwYzELMAkGA1UEBhMCVFcxIzAhBgNVBAoMGkNodW5naHdhIFRlbGVjb20gQ28uLCBMdGQuMS8wLQYDVQQDDCZlUEtJIFJvb3QgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBHMjAeFw0xOTA3MTkwNjQ2NDVaFw0zMTA4MTkwNjQ2NDVaMFgxCzAJBgNVBAYTAlRXMRIwEAYDVQQKDAnooYzmlL%2FpmaIxNTAzBgNVBAMMLOaUv%2BW6nOS8uuacjeWZqOaVuOS9jeaGkeitieeuoeeQhuS4reW%2FgyAtIEcxMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAwg5R4LGoDj%2BmZIXmcHmRYv501jsSLIm7EoX%2FKAt74uN2yDR436V2EWkFeWhD%2BTS4sx2%2F3JCRW%2BKE%2BIX8NYBKjsWuK9OMY4Gu4FEWJpBu1XCWYjTPKyhHdEhDpxRxv91g3Zk68XgK7j2U5sEzCPx13QjkH7qc%2FMo5BFiro8YsYAfxgCoa%2FrZFEsXyZKXRJeIDw7t%2BiPxVy2cbQ0uNloO9670LGoOVzYVkYABv3IwZo%2BJRtj%2Bj7rLjB7xQKYmfJOA2Jc96yPm6li7zHrIQYfohGPdANmwR9opNNqYOo%2BLtsIYot3%2FcLp9YgAaiGdrAiKrbbEVkYH%2BzKzAHolf5mPBn%2Bh3OElYfygESitWRBp2bwfOGJwAYseTuorQHpyQps1GGcn9vcfnLhvLxa3DMrCAvSJb3SvHCyqahQz0KR0IPcu%2BVLW3icaqlbJausGIGYqp8VSN6FJ0pgmYdbunBLYc1v23VvjmVMl%2BxNJoaSFEUscmSqA4CuYANhkWSANk8HI9rNbvmzuyWhSv7tUXY6UB67mHp4ypGcKYbXrjiKqahv6QLUEb7S8FD71Ds75F2vMeO4O77i6joBs%2FL2E6WZJvSronzJCXL0IwmpYaOAsoFOf0eGVsPBVKn%2Bz4Bq0WA0%2Br7plfWofDbUGmx9Zun%2B%2BrWhoDXrma%2BodubN1Xj1RjlL3sCAwEAAaOCAW4wggFqMB8GA1UdIwQYMBaAFHJbuqpyOO4lkCS1lCL6CYjKiwr7MB0GA1UdDgQWBBTW6y2dYf4ru3CILrgHsVmw9IMiajAOBgNVHQ8BAf8EBAMCAYYwPAYDVR0fBDUwMzAxoC%2BgLYYraHR0cDovL2VjYS5oaW5ldC5uZXQvcmVwb3NpdG9yeS9DUkwyL0NBLmNybDCBggYIKwYBBQUHAQEEdjB0MDsGCCsGAQUFBzAChi9odHRwOi8vZWNhLmhpbmV0Lm5ldC9yZXBvc2l0b3J5L0NlcnRzL2VDQUcyLmNydDA1BggrBgEFBQcwAYYpaHR0cDovL29jc3AuZWNhLmhpbmV0Lm5ldC9PQ1NQL29jc3BHMnNoYTIwEgYDVR0TAQH%2FBAgwBgEB%2FwIBADAiBgNVHSAEGzAZMA0GCysGAQQBgbcjZAADMAgGBmeBDAECAjAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwDQYJKoZIhvcNAQELBQADggIBAEyrsJ9vUi6nEfwO0vgAoFefXpCRF%2BuDsmG%2F8F6OV9VRnbtzBwazHbxVmaBvDRVofLfoXWr%2BNd8dd3BXVUNxemNrkZa8Hdgdv4s8yFbRs0W6fRTWkhCcc39RpQtSeV7kyxCP1rMTYRSqCA9F%2BFcDMLXJIzZrzl7Tn6guIyqcfZv6sRN7CbbTrYKSc0JX4t26WGFun2zLjzH8kx1TZ457TE4yyjl1oSZdgiWL6Hz7l%2BnbTe6WqPVVm4am2AAmaQaLGncsGLasl7PIHx9Nc4sy7KdOMTc5r0BPCGhAiJ6ueQ6aVd49pra7BDIqFMA7Myy4pXRYfqFnjq9RuROWYiIluzLNUSxlaFtTMUVQnWjJxnlXlBDLX9L4OAxTOvdbtcNNS1GK%2BW1cWiYdTOWF4HTu5pvdUn%2F%2B8yVE4E7MPb0vGuxv3S11QG6JtVPuHkX6BGqRXHo253gY77HZU0g3g9qVs9UaZjWS5UTcqdgLmmOQnH7USaJ9%2F4rXRu%2FP8IWMPG2s6tv1dRVQV5xfq21PQ4y53ytVd0%2B%2Flp0L743%2B1AjnOw0I8t9QxP6c2ti%2Boo43rxM8YE3etVLQBeWsmJc00GOWa%2FXmFACsy8Lkctx0QScAAYwCfB2accfxj9hEX1c6MAeVUVp04YJx4dtjoIFTPI1%2FMFX%2BFkxMq4Fs6k%2BmxSm7tNvv&cert=MIIHZDCCBUygAwIBAgIRAK%2FNjWQsYtZFBn3IV%2F2o8V0wDQYJKoZIhvcNAQELBQAwXjELMAkGA1UEBhMCVFcxIzAhBgNVBAoMGkNodW5naHdhIFRlbGVjb20gQ28uLCBMdGQuMSowKAYDVQQLDCFlUEtJIFJvb3QgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTUxMTE3MDg1MTM1WhcNMzQxMjIwMDIzMTI3WjBjMQswCQYDVQQGEwJUVzEjMCEGA1UECgwaQ2h1bmdod2EgVGVsZWNvbSBDby4sIEx0ZC4xLzAtBgNVBAMMJmVQS0kgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEApFkfoC%2FfvuD76dy1if5alwPJOnenjlyv8uMYOfWq3Q9G0mgPV5ynY2DTWM41wqf2iMJPfxso6dCnAMQXTW3iD8UOJiMgq%2Fc6KKJMCgvMjs7mAJpaQA3UUBqb0Q2clPnb7lzQ8YoHzZorQCxJpF1iX6dr3%2B5WCFDzQhhsMbBe5ZxzkrwO0gx9xThXvLtY2yYZAu3jQ4SKTlZr262hMdnMImeWeP93ncxkxTIgau9OMNUkJf2Iea9xGv7VSxsViLwYcKq9rTgKZjBG5YmF1XYkqamz5llgD7SpU8I6nUUa1q7jd17EYjYzLzDEv5XxLTildejRapMuRYdLSqLfv1gnmspiGape1LGASZbdK%2Bxfj5vgnZeI9YQDo6%2BzpXMtQbrlB7dva3H398lar2mZsy%2FIT0LrbGtxZ3jfCqxP10qFAEYa1c24n%2BqVnQ980cYFheYI3ogXgfbVtW7qoRzXYarjWUKJnFl%2BsXxkNN1hIyo5tRCr%2FIapUxrF62rigE5ZkcA4if6zXdb7kenXsH3ZeAjM9SvMK%2BGh1pRzwf5R9Ix9CrWairn12uDJs9iPqoKDjWlTLf0ABBhKoNpU4XmMiet%2F9YLnoLl3Ta75ugI7iHbrfF2zWhPbfCkWa5nRHeRIIaINXgGI6L7xmE0%2BxxZXHF%2FhCG8cTFhDVveAZYxxDqIEZ08CAwEAAaOCAhYwggISMB8GA1UdIwQYMBaAFB4M97Zn8uGSJglFwFU5Lnc%2FQkqiMB0GA1UdDgQWBBRyW7qqcjjuJZAktZQi%2BgmIyosK%2BzAOBgNVHQ8BAf8EBAMCAQYwQAYDVR0fBDkwNzA1oDOgMYYvaHR0cDovL2VjYS5oaW5ldC5uZXQvcmVwb3NpdG9yeS9DUkxfU0hBMi9DQS5jcmwwgYIGCCsGAQUFBwEBBHYwdDA7BggrBgEFBQcwAoYvaHR0cDovL2VjYS5oaW5ldC5uZXQvcmVwb3NpdG9yeS9DZXJ0cy9lQ0FHMS5jcnQwNQYIKwYBBQUHMAGGKWh0dHA6Ly9vY3NwLmVjYS5oaW5ldC5uZXQvT0NTUC9vY3NwRzFzaGEyMA8GA1UdEwEB%2FwQFMAMBAf8wgecGA1UdIASB3zCB3DANBgsrBgEEAYG3I2QAATANBgsrBgEEAYG3I2QAAjANBgsrBgEEAYG3I2QAAzANBgsrBgEEAYG3I2QABDANBgsrBgEEAYG3I2QACTANBgsrBgEEAYG3I2QAADANBgsrBgEEAYG3I2QEATANBgsrBgEEAYG3I2QEAjANBgsrBgEEAYG3I2QEAzAJBgdghnYBZAABMAkGB2CGdgFkAAIwCQYHYIZ2AWQAAzAJBgdghnYBZAAEMAkGB2CGdgFkAAAwCAYGZ4EMAQIBMAgGBmeBDAECAjAIBgZngQwBAgMwDQYJKoZIhvcNAQELBQADggIBALwy4mxatKA6X%2BUM2IDpnWajNmek00EM4qh5E7eiQY0yZV5Eit9D%2F8q9h0hD77NjVaYPwsOWqWAiVtDAro%2BnWDHfkAG14ptRNBoGjJjzZi%2F%2BOeI2WTc8ZER6C8rAjQ7b%2FRxMzwxfDjRtgCbT2qq01rPiJ%2BqDgyUniDstbyQj08bSo3GJWp6ZsSNDAP26ygODpSgL0Ja806Byk2b4npQevdkmQ0k43S9IU0MeSlWT8hxzluyFlPRl4yuev5le91outdEdpV98KvYcgLAWwW5UcFOM6SRsYTBS2dfSRgKreDnMNdbUHmbAVsb3wLD6WqLoe6LyRNOeXctKPA6%2Be5i%2FJN6NZnqejcMopuS%2BpyWyrNiHlRShGUfTiXrcbT8fbyOswAT8JsX4fWyZYub0kKfFG8hEKQsIxNiyKH4cw6HBih31EYaYS9IEj19NxfHl0KbPm22cpBJoGwkZWgg%2F%2FPflFFHNTdKSalDxPHMKdyZbTBugLtqFVkV%2Bvu1y6WRoGfHwzpa9aQsMWAwLYRnBZnSYzfN9QFZsoHCSDJJVt30Oi6fURJy34%2Bdtvs%2BsQihiN886uYTJ0Cex1R%2BOb9HXCKFrGTumgwD%2Bnitt7hwlB74K9lqrKQrtfgfBFFMG9Tu%2FE%2FOI6JoST2j8KmSN1rpcxoMH3tamxqm3%2BxpLM9HekbBoJ0V2&cert=MIIFsDCCA5igAwIBAgIQFci9ZUdcr7iXAF7kBtK8nTANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJUVzEjMCEGA1UECgwaQ2h1bmdod2EgVGVsZWNvbSBDby4sIEx0ZC4xKjAoBgNVBAsMIWVQS0kgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wNDEyMjAwMjMxMjdaFw0zNDEyMjAwMjMxMjdaMF4xCzAJBgNVBAYTAlRXMSMwIQYDVQQKDBpDaHVuZ2h3YSBUZWxlY29tIENvLiwgTHRkLjEqMCgGA1UECwwhZVBLSSBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA4SUP7o3biDN1Z82tH306Tm2d0y8U82N0ywEhajfqhFAHSyZbCUNsIZ5qyNUD9WBpj8zwIuQf5%2FdqIjG3LBXy4P4AakP%2Fh2XGtRrBp0xtInAhijHyl3SJCRImHJ7K2RKilTza6We%2FCKBk49ZCt0Xvl%2FT29de1ShUCWH2YWEtgvM3XDZoTM1PRYfl61dd4s5oz9wCGzh1NlDivqOx4UXCKXBCDUSH3ET00hl7lSM2XgYI1TBnsZfZrxQWh7kcT1rMhJ5QQCtkkO7q%2BRBNGMD%2BXPNjX12ruOzjjK9SXDrkb5wdJfzcq%2BXd4z1TtW0ado4AOkUPB1ltfFLqfpo0kR0BZv3I4sjZsN%2F%2BZ0V0OWQqraffAsgRFelQArr5T9rXn4fg8ozHSqf4hUmTFpmfwdQcGlBSBVcYn5AGPF8Fqcde%2BS%2FuUWH1%2BETOxQvdibBjWzwloPn9s9h6PYq2lY9sJpx8iQkEeb5mKPtf5P0B6ebClAZLSnT0IFaUQAS2zMnaolQ2zepr7BxB4EW%2Fhj8e6DyUadCrlHJhBmd8hh%2BiVBmoKs2pHdmX2Os%2BPYhcZewoozRrSgx4hxyy%2Fvv9haLdnG7t4TY3OZ%2BXkwY63I2binZB1NJipNiuKmpS5nezMirH4JYlcWrYvjB9teSSnUmjDhDXiZo1jDiVN1Rmy5nk3pyKdVDECAwEAAaNqMGgwHQYDVR0OBBYEFB4M97Zn8uGSJglFwFU5Lnc%2FQkqiMAwGA1UdEwQFMAMBAf8wOQYEZyoHAAQxMC8wLQIBADAJBgUrDgMCGgUAMAcGBWcqAwAABBRFsMLHClZ87lt4DJX5GFPBphzYEDANBgkqhkiG9w0BAQUFAAOCAgEACbODU1kBPpVJufGBuvl2ICO1J2B01GqZNF5sAFPZn%2FKmsSQHRGoqxqWOeBLoR9lYGxMqXnmbnwoqZ6YlPwZpVnPDimZI%2BymBV3QGypzqKOg4ZyYr8dW1P2WT%2BDZdjo2NQCCHGervJ8A9tDkPJXtoUHRVnAxZfVo9QZQlUgjgRywVMRnVvwdVxrsStZf0X4OFunHB2WyBEXYKCrC%2Fgpf36j36%2BuwtqSiUO1bd0lEursC9CBWMd1I0ltabrNMdjmEPNXubrjlpC2JgQCA2j6%2F7Nu4tCEoduL%2BbXPjqpRugc6bY%2BG7gMwRfaKonh%2B3ZwZCc7b3jajWvY9%2BrGNm65ulK6lCKD2GTHuItGeIwlDWSXQ62B68ZgI9HkFFLLk3dheLSClIKF5r8GrBQAuUBo2M3IUxExJtRmREOc5wGj1QupyheRDmHVi03vYVElOEMSyycw5KFNGHLD7ibSkNS%2FjQ6fbjpKdx2qcgw%2BBRxgMYeNkh0IkFch4LoGHGLQYlE535YW6i4jRPpp2zDR%2B2zGp1iro2C6pSe3VkQw63d4k3jMdXH7OjysP6SHhYKGvzZ8%2Fgntsm%2BHbRsZJB%2F9OTEW9c3rkIO3aQab3yIVMUWbuF6aC74Or8NpDyJO3inTmODBCEIZ43ygknQW%2F2xzQ%2BDhNQ%2BIIX3Sj0rnP0qCglN6oH4EZw%3D";

  await BrowserTestUtils.withNewTab(kURL, async function(browser) {
    await SpecialPowers.spawn(browser, [], async function() {
      let certificateSection = await ContentTaskUtils.waitForCondition(() => {
        return content.document.querySelector("certificate-section");
      }, "Certificate section found");

      let tabs = certificateSection.shadowRoot.querySelector(
        ".certificate-tabs"
      ).children;

      Assert.ok(tabs, "Tabs were found");
      Assert.equal(tabs.length, 4, "There should be 4 tabs");
      for (let tab of tabs) {
        Assert.ok(tab.textContent, "Tab should have non-empty label");
        Assert.notEqual(
          tab.dataset.l10nId,
          "certificate-viewer-unknown-group-label"
        );
        // If there is another tab after this one, this tab should link to the
        // next via its issuer's common name or OU, if available.
        if (tab.nextElementSibling) {
          tab.click();
          let infoGroup = certificateSection.shadowRoot.querySelector(
            ".selected info-group.issuer-name"
          );
          Assert.ok(infoGroup, "infoGroup found");
          let container =
            infoGroup.shadowRoot.querySelector(".common-name") ||
            infoGroup.shadowRoot.querySelector(".organizational-unit");
          Assert.ok(container, "Should find container for link");
          Assert.ok(
            container.shadowRoot.querySelector("a"),
            "There should be a link in the container for " +
              container.textContent
          );
        }
      }
    });
  });
});
