// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

/// Metrics included in every ping as `client_info`.
#[derive(Debug, Clone)]
pub struct ClientInfo {
    /// The build identifier generated by the CI system (e.g. "1234/A").
    pub app_build: String,
    /// The user visible version string (e.g. "1.0.3").
    pub app_display_version: String,
    /// The release channel the application is on, if known.
    pub channel: Option<String>,
    /// The user-visible version of the operating system (e.g. "1.2.3").
    pub os_version: String,
    /// The architecture of the device, (e.g. "x86-64", "arm").
    pub architecture: String,
}
